# Generated by default/object.tt
package Paws::SageMaker::EdgePackagingJobSummary;
  use Moose;
  has CompilationJobName => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has EdgePackagingJobArn => (is => 'ro', isa => 'Str', required => 1);
  has EdgePackagingJobName => (is => 'ro', isa => 'Str', required => 1);
  has EdgePackagingJobStatus => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has ModelName => (is => 'ro', isa => 'Str');
  has ModelVersion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::EdgePackagingJobSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::EdgePackagingJobSummary object:

  $service_obj->Method(Att1 => { CompilationJobName => $value, ..., ModelVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::EdgePackagingJobSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CompilationJobName

=head1 DESCRIPTION

Summary of edge packaging job.

=head1 ATTRIBUTES


=head2 CompilationJobName => Str

The name of the SageMaker Neo compilation job.


=head2 CreationTime => Str

The timestamp of when the job was created.


=head2 B<REQUIRED> EdgePackagingJobArn => Str

The Amazon Resource Name (ARN) of the edge packaging job.


=head2 B<REQUIRED> EdgePackagingJobName => Str

The name of the edge packaging job.


=head2 B<REQUIRED> EdgePackagingJobStatus => Str

The status of the edge packaging job.


=head2 LastModifiedTime => Str

The timestamp of when the edge packaging job was last updated.


=head2 ModelName => Str

The name of the model.


=head2 ModelVersion => Str

The version of the model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

