package Daje::Sentinel::Api;
use Mojo::Base -base;

use Daje::Utils::Factory::Collection qw{load_collection};
use POSIX qw(strftime);
use Try::Tiny;

our $VERSION = '0.13';

has 'mango';
# Capture message and insert it into the collection
# my $oid = $self->capture_message($source, $method, $message)
# $source, $method are used for filtering and message is the actual error
# $oid is the returned _id from MungoDB
#
sub capture_message{ #  $oid ($source, $method, $message)
	my ($self, $source, $method, $message) = @_;

	my $classname = load_collection("Sentinel");

	my $oid = try {
		return $classname->new(
			mango => $self->mango,
			query => {
				source      => $source,
				method 		=> $method,
				message     => $message,
				doc_updated => strftime ("%Y-%m-%d %H:%M:%S", localtime),
			}
		)->insert();
	} catch {
		say $_;
		return $_;
	};

	return $oid;
}

1;





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Sentinel::Api


=head1 DESCRIPTION

Capture message and insert it into the collection
my $oid = $self->capture_message($source, $method, $message)
$source, $method are used for filtering and message is the actual error
$oid is the returned _id from MungoDB



=head1 REQUIRES

L<Try::Tiny> 

L<POSIX> 

L<Daje::Utils::Factory::Collection> 

L<Mojo::Base> 


=head1 METHODS

=head2 capture_message

 my $oid = capture_message($source, $method, $message);

has 'mango';
Capture message and insert it into the collection
my $oid = $self->capture_message($source, $method, $message)
$source, $method are used for filtering and message is the actual error
$oid is the returned _id from MungoDB




=cut

