# Contributing

All contributions are welcome and most will be accepted.
These are the guidelines for contributing to this repository.

## Issues (Bugs &amp; Feature Requests)

[File an issue](https://github.com/dyacob/Convert-Braille/issues) if you think you've found a [bug](https://en.wikipedia.org/wiki/Software_bug). Please describe the following:

1. What version of the involved component was used?
2. What environment was the component used in (OS, Perl version etc.)?
3. What was expected?
4. What actually occurred?
5. What has to be done to reproduce the issue?

## Patches

Patches for fixes, features, and improvements are accepted via pull requests. If you are not a Git user, email submissions are OK.

Pull requests should be based on the **main** branch, unless you want to contribute to an active branch for a specific topic.

## Coding Guidelines

Coding guidelines are basic, please use:

- [EditorConfig](http://editorconfig.org/)
- [PerlTidy](http://perltidy.sourceforge.net/)

Evaluation with `Perl::Critic` is also encouraged.

Not actually applying any of the above presently, but this is the intent going forward 😊


## Licensing and Copyright

Please note that accepted contributions are included in the repository and hence under the same license as the repository contributed to.

## Acknowledgement and Mentions

Please note that all contributions are acknowledged and contributors are mentioned by available identification, if you as a contributor would prefer not to be mentioned explicitly please indicate this, PR mechanics cannot be ignored.

If you prefer to be mentioned in a specific manner other than by GitHub handle or similar please indicate this and accommodation will be attempted.
