# Generated by default/object.tt
package Paws::SecretsManager::ValidationErrorsEntry;
  use Moose;
  has CheckName => (is => 'ro', isa => 'Str');
  has ErrorMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecretsManager::ValidationErrorsEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecretsManager::ValidationErrorsEntry object:

  $service_obj->Method(Att1 => { CheckName => $value, ..., ErrorMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecretsManager::ValidationErrorsEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->CheckName

=head1 DESCRIPTION

Displays errors that occurred during validation of the resource policy.

=head1 ATTRIBUTES


=head2 CheckName => Str

Checks the name of the policy.


=head2 ErrorMessage => Str

Displays error messages if validation encounters problems during
validation of the resource policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecretsManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

