# Generated by default/object.tt
package Paws::WAFV2::LoggingConfiguration;
  use Moose;
  has LogDestinationConfigs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has LoggingFilter => (is => 'ro', isa => 'Paws::WAFV2::LoggingFilter');
  has ManagedByFirewallManager => (is => 'ro', isa => 'Bool');
  has RedactedFields => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::FieldToMatch]');
  has ResourceArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::LoggingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::LoggingConfiguration object:

  $service_obj->Method(Att1 => { LogDestinationConfigs => $value, ..., ResourceArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::LoggingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->LogDestinationConfigs

=head1 DESCRIPTION

Defines an association between Amazon Kinesis Data Firehose
destinations and a web ACL resource, for logging from WAF. As part of
the association, you can specify parts of the standard logging fields
to keep out of the logs and you can specify filters so that you log
only a subset of the logging records.

=head1 ATTRIBUTES


=head2 B<REQUIRED> LogDestinationConfigs => ArrayRef[Str|Undef]

The Amazon Kinesis Data Firehose Amazon Resource Name (ARNs) that you
want to associate with the web ACL.


=head2 LoggingFilter => L<Paws::WAFV2::LoggingFilter>

Filtering that specifies which web requests are kept in the logs and
which are dropped. You can filter on the rule action and on the web
request labels that were applied by matching rules during web ACL
evaluation.


=head2 ManagedByFirewallManager => Bool

Indicates whether the logging configuration was created by Firewall
Manager, as part of an WAF policy configuration. If true, only Firewall
Manager can modify or delete the configuration.


=head2 RedactedFields => ArrayRef[L<Paws::WAFV2::FieldToMatch>]

The parts of the request that you want to keep out of the logs. For
example, if you redact the C<HEADER> field, the C<HEADER> field in the
firehose will be C<xxx>.

You must use one of the following values: C<URI>, C<QUERY_STRING>,
C<HEADER>, or C<METHOD>.


=head2 B<REQUIRED> ResourceArn => Str

The Amazon Resource Name (ARN) of the web ACL that you want to
associate with C<LogDestinationConfigs>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

