/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;

public class StateGrabber {
    static String getAllPoolsJSON(CouchbaseMock mock) {
        HashMap<String, String> pools = new HashMap<String, String>();
        pools.put("name", mock.getPoolName());
        pools.put("uri", "/pools/" + mock.getPoolName());
        pools.put("streamingUri", "/poolsStreaming/" + mock.getPoolName());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("pools", pools);
        map.put("isAdminCreds", Boolean.TRUE);
        return JSONObject.fromObject(map).toString();
    }

    static String getPoolJSON(CouchbaseMock mock, String poolName) {
        HashMap poolInfo = new HashMap();
        poolInfo.put("buckets", new HashMap());
        ((Map)poolInfo.get("buckets")).put("uri", "/pools/" + mock.getPoolName() + "/buckets");
        return JSONObject.fromObject(poolInfo).toString();
    }

    static String getBucketJSON(Bucket bucket) {
        bucket.configReadLock();
        String ret = bucket.getJSON();
        bucket.configReadUnlock();
        return ret;
    }

    static String getAllBucketsJSON(CouchbaseMock mock, String poolName, List<Bucket> allowedBuckets) {
        JSONArray bucketsJSON = new JSONArray();
        for (Bucket bucket : allowedBuckets) {
            bucketsJSON.add(StateGrabber.getBucketJSON(bucket));
        }
        return bucketsJSON.toString();
    }

    static String getStreamDelimiter() {
        return "\n\n\n\n";
    }
}

