# Generated by default/object.tt
package Paws::Macie2::CriterionAdditionalProperties;
  use Moose;
  has Eq => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eq', traits => ['NameInRequest']);
  has EqExactMatch => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eqExactMatch', traits => ['NameInRequest']);
  has Gt => (is => 'ro', isa => 'Int', request_name => 'gt', traits => ['NameInRequest']);
  has Gte => (is => 'ro', isa => 'Int', request_name => 'gte', traits => ['NameInRequest']);
  has Lt => (is => 'ro', isa => 'Int', request_name => 'lt', traits => ['NameInRequest']);
  has Lte => (is => 'ro', isa => 'Int', request_name => 'lte', traits => ['NameInRequest']);
  has Neq => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'neq', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::CriterionAdditionalProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::CriterionAdditionalProperties object:

  $service_obj->Method(Att1 => { Eq => $value, ..., Neq => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::CriterionAdditionalProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Eq

=head1 DESCRIPTION

Specifies the operator to use in a property-based condition that
filters the results of a query for findings. For detailed information
and examples of each operator, see Fundamentals of filtering findings
(https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html)
in the I<Amazon Macie User Guide>.

=head1 ATTRIBUTES


=head2 Eq => ArrayRef[Str|Undef]

The value for the property matches (equals) the specified value. If you
specify multiple values, Macie uses OR logic to join the values.


=head2 EqExactMatch => ArrayRef[Str|Undef]

The value for the property exclusively matches (equals an exact match
for) all the specified values. If you specify multiple values, Amazon
Macie uses AND logic to join the values.

You can use this operator with the following properties:
customDataIdentifiers.detections.arn,
customDataIdentifiers.detections.name,
resourcesAffected.s3Bucket.tags.key,
resourcesAffected.s3Bucket.tags.value,
resourcesAffected.s3Object.tags.key,
resourcesAffected.s3Object.tags.value, sensitiveData.category, and
sensitiveData.detections.type.


=head2 Gt => Int

The value for the property is greater than the specified value.


=head2 Gte => Int

The value for the property is greater than or equal to the specified
value.


=head2 Lt => Int

The value for the property is less than the specified value.


=head2 Lte => Int

The value for the property is less than or equal to the specified
value.


=head2 Neq => ArrayRef[Str|Undef]

The value for the property doesn't match (doesn't equal) the specified
value. If you specify multiple values, Macie uses OR logic to join the
values.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

