# Generated by default/object.tt
package Paws::Transfer::ListedServer;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has Domain => (is => 'ro', isa => 'Str');
  has EndpointType => (is => 'ro', isa => 'Str');
  has IdentityProviderType => (is => 'ro', isa => 'Str');
  has LoggingRole => (is => 'ro', isa => 'Str');
  has ServerId => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has UserCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::ListedServer

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::ListedServer object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UserCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::ListedServer object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Returns properties of a file transfer protocol-enabled server that was
specified.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

Specifies the unique Amazon Resource Name (ARN) for a server to be
listed.


=head2 Domain => Str

Specifies the domain of the storage system that is used for file
transfers.


=head2 EndpointType => Str

Specifies the type of VPC endpoint that your server is connected to. If
your server is connected to a VPC endpoint, your server isn't
accessible over the public internet.


=head2 IdentityProviderType => Str

Specifies the mode of authentication for a server. The default value is
C<SERVICE_MANAGED>, which allows you to store and access user
credentials within the Amazon Web Services Transfer Family service.

Use C<AWS_DIRECTORY_SERVICE> to provide access to Active Directory
groups in Amazon Web Services Managed Active Directory or Microsoft
Active Directory in your on-premises environment or in Amazon Web
Services using AD Connectors. This option also requires you to provide
a Directory ID using the C<IdentityProviderDetails> parameter.

Use the C<API_GATEWAY> value to integrate with an identity provider of
your choosing. The C<API_GATEWAY> setting requires you to provide an
API Gateway endpoint URL to call for authentication using the
C<IdentityProviderDetails> parameter.


=head2 LoggingRole => Str

Specifies the Amazon Resource Name (ARN) of the Amazon Web Services
Identity and Access Management (IAM) role that allows a server to turn
on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When
set, user activity can be viewed in your CloudWatch logs.


=head2 ServerId => Str

Specifies the unique system assigned identifier for the servers that
were listed.


=head2 State => Str

Specifies the condition of a server for the server that was described.
A value of C<ONLINE> indicates that the server can accept jobs and
transfer files. A C<State> value of C<OFFLINE> means that the server
cannot perform file transfer operations.

The states of C<STARTING> and C<STOPPING> indicate that the server is
in an intermediate state, either not fully able to respond, or not
fully offline. The values of C<START_FAILED> or C<STOP_FAILED> can
indicate an error condition.


=head2 UserCount => Int

Specifies the number of users that are assigned to a server you
specified with the C<ServerId>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

