#! /usr/bin/perl -w
use strict;
use vars qw($VERSION);
$VERSION = "0.12";

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $xs   = eval 'use Heap::Simple::XS;   $Heap::Simple::XS::VERSION   || 0.01';
my $perl = eval 'use Heap::Simple::Perl; $Heap::Simple::Perl::VERSION || 0.01';

my %want;
my $simple = "lib/Heap/Simple.pm";
open(local *SIMPLE, "< $simple") || die "Could not open $simple: $!";
while (<SIMPLE>) {
    while (/\bHeap::Simple::(\w+)\(([^\)]+)\)/g) {
        die "Found a demand for both version $2 and $want{1} of Heap::Simple::$1 in $simple" if exists $want{$1} && $want{$1} ne $2;
        $want{$1} = $2;
    }
}
exists $want{XS} ||
    die "Found no minimum version for Heap::Simple::XS in $simple";
exists $want{Perl} ||
    die "Found no minimum version for Heap::Simple::Perl in $simple";

if ($xs) {
    if ($xs < $want{XS}) {
        print <<"EOT"

I would like to use 'Heap::Simple::XS' on your setup, but you only have version
$xs, while I need at least $want{XS}, so I won't as things stand now. This is
a runtime decission though, so I will if you later upgrade Heap::Simple::XS.
However, to avoid a period where the XS version won't get selected you might
prefer to upgrade Heap::Simple::XS first.

EOT
    } else {
        print <<"EOT"

I will probably use 'Heap::Simple::XS' on your setup. Very good.
(the actual decission is deferred to runtime).

EOT
    }
} elsif (!($xs && $xs >= $want{XS}) && $perl) {
    if ($perl < $want{Perl}) {
        print <<'EOT'

I would like to use 'Heap::Simple::Perl' on your setup, but you only have
version $perl, while I need at least $want{Perl}, so I won't as things stand
now. This is a runtime decission though, so I will if you later upgrade
Heap::Simple::Perl. However, to avoid a period where the XS version won't get
selected you might prefer to upgrade Heap::Simple::Perl first.

EOT
    } else {
        print <<'EOT'

I will probably use 'Heap::Simple::Perl' on your setup, which is perfectly fine
(the actual decission is deferred to runtime). You might consider also
installing 'Heap::Simple::XS' though

EOT
    }
}
unless ($xs || $perl) {
    print <<'EOT'

You seem to have neither 'Heap::Simple::XS' nor 'Heap::Simple::Perl' installed.
That should not stop this package from getting installed (in fact, you'll need
to install this package before you can install any of the other two).
However, this package won't be usable until you install one (or both) of these
two.

EOT
}
WriteMakefile
    (NAME		=> 'Heap::Simple',
     VERSION_FROM	=> "lib/Heap/Simple/Package.pm",
     PREREQ_PM		=> {}, # e.g., Module::Name => 1.1
     ($] >= 5.005 ?	## Add these new keywords supported since 5.005
      (AUTHOR		=> 'Ton Hospel <Heap-Simple@ton.iguana.be>') : ()),
     $^O eq "MSWin32" ? (
         PM_FILTER	=> '$(PERL) -p -e1',
     ) : (),
     clean		=> {
         FILES => '$(DISTNAME).ppd ppm cover_db',
     },
);

# START MY
# autogenerated by release_pm
package MY;
sub postamble {
    return shift->SUPER::postamble() . <<"EOF";
ppm: \$(DISTNAME).ppd

\$(DISTNAME).ppd: all ppd
	makeppd.pl "--perl=\$(PERL)" --min_version=1.013 "--zip=\$(ZIP)" "--tar=\$(TAR)" "--compress=\$(COMPRESS)" --leave=ppm \$(DISTNAME).ppd \$(VERSION)

cover:
	cover -delete
	-HARNESS_PERL_SWITCHES=-MDevel::Cover make test
	cover

ppm_install: \$(DISTNAME).ppd
	ppm install ppm/\$(DISTNAME).ppd

ppm_uninstall:
	ppm uninstall \$(DISTNAME)
EOF
}
# END MY
