# Generated by default/object.tt
package Paws::MediaTailor::SecretsManagerAccessTokenConfiguration;
  use Moose;
  has HeaderName => (is => 'ro', isa => 'Str');
  has SecretArn => (is => 'ro', isa => 'Str');
  has SecretStringKey => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::SecretsManagerAccessTokenConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::SecretsManagerAccessTokenConfiguration object:

  $service_obj->Method(Att1 => { HeaderName => $value, ..., SecretStringKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::SecretsManagerAccessTokenConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->HeaderName

=head1 DESCRIPTION

AWS Secrets Manager access token configuration parameters. For
information about Secrets Manager access token authentication, see
Working with AWS Secrets Manager access token authentication
(https://docs.aws.amazon.com/mediatailor/latest/ug/channel-assembly-access-configuration-access-token.html).

=head1 ATTRIBUTES


=head2 HeaderName => Str

The name of the HTTP header used to supply the access token in requests
to the source location.


=head2 SecretArn => Str

The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that
contains the access token.


=head2 SecretStringKey => Str

The AWS Secrets Manager SecretString
(https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html#SecretsManager-CreateSecret-request-SecretString.html)
key associated with the access token. MediaTailor uses the key to look
up SecretString key and value pair containing the access token.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

