#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

DEN INTERNASJONALE FRÅSEGNA OM MENNESKERETTANE
INNLEIING
Då det å godkjenne det naturlege menneskeverdet med like og umissande rettar for alle menneske på jorda er grunnlaget for fridom, rettferd og fred i verda,

og då hån og vørdsløyse mot menneskerettane har ført til barbariske handlingar som har skaka samvitet til menneskeretta, er framvoksteren i den verda der menneska skal ha talefridom og trusfridom og vere løyste frå otte og naud, kunngjord som det høgste målet for kvart menneske,

og då det er nødvendig at menneskerettane blir verna om av lover slik at menneska ikkje blir tvinga til å finne den siste utvegen i å gjere opprør mot tyranni og trælekår,

og då det er nødvendig å arbeide for betre tilhøve mellom nasjonane,

og då folka i Dei Sameinte Nasjonane har stadfest trua si i denne pakta, på grunnleggjande menneskerettar, på menneskeverd og på same rett for mann og kvinne, og har vedteke å arbeide for sosiale framsteg og betre levevilkår i større fridom,

og då medlemsstatane har bunde seg til å fremje allmenn vørdnad for pakta og halde seg etter menneskerettane og den grunnleggjande fridomen i samarbeid med Dei Sameinte Nasjonane,

og då denne retten og fridomen må bli godkjend av alle dersom pakta skal bli røyndom,

KUNNGJER

GENERALFORSAMLINGA

DEN INTERNASJONALE FRÅSEGNA OM MENNESKERETTANE, som skal peike mot eit sams mål for alle folk og nasjonar. Fråsegna må alltid vere i tankane til den einskilde og dei styrande og få dei til å styrkje vørdnaden for rett og fridom gjennom undervisning og oppseding. Dei skal syte for at fråsegna blir allment kjend og etterlevd både i medlemslanda og i tilsynsområda, og arbeide trufast med dette både på nasjonalt og internasjonalt grunnlag.

Artikkel 1.
Alle menneske er fødde til fridom og med same menneskeverd og menneskerettar. Dei har fått fornuft og samvit og skal leve med kvarandre som brør.

Artikkel 2.
Kvar einskild har krav på all den rett og fridom som fråsegna nemner, utan skilnad av noko slag på grunn av rase, farge, kjønn, språk, religion, politisk syn eller anna meining, nasjonalt eller sosialt opphav, eigedom, fødsel eller andre tilhøve.

Den politiske stoda, lovverket eller dei internasjonale påboda eit land lever under, kan ikkje vere påskott til at det blir gjort skilnad på nokon i det landet eller området han høyrer til, anten landet har sjølvstende, står under tilsyn, er ikkje-sjølvstyrt eller sjølvstyret er avgrensa på nokon annan måte.

Artikkel 3.
Alle har rett til liv, fridom og personleg tryggleik.

Artikkel 4.
Ingen skal haldast i slaveri eller trældom. Slaveri og slavehandel av alle slag er forbode.

Artikkel 5.
Ingen må torturerast, pinast eller straffast på umenneskeleg eller nedsetjande vis.

Artikkel 6.
Alle menneske har krav på at domstolane alle stader godtek dei som rettssubjekt.

Artikkel 7.
Alle er like for lova og har krav på same rettsvern, utan skilnad av noko slag. Alle har krav på same vern mot at det blir gjort skilnad på folk i strid med denne fråsegna, og vern mot tiltak som ber i seg ein slik fare.

Artikkel 8.
Alle har rett til å få fullgod hjelp frå dei lovlege nasjonale domstolane når det gjeld handlingar som krenkjer den retten den einskilde har fått i grunnlova eller lovverket elles.

Artikkel 9.
Ingan må utan lov og rett arresterast, setjast i fengsel eller visast ut or landet.

Artikkel 10.
Alle har same rett til å få saka si rettferdig og offentleg granska av ein sjølvstendig og upartisk domstol, både når det er pliktene og retten til den einskilde som skal fastsetjast, og når det er reist klagemål mot han.

Artikkel 11.
Den som er klaga for ei straffbar handling, har rett til å bli rekna som skuldlaus til ein offentleg domstol, der han har fått full trygd for retten til å forsvare seg, har prova at han er skuldig etter lova.
Ingen skal kjennast skuldig i ei straffbar handling når det han har gjort eller forsømt ikkje streid mot nasjonal lov eller folkeretten på den tida det hende. Han må heller ikkje dømast hardare enn det lova gav høve til då den straffbare handlinga vart utførd.
Artikkel 12.
Ingen skal lide under vilkårleg innblanding frå andre, anten det gjeld hans eigen person, familie, heim, brevskifte, eller åtak på ære og omdøme. Alle har krav på at lova vernar dei mot slik innblanding eller slike åtak.

Artikkel 13.
Alle menneske har rett til å ferdast fritt og til å velje bustad innafor grensene i sitt eige land.
Det skal også vere full rett til å reise ut or det landet ein bur i, same kva land det er, og til å vende attende til sitt eige land.
Artikkel 14.
Alle som blir forfølgde har rett til å søkje og ta imot asyl i eit anna land.
Denne retten gjeld ikkje i rettssakar som har røynleg grunnlag i upolitiske brotsverk eller handlingar som strir mot formålet og prinsippet til Dei Sameinte Nasjonane.
Artikkel 15.
Alle har rett til eit statsborgarskap.
Ingen skal misse statsborgarskapet sitt vilkårleg, eller bli nekta retten til å endre det.
Artikkel 16.
Vaksne menn og kvinner har rett til å gifte seg og skipe familie utan avgrensing av noko slag på grunn av rase, nasjonalitet eller religion. Dei har krav på dei same rettane når det gjeld ekteskapet, både så lenge ekteskapet varer og medan det blir løyst opp.
Ekteskapet må berre kome i stand etter fritt og fullt samtykke frå begge partar.
Familien er den naturlege og grunnleggjande eininga i samfunnet og har krav på at staten og samfunnet vernar om det.
Artikkel 17.
Alle har rett til å ha eigedom åleine og saman med andre.
Ingen skal vilkårleg bli fråteken eigedomen sin.
Artikkel 18.
Alle har rett til tankefridom, samvitsfridom og religionfridom. Denne retten gjeld fridom til å endre religion eller tru, og fridom til å målbere sin eigen religion eller si eiga truslære i gjerning og framferd, anten åleine eller saman med andre, offentleg eller privat.

Artikkel 19.
Alle skal ha meinings- og ytringsfridom. Denne retten gjeld fridom til å ha meiningar utan innblanding, til å søkje, ta imot og gjere kjent opplysningar og idear gjennom alle dei informasjonskanalar som finst, og på tvers av alle grenser.

Artikkel 20.
Alle har rett til fritt å vere med på møte og i organisasjonar med fredelege formål.
Ingen kan tvingast inn i ein organisasjon.
Artikkel 21.
Alle skal ha rett til å vere med på å styre landet sitt, beinveges eller gjennom talsmenn som er peika ut i frie val.
Alle skal ha same retten til å gjere teneste i offentlege ombod i landet sitt.
Folkeviljen skal vere grunnlaget for den makta som er lagd til styremaktene. Folkeviljen skal kome til syne gjennom regelfaste og røynlege val, som er grunna på allmenn og lik røysterett i løynlege val eller på annan jamgod røystemåte.
Artikkel 22.
Kvar einskild medlem i samfunnet har rett til sosial tryggleik, og har krav på at dei økonomiske, sosiale og kulturelle godane, som han ikkje kan vere utan om han skal ha vørdnad for seg sjølv og styrke den personlege karakteren sin, blir løyste gjennom nasjonale tiltak og internasjonalt samarbeid i samsvar med det kvar stat maktar.

Artikkel 23.
Alle har rett til arbeid, til fritt å velje yrke, til rettferdige og gode arbeidstilhøve og vern mot arbeidsløyse.
Alle har same rett til å få lik betaling for likt arbeid, utan skilnad av noko slag.
Den som arbeider har krav på rettferdig og god betaling, så han kan syte for familien sin og seg sjølv på ein menneskeverdig måte, og om det trengst, få hjelp gjennom andre og utfyllande sosiale midlar.
Alle har rett til å skipe og melde seg inn i fagforeningar for å verne interessene sine.
Artikkel 24.
Alle har rett til kvile og fritid, og dermed til ei rimeleg avgrensa arbeidstid, og til ferie med løn.

Artikkel 25.
Alle har rett til ein levestandard som kan tryggje helsa og velværet til forsytaren og familien hans, og gje dei mat, klede, hus, helsestell og nødvendige sosiale trygder ved arbeidsløyse, uføre, dødsfall, alderdom eller andre tilhøve som skiplar livskåra, og som forsytaren ikkje er herre over.
Mor og barn har rett til særskild omsorg og hjelp. Alle barn skal ha same sosiale vern, anten dei er fødde i eller utafor ekteskapet.
Artikkel 26.
Alle har rett til undervisning. Opplæringa skal vere kostnadsfri, i det minste i den allmenne grunnskulen. Den elementære undervisninga skal vere pliktig for alle. Alle skal ha høve til å få fagopplæring, og det skal vere like vilkår for alle til å få høgre utdaning, alt etter dei evnene dei har.
Undervisninga skal ha til mål å styrkje den menneskelege personlegdomen og auke vørdnaden for menneskerettane og den grunnleggjande fridomen, fremje skjønsemd, toleranse og venskap mellom alle nasjonar, folkeslag og religiøse grupper og stø fredsarbeidet til Dei Sameinte Nasjonane.
Foreldra har førsteretten til å velje kva slag opplæring barna deira skal få.
Artikkel 27.
Alle har rett til fritt å vere med i det kulturelle livet i samfunnet, til å nyte kunst og til å få sin part av dei vitskaplege nyvinningane og godane som følgjer med dei.
Kvar einskild har rett til å få verna dei moralske og materielle interessene som han har skapt seg gjennom vitskapleg, litterært eller kunstnarleg arbeid.
Artikkel 28.
Alle har krav på å få leve under slike sosiale kår og internasjonale tilhøve at dei fullt ut kan gjere til røyndom retten og fridomen i denne fråsegna.

Artikkel 29.
Alle har plikter andsynes samfunnet, då personlegdomen til den einskilde einast der kan få frie og fullgode voksterkår.
Retten og fridomen til den einskilde skal ikkje vere avgrensa av anna enn det lova tydeleg slår fast for å tryggje den vørdnaden alle andre har krav på når det gjeld rett og fridom, og dei krav som eit demokratisk samfunn med rette kan setje til moral, offentleg orden og allmenn velferd.
Denne retten og fridomen kan ikkje i noko høve nyttast i strid med formålet og prinsippet til Dei Sameinte Nasjonane.
Artikkel 30.
Ikkje noko i denne fråsegna må tolkast slik at det gjev stat, grupper eller einskildmenneske rett til å vere med på tiltak eller handlingar av noko slag som har til mål å øydeleggje den retten og fridomen som denne fråsegna stadfester.


TEXT

#is(Text::Guess::Language->guess($text),'no','is no');

done_testing;
