package AI::MicroStructure::WordBlacklist;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

sub getStopWordsSmall{
my @search = ("a","a's","able","about","above","according","accordingly","across","actually","after","afterwards","again","against","ain't","all","allow","allows","almost","alone","along","already","also","although","always","am","among","amongst","an","and","another","any","anybody","anyhow","anyone","anything","anyway","anyways","anywhere","apart","appear","appreciate","appropriate","are","aren't","around","as","aside","ask","asking","associated","at","available","away","awfully","b","be","became","because","become","becomes","becoming","been","before","beforehand","behind","being","believe","below","beside","besides","best","better","between","beyond","both","brief","but","by","c","c'mon","c's","came","can","can't","cannot","cant","cause","causes","certain","certainly","changes","clearly","co","com","come","comes","concerning","consequently","consider","considering","contain","containing","contains","corresponding","could","couldn't","course","currently","d","definitely","described","despite","did","didn't","different","do","does","doesn't","doing","don't","done","down","downwards","during","e","each","edu","eg","eight","either","else","elsewhere","enough","entirely","especially","et","etc","even","ever","every","everybody","everyone","everything","everywhere","ex","exactly","example","except","f","far","few","fifth","first","five","followed","following","follows","for","former","formerly","forth","four","from","further","furthermore","g","get","gets","getting","given","gives","go","goes","going","gone","got","gotten","greetings","h","had","hadn't","happens","hardly","has","hasn't","have","haven't","having","he","he's","hello","help","hence","her","here","here's","hereafter","hereby","herein","hereupon","hers","herself","hi","him","himself","his","hither","hopefully","how","howbeit","however","i","i'd","i'll","i'm","i've","ie","if","ignored","immediate","in","inasmuch","inc","indeed","indicate","indicated","indicates","inner","insofar","instead","into","inward","is","isn't","it","it'd","it'll","it's","its","itself","j","just","k","keep","keeps","kept","know","knows","known","l","last","lately","later","latter","latterly","least","less","lest","let","let's","like","liked","likely","little","look","looking","looks","ltd","m","mainly","many","may","maybe","me","mean","meanwhile","merely","might","more","moreover","most","mostly","much","must","my","myself","n","name","namely","nd","near","nearly","necessary","need","needs","neither","never","nevertheless","new","next","nine","no","nobody","non","none","noone","nor","normally","not","nothing","novel","now","nowhere","o","obviously","of","off","often","oh","ok","okay","old","on","once","one","ones","only","onto","or","other","others","otherwise","ought","our","ours","ourselves","out","outside","over","overall","own","p","particular","particularly","per","perhaps","placed","please","plus","possible","presumably","probably","provides","q","que","quite","qv","r","rather","rd","re","really","reasonably","regarding","regardless","regards","relatively","respectively","right","s","said","same","saw","say","saying","says","second","secondly","see","seeing","seem","seemed","seeming","seems","seen","self","selves","sensible","sent","serious","seriously","seven","several","shall","she","should","shouldn't","since","six","so","some","somebody","somehow","someone","something","sometime","sometimes","somewhat","somewhere","soon","sorry","specified","specify","specifying","still","sub","such","sup","sure","t","t's","take","taken","tell","tends","th","than","thank","thanks","thanx","that","that's","thats","the","their","theirs","them","themselves","then","thence","there","there's","thereafter","thereby","therefore","therein","theres","thereupon","these","they","they'd","they'll","they're","they've","think","third","this","thorough","thoroughly","those","though","three","through","throughout","thru","thus","to","together","too","took","toward","towards","tried","tries","truly","try","trying","twice","two","u","un","under","unfortunately","unless","unlikely","until","unto","up","upon","us","use","used","useful","uses","using","usually","uucp","v","value","various","very","via","viz","vs","w","want","wants","was","wasn't","way","we","we'd","we'll","we're","we've","welcome","well","went","were","weren't","what","what's","whatever","when","whence","whenever","where","where's","whereafter","whereas","whereby","wherein","whereupon","wherever","whether","which","while","whither","who","who's","whoever","whole","whom","whose","why","will","willing","wish","with","within","without","won't","wonder","would","would","wouldn't","x","y","yes","yet","you","you'd","you'll","you're","you've","your","yours","yourself","yourselves","z","zero");
return @search;
}
sub getStopWords {
if ( @_ and $_[0] eq 'UTF-8' ) {
# adding U0 causes the result to be flagged as UTF-8
my %stoplist = map { ( pack("U0a*", $_), 1 ) } qw(
a able about above according accordingly across actually after afterwards again against aint all allow allows almost alone along already also although always am among amongst an and another any anybody anyhow anyone anything anyway anyways anywhere apart appear appreciate appropriate are arent around as as aside ask asking associated at available away awfully
b be became because become becomes becoming been before beforehand behind being believe below beside besides best better between beyond both brief but by
c came can cannot cant cant cause causes certain certainly changes clearly cmon co com come comes concerning consequently consider considering contain containing contains corresponding could couldnt course cs currently
d definitely described despite did didnt different do does doesnt doing done dont down downwards during
e each edu eg eight either else elsewhere enough entirely especially et etc even ever every everybody everyone everything everywhere ex exactly example except
f far few fifth first five followed following follows for former formerly forth four from further furthermore
g get gets getting given gives go goes going gone got gotten greetings
h had hadnt happens hardly has hasnt have havent having he hello help hence her here hereafter hereby herein heres hereupon hers herself hes hi him himself his hither hopefully how howbeit however
i id ie if ignored ill im immediate in inasmuch inc indeed indicate indicated indicates inner insofar instead into inward is isnt it itd itll its its itself ive
j just k keep keeps kept know known knows
l last lately later latter latterly least less lest let lets like liked likely little look looking looks ltd
m mainly many may maybe me mean meanwhile merely might more moreover most mostly much must my myself
n name namely nd near nearly necessary need needs neither never nevertheless new next nine no nobody non none noone nor normally not nothing novel now nowhere
o obviously of off often oh ok okay old on once one ones only onto or other others otherwise ought our ours ourselves out outside over overall own
p particular particularly per perhaps placed please plus possible presumably probably provides
q que quite qv r rather rd re really reasonably regarding regardless regards relatively respectively right
s said same saw say saying says second secondly see seeing seem seemed seeming seems seen self selves sensible sent serious seriously seven several shall she should shouldnt since six so some somebody somehow someone something sometime sometimes somewhat somewhere soon sorry specified specify specifying still sub such sup sure
t take taken tell tends th than thank thanks thanx that thats thats the their theirs them themselves then thence there thereafter thereby therefore therein theres theres thereupon these they theyd theyll theyre theyve think third this thorough thoroughly those though three through throughout thru thus to together too took toward towards tried tries truly try trying ts twice two
u un under unfortunately unless unlikely until unto up upon us use used useful uses using usually uucp
v value various very via viz vs
w want wants was wasnt way we wed welcome well well went were were werent weve what whatever whats when whence whenever where whereafter whereas whereby wherein wheres whereupon wherever whether which while whither who whoever whole whom whos whose why will willing wish with within without wonder wont would would wouldnt
x
y yes yet you youd youll your youre yours yourself yourselves youve
z zero
air anr arm cke ckg ckl duo ged gie hie ihk las len lie llt los lte max mmt mvv opa rer rkt sap spr str ung utf zoo zuf zuh abo awo bef beh bmw cks daf del ern geh gen hne hof hrl lle lze mer nau ner ost pfe ppg pur rde rin rke sen tee tvf uni vri wut zug zun abf anw fte mcv nge ngt spa sst ten tes tsv vfr abh bat big gem men nat nde obi rma tte aff alt art che eng hlt hrt ler nsa ste tag tzt app ben ckt gef ser ter ume zus hmt jan suv ude gel hei gew jay eva nen wei ren ger sch tze ver gro ber uhr
i me my myself we our ours ourselves you your yours yourself
yourselves he him his himself she her hers herself it its
itself they them their theirs themselves what which who whom
this that these those am is are was were be been being have has
had having do does did doing would should could ought i'm
you're he's she's it's we're they're i've you've we've they've
i'd you'd he'd she'd we'd they'd i'll you'll he'll she'll we'll
they'll isn't aren't wasn't weren't hasn't haven't hadn't
doesn't don't didn't won't wouldn't shan't shouldn't can't
cannot couldn't mustn't let's that's who's what's here's
there's when's where's why's how's a an the and but if or
because as until while of at by for with about against between
into through during before after above below to from up down in
out on off over under again further then once here there when
where why how all any both each few more most other some such
no nor not only own same so than too very a a's able about above
according accordingly across actually after afterwards again against
ain't all allow allows almost alone along already also although always
am among amongst an and another any anybody anyhow anyone anything
anyway anyways anywhere apart appear appreciate appropriate are aren't
around as aside ask asking associated at available away awfully b be
became because become becomes becoming been before beforehand behind
being believe below beside besides best better between beyond both brief
but by c c'mon c's came can can't cannot cant cause causes certain
certainly changes clearly co com come comes concerning consequently
consider considering contain containing contains corresponding could
 couldn't course currently d definitely described despite did didn't
 different do does doesn't doing don't done down downwards during e each
  edu eg eight either else elsewhere enough entirely especially et etc
  even ever every everybody everyone everything everywhere ex exactly
  example except f far few fifth first five followed following follows
  for former formerly forth four from further furthermore g get gets
  getting given gives go goes going gone got gotten greetings h had
   hadn't happens hardly has hasn't have haven't having he he's hello
   help hence her here here's hereafter hereby herein hereupon hers
   herself hi him himself his hither hopefully how howbeit however
    i i'd i'll i'm i've ie if ignored immediate in inasmuch inc indeed
    indicate indicated indicates inner insofar instead into inward is
     isn't it it'd it'll it's its itself j just k keep keeps kept know
     knows known l last lately later latter latterly least less lest let
      let's like liked likely little look looking looks ltd m mainly many
       may maybe me mean meanwhile merely might more moreover most
       mostly much must my myself n name namely nd near nearly necessary
        need needs neither never nevertheless new next nine no nobody non
none noone nor normally not nothing novel now nowhere o obviously of
off often oh ok okay old on once one ones only onto or other others otherwise ought
our ours ourselves out outside over overall own
p particular particularly per perhaps placed please plus possible presumably probably
provides q que quite qv r rather rd re really reasonably regarding regardless regards
relatively respectively right s said same saw say saying says second secondly see seeing seem seemed seeming seems seen self selves sensible sent serious seriously seven
several shall she should shouldn't since six
so some somebody somehow someone something sometime sometimes somewhat somewhere soon sorry specified specify specifying still sub such sup sure t t's take taken tell tends th than thank thanks thanx that that's thats the their theirs them themselves then thence there there's thereafter thereby therefore therein theres thereupon these they they'd they'll they're they've think third this thorough thoroughly those though three through throughout thru thus to together too took toward towards tried tries truly try trying twice two u un under unfortunately unless unlikely until unto up upon us use used useful uses using usually uucp v value various very via viz vs w want wants was wasn't way we we'd we'll we're we've welcome well went were weren't what what's whatever when whence whenever where where's whereafter whereas whereby wherein whereupon wherever whether which while whither who who's whoever whole whom whose why will willing wish with within without won't wonder would would wouldn't x y yes yet you you'd you'll you're you've your yours yourself yourselves z zero  aaa bbb ccc ddd eee fff ggg hhh iii jjj kkk lll mmm nnn ooo ppp qqq rrr sss ttt eee fff ggg hhh iii jjj kkk lll mmm nnn ooo ppp
qqq rrr sss ttt uuu vvv www xxx yyy zzz .... unsere ihrer uns wurde wer gegen diesem bis nur wieder unserem einer war man bei wir einen vom einem unter jeder werden wie als durch zum hat vor unseres email bel ihnen unseren bzw lieber uft kommen nicht stehen melden ihrem ihren eines ist schon unserer zur aus des nachrichtenportal dem geben von haben neckar rhein auf bitte mit ein das den und der die sie ab aber abermaliges abermals abgerufen abgerufene abgerufener abgerufenes acht aehnlich aehnliche aehnlichem aehnlichen aehnlicher aehnliches aehnlichste aehnlichstem aehnlichsten aehnlichster aehnlichstes aeusserst aeusserste aeusserstem aeussersten aeusserster aeusserstes aeuerst aeuerste aeuerstem aeuersten aeuerster aeuerstes alle allein alleine allem allemal allen allenfalls allenthalben aller allerdings allerlei alles allesamt allg allg. allgemein allgemeine allgemeinem allgemeinen allgemeiner allgemeines allgemeinste allgemeinstem allgemeinsten allgemeinster allgemeinstes allmhlich allzeit allzu als alsbald also am an andauernd andauernde andauerndem andauernden andauernder andauerndes ander andere anderem anderen anderer andererseits anderes anderm andern andernfalls anders anderst anderweitig anderweitige anderweitigem
anderweitigen anderweitiger anderweitiges anerkannt anerkannte anerkannter anerkanntes anfangen anfing angefangen angesetze angesetzt angesetzten angesetzter ans anscheinend ansetzen ansonst ansonsten anstatt anstelle arbeiten auch auf aufgehrt aufgrund aufhren aufhrte aufzusuchen augenscheinlich augenscheinliche augenscheinlichem augenscheinlichen augenscheinlicher augenscheinliches augenscheinlichst augenscheinlichste augenscheinlichstem augenscheinlichsten augenscheinlichster augenscheinlichstes aus ausdrcken ausdrcklich ausdrckliche ausdrcklichem ausdrcklichen ausdrcklicher ausdrckliches ausdrckt ausdrckte ausgenommen ausgenommene ausgenommenem ausgenommenen ausgenommener ausgenommenes ausgerechnet ausgerechnete ausgerechnetem ausgerechneten ausgerechneter ausgerechnetes ausnahmslos ausnahmslose ausnahmslosem ausnahmslosen ausnahmsloser ausnahmsloses ausser ausserdem ausserhalb author autor auen auer auerdem auerhalb baelde bald bearbeite bearbeiten bearbeitete bearbeiteten bedarf bedurfte bedrfen befahl befiehlt befiehlte befohlene befohlens befragen befragte befragten befragter begann beginnen begonnen behalten behielt bei beide beidem beiden beider beiderlei beides beim beinahe beisammen beispielsweise beitragen beitrugen bekannt bekannte bekannter bekanntlich bekanntliche bekanntlichem bekanntlichen bekanntlicher bekanntliches bekennen benutzt bereits berichten berichtet berichtete berichteten besonders besser
bessere besserem besseren besserer besseres bestehen besteht bestenfalls bestimmt bestimmte bestimmtem bestimmten bestimmter bestimmtes betraechtlich betraechtliche betraechtlichem betraechtlichen betraechtlicher betraechtliches betreffend betreffende betreffendem betreffenden betreffender betreffendes betrchtlich betrchtliche betrchtlichem betrchtlichen betrchtlicher betrchtliches bevor bez bez. bezgl bezgl. bezueglich bezglich bietet bin bis bisher bisherige bisherigem bisherigen bisheriger bisheriges bislang bisschen bist bichen bleiben blieb bloss blo brachte brachten brauchen braucht bringen bruchte bsp bsp. bspw bspw. bzw bzw. blde bden ca ca. circa da dabei dadurch dafuer dafr dagegen daher dahin dahingehend dahingehende dahingehendem dahingehenden dahingehender dahingehendes dahinter damalige damaligem damaligen damaliger damaliges damals damit danach daneben dank danke danken dann dannen daran darauf daraus darf darfst darin darueber darueberhinaus darum darunter darber darberhinaus das dass dasselbe Dat davon davor dazu dazwischen da dein deine deinem deinen deiner deines dem demgegenueber demgegenber demgemaess demgemae demgemss demgem demnach demselben den denen denkbar denkbare denkbarem denkbaren denkbarer denkbares denn dennoch denselben der derart derartig derartige derartigem derartigen derartiger derem deren derer derjenige derjenigen derselbe derselben derzeit derzeitig derzeitige derzeitigem derzeitigen derzeitiges des deshalb desselben dessen dessenungeachtet desto desungeachtet deswegen dich die diejenige diejenigen dies diese dieselbe dieselben diesem diesen dieser dieses diesseitig diesseitige diesseitigem diesseitigen diesseitiger
diesseitiges diesseits dinge dir direkt direkte direkten direkter doch doppelt dort dorther dorthin dran drauf drei dreiig drin dritte drueber drum drunter drber du dunklen durch durchaus durchweg durchwegs durfte durften drfen drfte eben ebenfalls ebenso ect ect. ehe eher eheste ehestem ehesten ehester ehestes eigen eigene eigenem eigenen eigener eigenes eigenst eigentlich eigentliche eigentlichem eigentlichen eigentlicher eigentliches ein einban eine einem einen einer einerlei einerseits eines einfach einfhren einfhrte einfhrten eingesetzt einig einige einigem einigen einiger einigermassen einigermaen einiges einmal einmalig einmalige einmaligem einmaligen einmaliger einmaliges eins einseitig einseitige einseitigen einseitiger einst einstmals einzig empfunden ende entgegen entlang entsprechend entsprechende entsprechendem entsprechenden
entsprechender entsprechendes entweder er ergo ergnze ergnzen ergnzte ergnzten erhalten erhielt erhielten erhlt erneut erst erste erstem ersten erster erstere ersterem ersteren ersterer ersteres erstes erffne erffnen erffnet erffnete erffnetes es etc etc. etliche etlichem etlichen etlicher etliches etwa etwaige etwas euch euer eure eurem euren eurer eures euretwegen fall falls fand fast ferner finden findest findet folgend folgende folgendem folgenden folgender folgendermassen folgendermaen folgendes folglich fordern fordert forderte forderten fortsetzen fortsetzt fortsetzte fortsetzten fragte frau frei freie freier freies fuer fuers fnf fr frs gab gaenzlich gaenzliche gaenzlichem gaenzlichen gaenzlicher gaenzliches ganz ganze ganzem ganzen ganzer ganzes gar gbr geb geben geblieben gebracht gedurft geehrt geehrte geehrten geehrter gefallen gefiel geflligst gefllt gegeben gegen gegenueber gegenber gehabt gehen geht gekommen gekonnt gemacht gemaess gemeinhin gemocht gemss genau genommen genug gepriesener gepriesenes gerade gern gesagt gesehen gestern gestrige getan geteilt geteilte getragen gewesen gewiss gewisse gewissem gewissen gewisser gewissermaen gewisses gewollt geworden ggf ggf. gib gibt gleich gleiche gleichem gleichen gleicher gleiches gleichsam gleichste gleichstem gleichsten gleichster gleichstes gleichwohl gleichzeitig gleichzeitige gleichzeitigem gleichzeitigen gleichzeitiger gleichzeitiges gluecklicherweise glcklicherweise gmbh gottseidank gratulieren gratuliert gratulierte groesstenteils groetenteils grsstenteils grtenteils gute guten gngig gngige gngigen gngiger gngiges gnzlich gnzliche gnzlichem gnzlichen gnzlicher gnzliches hab habe haben haette haeufig haeufige haeufigem haeufigen haeufiger haeufigere haeufigeren haeufigerer haeufigeres halb hallo hast hat hatte hatten hattest hattet hen her heraus herein herum heute heutige heutigem heutigen heutiger heutiges hier hierbei hiermit hiesige hiesigem hiesigen hiesiger hiesiges hin hinein hingegen hinlanglich hinlnglich hinten hinter hinterher hinterm hintern hoch http hundert htt htte htten hufig
hufige hufigem hufigen hufiger hufigere hufigeren hufigerer hufigeres hchst hchstens ich igitt ihm ihn ihnen ihr ihre ihrem ihren ihrer ihres ihretwegen im immer immerhin immerwaehrend immerwaehrende immerwaehrendem immerwaehrenden immerwaehrender immerwaehrendes immerwhrend immerwhrende immerwhrendem immerwhrenden immerwhrender immerwhrendes immerzu important in indem indessen Inf. info infolge infolgedessen innen innerhalb ins insbesondere insgeheim insgeheime insgeheimer insgesamt insgesamte insgesamter insofern inzwischen irgend irgendein irgendeine irgendeinem irgendeiner irgendeines irgendjemand irgendjemandem irgendwann irgendwas irgendwen irgendwer irgendwie irgendwo ist ja jaehrig jaehrige jaehrigem jaehrigen jaehriger jaehriges je jede jedem jeden jedenfalls jeder jederlei jedes jedesmal jedoch jeglichem
jeglichen jeglicher jegliches jemals jemand jene jenem jenen jener jenes jenseitig jenseitigem jenseitiger jenseits jetzt jhrig jhrige jhrigem jhrigen jhriges kaeumlich kam kann kannst kaum kein keine keinem keinen keiner keinerlei keines keineswegs klar klare klaren klares klein kleinen kleiner kleines koennen koennt koennte koennten komme kommen kommt konkret konkrete konkreten konkreter konkretes konnte konnten kuenftig kuerzlich kuerzlichst knftig krzlich krzlichst kumlich knn knnen knnt knnte knnten laengst lag lagen langsam lassen laut lediglich leer legen legte legten leicht leider lesen letze letzte letzten letztendlich letztens letztere letzterem letzterer letzteres letztes letztlich lichten liegt liest links lngst lngstens mache machen machst macht machte machten mag magst mal man manch manche manchem manchen mancher mancherlei mancherorts manches manchmal mann margin massgebend massgebende massgebendem massgebenden massgebender massgebendes massgeblich massgebliche massgeblichem massgeblichen massgeblicher mehr mehrere mehrerer mehrfach mehrmalig mehrmaligem mehrmaliger mehrmaliges mein meine meinem meinen meiner meines meinetwegen meins meist meiste meisten meistens meistenteils meta mich mindestens mir mit miteinander mitgleich mithin mitnichten mittels mittelst mitten mittig mitunter mitwohl mochte moeglichst moeglichste moeglichstem moeglichsten moeglichster morgen morgige muessen muesst muesste muss musst musste mussten mu mut mssen msste mssten mt mte mchte mchten mchtest mgen mglich mgliche mglichen mglicher mglicherweise mglichst mglichste mglichstem mglichsten mglichster nach nachdem nacher nachher nachhinein nacht
naechste naemlich nahm naturgemaess naturgemae naturgemss naturgem natrlich neben nebenan nehmen nein neu neue neuem neuen neuer neuerdings neuerlich neuerliche neuerlichem neuerlicher neuerliches neues neulich neun nicht nichts nichtsdestotrotz nichtsdestoweniger nie niemals niemand niemandem niemanden nimm nimmer nimmt nirgends nirgendwo noch noetigenfalls nun nur nutzen nutzt nutzung ntzt nchste nmlich ntigenfalls ob oben ober oberen oberer oberhalb oberste obersten oberster obgleich obs obschon obwohl oder oefter oefters offenkundig offenkundige offenkundigem offenkundigen offenkundiger offenkundiges offensichtlich offensichtliche offensichtlichem offensichtlichen offensichtlicher offensichtliches oft oftmals ohne ohnedies paar partout per persoenlich persoenliche persoenlichem persoenlicher persoenliches persnlich persnliche persnlicher persnliches pfui ploetzlich ploetzliche ploetzlichem ploetzlicher ploetzliches pltzlich pltzliche pltzlichem pltzlicher pltzliches pro quasi reagiere reagieren reagiert reagierte recht rechts regelmig reichlich reichliche reichlichem reichlichen reichlicher restlos restlose restlosem restlosen restloser restloses richtiggehend richtiggehende richtiggehendem richtiggehenden richtiggehender richtiggehendes rief rund rundheraus rundum runter sage sagen sagt sagte sagten sagtest samt sang sangen sattsam scheinbar schlechter schlicht schlichtweg schliesslich schlielich schlussendlich schnell schon schreibe schreiben schreibens schreiber schwerlich schwerliche schwerlichem schwerlichen schwerlicher schwerliches schwierig schtzen schtzt schtzte schtzten sechs sect sehe sehen sehr sehrwohl seht sei seid sein
seine seinem seinen seiner seines seit seitdem seite seiten seither selbe selben selber selbst selbstredend selbstredende selbstredendem selbstredenden selbstredender selbstredendes seltsamerweise senke senken senkt senkte senkten setzen setzt setzte setzten sich sicher sicherlich sie sieben siebte siehe sieht sind singt so sobald sodass soda soeben sofern sofort sog sogar sogleich solange solc solch solche solchem solchen solcher solches soll sollen sollst sollt sollte sollten solltest somit sondern sonst sonstig sonstige sonstigem sonstiger sonstwo sooft soviel soweit sowie sowieso sowohl spielen spter startet startete starteten statt stattdessen steht steige steigen steigt stellenweise stellenweisem stellenweisen stets stieg stiegen such suchen smtliche tages tat tatsaechlich tatsaechlichen tatsaechlicher tatsaechliches tatschlich tatschlichen tatschlicher tatschliches tausend teile teilen teilte teilten titel total trage tragen trotzdem trug trgt tun tust tut txt tt ueber ueberall ueberallhin ueberaus ueberdies ueberhaupt uebermorgen ueblicherweise uebrig uebrigens um ums umso umstaendehalber umstndehalber unbedingt unbedingte unbedingter unbedingtes und unerhoert unerhoerte unerhoertem unerhoerten unerhoerter unerhoertes unerhrt unerhrte unerhrtem unerhrten unerhrter unerhrtes ungefhr ungemein ungewoehnlich ungewoehnliche ungewoehnlichem ungewoehnlichen ungewoehnlicher ungewoehnliches ungewhnlich ungewhnliche ungewhnlichem ungewhnlichen ungewhnlicher ungewhnliches ungleich ungleiche ungleichem ungleichen ungleicher ungleiches unmassgeblich unmassgebliche unmassgeblichem unmassgeblichen unmassgeblicher unmassgebliches unmageblich unmagebliche
unmageblichem unmageblichen unmageblicher unmagebliches unmoeglich unmoegliche unmoeglichem unmoeglichen unmoeglicher unmoegliches unmglich unmgliche unmglichen unmglicher unntig uns unsaeglich unsaegliche unsaeglichem unsaeglichen unsaeglicher unsaegliches unsagbar unsagbare unsagbarem unsagbaren unsagbarer unsagbares unse unsem unsen unser unsere unserem unseren unserer unseres unserm unses unsre unsrem unsren unsrer unsres unstreitig unstreitige unstreitigem unstreitigen unstreitiger unstreitiges unsglich unsgliche unsglichem unsglichen unsglicher unsgliches unten unter unterbrach unterbrechen untere unterem unteres unterhalb unterste unterster unterstes unwichtig unzweifelhaft unzweifelhafte unzweifelhaftem unzweifelhaften unzweifelhafter unzweifelhaftes usw usw. vergangen vergangene vergangener vergangenes vermag vermutlich vermutliche vermutlichem vermutlichen vermutlicher vermutliches vermgen verrate verraten verriet verrieten version versorge versorgen versorgt versorgte versorgten versorgtes verffentlichen verffentlicher verffentlicht verffentlichte verffentlichten verffentlichtes viel viele vielen vieler vielerlei vieles vielleicht vielmalig vielmals vier voellig voellige voelligem voelligen voelliger voelliges voelligst
vollends vollstaendig vollstaendige vollstaendigem vollstaendigen vollstaendiger vollstaendiges vollstndig vollstndige vollstndigem vollstndigen vollstndiger vollstndiges vom von vor voran vorbei vorgestern vorher vorherig vorherige vorherigem vorheriger vorne vorueber vorber vllig vllige vlligem vlligen vlliger vlliges vlligst wachen waehrend waehrenddessen waere wann war waren warst warum was weder weg wegen weil weiter weitere weiterem weiteren weiterer weiteres weiterhin weitestgehend weitestgehende weitestgehendem weitestgehenden weitestgehender weitestgehendes weitgehend weitgehende weitgehendem weitgehenden weitgehender weitgehendes wei welche welchem welchen welcher welches wem wen wenig wenige weniger wenigstens wenn wenngleich wer werde werden werdet weshalb wessen wichtig wie wieder wiederum wieso wieviel wieviele wievieler wiewohl will willst wir wird wirklich wirklichem wirklicher wirkliches wirst wo wobei wodurch wofuer wofr wogegen woher wohin wohingegen wohl wohlgemerkt wohlweislich wolle wollen wollt wollte wollten wolltest wolltet womit womoeglich womoegliche womoeglichem womoeglichen womoeglicher womoegliches womglich womgliche womglichem womglichen womglicher womgliches woran woraufhin woraus worin wurde wurden www
wrde wrden whrend whrenddessen wr wre wren x bel ber berall berallhin beraus berdies berhaupt bermorgen blicherweise brig brigens z.B. zahlreich zahlreichem zahlreicher zB zb. zehn zeitweise zeitweisem zeitweisen zeitweiser ziehen zieht ziemlich ziemliche ziemlichem ziemlichen ziemlicher ziemliches zirka zog zogen zu zudem zuerst zufolge zugleich zuletzt zum zumal zumeist zumindest zunaechst zunchst zur zurueck zurck zusammen zusehends zuviel zuviele zuvieler zuweilen zwanzig zwar zwei zweifelsfrei zweifelsfreie zweifelsfreiem zweifelsfreien zweifelsfreier zweifelsfreies zwischen zwlf hnlich hnliche hnlichem hnlichen hnlicher hnliches hnlichst hnlichste hnlichstem hnlichsten hnlichster hnlichstes usserst usserste usserstem ussersten usserster usserstes uerst uerste uerstem uersten uerster uerstes fter fters);
return \%stoplist;
}
else {
my %stoplist = map { ( $_, 1 ) } qw(
a able about above according accordingly across actually after afterwards again against aint all allow allows almost alone along already also although always am among amongst an and another any anybody anyhow anyone anything anyway anyways anywhere apart appear appreciate appropriate are arent around as as aside ask asking associated at available away awfully
b be became because become becomes becoming been before beforehand behind being believe below beside besides best better between beyond both brief but by
c came can cannot cant cant cause causes certain certainly changes clearly cmon co com come comes concerning consequently consider considering contain containing contains corresponding could couldnt course cs currently
d definitely described despite did didnt different do does doesnt doing done dont down downwards during
e each edu eg eight either else elsewhere enough entirely especially et etc even ever every everybody everyone everything everywhere ex exactly example except
f far few fifth first five followed following follows for former formerly forth four from further furthermore
g get gets getting given gives go goes going gone got gotten greetings
h had hadnt happens hardly has hasnt have havent having he hello help hence her here hereafter hereby herein heres hereupon hers herself hes hi him himself his hither hopefully how howbeit however
i id ie if ignored ill im immediate in inasmuch inc indeed indicate indicated indicates inner insofar instead into inward is isnt it itd itll its its itself ive
j just k keep keeps kept know known knows
l last lately later latter latterly least less lest let lets like liked likely little look looking looks ltd
m mainly many may maybe me mean meanwhile merely might more moreover most mostly much must my myself
n name namely nd near nearly necessary need needs neither never nevertheless new next nine no nobody non none noone nor normally not nothing novel now nowhere
o obviously of off often oh ok okay old on once one ones only onto or other others otherwise ought our ours ourselves out outside over overall own
p particular particularly per perhaps placed please plus possible presumably probably provides
q que quite qv r rather rd re really reasonably regarding regardless regards relatively respectively right
s said same saw say saying says second secondly see seeing seem seemed seeming seems seen self selves sensible sent serious seriously seven several shall she should shouldnt since six so some somebody somehow someone something sometime sometimes somewhat somewhere soon sorry specified specify specifying still sub such sup sure
t take taken tell tends th than thank thanks thanx that thats thats the their theirs them themselves then thence there thereafter thereby therefore therein theres theres thereupon these they theyd theyll theyre theyve think third this thorough thoroughly those though three through throughout thru thus to together too took toward towards tried tries truly try trying ts twice two
u un under unfortunately unless unlikely until unto up upon us use used useful uses using usually uucp
v value various very via viz vs
w want wants was wasnt way we wed welcome well well went were were werent weve what whatever whats when whence whenever where whereafter whereas whereby wherein wheres whereupon wherever whether which while whither who whoever whole whom whos whose why will willing wish with within without wonder wont would would wouldnt
x
y yes yet you youd youll your youre yours yourself yourselves youve
z zero
i me my myself we our ours ourselves you your yours yourself
yourselves he him his himself she her hers herself it its
itself they them their theirs themselves what which who whom
this that these those am is are was were be been being have has
had having do does did doing would should could ought i'm
you're he's she's it's we're they're i've you've we've they've
i'd you'd he'd she'd we'd they'd i'll you'll he'll she'll we'll
they'll isn't aren't wasn't weren't hasn't haven't hadn't
doesn't don't didn't won't wouldn't shan't shouldn't can't
cannot couldn't mustn't let's that's who's what's here's
there's when's where's why's how's a an the and but if or
because as until while of at by for with about against between
into through during before after above below to from up down in
out on off over under again further then once here there when
where why how all any both each few more most other some such
no nor not only own same so than too very
a a's able about above according accordingly across actually after afterwards again against ain't all allow allows almost alone along already also although always am among amongst an and another any anybody anyhow anyone anything anyway anyways anywhere apart appear appreciate appropriate are aren't around as aside ask asking associated at available away awfully b be became because become becomes becoming been before beforehand behind being believe below beside besides best better between beyond both brief but by c c'mon c's came can can't cannot cant cause causes certain certainly changes clearly co com come comes concerning consequently consider considering contain containing contains corresponding could couldn't course currently d definitely described despite did didn't different do does doesn't doing don't done down downwards during e each edu eg eight either else elsewhere enough entirely especially et etc even ever every everybody everyone everything everywhere ex exactly example except f far few fifth first five followed following follows for former formerly forth four from further furthermore g get gets getting given gives go goes going gone got gotten greetings h had hadn't happens hardly has hasn't have haven't having he he's hello help hence her here here's hereafter hereby herein hereupon hers herself hi him himself his hither hopefully how howbeit however i i'd i'll i'm i've ie if ignored immediate in inasmuch inc indeed indicate indicated indicates inner insofar instead into inward is isn't it it'd it'll it's its itself j just k keep keeps kept know knows known l last lately later latter latterly least less lest let let's like liked likely little look looking looks ltd m mainly many may maybe me mean meanwhile merely might more moreover most mostly much must my myself n name namely nd near nearly necessary need needs neither never nevertheless new next nine no nobody non none noone nor normally not nothing novel now nowhere o obviously of off often oh ok okay old on once one ones only onto or other others otherwise ought our ours ourselves out outside over overall own p particular particularly per perhaps placed please plus possible presumably probably provides q que quite qv r rather rd re really reasonably regarding regardless regards relatively respectively right s said same saw say saying says second secondly see seeing seem seemed seeming seems seen self selves sensible sent serious seriously seven several shall she should shouldn't since six so some somebody somehow someone something sometime sometimes somewhat somewhere soon sorry specified specify specifying still sub such sup sure t t's take taken tell tends th than thank thanks thanx that that's thats the their theirs them themselves then thence there there's thereafter thereby therefore therein theres thereupon these they they'd they'll they're they've think third this thorough thoroughly those though three through throughout thru thus to together too took toward towards tried tries truly try trying twice two u un under unfortunately unless unlikely until unto up upon us use used useful uses using usually uucp v value various very via viz vs w want wants was wasn't way we we'd we'll we're we've welcome well went were weren't what what's whatever when whence whenever where where's whereafter whereas whereby wherein whereupon wherever whether which while whither who who's whoever whole whom whose why will willing wish with within without won't wonder would would wouldn't x y yes yet you you'd you'll you're you've your yours yourself yourselves z zero aaa bbb ccc ddd eee fff ggg hhh iii jjj kkk lll mmm nnn ooo ppp qqq rrr sss ttt eee fff ggg hhh iii jjj kkk lll mmm nnn ooo ppp
qqq rrr sss ttt uuu vvv www xxx yyy zzz .... unsere ihrer uns wurde wer gegen diesem bis nur wieder unserem einer war man bei wir einen vom einem unter jeder werden wie als durch zum hat vor unseres email bel ihnen unseren bzw lieber uft kommen nicht stehen melden ihrem ihren eines ist schon unserer zur aus des nachrichtenportal dem geben von haben neckar rhein auf bitte mit ein das den und der die sie ab aber abermaliges abermals abgerufen abgerufene abgerufener abgerufenes acht aehnlich aehnliche aehnlichem aehnlichen aehnlicher aehnliches aehnlichste aehnlichstem aehnlichsten aehnlichster aehnlichstes aeusserst aeusserste aeusserstem aeussersten aeusserster aeusserstes aeuerst aeuerste aeuerstem aeuersten aeuerster aeuerstes alle allein alleine allem allemal allen allenfalls allenthalben aller allerdings allerlei alles allesamt allg allg. allgemein allgemeine allgemeinem allgemeinen allgemeiner allgemeines allgemeinste allgemeinstem allgemeinsten allgemeinster allgemeinstes allmhlich allzeit allzu als alsbald also am an andauernd andauernde andauerndem andauernden andauernder andauerndes ander andere anderem anderen anderer andererseits anderes anderm andern andernfalls anders anderst anderweitig anderweitige anderweitigem
anderweitigen anderweitiger anderweitiges anerkannt anerkannte anerkannter anerkanntes anfangen anfing angefangen angesetze angesetzt angesetzten angesetzter ans anscheinend ansetzen ansonst ansonsten anstatt anstelle arbeiten auch auf aufgehrt aufgrund aufhren aufhrte aufzusuchen augenscheinlich augenscheinliche augenscheinlichem augenscheinlichen augenscheinlicher augenscheinliches augenscheinlichst augenscheinlichste augenscheinlichstem augenscheinlichsten augenscheinlichster augenscheinlichstes aus ausdrcken ausdrcklich ausdrckliche ausdrcklichem ausdrcklichen ausdrcklicher ausdrckliches ausdrckt ausdrckte ausgenommen ausgenommene ausgenommenem ausgenommenen ausgenommener ausgenommenes ausgerechnet ausgerechnete ausgerechnetem ausgerechneten ausgerechneter ausgerechnetes ausnahmslos ausnahmslose ausnahmslosem ausnahmslosen ausnahmsloser ausnahmsloses ausser ausserdem ausserhalb author autor auen auer auerdem auerhalb baelde bald bearbeite bearbeiten bearbeitete bearbeiteten bedarf bedurfte bedrfen befahl befiehlt befiehlte befohlene befohlens befragen befragte befragten befragter begann beginnen begonnen behalten behielt bei beide beidem beiden beider beiderlei beides beim beinahe beisammen beispielsweise beitragen beitrugen bekannt bekannte bekannter bekanntlich bekanntliche bekanntlichem bekanntlichen bekanntlicher bekanntliches bekennen benutzt bereits berichten berichtet berichtete berichteten besonders besser
bessere besserem besseren besserer besseres bestehen besteht bestenfalls bestimmt bestimmte bestimmtem bestimmten bestimmter bestimmtes betraechtlich betraechtliche betraechtlichem betraechtlichen betraechtlicher betraechtliches betreffend betreffende betreffendem betreffenden betreffender betreffendes betrchtlich betrchtliche betrchtlichem betrchtlichen betrchtlicher betrchtliches bevor bez bez. bezgl bezgl. bezueglich bezglich bietet bin bis bisher bisherige bisherigem bisherigen bisheriger bisheriges bislang bisschen bist bichen bleiben blieb bloss blo brachte brachten brauchen braucht bringen bruchte bsp bsp. bspw bspw. bzw bzw. blde bden ca ca. circa da dabei dadurch dafuer dafr dagegen daher dahin dahingehend dahingehende dahingehendem dahingehenden dahingehender dahingehendes dahinter damalige damaligem damaligen damaliger damaliges damals damit danach daneben dank danke danken dann dannen daran darauf daraus darf darfst darin darueber darueberhinaus darum darunter darber darberhinaus das dass dasselbe Dat davon davor dazu dazwischen da dein deine deinem deinen deiner deines dem demgegenueber demgegenber demgemaess demgemae demgemss demgem demnach demselben den denen denkbar denkbare denkbarem denkbaren denkbarer denkbares denn dennoch denselben der derart derartig derartige derartigem derartigen derartiger derem deren derer derjenige derjenigen derselbe derselben derzeit derzeitig derzeitige derzeitigem derzeitigen derzeitiges des deshalb desselben dessen dessenungeachtet desto desungeachtet deswegen dich die diejenige diejenigen dies diese dieselbe dieselben diesem diesen dieser dieses diesseitig diesseitige diesseitigem diesseitigen diesseitiger
diesseitiges diesseits dinge dir direkt direkte direkten direkter doch doppelt dort dorther dorthin dran drauf drei dreiig drin dritte drueber drum drunter drber du dunklen durch durchaus durchweg durchwegs durfte durften drfen drfte eben ebenfalls ebenso ect ect. ehe eher eheste ehestem ehesten ehester ehestes eigen eigene eigenem eigenen eigener eigenes eigenst eigentlich eigentliche eigentlichem eigentlichen eigentlicher eigentliches ein einban eine einem einen einer einerlei einerseits eines einfach einfhren einfhrte einfhrten eingesetzt einig einige einigem einigen einiger einigermassen einigermaen einiges einmal einmalig einmalige einmaligem einmaligen einmaliger einmaliges eins einseitig einseitige einseitigen einseitiger einst einstmals einzig empfunden ende entgegen entlang entsprechend entsprechende entsprechendem entsprechenden
entsprechender entsprechendes entweder er ergo ergnze ergnzen ergnzte ergnzten erhalten erhielt erhielten erhlt erneut erst erste erstem ersten erster erstere ersterem ersteren ersterer ersteres erstes erffne erffnen erffnet erffnete erffnetes es etc etc. etliche etlichem etlichen etlicher etliches etwa etwaige etwas euch euer eure eurem euren eurer eures euretwegen fall falls fand fast ferner finden findest findet folgend folgende folgendem folgenden folgender folgendermassen folgendermaen folgendes folglich fordern fordert forderte forderten fortsetzen fortsetzt fortsetzte fortsetzten fragte frau frei freie freier freies fuer fuers fnf fr frs gab gaenzlich gaenzliche gaenzlichem gaenzlichen gaenzlicher gaenzliches ganz ganze ganzem ganzen ganzer ganzes gar gbr geb geben geblieben gebracht gedurft geehrt geehrte geehrten geehrter gefallen gefiel geflligst gefllt gegeben gegen gegenueber gegenber gehabt gehen geht gekommen gekonnt gemacht gemaess gemeinhin gemocht gemss genau genommen genug gepriesener gepriesenes gerade gern gesagt gesehen gestern gestrige getan geteilt geteilte getragen gewesen gewiss gewisse gewissem gewissen gewisser gewissermaen gewisses gewollt geworden ggf ggf. gib gibt gleich gleiche gleichem gleichen gleicher gleiches gleichsam gleichste gleichstem gleichsten gleichster gleichstes gleichwohl gleichzeitig gleichzeitige gleichzeitigem gleichzeitigen gleichzeitiger gleichzeitiges gluecklicherweise glcklicherweise gmbh gottseidank gratulieren gratuliert gratulierte groesstenteils groetenteils grsstenteils grtenteils gute guten gngig gngige gngigen gngiger gngiges gnzlich gnzliche gnzlichem gnzlichen gnzlicher gnzliches hab habe haben haette haeufig haeufige haeufigem haeufigen haeufiger haeufigere haeufigeren haeufigerer haeufigeres halb hallo hast hat hatte hatten hattest hattet hen her heraus herein herum heute heutige heutigem heutigen heutiger heutiges hier hierbei hiermit hiesige hiesigem hiesigen hiesiger hiesiges hin hinein hingegen hinlanglich hinlnglich hinten hinter hinterher hinterm hintern hoch http hundert htt htte htten hufig
hufige hufigem hufigen hufiger hufigere hufigeren hufigerer hufigeres hchst hchstens ich igitt ihm ihn ihnen ihr ihre ihrem ihren ihrer ihres ihretwegen im immer immerhin immerwaehrend immerwaehrende immerwaehrendem immerwaehrenden immerwaehrender immerwaehrendes immerwhrend immerwhrende immerwhrendem immerwhrenden immerwhrender immerwhrendes immerzu important in indem indessen Inf. info infolge infolgedessen innen innerhalb ins insbesondere insgeheim insgeheime insgeheimer insgesamt insgesamte insgesamter insofern inzwischen irgend irgendein irgendeine irgendeinem irgendeiner irgendeines irgendjemand irgendjemandem irgendwann irgendwas irgendwen irgendwer irgendwie irgendwo ist ja jaehrig jaehrige jaehrigem jaehrigen jaehriger jaehriges je jede jedem jeden jedenfalls jeder jederlei jedes jedesmal jedoch jeglichem
jeglichen jeglicher jegliches jemals jemand jene jenem jenen jener jenes jenseitig jenseitigem jenseitiger jenseits jetzt jhrig jhrige jhrigem jhrigen jhriges kaeumlich kam kann kannst kaum kein keine keinem keinen keiner keinerlei keines keineswegs klar klare klaren klares klein kleinen kleiner kleines koennen koennt koennte koennten komme kommen kommt konkret konkrete konkreten konkreter konkretes konnte konnten kuenftig kuerzlich kuerzlichst knftig krzlich krzlichst kumlich knn knnen knnt knnte knnten laengst lag lagen langsam lassen laut lediglich leer legen legte legten leicht leider lesen letze letzte letzten letztendlich letztens letztere letzterem letzterer letzteres letztes letztlich lichten liegt liest links lngst lngstens mache machen machst macht machte machten mag magst mal man manch manche manchem manchen mancher mancherlei mancherorts manches manchmal mann margin massgebend massgebende massgebendem massgebenden massgebender massgebendes massgeblich massgebliche massgeblichem massgeblichen massgeblicher mehr mehrere mehrerer mehrfach mehrmalig mehrmaligem mehrmaliger mehrmaliges mein meine meinem meinen meiner meines meinetwegen meins meist meiste meisten meistens meistenteils meta mich mindestens mir mit miteinander mitgleich mithin mitnichten mittels mittelst mitten mittig mitunter mitwohl mochte moeglichst moeglichste moeglichstem moeglichsten moeglichster morgen morgige muessen muesst muesste muss musst musste mussten mu mut mssen msste mssten mt mte mchte mchten mchtest mgen mglich mgliche mglichen mglicher mglicherweise mglichst mglichste mglichstem mglichsten mglichster nach nachdem nacher nachher nachhinein nacht
naechste naemlich nahm naturgemaess naturgemae naturgemss naturgem natrlich neben nebenan nehmen nein neu neue neuem neuen neuer neuerdings neuerlich neuerliche neuerlichem neuerlicher neuerliches neues neulich neun nicht nichts nichtsdestotrotz nichtsdestoweniger nie niemals niemand niemandem niemanden nimm nimmer nimmt nirgends nirgendwo noch noetigenfalls nun nur nutzen nutzt nutzung ntzt nchste nmlich ntigenfalls ob oben ober oberen oberer oberhalb oberste obersten oberster obgleich obs obschon obwohl oder oefter oefters offenkundig offenkundige offenkundigem offenkundigen offenkundiger offenkundiges offensichtlich offensichtliche offensichtlichem offensichtlichen offensichtlicher offensichtliches oft oftmals ohne ohnedies paar partout per persoenlich persoenliche persoenlichem persoenlicher persoenliches persnlich persnliche persnlicher persnliches pfui ploetzlich ploetzliche ploetzlichem ploetzlicher ploetzliches pltzlich pltzliche pltzlichem pltzlicher pltzliches pro quasi reagiere reagieren reagiert reagierte recht rechts regelmig reichlich reichliche reichlichem reichlichen reichlicher restlos restlose restlosem restlosen restloser restloses richtiggehend richtiggehende richtiggehendem richtiggehenden richtiggehender richtiggehendes rief rund rundheraus rundum runter sage sagen sagt sagte sagten sagtest samt sang sangen sattsam scheinbar schlechter schlicht schlichtweg schliesslich schlielich schlussendlich schnell schon schreibe schreiben schreibens schreiber schwerlich schwerliche schwerlichem schwerlichen schwerlicher schwerliches schwierig schtzen schtzt schtzte schtzten sechs sect sehe sehen sehr sehrwohl seht sei seid sein
seine seinem seinen seiner seines seit seitdem seite seiten seither selbe selben selber selbst selbstredend selbstredende selbstredendem selbstredenden selbstredender selbstredendes seltsamerweise senke senken senkt senkte senkten setzen setzt setzte setzten sich sicher sicherlich sie sieben siebte siehe sieht sind singt so sobald sodass soda soeben sofern sofort sog sogar sogleich solange solc solch solche solchem solchen solcher solches soll sollen sollst sollt sollte sollten solltest somit sondern sonst sonstig sonstige sonstigem sonstiger sonstwo sooft soviel soweit sowie sowieso sowohl spielen spter startet startete starteten statt stattdessen steht steige steigen steigt stellenweise stellenweisem stellenweisen stets stieg stiegen such suchen smtliche tages tat tatsaechlich tatsaechlichen tatsaechlicher tatsaechliches tatschlich tatschlichen tatschlicher tatschliches tausend teile teilen teilte teilten titel total trage tragen trotzdem trug trgt tun tust tut txt tt ueber ueberall ueberallhin ueberaus ueberdies ueberhaupt uebermorgen ueblicherweise uebrig uebrigens um ums umso umstaendehalber umstndehalber unbedingt unbedingte unbedingter unbedingtes und unerhoert unerhoerte unerhoertem unerhoerten unerhoerter unerhoertes unerhrt unerhrte unerhrtem unerhrten unerhrter unerhrtes ungefhr ungemein ungewoehnlich ungewoehnliche ungewoehnlichem ungewoehnlichen ungewoehnlicher ungewoehnliches ungewhnlich ungewhnliche ungewhnlichem ungewhnlichen ungewhnlicher ungewhnliches ungleich ungleiche ungleichem ungleichen ungleicher ungleiches unmassgeblich unmassgebliche unmassgeblichem unmassgeblichen unmassgeblicher unmassgebliches unmageblich unmagebliche
unmageblichem unmageblichen unmageblicher unmagebliches unmoeglich unmoegliche unmoeglichem unmoeglichen unmoeglicher unmoegliches unmglich unmgliche unmglichen unmglicher unntig uns unsaeglich unsaegliche unsaeglichem unsaeglichen unsaeglicher unsaegliches unsagbar unsagbare unsagbarem unsagbaren unsagbarer unsagbares unse unsem unsen unser unsere unserem unseren unserer unseres unserm unses unsre unsrem unsren unsrer unsres unstreitig unstreitige unstreitigem unstreitigen unstreitiger unstreitiges unsglich unsgliche unsglichem unsglichen unsglicher unsgliches unten unter unterbrach unterbrechen untere unterem unteres unterhalb unterste unterster unterstes unwichtig unzweifelhaft unzweifelhafte unzweifelhaftem unzweifelhaften unzweifelhafter unzweifelhaftes usw usw. vergangen vergangene vergangener vergangenes vermag vermutlich vermutliche vermutlichem vermutlichen vermutlicher vermutliches vermgen verrate verraten verriet verrieten version versorge versorgen versorgt versorgte versorgten versorgtes verffentlichen verffentlicher verffentlicht verffentlichte verffentlichten verffentlichtes viel viele vielen vieler vielerlei vieles vielleicht vielmalig vielmals vier voellig voellige voelligem voelligen voelliger voelliges voelligst
vollends vollstaendig vollstaendige vollstaendigem vollstaendigen vollstaendiger vollstaendiges vollstndig vollstndige vollstndigem vollstndigen vollstndiger vollstndiges vom von vor voran vorbei vorgestern vorher vorherig vorherige vorherigem vorheriger vorne vorueber vorber vllig vllige vlligem vlligen vlliger vlliges vlligst wachen waehrend waehrenddessen waere wann war waren warst warum was weder weg wegen weil weiter weitere weiterem weiteren weiterer weiteres weiterhin weitestgehend weitestgehende weitestgehendem weitestgehenden weitestgehender weitestgehendes weitgehend weitgehende weitgehendem weitgehenden weitgehender weitgehendes wei welche welchem welchen welcher welches wem wen wenig wenige weniger wenigstens wenn wenngleich wer werde werden werdet weshalb wessen wichtig wie wieder wiederum wieso wieviel wieviele wievieler wiewohl will willst wir wird wirklich wirklichem wirklicher wirkliches wirst wo wobei wodurch wofuer wofr wogegen woher wohin wohingegen wohl wohlgemerkt wohlweislich wolle wollen wollt wollte wollten wolltest wolltet womit womoeglich womoegliche womoeglichem womoeglichen womoeglicher womoegliches womglich womgliche womglichem womglichen womglicher womgliches woran woraufhin woraus worin wurde wurden www
wrde wrden whrend whrenddessen wr wre wren x bel ber berall berallhin beraus berdies berhaupt bermorgen blicherweise brig brigens z.B. zahlreich zahlreichem zahlreicher zB zb. zehn zeitweise zeitweisem zeitweisen zeitweiser ziehen zieht ziemlich ziemliche ziemlichem ziemlichen ziemlicher ziemliches zirka zog zogen zu zudem zuerst zufolge zugleich zuletzt zum zumal zumeist zumindest zunaechst zunchst zur zurueck zurck zusammen zusehends zuviel zuviele zuvieler zuweilen zwanzig zwar zwei zweifelsfrei zweifelsfreie zweifelsfreiem zweifelsfreien zweifelsfreier zweifelsfreies zwischen zwlf hnlich hnliche hnlichem hnlichen hnlicher hnliches hnlichst hnlichste hnlichstem hnlichsten hnlichster hnlichstes usserst usserste usserstem ussersten usserster usserstes uerst uerste uerstem uersten uerster uerstes fter fters air anr arm cke ckg ckl duo ged gie hie ihk las len lie llt los lte max mmt mvv opa rer rkt sap spr str ung utf zoo zuf zuh abo awo bef beh bmw cks daf del ern geh gen hne hof hrl lle lze mer nau ner ost pfe ppg pur rde rin rke sen tee tvf uni vri wut zug zun abf anw fte mcv nge ngt spa sst ten tes tsv vfr abh bat big gem men nat nde obi rma tte aff alt art che eng hlt hrt ler nsa ste tag tzt app ben ckt gef ser ter ume zus hmt jan suv ude gel hei gew jay eva nen wei ren ger sch tze ver gro ber uhr );
return \%stoplist;
}
}




1;




=head1 NAME

  AI::MicroStructure::WordBlacklist

=head1 DESCRIPTION

  Creates Concepts for words

=head1 SYNOPSIS

  ~$ micro new world

  ~$ micro structures

  ~$ micro any 2

  ~$ micro drop world

  ~$ micro

=head1 AUTHOR

  Hagen Geissler <santex@cpan.org>

=head1 COPYRIGHT AND LICENCE

  Hagen Geissler <santex@cpan.org>

=head1 SUPPORT AND DOCUMENTATION

  ☞ [sample using concepts](http://quantup.com)

  ☞ [PDF info on my works](https://github.com/santex)


=head1 SEE ALSO

  AI-MicroStructure
  AI-MicroStructure-Cache
  AI-MicroStructure-Deamon
  AI-MicroStructure-Relations
  AI-MicroStructure-Concept
  AI-MicroStructure-Data
  AI-MicroStructure-Driver
  AI-MicroStructure-Plugin-Pdf
  AI-MicroStructure-Plugin-Twitter
  AI-MicroStructure-Plugin-Wiki


__END__

__DATA__

