/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class TableElementList
extends QueryTreeNodeVector {
    private int numColumns;
    private TableDescriptor td;

    public void addTableElement(TableElementNode tableElementNode) {
        this.addElement(tableElementNode);
        if (tableElementNode instanceof ColumnDefinitionNode || tableElementNode.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    public String toString() {
        return "";
    }

    void validate(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        this.td = tableDescriptor;
        int n = 0;
        int n2 = this.size();
        Hashtable hashtable = new Hashtable(n2 + 2, 0.999f);
        Hashtable hashtable2 = new Hashtable(n2 + 2, 0.999f);
        Vector<Object> vector = new Vector<Object>();
        if (tableDescriptor != null && (constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor)) != null) {
            for (int i = 0; i < constraintDescriptorList.size(); ++i) {
                ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
                if (constraintDescriptor.getConstraintType() != 2 && constraintDescriptor.getConstraintType() != 3) continue;
                vector.addElement(constraintDescriptor);
            }
        }
        int n3 = 0;
        if (dDLStatementNode instanceof CreateTableNode) {
            n3 = ((CreateTableNode)dDLStatementNode).tableType;
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string;
            Object object2;
            Object object3;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (tableElementNode instanceof ColumnDefinitionNode) {
                object3 = (ColumnDefinitionNode)this.elementAt(i);
                if (n3 == 3 && (((ColumnDefinitionNode)object3).getDataTypeServices().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)object3).getDataTypeServices().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)object3).getColumnName());
                }
                this.checkForDuplicateColumns(dDLStatementNode, hashtable, ((ColumnDefinitionNode)object3).getColumnName());
                ((ColumnDefinitionNode)object3).checkUserType(tableDescriptor);
                ((ColumnDefinitionNode)object3).bindAndValidateDefault(dataDictionary, tableDescriptor);
                ((ColumnDefinitionNode)object3).validateAutoincrement(dataDictionary, tableDescriptor, n3);
                if (tableElementNode instanceof ModifyColumnNode) {
                    object2 = (ModifyColumnNode)object3;
                    ((ModifyColumnNode)object2).checkExistingConstraints(tableDescriptor);
                } else if (((ColumnDefinitionNode)object3).isAutoincrementColumn()) {
                    ++n;
                }
            } else if (tableElementNode.getElementType() == 7) {
                object3 = tableElementNode.getName();
                if (tableDescriptor.getColumnDescriptor((String)object3) != null) break;
                throw StandardException.newException("42X14", object3, (Object)tableDescriptor.getQualifiedName());
            }
            if (!tableElementNode.hasConstraint()) continue;
            object3 = (ConstraintDefinitionNode)tableElementNode;
            ((ConstraintDefinitionNode)object3).bind(dDLStatementNode, dataDictionary);
            if (((ConstraintDefinitionNode)object3).getConstraintType() == 2 || ((ConstraintDefinitionNode)object3).getConstraintType() == 3) {
                string = null;
                object = null;
                for (int j = 0; j < vector.size(); ++j) {
                    Object object4;
                    object2 = vector.elementAt(j);
                    if (object2 instanceof ConstraintDefinitionNode) {
                        object4 = (ConstraintDefinitionNode)object2;
                        string = ((ConstraintDefinitionNode)object4).getConstraintMoniker();
                        object = ((ConstraintDefinitionNode)object4).getColumnList().getColumnNames();
                    } else if (object2 instanceof ConstraintDescriptor) {
                        object4 = (ConstraintDescriptor)object2;
                        string = ((ConstraintDescriptor)object4).getConstraintName();
                        object = ((ConstraintDescriptor)object4).getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)object3).getColumnList().getColumnNames(), (String[])object)) continue;
                    throw StandardException.newException("42Z93", ((ConstraintDefinitionNode)object3).getConstraintMoniker(), (Object)string);
                }
                vector.addElement(object3);
            }
            if (object3 instanceof ConstraintDefinitionNode) {
                this.checkForDuplicateConstraintNames(dDLStatementNode, hashtable2, ((ConstraintDefinitionNode)object3).getConstraintMoniker());
            }
            if (((ConstraintDefinitionNode)object3).getConstraintType() == 5 && (object2 = ((ConstraintDefinitionNode)object3).getConstraintMoniker()) != null) {
                string = ((ConstraintDefinitionNode)object3).getDropSchemaName();
                object = string == null ? tableDescriptor.getSchemaDescriptor() : this.getSchemaDescriptor(string);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, (SchemaDescriptor)object, (String)object2, false);
                if (constraintDescriptor == null) {
                    throw StandardException.newException("42X86", object.getSchemaName() + "." + (String)object2, (Object)tableDescriptor.getQualifiedName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
            }
            if (((ConstraintDefinitionNode)object3).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                if (tableDescriptor == null) {
                    this.setColumnListToNotNull((ConstraintDefinitionNode)object3);
                    continue;
                }
                this.checkForNullColumns((ConstraintDefinitionNode)object3, tableDescriptor);
                continue;
            }
            if (((ConstraintDefinitionNode)object3).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                this.checkForNullColumns((ConstraintDefinitionNode)object3, tableDescriptor);
                continue;
            }
            if (!((ConstraintDefinitionNode)object3).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
        }
        if (n > 1) {
            throw StandardException.newException("428C1");
        }
    }

    public int countConstraints(int n) {
        int n2 = 0;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || n != (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType()) continue;
            ++n2;
        }
        return n2;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] columnInfoArray) {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (((TableElementNode)this.elementAt(i)).getElementType() == 7) {
                columnInfoArray[i] = new ColumnInfo(((TableElementNode)this.elementAt(i)).getName(), null, null, null, null, null, 2, 0L, 0L);
                break;
            }
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) {
                ++n;
                continue;
            }
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(i);
            columnInfoArray[i - n] = new ColumnInfo(columnDefinitionNode.getColumnName(), columnDefinitionNode.getDataTypeServices(), columnDefinitionNode.getDefaultValue(), columnDefinitionNode.getDefaultInfo(), null, columnDefinitionNode.getOldDefaultUUID(), columnDefinitionNode.getAction(), columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementStart() : 0L, columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementIncrement() : 0L);
            if (!columnDefinitionNode.hasConstraint()) continue;
            ++n;
        }
        return n;
    }

    public void appendNewColumnsToRCL(FromBaseTable fromBaseTable) throws StandardException {
        int n = this.size();
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        TableName tableName = fromBaseTable.getTableName();
        for (int i = 0; i < n; ++i) {
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(i);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDefinitionNode.getColumnName(), tableName, columnDefinitionNode.getDataTypeServices(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDefinitionNode.getDataTypeServices(), valueNode, this.getContextManager());
            resultColumn.setName(columnDefinitionNode.getColumnName());
            resultColumnList.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        int n = this.size();
        CompilerContext compilerContext = this.getCompilerContext();
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            Object object;
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType() != 4) continue;
            ValueNode valueNode = constraintDefinitionNode.getCheckCondition();
            int n2 = compilerContext.getReliability();
            try {
                object = new ProviderList();
                ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object);
                compilerContext.setReliability(1657);
                valueNode = valueNode.bindExpression(fromList, null, vector);
                if (vector.size() != 0) {
                    throw StandardException.newException("42Y01", constraintDefinitionNode.getConstraintText());
                }
                valueNode = valueNode.checkIsBoolean();
                constraintDefinitionNode.setCheckCondition(valueNode);
                if (((Hashtable)object).size() > 0) {
                    constraintDefinitionNode.setAuxiliaryProviderList((ProviderList)object);
                }
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
            }
            finally {
                compilerContext.setReliability(n2);
            }
            object = fromBaseTable.getResultColumns();
            int n3 = ((ResultColumnList)object).countReferencedColumns();
            int[] nArray = new int[n3];
            ((ResultColumnList)object).recordColumnReferences(nArray, 1);
            constraintDefinitionNode.setCheckColumnReferences(nArray);
            ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            ((ResultColumnList)object).copyReferencedColumnsToNewList(resultColumnList);
            if (constraintDefinitionNode.getColumnList() != null) {
                String string = ((ResultColumn)constraintDefinitionNode.getColumnList().elementAt(0)).getName();
                if (n3 > 1 || !string.equals(((ResultColumn)resultColumnList.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", string);
                }
            }
            constraintDefinitionNode.setColumnList(resultColumnList);
            ((ResultColumnList)object).clearColumnReferences();
        }
    }

    void genConstraintActions(ConstraintConstantAction[] constraintConstantActionArray, String string, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = null;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            IndexConstantAction indexConstantAction = null;
            if (!tableElementNode.hasConstraint() || tableElementNode instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode;
            if (constraintDefinitionNode.getColumnList() != null) {
                stringArray = new String[constraintDefinitionNode.getColumnList().size()];
                constraintDefinitionNode.getColumnList().exportNames(stringArray);
            }
            int n3 = constraintDefinitionNode.getConstraintType();
            String string2 = constraintDefinitionNode.getConstraintText();
            String string3 = constraintDefinitionNode.getConstraintMoniker();
            if (constraintDefinitionNode.requiresBackingIndex()) {
                indexConstantAction = this.genIndexAction(constraintDefinitionNode.requiresUniqueIndex(), null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n3, dataDictionary);
            }
            if (n3 == 5) {
                constraintConstantActionArray[n2] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction, constraintDefinitionNode.getDropBehavior(), constraintDefinitionNode.getVerifyType());
                continue;
            }
            ProviderList providerList = constraintDefinitionNode.getAuxiliaryProviderList();
            ConstraintInfo constraintInfo = null;
            ProviderInfo[] providerInfoArray = null;
            if (constraintDefinitionNode instanceof FKConstraintDefinitionNode) {
                constraintInfo = ((FKConstraintDefinitionNode)constraintDefinitionNode).getReferencedConstraintInfo();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            } else {
                providerInfoArray = new ProviderInfo[]{};
            }
            constraintConstantActionArray[n2++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(string3, n3, string, this.td != null ? this.td.getUUID() : (UUID)null, schemaDescriptor.getSchemaName(), stringArray, indexConstantAction, string2, true, constraintInfo, providerInfoArray);
        }
    }

    private boolean columnsMatch(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean bl, String string, ConstraintDefinitionNode constraintDefinitionNode, String[] stringArray, boolean bl2, SchemaDescriptor schemaDescriptor, String string2, int n, DataDictionary dataDictionary) throws StandardException {
        if (string == null) {
            string = constraintDefinitionNode.getBackingIndexName(dataDictionary);
        }
        if (n == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, string, string2, schemaDescriptor.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(bl, "BTREE", schemaDescriptor.getSchemaName(), string, string2, this.td != null ? this.td.getUUID() : (UUID)null, 0L, stringArray, blArray, bl2, constraintDefinitionNode.getBackingIndexUUID(), constraintDefinitionNode.getProperties());
    }

    private void checkForDuplicateColumns(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X12", string);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        if (string == null) {
            return;
        }
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X91", string);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode dDLStatementNode, ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        String string;
        if (dDLStatementNode instanceof CreateTableNode && (string = constraintDefinitionNode.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", dDLStatementNode.getRelativeName(), (Object)string);
        }
        string = constraintDefinitionNode.getColumnList().verifyUniqueNames(false);
        if (string != null) {
            throw StandardException.newException("42X92", string);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode constraintDefinitionNode) {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            DataTypeDescriptor dataTypeDescriptor = this.getColumnDataTypeDescriptor(string);
            dataTypeDescriptor.setNullability(false);
        }
    }

    private void checkForNullColumns(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            throw StandardException.newException("42831", string);
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals((columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).getColumnName())) continue;
            return columnDefinitionNode.getDataTypeServices();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string, TableDescriptor tableDescriptor) {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor != null) {
            return columnDescriptor.getType();
        }
        return this.getColumnDataTypeDescriptor(string);
    }

    public boolean containsColumnName(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals(((ColumnDefinitionNode)tableElementNode).getName())) continue;
            return true;
        }
        return false;
    }
}

