#!/usr/bin/perl

package eBay::API::XML::Call::GetMessagePreferences;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMessagePreferences.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMessagePreferences

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMessagePreferences inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesRequestType;
use eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetMessagePreferences';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesResponseType';
}

#
# input properties
#

=head2 setIncludeASQPreferences()

If true, indicates that the ASQ subjects for the
specified user should be returned.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeASQPreferences {
   my $self   = shift;
   my $sIncludeASQPreferences = shift;
   $self->getRequestDataType()->setIncludeASQPreferences($sIncludeASQPreferences);
}

=head2 setSellerID()

The ID of the user to retrieve ASQ subjects for. This
value must be specified in the request, but does not
need to be the same user as the user making the
request.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut
       
sub setSellerID {
   my $self   = shift;
   my $pSellerID = shift;
   $self->getRequestDataType()->setSellerID($pSellerID);
}



#
# output properties
#

=head2 getASQPreferences()

Returns a seller's ASQ subjects, each in its own Subject
node. If the seller has not customized the ASQ subjects
using SetMessagePreferences, the call will return the
current default values. Returned if
IncludeASQPreferences = true was specified in the
request.

  Returned: Conditionally
#    Returns: 'ns:ASQPreferencesType'

=cut
       
sub getASQPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getASQPreferences();
}





1;   
