# Generated by default/object.tt
package Paws::SSMContacts::Contact;
  use Moose;
  has Alias => (is => 'ro', isa => 'Str', required => 1);
  has ContactArn => (is => 'ro', isa => 'Str', required => 1);
  has DisplayName => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Contact

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Contact object:

  $service_obj->Method(Att1 => { Alias => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Contact object:

  $result = $service_obj->Method(...);
  $result->Att1->Alias

=head1 DESCRIPTION

A personal contact or escalation plan that Incident Manager engages
during an incident.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Alias => Str

The unique and identifiable alias of the contact or escalation plan.


=head2 B<REQUIRED> ContactArn => Str

The Amazon Resource Name (ARN) of the contact or escalation plan.


=head2 DisplayName => Str

The full name of the contact or escalation plan.


=head2 B<REQUIRED> Type => Str

Refers to the type of contact. A single contact is type C<PERSONAL> and
an escalation plan is type C<ESCALATION>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

