# $Id: Build.PL 46667 2013-06-10 10:28:43Z apatecgortan $

use strict;
use warnings;
use Module::Build 0.4004;

my $builder = Module::Build->new
  (module_name         => 'XML::NewsML_G2',
   license             => 'gpl',
   dist_author         => 'Philipp Gortan <philipp.gortan@apa.at>',
   dist_abstract       => 'generate NewsML G2 news items',
   dist_version_from   => 'lib/XML/NewsML_G2.pm',
   requires =>
   { 'perl'                  => '5.8.0',
     'version'               => 0.77,
     'Moose'                 => 0.64,
     'namespace::autoclean'  => 0.05,
     'XML::LibXML'           => 0,
     'DateTime'              => 0,
     'DateTime::Format::XSD' => 0,
     'UUID::Tiny'            => 1.02,
   },
   configure_requires =>
   { 'Module::Build' => 0.40
   },
   test_requires =>
   { 'Test::More'      => 0,
     'Test::Exception' => 0,
   },
   add_to_cleanup =>
   [ 'XML-NewsML_G2-*',
   ],
   create_makefile_pl => 'traditional',
  );

$builder->create_build_script();
