
package Paws::SSM::RegisterDefaultPatchBaseline;
  use Moose;
  has BaselineId => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'RegisterDefaultPatchBaseline');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SSM::RegisterDefaultPatchBaselineResult');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::RegisterDefaultPatchBaseline - Arguments for method RegisterDefaultPatchBaseline on L<Paws::SSM>

=head1 DESCRIPTION

This class represents the parameters used for calling the method RegisterDefaultPatchBaseline on the
L<Amazon Simple Systems Manager (SSM)|Paws::SSM> service. Use the attributes of this class
as arguments to method RegisterDefaultPatchBaseline.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to RegisterDefaultPatchBaseline.

=head1 SYNOPSIS

    my $ssm = Paws->service('SSM');
    my $RegisterDefaultPatchBaselineResult = $ssm->RegisterDefaultPatchBaseline(
      BaselineId => 'MyBaselineId',

    );

    # Results:
    my $BaselineId = $RegisterDefaultPatchBaselineResult->BaselineId;

    # Returns a L<Paws::SSM::RegisterDefaultPatchBaselineResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ssm/RegisterDefaultPatchBaseline>

=head1 ATTRIBUTES


=head2 B<REQUIRED> BaselineId => Str

The ID of the patch baseline that should be the default patch baseline.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method RegisterDefaultPatchBaseline in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

