# Generated by default/object.tt
package Paws::MediaStore::MetricPolicy;
  use Moose;
  has ContainerLevelMetrics => (is => 'ro', isa => 'Str', required => 1);
  has MetricPolicyRules => (is => 'ro', isa => 'ArrayRef[Paws::MediaStore::MetricPolicyRule]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaStore::MetricPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaStore::MetricPolicy object:

  $service_obj->Method(Att1 => { ContainerLevelMetrics => $value, ..., MetricPolicyRules => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaStore::MetricPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->ContainerLevelMetrics

=head1 DESCRIPTION

The metric policy that is associated with the container. A metric
policy allows AWS Elemental MediaStore to send metrics to Amazon
CloudWatch. In the policy, you must indicate whether you want
MediaStore to send container-level metrics. You can also include rules
to define groups of objects that you want MediaStore to send
object-level metrics for.

To view examples of how to construct a metric policy for your use case,
see Example Metric Policies
(https://docs.aws.amazon.com/mediastore/latest/ug/policies-metric-examples.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContainerLevelMetrics => Str

A setting to enable or disable metrics at the container level.


=head2 MetricPolicyRules => ArrayRef[L<Paws::MediaStore::MetricPolicyRule>]

A parameter that holds an array of rules that enable metrics at the
object level. This parameter is optional, but if you choose to include
it, you must also include at least one rule. By default, you can
include up to five rules. You can also request a quota increase
(https://console.aws.amazon.com/servicequotas/home?region=us-east-1#!/services/mediastore/quotas)
to allow up to 300 rules per policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaStore>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

