use 5.014;

use Algorithm::AdaBoost;
use Smart::Args;
use Test::More;

my @dataset = map {
  chomp;
  my ($label, $x, $y) = split /\s/;
  +{ feature => [$x, $y], label => $label };
} <DATA>;

my @training_set = @dataset[0 .. 99];
my @test_set = @dataset[100 .. 199];

my $learner = new_ok 'Algorithm::AdaBoost' => [
  training_set => \@training_set,
  weak_classifier_generator => \&generate_weak_classifier,
];
ok(
  +(not $learner->trained),
  '|trained| should be false before the learner |train|-ed.'
);

$learner->train(num_iterations => 1000);
ok($learner->trained, 'A classifier is constructed successfully.');

my $classifier = $learner->final_classifier;

my $correct = 0;
for my $test_data (@test_set) {
  my $answer = $classifier->classify($test_data->{feature}) < 0 ? -1 : 1;
  ++$correct if $answer == $test_data->{label};
}
my $accuracy = $correct / @test_set;
cmp_ok(
  $accuracy, '>', 0.65,
  'The constructed classifier should sagnificantly accurate rather than random guess'
);

done_testing;

# Generates simple linear classifier randomly.
sub generate_weak_classifier {
  args
    my $distribution => 'ArrayRef[Num]',
    my $training_set => 'ArrayRef[HashRef]';

  while (1) {
    my ($o_x, $o_y) = (rand(6) - 3, rand(6) - 3);
    my ($p_x, $p_y) = (rand(6) - 3, rand(6) - 3);
    my @normal_vector = ($p_x - $o_x, $p_y - $o_y);

    my $accuracy = 0;
    my $classifier_candidate = sub {
      args_pos my $point => 'ArrayRef[Num]';
      my ($x, $y) = @$point;
      my @position_vector = ($x - $o_x, $y - $o_y);
      my $inner_product = $normal_vector[0] * $position_vector[0]
        + $normal_vector[1] * $position_vector[1];
      return $inner_product < 0 ? -1 : 1;
    };

    for my $i (0 .. $#$distribution) {
      my $answer = $classifier_candidate->($training_set->[$i]{feature});
      $accuracy += $distribution->[$i] if $answer == $training_set->[$i]{label};
    }
    return $classifier_candidate if $accuracy > 1/2;
  }
}

# f(x, y) = 1 if x^2 + y^2 < 4, -1 otherwise.
# subject to -3 <= x < 3, -3 <= y < 3.
__DATA__
1 -0.248490100750111 -0.739693407357834
1 -0.566115592376427 -1.68714313853555
1 -0.399623250750217 1.33407775536753
-1 1.39932333014989 2.54595589010434
-1 -2.09890668052825 -2.26928674627152
-1 -1.35789686105749 -2.76051974907672
1 0.0495294874471526 -0.961790183534873
-1 -2.14562371189552 2.51764233416243
1 1.27731540363029 0.241831210669432
1 1.16150264946072 1.49304025338465
-1 -2.69274234964235 -1.46871200361485
-1 -2.89310561098872 -2.81413989571512
-1 2.54696623984031 1.41616350632637
-1 0.781246866667637 2.48176816466842
-1 2.38373366136403 1.01253303786686
-1 0.600980674475842 2.88221379594241
-1 0.939597995977032 -2.83339742205175
-1 2.28972352960461 -0.525712426444059
-1 -2.75988102026145 -2.24446732401097
-1 2.21730008163812 -2.33850116064853
1 -1.54575431091852 -1.09897828975295
1 1.01039465416262 -1.03916319224517
-1 -2.54494588098925 2.89106013439718
-1 -0.906021606727585 -2.36200605486606
1 1.18012920171409 -1.13335728166845
1 1.0976701154454 1.51814395249566
1 0.352755644705319 -0.576001314626382
-1 1.63010120924961 -1.78558630903204
-1 2.24641222885028 0.433679372218307
1 -0.730498875458231 -0.155846827770816
1 -0.0103682274561336 0.903988972969017
-1 -2.55871684579451 2.4820246671987
-1 1.03914071391184 -2.47013455036148
-1 2.57331225205082 -2.09971455910711
1 -1.01187493679573 0.675275173414235
-1 -2.82455058874117 -1.81433702562207
-1 1.88403020752772 -2.46291432114049
-1 0.639312525703879 2.55790116121567
1 1.23578758473143 0.824585442031179
-1 2.1731435466231 1.95012524070098
-1 0.391818457618136 -2.25156279176036
-1 -1.32985199557316 -2.20788347147068
1 -1.06560921130689 -0.173258529138565
1 -1.02965253504461 0.954639702309933
-1 -2.90155358560438 2.95865861423533
-1 -0.851719893813303 -2.69989013044439
-1 2.38816922117467 1.45605135623143
-1 -2.40702878971356 -0.0801417355682332
-1 -2.09462229112317 2.92297283457907
1 1.91239584196598 0.442538561637704
-1 -2.73790593529362 1.78739935047284
-1 1.48084220237551 -2.86295516367976
-1 -2.86408646150111 -2.73100021165305
-1 1.86157798320892 2.61567151288465
-1 -0.179630617782841 2.05430544701707
1 -1.29480462666631 1.32186960797021
-1 1.77140676843387 1.98350381963468
-1 -2.90911493491699 0.558326558697715
1 -0.127859190891634 -1.23791287691753
-1 2.90733754435966 -2.68454668842683
1 -1.38317406780462 -0.179649523439252
-1 -2.25558699710029 1.68168650514734
-1 -2.19429668545849 2.77261493917305
-1 -1.91266874256862 -2.91696011431729
1 1.7681666901308 0.888156512315447
-1 1.2918319740382 -1.71844807533064
-1 2.18429152803355 -1.91698693039243
-1 2.01021515179767 1.07591033505879
-1 -2.18524482060688 -2.72427363002544
-1 -0.708185907284353 2.45157318454936
1 -0.094166997546445 -1.28598478670247
-1 2.5734498501133 1.82488495415937
-1 2.70753456398588 0.860477787796469
-1 -1.99931072005193 -2.33751143633613
-1 1.89584165951452 2.50454570899299
-1 -2.00704980593863 0.623995457248284
-1 -2.84002703152479 -1.58033146327864
-1 -1.58291139395475 2.30637968794711
-1 -2.29307446114598 -0.32254494578504
-1 -2.88376345569318 -2.65935706691191
1 -1.17872214603742 0.826345676791391
-1 -1.47674374201636 -2.97356010994788
1 0.240179846797439 -0.20280159790704
-1 2.55990973462466 -1.24620808281337
-1 -2.72785123008797 -0.538451905789543
-1 -2.40886684099905 -0.638264526325102
1 1.08303317589769 1.1836049853267
-1 -1.3051738549532 2.37448524956604
-1 -1.85865270957434 1.01140245576238
1 -0.53376285724385 0.132924238010489
-1 -2.32508835865509 1.97674579149046
-1 2.76602123387116 -1.55680123897706
-1 -2.67309018143889 -0.457637907693766
-1 2.72478645939862 2.07887999280955
1 -0.333617444659872 1.86626618889906
1 -1.3643982566231 -1.27371079415131
-1 -2.57112418271524 -1.84005230193242
-1 2.51943526589032 0.525656169504302
-1 -2.57076386447353 2.00440957725405
1 0.775498669089338 0.849023233978201
-1 -1.93904909934557 -2.34404189255565
-1 -2.21358837207548 2.32820600887258
-1 -1.29573938142818 1.81531751228894
-1 1.21314495743852 -2.79459042946364
1 1.70657109382537 0.336228786046092
1 0.28177043578507 0.971761180708697
1 1.84026302499648 -0.705948871367781
1 0.146813771655083 1.97529094575056
-1 -2.77961855452683 -0.304374952314561
1 0.646895511489795 -1.44624493403013
-1 -2.01781530366015 1.95713806010687
1 1.89852504074711 0.456886693198228
-1 -2.05081094877253 0.7690663840404
1 1.3733070595618 -0.611338693132964
1 -0.0920423992404338 0.862308431685193
-1 1.76109988140187 -2.21178869064191
1 -1.2430025782899 -0.163012331293658
1 1.14425248877252 1.18710260536874
-1 -0.0069557218428784 2.05844287231761
-1 2.12211435765605 -0.816471357566158
-1 -2.01322399622845 1.70075237235636
1 1.5754805072001 0.157069125586801
-1 -0.0015988290764497 2.45761487285429
-1 2.01117591817835 -2.94876424658092
-1 -1.42283446148068 -2.0318576992712
-1 -2.13997973205289 1.95907023051267
-1 -2.96809803860101 2.43946918827825
-1 2.91811772600804 1.78730486737216
-1 -2.82463318526786 0.70115774216066
-1 1.24170921786101 -2.781472341427
-1 1.12505441213988 -2.49596264153124
1 -0.631622029406536 0.653646207869784
-1 1.14800725125357 2.37797128638567
-1 -2.4003648233986 -1.74229737952659
-1 2.39614108008748 -2.01754920328622
-1 -0.681996873026058 2.95348888260806
-1 2.88982661695891 -2.59201204868424
-1 2.72058004839773 2.85593367179904
-1 1.73771115073156 -2.80412872980989
-1 -1.05561399805091 -2.29388863688028
-1 2.76557007188907 -1.58642637047535
-1 -0.931025556158936 -2.81905340815935
-1 0.370647513362933 2.52131797163017
-1 -1.13997871792085 2.20098747657637
-1 0.393523588145193 2.15412324115238
1 1.03379436405391 -0.444518125884841
-1 2.44883007350858 -1.42107024360607
1 0.165233173360129 0.176648202644415
-1 -1.21032631586221 -2.68225064505054
-1 1.73925297458164 -2.56753019095085
-1 -2.82228682635679 -0.80143950583502
1 -0.917998402582519 -1.07770605663659
1 1.13952028078406 -0.557018585820572
1 0.551062371349367 -0.151532485705687
-1 2.62693186827084 0.954464859489264
-1 2.17468528406213 1.34042630901571
1 1.65011836324728 -1.04252492090143
-1 -1.60753788397198 2.7090566431434
-1 2.57134867447035 1.87519126037543
1 -1.6353880249475 -0.0634971620440155
-1 2.05797100681186 0.732840572731504
-1 1.90413319315332 -1.46861512348444
-1 -1.71325070600142 -1.5583420208246
-1 -2.91582217109359 2.81685244336951
-1 -2.07105679951204 -2.34569170833856
-1 1.33953791634145 1.72801867897975
1 1.25569267804479 0.179747974963988
-1 1.99226999160644 -0.92117624507209
-1 -2.11558722306072 -1.50894068144618
1 0.882148185945148 -0.837240825715028
-1 2.20581768073031 -1.96538282836374
1 0.686498173042686 -1.53262710168893
-1 2.32342163232791 -0.172342151867838
-1 -2.196553624506 1.54305737086609
1 -1.19279457755301 0.282270430941452
-1 -1.20110705596348 -2.14996836943594
-1 -1.91636270533011 0.979131913324693
1 0.550504999262621 -1.76485065720597
1 0.697193359128271 -0.0101812153278331
-1 -2.24959965621084 2.92743112425775
1 1.79448177429523 -0.338141826699257
-1 1.45937318831057 -1.70298365336102
-1 0.280333928546661 2.97919087522754
1 -0.734325737401171 -0.350708931578126
1 1.42383150500623 -1.27048409988453
-1 -2.66458012266235 -2.07924077028447
-1 2.9679875197313 -1.12006907123074
-1 -1.48666006030984 -1.95398187078068
1 -1.29476094047224 -1.49201532431823
-1 2.6242054796984 -0.940039139821707
-1 -2.82366361340059 2.17507496018899
1 -0.561926209000283 1.61379218833038
-1 2.75567419784331 -2.82483031421197
1 -0.683624297080478 -0.210905315563039
1 -1.50659699810468 -0.850043715893747
-1 2.48951665676126 2.0062531520157
-1 -2.74567131798953 -0.768652127119367
1 -0.91250696793599 -0.0989781076406331
-1 -2.04504677746906 -1.65284921888488
-1 0.529209433734628 -2.41136450117328
