# NAME

App::Greple::xlate - greple을 위한 번역 지원 모듈

# SYNOPSIS

    greple -Mxlate -e ENGINE --xlate pattern target-file

    greple -Mxlate::deepl --xlate pattern target-file

# VERSION

Version 0.44

# DESCRIPTION

**Greple** **xlate** 모듈은 원하는 텍스트 블록을 찾아 번역된 텍스트로 대체합니다. 현재 DeepL (`deepl.pm`) 및 ChatGPT (`gpt3.pm`) 모듈이 백엔드 엔진으로 구현되어 있습니다. 실험적으로 gpt-4 및 gpt-4o를 지원하고 있습니다.

만약 Perl의 pod 스타일로 작성된 문서에서 일반 텍스트 블록을 번역하려면 다음과 같이 `xlate::deepl`과 `perl` 모듈을 사용하는 **greple** 명령을 사용하십시오.

    greple -Mxlate::deepl -Mperl --pod --re '^([\w\pP].*\n)+' --all foo.pm

이 명령어에서 패턴 문자열 `^([\w\pP].*\n)+`은 알파벳-숫자 및 구두점 문자로 시작하는 연이은 줄을 의미합니다. 이 명령어는 번역할 영역을 강조해서 보여줍니다. 옵션 **--all**은 전체 텍스트를 생성하는 데 사용됩니다.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
    </p>
</div>

그런 다음 선택한 영역을 번역하려면 `--xlate` 옵션을 추가하십시오. 그러면 원하는 섹션을 찾아 **deepl** 명령의 출력으로 대체합니다.

기본적으로 원본 및 번역된 텍스트는 [git(1)](http://man.he.net/man1/git)과 호환되는 "충돌 마커" 형식으로 출력됩니다. `ifdef` 형식을 사용하면 [unifdef(1)](http://man.he.net/man1/unifdef) 명령을 사용하여 원하는 부분을 쉽게 얻을 수 있습니다. 출력 형식은 **--xlate-format** 옵션으로 지정할 수 있습니다.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
    </p>
</div>

전체 텍스트를 번역하려면 **--match-all** 옵션을 사용하십시오. 이는 전체 텍스트와 일치하는 `(?s).+` 패턴을 지정하는 단축키입니다.

충돌 표시자 형식 데이터는 `sdif` 명령어와 `-V` 옵션을 사용하여 측면으로 볼 수 있습니다. 문자열 단위로 비교하는 것은 의미가 없으므로 `--no-cdif` 옵션이 권장됩니다. 텍스트에 색상을 입힐 필요가 없다면 `--no-textcolor` (또는 `--no-tc`)를 지정하십시오.

    sdif -V --no-tc --no-cdif data_shishin.deepl-EN-US.cm

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/sdif-cm-view.png">
    </p>
</div>

# NORMALIZATION

처리는 지정된 단위로 이루어지지만, 비어 있지 않은 여러 줄의 연속된 텍스트의 경우, 이를 함께 단일 줄로 변환합니다. 이 작업은 다음과 같이 수행됩니다:

- 각 줄의 시작과 끝의 공백을 제거합니다.
- 만약 줄이 전체 너비의 구두점 문자로 끝난다면, 다음 줄과 연결합니다.
- 한 줄이 전체 너비 문자로 끝나고 다음 줄이 전체 너비 문자로 시작하는 경우, 줄을 연결합니다.
- 한 줄의 끝 또는 시작이 전체 너비 문자가 아닌 경우, 공백 문자를 삽입하여 연결합니다.

캐시 데이터는 정규화된 텍스트를 기반으로 관리되므로 정규화 결과에 영향을 주지 않는 수정이 이루어져도 캐시된 번역 데이터는 여전히 유효합니다.

이 정규화 과정은 첫 번째(0번째) 및 짝수 번째 패턴에 대해서만 수행됩니다. 따라서 두 개의 패턴이 다음과 같이 지정된 경우, 첫 번째 패턴과 일치하는 텍스트는 정규화 후 처리되며, 두 번째 패턴과 일치하는 텍스트에는 정규화 과정이 수행되지 않습니다.

    greple -Mxlate -E normalized -E not-normalized

따라서 여러 줄을 하나의 줄로 결합하여 처리해야 하는 텍스트에는 첫 번째 패턴을 사용하고, 서식이 있는 텍스트에는 두 번째 패턴을 사용하십시오. 첫 번째 패턴에 일치하는 텍스트가 없는 경우 `(?!)`과 같이 아무것도 일치하지 않는 패턴을 사용하십시오.

# MASKING

가끔은 번역하고 싶지 않은 텍스트 부분이 있습니다. 예를 들어, 마크다운 파일의 태그들입니다. DeepL은 이러한 경우에는 번역에서 제외할 텍스트 부분을 XML 태그로 변환한 후 번역을 완료한 후에 다시 복원하는 것을 제안합니다. 이를 지원하기 위해 번역에서 가려져야 하는 부분을 지정할 수 있습니다.

    --xlate-setopt maskfile=MASKPATTERN

이는 파일 \`MASKPATTERN\`의 각 줄을 정규 표현식으로 해석하여 일치하는 문자열을 번역하고 처리 후 되돌립니다. `#`로 시작하는 줄은 무시됩니다.

복잡한 패턴은 백슬래시로 이스케이프된 새 줄에 여러 줄에 작성할 수 있습니다.

텍스트가 가려짐으로써 어떻게 변환되는지는 **--xlate-mask** 옵션으로 확인할 수 있습니다.

이 인터페이스는 실험적이며 향후 변경될 수 있습니다.

# OPTIONS

- **--xlate**
- **--xlate-color**
- **--xlate-fold**
- **--xlate-fold-width**=_n_ (Default: 70)

    매치된 영역마다 번역 프로세스를 호출합니다.

    이 옵션 없이 **greple**은 일반 검색 명령으로 동작합니다. 따라서 실제 작업을 호출하기 전에 파일의 어느 부분이 번역의 대상이 될지 확인할 수 있습니다.

    명령 결과는 표준 출력으로 전달되므로 필요한 경우 파일로 리디렉션하거나 [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate) 모듈을 사용하는 것을 고려하십시오.

    옵션 **--xlate**은 **--xlate-color** 옵션을 **--color=never** 옵션과 함께 호출합니다.

    **--xlate-fold** 옵션으로 변환된 텍스트를 지정된 너비로 접힙니다. 기본 너비는 70이며 **--xlate-fold-width** 옵션으로 설정할 수 있습니다. 네 개의 열은 run-in 작업을 위해 예약되어 있으므로 각 줄에는 최대 74자까지 포함될 수 있습니다.

- **--xlate-engine**=_engine_

    사용할 번역 엔진을 지정합니다. `-Mxlate::deepl`과 같이 엔진 모듈을 직접 지정하는 경우에는 이 옵션을 사용할 필요가 없습니다.

    현재 사용 가능한 엔진은 다음과 같습니다.

    - **deepl**: DeepL API
    - **gpt3**: gpt-3.5-turbo
    - **gpt4**: gpt-4-turbo
    - **gpt4o**: gpt-4o-mini

        **gpt-4o**의 인터페이스는 현재 불안정하며 올바르게 작동할 수 없음을 보장할 수 없습니다.

- **--xlate-labor**
- **--xlabor**

    번역 엔진을 호출하는 대신, 직접 작업하도록 요청됩니다. 번역할 텍스트를 준비한 후, 해당 텍스트를 클립보드에 복사합니다. 그런 다음, 해당 텍스트를 양식에 붙여넣고, 결과를 클립보드에 복사한 후, Enter 키를 누르도록 요청됩니다.

- **--xlate-to** (Default: `EN-US`)

    대상 언어를 지정합니다. **DeepL** 엔진을 사용할 때 `deepl languages` 명령으로 사용 가능한 언어를 얻을 수 있습니다.

- **--xlate-format**=_format_ (Default: `conflict`)

    원본 및 번역된 텍스트의 출력 형식을 지정합니다.

    다음 형식들은 `xtxt` 이외의 형식을 가정하며, 번역할 부분이 여러 줄의 모음인 것으로 가정합니다. 실제로 한 줄의 일부만을 번역하는 것도 가능하며, `xtxt` 이외의 형식을 지정해도 의미 있는 결과를 얻을 수 없습니다.

    - **conflict**, **cm**

        원본과 변환된 텍스트는 [git(1)](http://man.he.net/man1/git) 충돌 표시자 형식으로 출력됩니다.

            <<<<<<< ORIGINAL
            original text
            =======
            translated Japanese text
            >>>>>>> JA

        다음 [sed(1)](http://man.he.net/man1/sed) 명령으로 원본 파일을 복구할 수 있습니다.

            sed -e '/^<<<<<<< /d' -e '/^=======$/,/^>>>>>>> /d'

    - **colon**, _:::::::_

        \`\`\`html

            ::::::: ORIGINAL
            original text
            :::::::
            ::::::: JA
            translated Japanese text
            :::::::

        &lt;div style="background-color: #f4f4f4; color: #333; padding: 10px; margin: 10px 0;">

            <div class="ORIGINAL">
            original text
            </div>
            <div class="JA">
            translated Japanese text
            </div>

        Number of colon is 7 by default. If you specify colon sequence like \`:::::\`, it is used instead of 7 colons.

    - **ifdef**

        원본과 변환된 텍스트는 [cpp(1)](http://man.he.net/man1/cpp) `#ifdef` 형식으로 출력됩니다.

            #ifdef ORIGINAL
            original text
            #endif
            #ifdef JA
            translated Japanese text
            #endif

        **unifdef** 명령으로 일본어 텍스트만 검색할 수 있습니다:

            unifdef -UORIGINAL -DJA foo.ja.pm

    - **space**
    - **space+**

        Original: Hello, how are you doing today?

    - **xtxt**

        형식이 `xtxt` (번역된 텍스트)이거나 알 수 없는 경우, 번역된 텍스트만 출력됩니다.

- **--xlate-maxlen**=_chars_ (Default: 0)

    다음 텍스트를 한국어로 번역하십시오. 한 번에 API에 보낼 수 있는 텍스트의 최대 길이를 지정하십시오. 기본값은 무료 DeepL 계정 서비스에 대해 128K로 설정되어 있으며, 클립보드 인터페이스에 대해서는 5000으로 설정되어 있습니다. Pro 서비스를 사용하는 경우 이 값을 변경할 수 있을 수도 있습니다.

- **--xlate-maxline**=_n_ (Default: 0)

    한 번에 API로 보낼 수 있는 최대 텍스트 라인 수를 지정합니다.

    한 번에 한 줄씩 번역하려면 이 값을 1로 설정하십시오. 이 옵션은 `--xlate-maxlen` 옵션보다 우선합니다.

- **--**\[**no-**\]**xlate-progress** (Default: True)

    STDERR 출력에서 실시간으로 번역 결과를 확인합니다.

- **--xlate-stripe**

    매치된 부분을 지브라 스트라이프 패션으로 보여주기 위해 [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe) 모듈을 사용합니다. 매치된 부분이 연이어 연결된 경우 유용합니다.

    색상 팔레트는 터미널의 배경색에 따라 전환됩니다. 명시적으로 지정하려면 **--xlate-stripe-light** 또는 **--xlate-stripe-dark**를 사용할 수 있습니다.

- **--xlate-mask**

    마스킹 기능을 수행하고 변환된 텍스트를 복원 없이 표시합니다.

- **--match-all**

    파일의 전체 텍스트를 대상 영역으로 설정합니다.

# CACHE OPTIONS

**xlate** 모듈은 각 파일의 번역 캐시 텍스트를 저장하고 실행 전에 읽어들여 서버에 요청하는 오버헤드를 제거할 수 있습니다. 기본 캐시 전략인 `auto`로 설정하면 대상 파일에 대해 캐시 파일이 존재할 때만 캐시 데이터를 유지합니다.

**--xlate-cache=clear**를 사용하여 캐시 관리를 시작하거나 기존 캐시 데이터를 모두 정리할 수 있습니다. 이 옵션을 사용하여 실행하면 새로운 캐시 파일이 없는 경우에는 새로 생성되고 그 후 자동으로 유지됩니다.

- --xlate-cache=_strategy_
    - `auto` (Default)

        캐시 파일이 있으면 유지합니다.

    - `create`

        빈 캐시 파일을 생성하고 종료합니다.

    - `always`, `yes`, `1`

        대상이 일반 파일인 한 캐시를 계속 유지합니다.

    - `clear`

        먼저 캐시 데이터를 지웁니다.

    - `never`, `no`, `0`

        캐시 파일을 사용하지 않습니다.

    - `accumulate`

        기본 동작으로 캐시 파일에서 사용되지 않는 데이터가 제거됩니다. 이를 제거하지 않고 파일에 유지하려면 `accumulate`를 사용하십시오.
- **--xlate-update**

    이 옵션은 필요하지 않더라도 캐시 파일을 강제로 업데이트합니다.

# COMMAND LINE INTERFACE

이 배포에 포함된 `xlate` 명령을 사용하여 이 모듈을 쉽게 명령 줄에서 사용할 수 있습니다. 사용법은 `xlate` 도움말 정보를 참조하십시오.

`xlate` 명령은 Docker 환경과 함께 작동하므로, 아무것도 설치하지 않은 상태에서 Docker가 사용 가능하다면 사용할 수 있습니다. `-D` 또는 `-C` 옵션을 사용하십시오.

또한, 다양한 문서 스타일에 대한 makefile이 제공되므로, 특별한 지정 없이 다른 언어로 번역할 수 있습니다. `-M` 옵션을 사용하십시오.

Docker와 make 옵션을 결합하여 Docker 환경에서 make를 실행할 수도 있습니다.

`xlate -GC`와 같이 실행하면 현재 작업 중인 git 저장소가 마운트된 셸이 시작됩니다.

자세한 내용은 ["SEE ALSO"](#see-also) 섹션에 있는 일본어 기사를 읽어보세요.

    xlate [ options ] -t lang file [ greple options ]
        -h   help
        -v   show version
        -d   debug
        -n   dry-run
        -a   use API
        -c   just check translation area
        -r   refresh cache
        -s   silent mode
        -e # translation engine (default "deepl")
        -p # pattern to determine translation area
        -x # file containing mask patterns
        -w # wrap line by # width
        -o # output format (default "xtxt", or "cm", "ifdef")
        -f # from lang (ignored)
        -t # to lang (required, no default)
        -m # max length per API call
        -l # show library files (XLATE.mk, xlate.el)
        --   terminate option parsing
    Make options
        -M   run make
        -n   dry-run
    Docker options
        -G   mount git top-level directory
        -B   run in non-interactive (batch) mode
        -R   mount read-only
        -E * specify environment variable to be inherited
        -I * docker image name or version (default: tecolicom/xlate:version)
        -D * run xlate on the container with the rest parameters
        -C * run following command on the container, or run shell
    
    Control Files:
        *.LANG    translation languates
        *.FORMAT  translation foramt (xtxt, cm, ifdef, colon, space)
        *.ENGINE  translation engine (deepl, gpt3, gpt4, gpt4o)

# EMACS

Emacs 편집기에서 `xlate` 명령을 사용하려면 저장소에 포함된 `xlate.el` 파일을 로드하십시오. `xlate-region` 함수는 지정된 영역을 번역합니다. 기본 언어는 `EN-US`이며 접두사 인수로 언어를 지정할 수 있습니다.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/emacs.png">
    </p>
</div>

# ENVIRONMENT

- DEEPL\_AUTH\_KEY

    DeepL 서비스의 인증 키를 설정하십시오.

- OPENAI\_API\_KEY

    OpenAI 인증 키입니다.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::xlate

## TOOLS

DeepL과 ChatGPT의 명령 줄 도구를 설치해야 합니다.

[https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

[https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

# SEE ALSO

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

[App::Greple::xlate::deepl](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Adeepl)

[App::Greple::xlate::gpt3](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Agpt3)

- [https://hub.docker.com/r/tecolicom/xlate](https://hub.docker.com/r/tecolicom/xlate)

    도커 컨테이너 이미지.

- [https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

    DeepL Python 라이브러리 및 CLI 명령입니다.

- [https://github.com/openai/openai-python](https://github.com/openai/openai-python)

    OpenAI Python 라이브러리

- [https://github.com/tecolicom/App-gpty](https://github.com/tecolicom/App-gpty)

    OpenAI 명령 줄 인터페이스

- [App::Greple](https://metacpan.org/pod/App%3A%3AGreple)

    대상 텍스트 패턴에 대한 자세한 내용은 **greple** 매뉴얼을 참조하십시오. 일치하는 영역을 제한하려면 **--inside**, **--outside**, **--include**, **--exclude** 옵션을 사용하십시오.

- [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate)

    **greple** 명령의 결과로 파일을 수정하는 데 `-Mupdate` 모듈을 사용할 수 있습니다.

- [App::sdif](https://metacpan.org/pod/App%3A%3Asdif)

    **-V** 옵션과 함께 충돌 마커 형식을 옆에 나란히 표시하려면 **sdif**를 사용하십시오.

- [App::Greple::stripe](https://metacpan.org/pod/App%3A%3AGreple%3A%3Astripe)

    Greple **stripe** 모듈은 **--xlate-stripe** 옵션을 사용합니다.

## ARTICLES

- [https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250](https://qiita.com/kaz-utashiro/items/1c1a51a4591922e18250)

    DeepL API를 사용하여 필요한 부분만 번역 및 교체하는 Greple 모듈 (일본어로)

- [https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6](https://qiita.com/kaz-utashiro/items/a5e19736416ca183ecf6)

    DeepL API 모듈을 사용하여 15개 언어로 문서 생성 (일본어로)

- [https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd](https://qiita.com/kaz-utashiro/items/1b9e155d6ae0620ab4dd)

    DeepL API를 사용한 자동 번역 Docker 환경 (일본어로)

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023-2024 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
