package Astro::Coord::ECI::VSOP87D::Mars;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Superior };

our $VERSION = '0.007';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Mars",
      default_model_cutoff => {
        Meeus => {
                   B0   => 16,
                   B1   => 9,
                   B2   => 7,
                   B3   => 4,
                   B4   => 3,
                   L0   => 69,
                   L1   => 46,
                   L2   => 33,
                   L3   => 12,
                   L4   => 8,
                   L5   => 2,
                   name => "Meeus",
                   R0   => 45,
                   R1   => 27,
                   R2   => 11,
                   R3   => 6,
                   R4   => 4,
                 },
        none  => {
                   B0   => 441,
                   B1   => 287,
                   B2   => 130,
                   B3   => 41,
                   B4   => 11,
                   B5   => 5,
                   L0   => 1217,
                   L1   => 686,
                   L2   => 310,
                   L3   => 129,
                   L4   => 36,
                   L5   => 15,
                   name => "none",
                   R0   => 1118,
                   R1   => 596,
                   R2   => 313,
                   R3   => 111,
                   R4   => 28,
                   R5   => 9,
                 },
      },
      diameter => 6780,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [6.20347711583, 0, 0],
                        [0.186563681, 5.05037100303, 3340.6124266998],
                        [0.01108216792, 5.40099836958, 6681.2248533996],
                        [0.00091798394, 5.75478745111, 10021.8372800994],
                        [0.00027744987, 5.97049512942, 3.523118349],
                        [0.0001061023, 2.93958524973, 2281.2304965106],
                        [0.00012315897, 0.84956081238, 2810.9214616052],
                        [8.926772e-05, 4.15697845939, 0.0172536522],
                        [8.715688e-05, 6.11005159792, 13362.4497067992],
                        [6.797552e-05, 0.36462243626, 398.1490034082],
                        [7.774867e-05, 3.33968655074, 5621.8429232104],
                        [3.575079e-05, 1.66186540141, 2544.3144198834],
                        [4.161101e-05, 0.2281497533, 2942.4634232916],
                        [3.07525e-05, 0.85696597082, 191.4482661116],
                        [2.628122e-05, 0.6480614357, 3337.0893083508],
                        [2.937543e-05, 6.07893711408, 0.0673103028],
                        [2.38942e-05, 5.03896401349, 796.2980068164],
                        [2.579842e-05, 0.02996706197, 3344.1355450488],
                        [1.52814e-05, 1.14979306228, 6151.533888305],
                        [1.798808e-05, 0.65634026844, 529.6909650946],
                        [1.264356e-05, 3.62275092231, 5092.1519581158],
                        [1.286232e-05, 3.06795924626, 2146.1654164752],
                        [1.546408e-05, 2.91579633392, 1751.539531416],
                        [1.024907e-05, 3.69334293555, 8962.4553499102],
                        [8.91567e-06, 0.1829389909, 16703.062133499],
                        [8.5876e-06, 2.40093704204, 2914.0142358238],
                        [8.32718e-06, 2.46418591282, 3340.5951730476],
                        [8.32724e-06, 4.49495753458, 3340.629680352],
                        [7.12899e-06, 3.66336014788, 1059.3819301892],
                        [7.48724e-06, 3.82248399468, 155.4203994342],
                        [7.23863e-06, 0.67497565801, 3738.761430108],
                        [6.35557e-06, 2.92182704275, 8432.7643848156],
                        [6.55163e-06, 0.48864075176, 3127.3133312618],
                        [5.50472e-06, 3.81001205408, 0.9803210682],
                        [5.52746e-06, 4.47478863016, 1748.016413067],
                        [4.25972e-06, 0.55365138172, 6283.0758499914],
                        [4.15132e-06, 0.49662314774, 213.299095438],
                        [4.72164e-06, 3.6254781941, 1194.4470102246],
                        [3.06552e-06, 0.38052862973, 6684.7479717486],
                        [3.12141e-06, 0.99853322843, 6677.7017350506],
                        [2.93199e-06, 4.22131277914, 20.7753954924],
                        [3.02377e-06, 4.48618150321, 3532.0606928114],
                        [2.74028e-06, 0.54222141841, 3340.545116397],
                        [2.81073e-06, 5.88163372945, 1349.8674096588],
                        [2.31185e-06, 1.28240685294, 3870.3033917944],
                        [2.836e-06, 5.76885494123, 3149.1641605882],
                        [2.36114e-06, 5.75504515576, 3333.498879699],
                        [2.74035e-06, 0.13372501211, 3340.6797370026],
                        [2.99396e-06, 2.78323705697, 6254.6266625236],
                        [2.04161e-06, 2.82133266185, 1221.8485663214],
                        [2.38857e-06, 5.37155471672, 4136.9104335162],
                        [1.88639e-06, 1.49103016486, 9492.1463150048],
                        [2.21225e-06, 3.50466672203, 382.8965322232],
                        [1.79196e-06, 1.00561112574, 951.7184062506],
                        [1.7211e-06, 0.43943041719, 5486.777843175],
                        [1.93126e-06, 3.35715137745, 3.5904286518],
                        [1.44305e-06, 1.41874193418, 135.0650800354],
                        [1.60011e-06, 3.94854735192, 4562.4609930212],
                        [1.74068e-06, 2.41360332576, 553.5694028424],
                        [1.30993e-06, 4.04491720264, 12303.06777661],
                        [1.38245e-06, 4.30145176915, 7.1135470008],
                        [1.28062e-06, 1.80665643332, 5088.6288397668],
                        [1.39897e-06, 3.32592516164, 2700.7151403858],
                        [1.28102e-06, 2.20806651008, 1592.5960136328],
                        [1.16945e-06, 3.12805282207, 7903.073419721],
                        [1.10375e-06, 1.05195079687, 242.728603974],
                        [1.13486e-06, 3.70070798123, 1589.0728952838],
                        [1.0009e-06, 3.24343740861, 11773.3768115154],
                        [9.5592e-07, 0.53954181149, 20043.6745601988],
                        [9.8947e-07, 4.8455829474, 6681.2421070518],
                        [1.04541e-06, 0.78535382076, 8827.3902698748],
                        [8.4187e-07, 3.9897072073, 4399.994356889],
                        [8.6931e-07, 2.20186740523, 11243.6858464208],
                        [7.1437e-07, 2.80307550016, 3185.1920272656],
                        [7.2091e-07, 5.84672102525, 5884.9268465832],
                        [7.3476e-07, 2.18428012567, 8429.2412664666],
                        [9.8946e-07, 2.81481140371, 6681.2075997474],
                        [6.8414e-07, 2.73834914412, 2288.3440435114],
                        [8.6751e-07, 1.02092221563, 7079.3738568078],
                        [6.532e-07, 2.68118597578, 28.4491874678],
                        [8.3749e-07, 3.2025613099, 4690.4798363586],
                        [7.5034e-07, 0.76643418252, 6467.9257579616],
                        [6.8984e-07, 3.76399731788, 6041.3275670856],
                        [6.6706e-07, 0.73630620766, 3723.508958923],
                        [6.3314e-07, 4.5277147047, 426.598190876],
                        [6.1683e-07, 6.16831509419, 2274.1169495098],
                        [5.2256e-07, 0.89941531307, 9623.6882766912],
                        [5.5488e-07, 4.6062546702, 4292.3308329504],
                        [5.1332e-07, 4.14823636534, 3341.592747768],
                        [5.6629e-07, 5.06250410206, 15.252471185],
                        [6.3376e-07, 0.91296240798, 3553.9115221378],
                        [4.5829e-07, 0.78784235062, 1990.745017041],
                        [4.8542e-07, 3.95670418719, 4535.0594369244],
                        [4.1223e-07, 6.02019329922, 3894.1818295422],
                        [4.1939e-07, 3.58326425115, 8031.0922630584],
                        [5.6396e-07, 1.68727150304, 6872.6731195112],
                        [5.5909e-07, 3.46260833495, 263.0839233728],
                        [5.1678e-07, 2.81307492682, 3339.6321056316],
                        [4.0671e-07, 3.13832621829, 9595.2390892234],
                        [3.8107e-07, 0.7340194632, 10025.3603984484],
                        [3.9495e-07, 5.6322539216, 3097.88382272579],
                        [4.4174e-07, 3.19529736702, 5628.9564702112],
                        [3.6716e-07, 2.63720775102, 692.1576012268],
                        [4.5905e-07, 0.28718981497, 5614.7293762096],
                        [3.8352e-07, 5.82880707426, 3191.0492295652],
                        [3.8206e-07, 2.34835984063, 162.4666361322],
                        [3.2562e-07, 0.48400659333, 6681.2921637024],
                        [3.7135e-07, 0.68508150774, 2818.035008606],
                        [3.1168e-07, 3.98160912982, 20.3553193988],
                        [3.2561e-07, 0.89250316888, 6681.1575430968],
                        [3.7752e-07, 4.15482955299, 2803.8079146044],
                        [3.3626e-07, 6.11992401052, 6489.776587288],
                        [2.9007e-07, 2.42707385674, 3319.8370312074],
                        [3.879e-07, 1.35198498795, 10018.3141617504],
                        [3.3148e-07, 1.14023770004, 5.5229243074],
                        [2.7584e-07, 1.59691203058, 7210.9158184942],
                        [2.8686e-07, 5.72055456734, 7477.522860216],
                        [3.4031e-07, 2.59544082509, 11769.8536931664],
                        [2.538e-07, 0.52093116112, 10.6366653498],
                        [2.6357e-07, 1.34532646574, 3496.032826134],
                        [2.4554e-07, 4.00323183088, 11371.7046897582],
                        [2.5637e-07, 0.2496352342, 522.5774180938],
                        [2.7278e-07, 4.55645328122, 3361.3878221922],
                        [2.3764e-07, 1.84058377256, 12832.7587417046],
                        [2.2816e-07, 3.52628212106, 1648.4467571974],
                        [2.2274e-07, 0.72106133721, 266.6070417218],
                        [2.1202e-07, 3.11824472284, 2957.7158944766],
                        [2.0158e-07, 3.67131504946, 1758.6530784168],
                        [2.153e-07, 6.15388757177, 3264.3463554242],
                        [2.0093e-07, 1.08247416065, 7064.1213856228],
                        [2.1343e-07, 4.28218757863, 4032.7700279266],
                        [2.754e-07, 6.08389942337, 6674.1113063988],
                        [1.9849e-07, 2.37668920745, 10713.9948813262],
                        [2.5512e-07, 3.43242352804, 3443.7052009184],
                        [2.2542e-07, 5.64861703438, 2388.8940204492],
                        [2.4378e-07, 0.96994696413, 632.7837393132],
                        [2.3079e-07, 4.74990214223, 3347.7259737006],
                        [1.7709e-07, 3.69742343974, 3344.2028553516],
                        [2.2662e-07, 3.95446324417, 4989.0591838972],
                        [2.2604e-07, 5.24082917494, 3205.5473466644],
                        [1.6811e-07, 5.48619684111, 3.881335358],
                        [1.8422e-07, 4.22535881468, 2787.0430238574],
                        [2.2737e-07, 4.98520896596, 7632.9432596502],
                        [1.6648e-07, 2.52823633184, 14584.2982731206],
                        [2.0963e-07, 4.27878216453, 5099.2655051166],
                        [1.6042e-07, 1.76786752521, 3475.6775067352],
                        [1.5816e-07, 3.13240869691, 59.3738619136],
                        [1.8113e-07, 3.25756020453, 3337.021998048],
                        [1.9295e-07, 3.23911854642, 7.046236698],
                        [1.6772e-07, 4.3973150711, 15643.6802033098],
                        [1.7555e-07, 4.09197396097, 74.7815985673],
                        [1.3704e-07, 2.5411701816, 4933.2084403326],
                        [1.6011e-07, 1.54669633224, 14054.607308026],
                        [1.3547e-07, 4.04152185347, 4929.6853219836],
                        [1.4566e-07, 3.45210993051, 7373.3824546264],
                        [1.3926e-07, 5.40797129468, 10973.55568635],
                        [1.4246e-07, 0.59808746067, 23.8784377478],
                        [1.4023e-07, 1.44218648988, 10404.7338123226],
                        [1.6051e-07, 3.79409950488, 2118.7638603784],
                        [1.3714e-07, 3.59050634457, 15113.9892382152],
                        [1.8038e-07, 4.25391532, 2487.4160449478],
                        [1.5846e-07, 0.56901288692, 103.0927742186],
                        [1.3403e-07, 5.16920432994, 10213.285546211],
                        [1.6069e-07, 2.36895958451, 3265.8308281325],
                        [1.2773e-07, 0.10483085657, 7234.794256242],
                        [1.2199e-07, 1.73079687044, 36.0278666774],
                        [1.2283e-07, 5.19940030635, 10021.8545337516],
                        [1.1945e-07, 5.47997890162, 2921.1277828246],
                        [1.189e-07, 4.76593905835, 5828.0284716476],
                        [1.2283e-07, 3.16862882612, 10021.8200264472],
                        [1.3274e-07, 6.1780690534, 1744.4259844152],
                        [1.1777e-07, 5.727315509, 0.42007609361],
                        [1.234e-07, 2.52146766331, 2906.900688823],
                        [1.4458e-07, 4.38010658432, 316.3918696566],
                        [1.0639e-07, 3.45016942919, 639.897286314],
                        [1.0925e-07, 0.60397688999, 5085.038411115],
                        [1.0645e-07, 5.47696728127, 419.4846438752],
                        [1.0797e-07, 1.37191539718, 10419.9862835076],
                        [1.0565e-07, 1.09061610786, 12168.0026965746],
                        [9.578e-08, 4.89489266197, 3230.4061054804],
                        [9.808e-08, 5.83632873998, 14314.1681130498],
                        [9.72e-08, 6.28282606427, 9225.539273283],
                        [9.146e-08, 1.10220667397, 9808.5381846614],
                        [1.2733e-07, 1.79883375851, 13745.3462390224],
                        [9.779e-08, 3.60056884868, 206.1855484372],
                        [1.2156e-07, 4.42295240981, 14712.317116458],
                        [8.801e-08, 3.97218590685, 170.6728706192],
                        [1.0685e-07, 4.33894776374, 7740.6067835888],
                        [1.0041e-07, 1.3829466683, 3583.3410306738],
                        [8.499e-08, 4.29275471153, 0.4298831267],
                        [9.882e-08, 2.69148019691, 36.6053653042],
                        [1.0585e-07, 0.89641284928, 23384.2869868986],
                        [8.478e-08, 2.86886131803, 9381.9399937854],
                        [9.56e-08, 4.33382353581, 131.5419616864],
                        [8.433e-08, 3.1523973397, 6525.8044539654],
                        [7.517e-08, 1.24476310635, 6894.5239488376],
                        [6.753e-08, 1.58869332894, 6836.6452528338],
                        [6.666e-08, 4.38910103043, 66.4874089144],
                        [6.697e-08, 5.77315870484, 5202.3582793352],
                        [6.188e-08, 1.5784796785, 3325.3599555148],
                        [8.392e-08, 2.90734956761, 43.718912305],
                        [6.427e-08, 6.03333185624, 574.3447983348],
                        [6.296e-08, 0.06976040737, 1964.838626854],
                        [6.144e-08, 5.43713363624, 1861.7458526354],
                        [8.18e-08, 0.43967386003, 2707.8286873866],
                        [6.532e-08, 1.24907069366, 12964.300703391],
                        [7.341e-08, 4.95693808975, 3767.2106175758],
                        [6.134e-08, 3.16322441707, 6680.2445323314],
                        [5.937e-08, 4.22752447794, 4459.3682188026],
                        [5.848e-08, 4.30379700916, 7875.6718636242],
                        [5.895e-08, 0.77226207039, 2699.7348193176],
                        [5.962e-08, 3.01318151415, 3369.0616141676],
                        [6.307e-08, 1.77830983983, 2178.137722292],
                        [6.103e-08, 4.49866000852, 6682.2051744678],
                        [5.77e-08, 0.96127853878, 13916.0191096416],
                        [5.725e-08, 4.93042706875, 2384.3232707292],
                        [7.576e-08, 6.16308742022, 6531.661656265],
                        [7.285e-08, 0.52756973131, 10575.4066829418],
                        [5.212e-08, 3.48999909365, 12935.8515159232],
                        [5.266e-08, 4.51201042373, 6144.4203413042],
                        [6.632e-08, 3.48100908925, 1118.7557921028],
                        [5.182e-08, 3.25459432228, 2391.43681773],
                        [5.214e-08, 0.01023839897, 533.2140834436],
                        [5.436e-08, 6.18510045571, 8425.6508378148],
                        [5.491e-08, 3.42235890731, 3134.4268782626],
                        [5.773e-08, 3.55190490896, 8969.568896911],
                        [5.093e-08, 0.60873962999, 8955.3418029094],
                        [4.798e-08, 4.63144694279, 4569.574540022],
                        [5.773e-08, 5.92316959013, 640.8776073822],
                        [5.661e-08, 0.75892958537, 3120.199784261],
                        [4.912e-08, 1.70762118141, 13358.9265884502],
                        [5.438e-08, 4.29256867866, 3503.079062832],
                        [4.631e-08, 3.34058594066, 3116.2676309979],
                        [5.823e-08, 2.39009621568, 3302.479391062],
                        [5.095e-08, 1.12497131307, 5331.3574437408],
                        [4.409e-08, 1.3870873295, 17256.6315363414],
                        [4.193e-08, 0.19116539271, 9830.3890139878],
                        [4.164e-08, 0.43798301495, 1066.49547719],
                        [4.22e-08, 1.69427060019, 13524.9163429314],
                        [5.192e-08, 3.63500646439, 536.8045120954],
                        [5.664e-08, 0.50446281443, 5305.4510535538],
                        [5.264e-08, 5.40031180025, 3355.8648978848],
                        [5.403e-08, 5.96867227489, 3074.005384978],
                        [4.046e-08, 0.83826342101, 10021.9045904022],
                        [4.153e-08, 3.14497570817, 8439.8779318164],
                        [4.82e-08, 1.09025983917, 13365.9728251482],
                        [4.906e-08, 3.73078406569, 1228.9621133222],
                        [4.576e-08, 0.99344843456, 6158.6474353058],
                        [4.211e-08, 3.87091723842, 3312.163239232],
                        [4.917e-08, 6.25051681717, 17654.7805397496],
                        [3.597e-08, 6.07298181151, 10818.1352869158],
                        [3.547e-08, 1.87663674277, 17395.2197347258],
                        [3.734e-08, 1.37011069213, 3973.396166013],
                        [4.422e-08, 2.89974680697, 6247.5131155228],
                        [3.975e-08, 4.03441621102, 1052.2683831884],
                        [4.466e-08, 4.59188422424, 5518.7501489918],
                        [3.445e-08, 4.26610076208, 3178.1457905676],
                        [3.607e-08, 4.24527056399, 8329.671610597],
                        [3.511e-08, 1.95133364438, 10177.2576795336],
                        [3.3e-08, 0.68865737747, 149.5631971346],
                        [3.235e-08, 3.90171358031, 27.4015560968],
                        [3.946e-08, 5.81982010903, 6261.7402095244],
                        [3.387e-08, 0.14377701728, 10014.7237330986],
                        [3.374e-08, 0.74722238154, 6048.4411140864],
                        [3.09e-08, 3.98540766861, 2648.454825473],
                        [3.821e-08, 5.23987859516, 5724.935697429],
                        [3.026e-08, 0.34314724795, 220.4126424388],
                        [4.052e-08, 1.24671617482, 10021.7699697966],
                        [2.937e-08, 0.73100893561, 2.751510611],
                        [3.084e-08, 3.79925632319, 169.580183133],
                        [4.04e-08, 2.91258200196, 22747.2907148744],
                        [3.246e-08, 4.90760526525, 6702.000248892],
                        [3.223e-08, 0.9264000861, 16865.5287696312],
                        [2.879e-08, 1.47180601483, 3346.1353510072],
                        [3.723e-08, 0.49978317761, 1.4844727083],
                        [2.798e-08, 3.26910698548, 9168.6408983474],
                        [3.347e-08, 0.68791690253, 3863.1898447936],
                        [3.44e-08, 2.77706064625, 6660.4494579072],
                        [2.798e-08, 2.79673379094, 16858.4825329332],
                        [2.753e-08, 4.41190782119, 3415.3940252671],
                        [2.703e-08, 0.19222683184, 3237.5196524812],
                        [2.719e-08, 3.26628341377, 3914.9572250346],
                        [2.941e-08, 3.76169133143, 6784.3176276182],
                        [3.078e-08, 5.48104322207, 3335.0895023924],
                        [2.701e-08, 5.08537226206, 6688.3384004004],
                        [2.606e-08, 4.83032556909, 4672.6673142406],
                        [2.883e-08, 2.64068086362, 3320.257107301],
                        [3.089e-08, 4.396198243, 1332.0548875408],
                        [3.438e-08, 1.93467064449, 10551.528245194],
                        [3.433e-08, 0.20933510815, 6604.958782124],
                        [2.513e-08, 2.88151502604, 17924.9106998204],
                        [2.683e-08, 3.68680362407, 3603.6963500726],
                        [2.696e-08, 2.6693177673, 10184.3039162316],
                        [2.386e-08, 1.05710815775, 3607.2194684216],
                        [2.444e-08, 3.46901444423, 6298.3283211764],
                        [2.566e-08, 5.55941956468, 6546.1597733642],
                        [2.354e-08, 0.8589678994, 3351.2490920496],
                        [2.304e-08, 6.0721098579, 1214.7350193206],
                        [2.387e-08, 4.30419979225, 3360.96774609859],
                        [3.109e-08, 2.18099805904, 16173.3711684044],
                        [2.907e-08, 3.43894993113, 2693.601593385],
                        [2.55e-08, 4.18354174372, 3546.797975137],
                        [2.991e-08, 2.37500894603, 13517.8701062334],
                        [2.508e-08, 5.99249607455, 5729.506447149],
                        [2.202e-08, 5.58486973955, 664.75604513],
                        [2.467e-08, 2.81052575497, 15110.4661198662],
                        [2.154e-08, 3.59696831702, 6677.6344247478],
                        [2.166e-08, 3.35965682842, 589.0648270082],
                        [2.112e-08, 4.57048853017, 6127.6554505572],
                        [2.178e-08, 3.21663279493, 20199.094959633],
                        [2.26e-08, 3.62776666288, 7799.9806455024],
                        [2.703e-08, 5.89441421026, 6438.4962494256],
                        [2.201e-08, 4.69972051344, 17277.4069318338],
                        [2.131e-08, 2.5180126434, 1545.3539829788],
                        [2.093e-08, 4.0368841963, 6684.8152820514],
                        [2.249e-08, 5.26171743929, 5618.3198048614],
                        [2.117e-08, 4.80404492675, 3657.0042963564],
                        [2.265e-08, 3.87401620754, 110.2063212194],
                        [2.521e-08, 4.21237950687, 2494.5295919486],
                        [2.492e-08, 6.10452779411, 3329.97576135],
                        [2.154e-08, 4.59093274516, 5625.3660415594],
                        [1.929e-08, 1.21920197307, 21.8508293264],
                        [2.343e-08, 0.90613584736, 227.476132789],
                        [1.871e-08, 2.0370739008, 56.8983749356],
                        [1.894e-08, 4.12432529517, 3399.9862886134],
                        [2.271e-08, 3.78951734652, 7910.1869667218],
                        [1.876e-08, 3.0203488708, 4885.9664096786],
                        [2.145e-08, 4.74972617629, 18984.2926300096],
                        [2.035e-08, 2.75110234296, 128.0188433374],
                        [1.77e-08, 2.73496011079, 6606.4432548323],
                        [1.733e-08, 1.70571779606, 6.6836638741],
                        [1.743e-08, 2.22986352012, 17085.9586657222],
                        [1.723e-08, 1.98207274526, 735.8765135318],
                        [1.814e-08, 0.92405242552, 4555.3474460204],
                        [1.661e-08, 3.07319305915, 1692.1656695024],
                        [2.332e-08, 5.05223613332, 20618.0193585336],
                        [1.653e-08, 3.86316179052, 699.2711482276],
                        [1.89e-08, 4.14080522607, 5459.3762870782],
                        [1.68e-08, 3.49750704538, 3347.6586633978],
                        [1.909e-08, 2.11478314309, 6816.289933435],
                        [1.918e-08, 3.31232891649, 3333.5661900018],
                        [1.707e-08, 4.88386665097, 3407.0998356142],
                        [1.577e-08, 3.5177713158, 13362.432453147],
                        [1.827e-08, 1.14937084769, 2807.3983432562],
                        [2.094e-08, 1.78938870686, 20597.2439630412],
                        [1.577e-08, 5.54854302324, 13362.4669604514],
                        [1.677e-08, 4.39073937265, 8270.2977486834],
                        [1.561e-08, 0.8024690473, 3017.1070100424],
                        [1.552e-08, 2.66876850182, 3024.2205570432],
                        [1.708e-08, 2.09721350898, 2814.4445799542],
                        [2.109e-08, 1.48733908496, 2679.3794999188],
                        [1.547e-08, 2.12956399169, 661.232926781],
                        [1.764e-08, 5.90517079295, 3326.3853326982],
                        [1.503e-08, 4.3438918317, 13936.794505134],
                        [1.504e-08, 0.83367652471, 4775.7600884592],
                        [1.543e-08, 5.82417982389, 3344.4937620578],
                        [1.458e-08, 1.42630589706, 15508.6151232744],
                        [1.648e-08, 2.88801518612, 8273.8208670324],
                        [1.527e-08, 1.10261249454, 2675.8563815698],
                        [1.8e-08, 5.17144672709, 38.1330356378],
                        [1.439e-08, 0.48751113425, 76.2660712756],
                        [1.478e-08, 4.63008666184, 19800.9459562248],
                        [1.77e-08, 2.18315009072, 2301.58581590939],
                        [1.712e-08, 2.60291779744, 29.429508536],
                        [1.416e-08, 2.46912016889, 2597.6223661672],
                        [1.835e-08, 3.93223068469, 6843.6914895318],
                        [1.437e-08, 3.48241890037, 3281.2385647862],
                        [1.385e-08, 4.18004525683, 2284.7536148596],
                        [1.479e-08, 3.88994194685, 6034.2140200848],
                        [1.469e-08, 2.91808856545, 12722.5524204852],
                        [1.824e-08, 3.94139541752, 18454.601664915],
                        [1.368e-08, 1.71899681607, 13760.5987102074],
                        [1.406e-08, 2.42916192473, 853.196381752],
                        [1.361e-08, 4.69126219798, 11081.2192102886],
                        [1.375e-08, 4.90787845983, 3304.5845600224],
                        [1.544e-08, 3.23251603238, 156.4007205024],
                        [1.543e-08, 1.13497136095, 3336.7310913418],
                        [1.385e-08, 2.90281983822, 1581.959348283],
                        [1.311e-08, 6.21748423079, 2547.8375382324],
                        [1.377e-08, 2.56537541792, 568.8218740274],
                        [1.474e-08, 4.65215247212, 394.6258850592],
                        [1.619e-08, 0.07481583409, 1435.1476617594],
                        [1.369e-08, 0.08979359617, 7895.9598727202],
                        [1.272e-08, 5.84659079053, 21.335640467],
                        [1.331e-08, 3.80007277718, 13119.7211028252],
                        [1.202e-08, 5.90681878458, 187.9251477626],
                        [1.284e-08, 5.30205682052, 6571.0185321802],
                        [1.468e-08, 5.91503888421, 3339.1279539915],
                        [1.497e-08, 2.57629850836, 151.8972810852],
                        [1.27e-08, 4.089962414, 4356.275444584],
                        [1.159e-08, 0.00546309207, 799.8211251654],
                        [1.154e-08, 1.81024985603, 158.9435177832],
                        [1.17e-08, 4.15567553953, 14.2270940016],
                        [1.349e-08, 0.39391022745, 2540.7913015344],
                        [1.403e-08, 4.89956428847, 4039.8835749274],
                        [1.188e-08, 3.46422365287, 1015.6630178842],
                        [1.136e-08, 5.54132891775, 13553.8979729108],
                        [1.282e-08, 4.5228842134, 3929.677253708],
                        [1.124e-08, 1.40102701439, 13149.1506113612],
                        [1.254e-08, 3.84775964741, 3980.5097130138],
                        [1.121e-08, 5.04552583589, 23141.5583829246],
                        [1.088e-08, 0.89388884633, 3340.19235060619],
                        [1.476e-08, 4.20852908107, 16460.333529525],
                        [1.084e-08, 5.70551481838, 3760.097070575],
                        [1.197e-08, 1.24543578245, 26724.8994135984],
                        [1.253e-08, 5.82286965998, 3344.5445799629],
                        [1.078e-08, 6.24742453183, 17.812522118],
                        [1.462e-08, 2.27467510211, 369.6998159404],
                        [1.044e-08, 4.34158344243, 2277.7073781616],
                        [1.099e-08, 4.08747611117, 802.3639224462],
                        [1.122e-08, 4.31726854418, 107.6635239386],
                        [1.148e-08, 0.42666214138, 949.1756089698],
                        [1.183e-08, 0.3156003412, 1162.4747044078],
                        [1.13e-08, 3.46061330657, 5732.0492444298],
                        [1.059e-08, 1.34075999078, 2149.6885348242],
                        [1.126e-08, 5.22902222299, 194.9713844606],
                        [9.77e-09, 3.44426658417, 9779.1086761254],
                        [1.134e-08, 0.13507173479, 12566.1516999828],
                        [1.185e-08, 3.65682936623, 6456.8800576977],
                        [9.62e-09, 4.85370284827, 3510.1926098328],
                        [1.033e-08, 2.47380728164, 31.9723058168],
                        [1.172e-08, 1.72927931309, 6923.9534573736],
                        [9.86e-09, 1.05152205629, 16335.8378045366],
                        [1.292e-08, 6.02388659607, 3316.733988952],
                        [9.32e-09, 1.56812178735, 111.1866422876],
                        [1.13e-08, 2.06879370733, 3376.6402933772],
                        [9.24e-09, 0.82106390115, 3364.4908644476],
                        [1.005e-08, 5.48594935121, 11236.57229942],
                        [9.36e-09, 1.58837554752, 10235.1363755374],
                        [1.063e-08, 1.93321644244, 87.30820453981],
                        [9.45e-09, 5.10393817688, 8013.2797409404],
                        [9.57e-09, 4.4142175236, 433.7117378768],
                        [9.21e-09, 1.71021166461, 2067.9314010726],
                        [9.1e-09, 1.91562889347, 401.6721217572],
                        [9.31e-09, 4.61327789373, 5415.6573747732],
                        [1.033e-08, 3.98512631089, 10596.1820784342],
                        [9.08e-09, 5.30549216988, 7107.8230442756],
                        [9.45e-09, 0.21610469082, 9872.2740829648],
                        [9.91e-09, 2.76931703924, 5938.234792867],
                        [9.18e-09, 4.37217510741, 1854.6323056346],
                        [8.89e-09, 1.81025662091, 2409.249339848],
                        [1.058e-08, 3.63303046818, 7255.5696517344],
                        [8.6e-09, 2.78826625605, 5621.8601768626],
                        [8.6e-09, 0.75749461239, 5621.8256695582],
                        [8.5e-09, 3.82228424021, 272.6729573516],
                        [8.51e-09, 0.25287875945, 11766.2632645146],
                        [8.53e-09, 1.84243320985, 2142.6422981262],
                        [1.03e-08, 0.42255009123, 1596.1864422846],
                        [8.26e-09, 1.26069501589, 20206.141196331],
                        [8.35e-09, 4.64394754967, 127.9515330346],
                        [1.046e-08, 3.50232998647, 9866.4168806652],
                        [8.24e-09, 2.42928138519, 11.0457002639],
                        [1.09e-08, 6.06536924506, 3341.0325027934],
                        [8.08e-09, 1.17345081945, 6460.8122109608],
                        [8.21e-09, 0.19617131185, 22743.4093795164],
                        [8.04e-09, 5.03144428114, 2.5427972808],
                        [1.074e-08, 2.80025232939, 3077.528503327],
                        [7.94e-09, 4.57067003887, 5223.6939198022],
                        [8.22e-09, 0.90150471199, 8646.0634802536],
                        [8.84e-09, 1.71007411939, 3.9321532631],
                        [8.5e-09, 1.24977903471, 12295.9542296092],
                        [9.26e-09, 3.02847055739, 3377.217792004],
                        [7.79e-09, 1.97930055918, 5408.5438277724],
                        [9.6e-09, 6.16414205869, 8542.970706035],
                        [7.85e-09, 4.63077378309, 3341.0423098265],
                        [7.52e-09, 3.51125131831, 10020.8569590312],
                        [7.49e-09, 2.5028675102, 2295.4575905122],
                        [8.01e-09, 4.54004277501, 1039.0266107904],
                        [7.35e-09, 3.91703254169, 12310.1813236108],
                        [7.84e-09, 3.24368310213, 3384.3313390048],
                        [7.19e-09, 3.35536995801, 11780.4903585162],
                        [9.4e-09, 3.589745616, 23539.7073863328],
                        [8.65e-09, 1.12444569157, 206.7007372966],
                        [7.31e-09, 5.61232905415, 16062.1845261168],
                        [8.23e-09, 2.65316808033, 3169.9395560806],
                        [9.03e-09, 4.86743346013, 931.3630868518],
                        [7.05e-09, 1.4630539462, 792.7748884674],
                        [7.54e-09, 2.89691411536, 3296.8935143948],
                        [7.36e-09, 2.21038016464, 146.8116865236],
                        [7.85e-09, 2.32844966721, 3340.1825435731],
                        [6.85e-09, 2.34948834397, 1.1806426521],
                        [6.77e-09, 4.3380350705, 3877.4169387952],
                        [7.29e-09, 3.56726385957, 485.9720527896],
                        [6.68e-09, 5.16798891078, 12721.572099417],
                        [7.13e-09, 4.80558699772, 4142.976349146],
                        [8.42e-09, 1.59708732155, 16304.9131300908],
                        [6.98e-09, 1.91829605833, 6665.9723822146],
                        [6.98e-09, 4.64681188157, 11216.284290324],
                        [6.84e-09, 3.88514563357, 846.0828347512],
                        [6.66e-09, 2.23927960017, 20735.8321614256],
                        [6.38e-09, 2.05380863176, 16699.53901515],
                        [7.26e-09, 5.04566216294, 3329.5667264359],
                        [6.97e-09, 0.30680314664, 19676.4502312364],
                        [6.5e-09, 3.23944472757, 9588.1255422226],
                        [7.36e-09, 2.24443728739, 11250.7993934216],
                        [6.92e-09, 1.76465916332, 51.28033786241],
                        [6.45e-09, 0.07661067442, 52.2603149128],
                        [6.85e-09, 2.72118140264, 6643.0918177618],
                        [6.84e-09, 1.26157751115, 142.1786270362],
                        [6.35e-09, 3.85231847116, 6.0659156298],
                        [8.19e-09, 6.04967230806, 19402.7969528166],
                        [6.64e-09, 3.6022393001, 1903.4368125012],
                        [6.13e-09, 4.96450118774, 8859.3625756916],
                        [6.15e-09, 5.7446741784, 6696.4773245846],
                        [6.22e-09, 1.64154132852, 24150.080051345],
                        [6.59e-09, 0.12506816965, 8116.372515159],
                        [6.79e-09, 1.94943016061, 12995.2253778368],
                        [6.16e-09, 4.94607504516, 9485.032768004],
                        [7.93e-09, 2.84922599989, 29.4918183034],
                        [5.97e-09, 5.72067567055, 3113.1362939108],
                        [7.63e-09, 0.42513533173, 3873.8265101434],
                        [5.87e-09, 1.31684217558, 9499.2598620056],
                        [5.92e-09, 4.34796024028, 3826.5844794894],
                        [6.52e-09, 5.53658742492, 9065.5481241288],
                        [5.83e-09, 0.59190068342, 26084.0218062162],
                        [6.03e-09, 0.7713556663, 3342.0968994081],
                        [7.01e-09, 3.35897774328, 6709.6740408674],
                        [5.74e-09, 1.08976979801, 6357.7194367422],
                        [7.5e-09, 4.84737198179, 10022.8176011676],
                        [5.88e-09, 5.65927128604, 2171.0241752912],
                        [6.32e-09, 3.84852695407, 16276.463942623],
                        [6.32e-09, 1.43230388645, 16706.585251848],
                        [7.8e-09, 1.1518150254, 377.3736079158],
                        [5.54e-09, 4.18192049239, 382.879278571],
                        [5.68e-09, 0.03816333919, 6414.6178116778],
                        [5.69e-09, 2.57704345512, 35.5627344686],
                        [5.66e-09, 0.62804830762, 3189.5647568569],
                        [6.87e-09, 5.61456944029, 155.3530891314],
                        [5.63e-09, 2.57358138188, 19406.6782881746],
                        [6.93e-09, 1.15645091892, 966.9708774356],
                        [5.76e-09, 1.60357663736, 3192.5337022735],
                        [6.21e-09, 2.23214771591, 3274.1250177854],
                        [5.86e-09, 6.17266280012, 9602.3526362242],
                        [5.41e-09, 0.53968808391, 13171.0014406876],
                        [5.7e-09, 3.11852290115, 2221.856634597],
                        [5.42e-09, 0.41889651002, 1641.3332101966],
                        [5.32e-09, 0.16606105669, 5511.636601991],
                        [5.3e-09, 3.78205188174, 7270.2896804078],
                        [5.75e-09, 5.48929613719, 2075.0449480734],
                        [6.7e-09, 3.67090656417, 6475.0393049624],
                        [5.09e-09, 4.21526585284, 7380.4960016272],
                        [5.1e-09, 1.59587338243, 13362.3823964964],
                        [4.94e-09, 2.1371159806, 2604.735913168],
                        [5.34e-09, 1.03109772656, 1478.8665740644],
                        [5.06e-09, 5.92145494356, 685.044054226],
                        [4.69e-09, 0.83917541691, 3041.4860324306],
                        [4.68e-09, 1.97135671591, 2412.772458197],
                        [4.68e-09, 4.57635781664, 11670.2840372968],
                        [5.59e-09, 1.47641018288, 8671.9698704406],
                        [4.75e-09, 2.07517976424, 5835.1420186484],
                        [4.66e-09, 2.92801596791, 2277.2983432475],
                        [4.78e-09, 6.13550464878, 4825.544916394],
                        [5.02e-09, 0.77928275348, 4407.1079038898],
                        [4.62e-09, 3.80503324215, 11140.5930722022],
                        [4.99e-09, 3.25557381873, 1744.493294718],
                        [5.25e-09, 0.74022979976, 1265.5674786264],
                        [5.21e-09, 6.27577138682, 3981.490034082],
                        [4.82e-09, 0.1482033753, 14158.7477136156],
                        [4.6e-09, 2.03348517376, 25685.872802808],
                        [5.1e-09, 4.27704405425, 3472.1543883862],
                        [4.44e-09, 1.95486223268, 3226.2133197864],
                        [5.75e-09, 0.59007504383, 2766.267628365],
                        [4.37e-09, 5.63861950911, 8958.9322315612],
                        [4.92e-09, 6.10071747922, 2285.1626497737],
                        [5.72e-09, 5.10308842466, 8564.306346502],
                        [4.3e-09, 4.12851356192, 13.241772398],
                        [5.44e-09, 4.78254843814, 9380.9596727172],
                        [4.3e-09, 3.83861916944, 1765.7666254176],
                        [4.99e-09, 4.26055736809, 6652.7756659318],
                        [5.41e-09, 0.84245625839, 4981.9456368964],
                        [5.91e-09, 2.01874828234, 27490.6924780448],
                        [4.38e-09, 1.36437546581, 12509.2533250472],
                        [4.7e-09, 4.70961176845, 3723.4917052708],
                        [4.21e-09, 1.76100140625, 956.2891559706],
                        [4.13e-09, 0.49206034039, 13355.3361597984],
                        [4.12e-09, 0.29353415123, 2810.9387152574],
                        [4.12e-09, 3.2486541775, 18451.078546566],
                        [4.12e-09, 1.70721395764, 7314.0085927128],
                        [4.12e-09, 4.54594776716, 2810.904207953],
                        [4.48e-09, 3.04254429984, 5636.070017212],
                        [5.1e-09, 1.18739936388, 13362.517017102],
                        [4.08e-09, 1.32068176489, 20809.4676246452],
                        [4.27e-09, 1.1610074204, 19004.6479494084],
                        [4.2e-09, 3.49180180953, 1655.5603041982],
                        [4.33e-09, 0.55429134487, 9945.5712088238],
                        [4.24e-09, 4.60854671688, 6518.7582172674],
                        [4.15e-09, 5.67120343816, 99.5696558696],
                        [4.76e-09, 5.94537443289, 48835.1938564486],
                        [4.05e-09, 5.63206200287, 3450.8187479192],
                        [4.95e-09, 4.38317490235, 2480.302497947],
                        [4.15e-09, 3.61905205961, 2089.782230399],
                        [3.95e-09, 0.25208772249, 1375.7737998458],
                        [4.21e-09, 2.26337694295, 13892.1406718938],
                        [3.91e-09, 5.25566087245, 10042.6126755918],
                        [5.04e-09, 4.91016850189, 8965.9784682592],
                        [4.17e-09, 3.45088934666, 279.7865043524],
                        [3.89e-09, 0.98703891513, 7203.8022714934],
                        [4.31e-09, 2.11881719623, 56.8032621698],
                        [4.97e-09, 1.63121523594, 22345.2603761082],
                        [3.77e-09, 4.06263841184, 10124.930054318],
                        [3.77e-09, 3.16019395941, 224.3447957019],
                        [3.78e-09, 5.82532048605, 6675.7019290922],
                        [3.77e-09, 0.05833226835, 905.4566966648],
                        [4.45e-09, 0.33560120738, 515.463871093],
                        [4.26e-09, 2.66458973231, 4076.4889402316],
                        [4.89e-09, 0.75760372851, 3561.0250691386],
                        [3.89e-09, 0.5028382658, 2825.1485556068],
                        [3.96e-09, 5.14198726837, 5195.2447323344],
                        [4.14e-09, 3.12530321804, 10001.061884607],
                        [5.02e-09, 5.02356488339, 73.297125859],
                        [4.32e-09, 3.3153835914, 5617.9107699473],
                        [3.59e-09, 4.97622870666, 5820.9149246468],
                        [3.59e-09, 5.420722273, 6019.9919266186],
                        [4.49e-09, 3.79544854612, 4996.172730898],
                        [3.74e-09, 2.85563965649, 2111.6503133776],
                        [4.26e-09, 0.24129917209, 5625.7750764735],
                        [4.23e-09, 3.60507971235, 8226.5788363784],
                        [4.02e-09, 4.5181371951, 4392.8808098882],
                        [3.91e-09, 4.26714089799, 21795.2140916148],
                        [4.47e-09, 4.25776540974, 18052.9295431578],
                        [3.55e-09, 4.17584780659, 6740.5987153132],
                        [3.53e-09, 1.81574804066, 6686.747777707],
                        [4.62e-09, 3.22304237134, 2011.1003364398],
                        [3.41e-09, 3.22071023668, 4253.1826703654],
                        [4.75e-09, 4.28822688035, 367.2243289624],
                        [4.62e-09, 2.91312544527, 418.9243989006],
                        [4.16e-09, 4.83203726375, 8535.8571590342],
                        [4.31e-09, 3.22440150226, 21265.5231265202],
                        [3.33e-09, 3.99300815003, 1353.3905280078],
                        [3.4e-09, 0.71636465254, 15664.0355227086],
                        [4.16e-09, 2.58443168474, 5753.3848848968],
                        [3.56e-09, 2.35639379021, 4.57074972],
                        [3.3e-09, 4.04831945983, 3.1030422554],
                        [3.81e-09, 4.06283076724, 1062.9050485382],
                        [4.31e-09, 5.42246026973, 26482.1708096244],
                        [3.28e-09, 4.0627695455, 6944.3087767724],
                        [3.34e-09, 5.10221163477, 22324.9050567094],
                        [4e-09, 2.28211698182, 3209.0704650134],
                        [4.2e-09, 2.44159662565, 6155.057006654],
                        [3.75e-09, 1.09229714548, 4246.0691233646],
                        [4.49e-09, 4.38183542571, 5106.3790521174],
                        [3.3e-09, 2.55172725319, 19513.9835951042],
                        [3.19e-09, 4.05704496382, 5430.3946570988],
                        [3.1e-09, 4.99907184482, 5095.6750764648],
                        [3.44e-09, 0.6269183218, 9389.0535407862],
                        [3.19e-09, 3.31673970253, 596.178374009],
                        [3.05e-09, 4.6694291091, 6756.0064519669],
                        [4.09e-09, 6.07568936266, 50.8324593058],
                        [3.77e-09, 5.42211267415, 1190.9238918756],
                        [3.42e-09, 2.67821304845, 6148.010769956],
                        [2.98e-09, 5.91093444215, 9886.772200064],
                        [2.99e-09, 5.44077050156, 10028.9508271002],
                        [3.15e-09, 1.03304445564, 3490.1756238344],
                        [3.69e-09, 3.93279262125, 1879.5583747534],
                        [3.04e-09, 4.56372485787, 7483.5887758458],
                        [3.3e-09, 3.29725079066, 286.9623611206],
                        [2.9e-09, 3.4385002402, 6418.1409300268],
                        [2.89e-09, 2.827660453, 3171.0322435668],
                        [3.17e-09, 4.13345374602, 1883.0814931024],
                        [2.94e-09, 0.0190673259, 202.2533951741],
                        [3.1e-09, 4.37565854379, 2796.6943676036],
                        [3.64e-09, 0.54935210242, 290.4854794696],
                        [2.91e-09, 2.39413982848, 29026.4852295078],
                        [2.86e-09, 5.76562894312, 5642.1982426092],
                        [3.92e-09, 3.01171327788, 10721.108428327],
                        [3.18e-09, 4.93376925851, 1197.9701285736],
                        [3.15e-09, 2.844378401, 10610.9021071076],
                        [2.99e-09, 1.18299169304, 550.0462844934],
                        [3.36e-09, 4.3076981876, 5989.0672521728],
                        [3.15e-09, 1.4140786334, 6947.8318951214],
                        [2.94e-09, 6.16453752963, 8982.810669309],
                        [2.85e-09, 2.82644088669, 9654.612951137],
                        [2.81e-09, 0.27739627997, 8166.1573430938],
                        [2.79e-09, 4.08648927643, 5355.2358814886],
                        [3.3e-09, 3.11968019451, 41.5507909848],
                        [2.75e-09, 5.89019272334, 3337.8609160888],
                        [2.75e-09, 4.00268079937, 3620.3989310522],
                        [2.92e-09, 3.06830662617, 4.3620363898],
                        [3.17e-09, 0.01919037405, 2267.003402509],
                        [2.72e-09, 1.70373580224, 3742.284548457],
                        [2.94e-09, 0.16019381973, 6670.5881880498],
                        [2.64e-09, 2.07967576148, 3735.238311759],
                        [2.62e-09, 4.49437120405, 6887.4104018368],
                        [3.07e-09, 3.03375977801, 6660.8695340008],
                        [2.8e-09, 0.47728086796, 5401.4302807716],
                        [2.68e-09, 0.46331887242, 6578.132079181],
                        [3.12e-09, 3.62016422039, 255.970376372],
                        [2.78e-09, 5.62032972822, 3378.7454623376],
                        [2.68e-09, 2.97528422526, 21947.1113727],
                        [3.03e-09, 2.71946492092, 3313.210870603],
                        [2.63e-09, 3.85883671333, 28628.3362260996],
                        [2.57e-09, 0.25607724431, 19146.7592661418],
                        [2.82e-09, 2.29169514758, 2008.557539159],
                        [3.01e-09, 0.83275594655, 2806.9893083421],
                        [2.64e-09, 3.78635346388, 3936.7908007088],
                        [2.54e-09, 1.28062508539, 95.9792272178],
                        [2.5e-09, 5.5849385856, 412.3710968744],
                        [2.84e-09, 4.71065509252, 5621.9102335132],
                        [2.86e-09, 5.1185436619, 5621.7756129076],
                        [2.54e-09, 5.77068701321, 5813.291189322],
                        [3.11e-09, 2.67573060947, 912.5702436656],
                        [2.52e-09, 4.19548440341, 24.858758816],
                        [2.55e-09, 1.80023727978, 3193.8007401762],
                        [2.47e-09, 2.94199704738, 310.8407988684],
                        [2.61e-09, 5.68285399692, 3133.9116894032],
                        [2.55e-09, 4.46589323429, 5490.300961524],
                        [2.47e-09, 2.28207487665, 246.251722323],
                        [2.57e-09, 5.64335704456, 10706.8813343254],
                        [2.46e-09, 0.26910281348, 22.7684966094],
                        [2.41e-09, 0.03931394254, 9070.1188738488],
                        [2.83e-09, 1.30585259585, 4025.6564809258],
                        [2.72e-09, 1.28327911416, 1442.2612087602],
                        [2.94e-09, 4.02082336381, 2814.8536148683],
                        [2.49e-09, 4.92144829429, 31022.7531708562],
                        [2.37e-09, 3.07683243726, 9947.0556815321],
                        [2.36e-09, 6.0576638036, 948.1952879016],
                        [3.09e-09, 3.45153658664, 25287.7237993998],
                        [2.32e-09, 4.99538565545, 1505.28780909299],
                        [2.75e-09, 1.20294105507, 6691.8615187494],
                        [3.05e-09, 2.73902403412, 176.6937301338],
                        [2.31e-09, 5.13610567818, 6997.6167230562],
                        [2.37e-09, 0.90339496046, 8.093868069],
                        [2.29e-09, 0.6325004797, 23017.0626579362],
                        [2.49e-09, 6.05357589804, 2060.8178540718],
                        [2.7e-09, 2.14769161882, 2973.3880977374],
                        [2.41e-09, 4.63019900075, 1612.9513330316],
                        [2.27e-09, 5.94537053649, 2942.4806769438],
                        [2.69e-09, 5.93687481153, 4005.3684718298],
                        [2.27e-09, 3.91459879933, 2942.4461696394],
                        [2.38e-09, 5.14570745178, 721.1392312062],
                        [2.75e-09, 1.06902528739, 3343.3639373108],
                        [2.32e-09, 3.5211029051, 6674.1786167016],
                        [2.77e-09, 0.19619249083, 270.1974703736],
                        [2.74e-09, 0.30235979008, 5607.6158292088],
                        [2.33e-09, 5.75237138576, 604.8497407048],
                        [2.14e-09, 3.38626276995, 647.0108333148],
                        [2.82e-09, 0.29694635625, 12323.4230960088],
                        [2.82e-09, 3.18114716742, 6364.832983743],
                        [2.64e-09, 4.64751563064, 1346.3442913098],
                        [2.8e-09, 4.64995184564, 6701.5801727984],
                        [2.46e-09, 3.03036675631, 3304.0070613956],
                        [2.13e-09, 4.80555095681, 8830.9133882238],
                        [2.2e-09, 1.54642908481, 23546.7536230308],
                        [2.14e-09, 1.35475764936, 184.8499079702],
                        [2.28e-09, 4.29420876593, 2970.9126107594],
                        [2.29e-09, 2.53361265404, 3710.3122426402],
                        [2.73e-09, 1.89943168433, 270.1301600708],
                        [2.84e-09, 3.28345980607, 16063.164847185],
                        [2.11e-09, 5.84341192825, 1971.9521738548],
                        [2.14e-09, 0.22905754741, 5.1991911658],
                        [2.46e-09, 4.55971876123, 6040.3472460174],
                        [2.29e-09, 1.24432891752, 3568.0885594888],
                        [2.16e-09, 3.2009868012, 362.1211367308],
                        [2.01e-09, 2.45025935972, 20426.571092422],
                        [2.23e-09, 2.07804482295, 17101.2111369072],
                        [2.71e-09, 3.49210901141, 3436.5916539176],
                        [2.26e-09, 0.42945734871, 557.0925211914],
                        [2.64e-09, 5.0579494007, 2938.9403049426],
                        [2.07e-09, 6.03491870748, 22487.3716928416],
                        [1.97e-09, 5.62923956977, 5209.471826336],
                        [2.11e-09, 2.26445749553, 765.7930644464],
                        [2.02e-09, 0.88670673933, 767.8488193486],
                        [2.12e-09, 1.85965510753, 4782.87363546],
                        [1.94e-09, 4.77420671032, 6850.8050365326],
                        [1.92e-09, 0.51565572072, 323.5054166574],
                        [2.09e-09, 4.79794980231, 14047.4937610252],
                        [1.93e-09, 2.56057288512, 18606.4989460002],
                        [2.09e-09, 1.46088434217, 5.8572022996],
                        [2.14e-09, 0.97578687412, 17468.8551979454],
                        [1.96e-09, 4.08789826861, 3262.8618827159],
                        [1.98e-09, 3.9911121623, 10018.2468514476],
                        [2.35e-09, 1.11133081576, 625.6701923124],
                        [1.97e-09, 0.48692287381, 15106.8756912144],
                        [2.14e-09, 5.33581901309, 955.2415245996],
                        [1.99e-09, 0.40088144456, 7586.6815500644],
                        [2.51e-09, 5.57906426342, 138.5881983844],
                        [2.08e-09, 4.11480858445, 1755.062649765],
                        [2.1e-09, 2.30499661227, 53.3079462838],
                        [2.53e-09, 1.27099771143, 309.2783226558],
                        [2.42e-09, 3.71426781511, 3212.5935833624],
                        [1.78e-09, 3.06961783443, 1437.1756141986],
                        [2.03e-09, 0.28410501881, 582.9989113784],
                        [1.9e-09, 0.10457198807, 26087.9031415742],
                        [1.78e-09, 0.53068485806, 7366.2689076256],
                        [2.45e-09, 4.20195166994, 8436.2875031646],
                        [1.76e-09, 3.66697456425, 6688.2710900976],
                        [1.77e-09, 4.48104044431, 8799.988713778],
                        [1.81e-09, 3.57461078885, 15121.102785216],
                        [1.98e-09, 3.55065962909, 24606.13555322],
                        [1.87e-09, 3.45440079747, 1329.51209026],
                        [1.76e-09, 5.81532365473, 12406.1605508286],
                        [2.35e-09, 1.28568802052, 4427.3959129858],
                        [1.79e-09, 1.55718466444, 3362.4632560262],
                        [1.74e-09, 1.61086801253, 30065.5118402982],
                        [1.99e-09, 0.07164714815, 375.7657315702],
                        [1.74e-09, 4.58412775793, 3283.7140517642],
                        [1.71e-09, 5.82189798695, 23937.856389741],
                        [1.82e-09, 2.57146189845, 418.504322807],
                        [1.68e-09, 5.13131619552, 21393.5419698576],
                        [1.83e-09, 4.9316196205, 9468.267877257],
                        [1.67e-09, 1.48091400654, 2619.4731954936],
                        [1.69e-09, 5.12437031125, 3223.2925584796],
                        [1.88e-09, 3.41823914376, 5032.7780962022],
                        [1.81e-09, 0.50010974122, 2125.8774073792],
                        [1.64e-09, 1.71077130702, 15849.865751747],
                        [2.02e-09, 6.21085922593, 3909.4343007272],
                        [1.71e-09, 5.86158194602, 625.6251361972],
                        [1.65e-09, 3.8556911822, 13207.029307365],
                        [1.63e-09, 2.0437336743, 3347.2960905739],
                        [1.6e-09, 2.83784244321, 5888.4499649322],
                        [2.12e-09, 2.32801112252, 3232.9489027612],
                        [1.63e-09, 4.23488695195, 31968.9486527994],
                        [1.59e-09, 1.48046671186, 249.9044607422],
                        [1.6e-09, 0.21960307161, 12942.965062924],
                        [2.2e-09, 3.90787704883, 9638.9407478762],
                        [1.61e-09, 2.94093367568, 3370.0419352358],
                        [1.59e-09, 5.59017475732, 1442.2784624124],
                        [2.21e-09, 3.82548751198, 1954.7171503636],
                        [1.92e-09, 4.62595272276, 3336.6802734367],
                        [1.64e-09, 1.59200641542, 386.4196505722],
                        [1.69e-09, 5.45784867095, 259.5608050238],
                        [2.01e-09, 0.95077053594, 29424.634232916],
                        [1.74e-09, 1.15216485688, 6382.0984591304],
                        [1.63e-09, 1.16606667991, 4289.7880356696],
                        [1.87e-09, 3.2213595646, 2751.5475996916],
                        [1.62e-09, 4.79372588575, 24889.5747959916],
                        [1.92e-09, 0.88040946364, 5244.049239201],
                        [1.6e-09, 2.8503478437, 9374.8264467846],
                        [1.72e-09, 2.38601254063, 2281.2477501628],
                        [2.02e-09, 4.12164786769, 7321.1221397136],
                        [1.56e-09, 4.55171204694, 27682.1407441564],
                        [1.7e-09, 4.62851491273, 10824.2012025456],
                        [1.57e-09, 0.91363725609, 4503.0871311076],
                        [1.56e-09, 5.58255618318, 10448.4354709754],
                        [1.57e-09, 0.92229160815, 15636.566656309],
                        [1.71e-09, 5.43820628341, 11904.9187732018],
                        [1.8e-09, 1.89091405241, 13575.7488022372],
                        [1.98e-09, 4.42539692212, 10025.4277087512],
                        [1.58e-09, 4.12087914642, 11240.1627280718],
                        [2.11e-09, 2.42218772392, 8749.1562544722],
                        [1.83e-09, 1.47934835951, 6677.3435180416],
                        [1.97e-09, 1.43469282909, 14061.7208550268],
                        [1.7e-09, 4.32424842659, 742.9900605326],
                        [1.7e-09, 2.92905324873, 9093.9973115966],
                        [1.6e-09, 2.79797608932, 1461.0540519464],
                        [1.74e-09, 5.37738922471, 3318.7615973734],
                        [1.72e-09, 0.35524089578, 2281.2132428584],
                        [1.47e-09, 2.76602235522, 4193.8088084518],
                        [1.51e-09, 4.23962231148, 3368.0139827966],
                        [1.57e-09, 1.01295201512, 24336.0053931492],
                        [1.65e-09, 0.58335652806, 15906.7641266826],
                        [1.49e-09, 5.69553079999, 31570.7996493912],
                        [1.54e-09, 5.2850438151, 1481.4093713452],
                        [1.63e-09, 1.8128862851, 18849.2275499742],
                        [1.45e-09, 3.57053080979, 3497.0131472022],
                        [1.56e-09, 3.56978076425, 21791.6909732658],
                        [1.43e-09, 0.56704903096, 13212.8865096646],
                        [1.55e-09, 0.08429188155, 6657.3464156518],
                        [1.84e-09, 2.54999403339, 24076.4445881254],
                        [1.46e-09, 1.16594990123, 526.1678467456],
                        [1.44e-09, 4.19229335185, 2771.7905526724],
                        [1.69e-09, 3.10771037057, 239.205485625],
                        [1.44e-09, 6.26688878164, 6679.7403806913],
                        [1.74e-09, 2.3750902528, 3397.5108016354],
                        [1.63e-09, 3.88047919138, 16703.0448798468],
                        [1.61e-09, 1.73958633312, 2185.2512692928],
                        [1.64e-09, 0.6214699473, 1538.240435978],
                        [1.82e-09, 6.16856014864, 6685.1061887576],
                        [1.4e-09, 4.08200595943, 4186.695261451],
                        [1.92e-09, 4.47709998867, 57.8786960038],
                        [1.51e-09, 3.06451266512, 838.9692877504],
                        [1.39e-09, 1.12767399649, 6682.7093261079],
                        [1.87e-09, 4.97174626997, 6681.6547365263],
                        [1.5e-09, 5.69209290362, 9360.6043533184],
                        [1.6e-09, 5.66336382679, 10927.2939767642],
                        [1.37e-09, 3.46860408347, 5562.4690612968],
                        [1.92e-09, 5.27908098216, 34363.365597556],
                        [1.37e-09, 5.87023088486, 2945.9865416406],
                        [1.8e-09, 1.07686767816, 15806.146839442],
                        [1.35e-09, 0.34109799474, 7322.1024607818],
                        [1.69e-09, 2.2740858315, 379.3734138742],
                        [1.72e-09, 3.83276777655, 6621.850991486],
                        [1.34e-09, 0.8948661109, 13286.1836355236],
                        [1.68e-09, 3.24434245132, 11614.4332937322],
                        [1.35e-09, 6.03727673544, 1214.8023296234],
                        [1.5e-09, 0.81912738038, 3416.8784979754],
                        [1.36e-09, 5.06627117467, 14421.8316369884],
                        [1.38e-09, 5.19336961955, 13363.4300278674],
                        [1.63e-09, 5.91124428824, 16703.0793871512],
                        [1.81e-09, 3.31978654659, 139.6981395228],
                        [1.62e-09, 4.05905033891, 1795.258443721],
                        [1.32e-09, 0.409015061, 1083.260367937],
                        [1.56e-09, 0.1230414464, 1107.1388056848],
                        [1.58e-09, 6.25022915072, 6666.997759398],
                        [1.31e-09, 3.95250083817, 3.4558080462],
                        [1.47e-09, 4.94673462086, 15010.8964639966],
                        [1.4e-09, 6.13853404667, 12729.665967486],
                        [1.31e-09, 5.43398849473, 25665.5174834092],
                        [1.35e-09, 5.06017183369, 11876.469585734],
                        [1.28e-09, 2.8696933273, 6549.6828917132],
                        [1.74e-09, 5.18169887171, 28230.1872226914],
                        [1.79e-09, 3.25589354429, 4922.5717749828],
                        [1.39e-09, 5.33624615245, 23958.6317852334],
                        [1.27e-09, 5.78406495652, 14577.1847261198],
                        [1.28e-09, 1.27276688747, 8584.6616659008],
                        [1.33e-09, 0.39052474466, 12410.7313005486],
                        [1.34e-09, 1.09641189843, 8962.438096258],
                        [1.25e-09, 3.20445201519, 29.8820436102],
                        [1.36e-09, 3.62250122667, 3511.285297319],
                        [1.62e-09, 5.36465149996, 2472.6787626222],
                        [1.5e-09, 0.40179894287, 1111.642245102],
                        [1.29e-09, 1.94909076932, 19645.5255567906],
                        [1.72e-09, 5.21328160366, 6747.712262314],
                        [1.26e-09, 4.39378462616, 21548.9623692918],
                        [1.46e-09, 3.85987749053, 13361.469385731],
                        [1.56e-09, 5.24740844581, 6645.1969867222],
                        [1.37e-09, 4.94588047257, 20995.3929664494],
                        [1.31e-09, 1.72431469184, 11925.2740926006],
                        [1.36e-09, 2.04268940441, 10654.6210194126],
                        [1.4e-09, 1.54439148652, 8219.4652893776],
                        [1.27e-09, 6.16695075115, 10016.314355792],
                        [1.55e-09, 5.47145482987, 2.9689454166],
                        [1.32e-09, 6.25626202928, 13227.3846267638],
                        [1.21e-09, 3.74135485334, 10294.510237451],
                        [1.34e-09, 3.12718351732, 8962.4726035624],
                        [1.22e-09, 0.77282907794, 4936.7988689844],
                        [1.25e-09, 4.23213631052, 15650.7937503106],
                        [1.57e-09, 1.79175545524, 16489.763038061],
                        [1.55e-09, 4.15655698197, 56.3831860762],
                        [1.34e-09, 1.53268827347, 708.98980227659],
                        [1.36e-09, 4.01025697673, 9797.4924843975],
                        [1.56e-09, 4.6155626882, 3354.8395207014],
                        [1.31e-09, 4.47476808853, 11776.8999298644],
                        [1.18e-09, 1.17466010141, 4606.1799053262],
                        [1.28e-09, 0.12648796247, 6681.6449294932],
                        [1.22e-09, 0.1351137794, 8322.5580635962],
                        [1.19e-09, 1.2913911635, 10544.4146981932],
                        [1.28e-09, 4.4496605074, 13465.5424810178],
                        [1.19e-09, 4.0170962999, 14481.205498902],
                        [1.47e-09, 1.8159027965, 685.1113645288],
                        [1.37e-09, 4.78402836071, 3613.2853840514],
                        [1.51e-09, 1.48428558337, 9698.331863442],
                        [1.36e-09, 2.47757608387, 10156.9023601348],
                        [1.23e-09, 2.42353206298, 6.1332259326],
                        [1.17e-09, 5.40635440024, 688.6344828778],
                        [1.53e-09, 5.00372030984, 14556.8967170238],
                        [1.33e-09, 3.15773785434, 1125.8693391036],
                        [1.53e-09, 1.94292660454, 6533.1461289733],
                        [1.24e-09, 4.94608245253, 12825.6451947038],
                        [1.17e-09, 1.13528750738, 4452.2546718018],
                        [1.15e-09, 3.34121813462, 10001.4819607006],
                        [1.15e-09, 3.44586362144, 7696.8878712838],
                        [1.17e-09, 0.72489390402, 27.4688663996],
                        [1.32e-09, 2.41318250916, 6717.252720077],
                        [1.18e-09, 0.35995031424, 27832.0382192832],
                        [1.57e-09, 1.73929012934, 11560.0777160774],
                        [1.48e-09, 2.14023976341, 15265.8865193004],
                        [1.13e-09, 1.29183863745, 26880.3198130326],
                        [1.51e-09, 0.95890610457, 6530.1771835567],
                        [1.53e-09, 5.62679784282, 9911.63095888],
                        [1.57e-09, 0.09791378159, 138.5174968707],
                        [1.19e-09, 2.16883964744, 7082.8969751568],
                        [1.13e-09, 5.43102427558, 422.027441156],
                        [1.3e-09, 2.13493506322, 117.812802892],
                        [1.4e-09, 2.5119459163, 28.9816299794],
                        [1.28e-09, 1.238227512, 6680.804777306],
                        [1.11e-09, 4.60294776614, 25135.8265183146],
                        [1.18e-09, 0.34226497704, 4140.4335518652],
                        [1.12e-09, 4.02233737541, 6314.0005244372],
                        [1.34e-09, 3.3592621473, 11247.2089647698],
                        [1.2e-09, 6.09430372868, 4106.4054911462],
                        [1.17e-09, 0.03006245187, 7.6737919754],
                        [1.09e-09, 3.62630036582, 3344.11829139661],
                        [1.09e-09, 1.94277745743, 16702.9948231962],
                        [1.14e-09, 4.87315937546, 6151.5166346528],
                        [1.09e-09, 5.65707270595, 3344.152798701],
                        [1.08e-09, 0.72637519191, 10.569355047],
                        [1.28e-09, 5.77326416186, 13369.5632538],
                        [1.47e-09, 4.73848506543, 11610.9101753832],
                        [1.45e-09, 4.95495312886, 9859.3706439672],
                        [1.11e-09, 3.28808788953, 257.018007743],
                        [1.12e-09, 4.79777726412, 12140.6011404778],
                        [1.09e-09, 3.73199687068, 13635.1226641508],
                        [1.17e-09, 1.20057736014, 6705.1032911474],
                        [1.49e-09, 4.91688353237, 277.0349937414],
                        [1.08e-09, 3.37299798972, 6717.8302187038],
                        [1.06e-09, 0.53379407701, 5085.1057214178],
                        [1.25e-09, 4.62770076269, 9329.6796788726],
                        [1.07e-09, 4.60288570375, 1957.7250798532],
                        [1.13e-09, 4.04786119569, 6953.8978107512],
                        [1.06e-09, 0.75378922686, 149.8974751268],
                        [1.14e-09, 0.62074562387, 6151.5511419572],
                        [1.08e-09, 5.22204692781, 1556.5681469554],
                        [1.04e-09, 1.02502614223, 4878.8528626778],
                        [1.33e-09, 1.15811543786, 816.6533262152],
                        [1.34e-09, 1.69834857217, 183.869586902],
                        [1.04e-09, 2.58832774275, 14591.4118201214],
                        [1.07e-09, 4.42117075795, 7.130800653],
                        [1.26e-09, 0.03750399181, 16.83220104979],
                        [1.02e-09, 1.20624870972, 11986.6759069534],
                        [1.02e-09, 2.97579561878, 29822.7832363242],
                        [1.16e-09, 4.73049067619, 13366.040135451],
                        [1.3e-09, 4.10484632841, 35.6077905838],
                        [1.13e-09, 3.69200525056, 44.6538332402],
                        [1.11e-09, 5.12900291511, 146.7944328714],
                        [1.26e-09, 1.82187459534, 26887.3660497306],
                        [1.21e-09, 6.08309355316, 7100.7094972748],
                        [1.05e-09, 6.16606590276, 9175.7544453482],
                        [1.32e-09, 2.97955203077, 1250.8301963008],
                        [1.06e-09, 5.08419485009, 8742.0427074714],
                        [1.2e-09, 0.59116561391, 31172.650645983],
                        [1.12e-09, 3.70888430091, 10050.2864675672],
                        [1e-09, 1.82077956276, 12012.5822971404],
                        [1.07e-09, 4.86100312387, 7899.550301372],
                        [9.9e-10, 0.72997085174, 18977.1790830088],
                        [1.07e-09, 5.25025570307, 63.7358983034],
                        [9.9e-10, 2.79139996703, 17932.0242468212],
                        [9.7e-10, 4.94370173613, 28109.214616052],
                        [1.22e-09, 4.18676567644, 19617.0763693228],
                        [1.21e-09, 3.14207351411, 9278.8472195668],
                        [1.12e-09, 1.43537110436, 16232.745030318],
                        [9.6e-10, 2.57929371627, 12715.4388734844],
                        [9.6e-10, 2.51396484677, 3535.5838111604],
                        [1.12e-09, 6.19137312195, 6685.1570066627],
                        [1.09e-09, 1.53428110338, 16703.1294438018],
                        [9.6e-10, 4.29245810274, 7906.59653807],
                        [9.6e-10, 3.08847844641, 3468.6312700372],
                        [9.5e-10, 6.091860847, 10037.0897512844],
                        [9.4e-10, 1.79812841802, 20047.1976785478],
                        [1.1e-09, 4.24859410294, 3337.0720546986],
                        [9.3e-10, 2.17945548408, 16066.0658614748],
                        [1.15e-09, 5.44548079869, 11353.8921676402],
                        [9.8e-10, 1.89605054783, 33406.124266998],
                        [1.01e-09, 3.00793005829, 3528.5375744624],
                        [9.6e-10, 5.4065991242, 5749.8617665478],
                        [1.13e-09, 3.93443805059, 7167.1969061892],
                        [9.2e-10, 3.58985964414, 6724.9437657046],
                        [1.19e-09, 3.9056157026, 11346.7786206394],
                        [9.7e-10, 2.5728079023, 1747.6073781529],
                        [1.18e-09, 3.82111723459, 9072.6616711296],
                        [9.6e-10, 0.72646224606, 3152.68727893721],
                        [9.2e-10, 6.23928508055, 24491.4257925834],
                        [9.9e-10, 1.86991802881, 72.0557333548],
                        [9.4e-10, 1.51091806861, 9801.4246376606],
                        [9.1e-10, 4.94377681711, 8756.269801473],
                        [9.5e-10, 2.58771497236, 11663.170490296],
                        [9.3e-10, 0.6609244332, 30.9919847486],
                        [8.8e-10, 2.47386826588, 17232.7530985936],
                        [1e-09, 0.19616913512, 11883.5831327348],
                        [9.4e-10, 0.61277732908, 73.6354632196],
                        [9.1e-10, 6.04139177526, 153.9252335244],
                        [9.5e-10, 0.30865798871, 29168.5965462412],
                        [1.1e-09, 6.27936643935, 3337.106562003],
                        [8.7e-10, 2.09287965409, 10264.5658840734],
                        [8.9e-10, 3.27633365389, 3002.3697277168],
                        [9.1e-10, 1.89622049447, 37895.4262903674],
                        [1.18e-09, 3.88268323672, 1236.075660323],
                        [9.4e-10, 2.2781906199, 4845.9002357928],
                        [8.5e-10, 3.07438636612, 9983.7042444616],
                        [8.6e-10, 3.94463425808, 16.764890747],
                        [9.9e-10, 4.58890225582, 3774.3241645766],
                        [8.6e-10, 1.27758598252, 34513.2630726828],
                        [1.18e-09, 6.10625309129, 454.9093665273],
                        [9.6e-10, 6.08772700197, 1755.4716846791],
                        [8.5e-10, 4.73193631802, 4576.6880870228],
                        [1.16e-09, 0.88573303872, 16511.6138673874],
                        [8.3e-10, 3.13948373813, 10191.4174632324],
                        [8.3e-10, 0.36972674664, 9755.2302383776],
                        [1.12e-09, 2.26524635842, 10006.5848089144],
                        [8.7e-10, 4.25461508452, 8.1681365824],
                        [8.7e-10, 5.31716927554, 1868.8593996362],
                        [1.15e-09, 3.3050783005, 14157.7000822446],
                        [8.7e-10, 2.90507350729, 36.995590611],
                        [8.3e-10, 3.58400049244, 12928.7379689224],
                        [8.6e-10, 2.46839611271, 113.7294395684],
                        [9.6e-10, 2.99829695985, 6510.5519827804],
                        [8.4e-10, 1.34333260788, 4133.3873151672],
                        [9.3e-10, 2.41895388985, 20040.1514418498],
                        [8.5e-10, 5.92093268818, 12299.544658261],
                        [8.2e-10, 4.71321236549, 7733.493236588],
                        [8.1e-10, 5.26971110105, 12199.9750023914],
                        [8e-10, 4.34410099751, 7218.029365495],
                        [9.5e-10, 0.02613500045, 2.9010142898],
                        [9.4e-10, 6.22018441621, 20043.691813851],
                        [8.5e-10, 4.66573809999, 8638.9499332528],
                        [7.9e-10, 2.89839604813, 22854.596021804],
                        [1.04e-09, 0.94882888784, 2735.762685995],
                        [8e-10, 1.68097745917, 12839.8722887054],
                        [8.5e-10, 1.95515305721, 4686.95671800959],
                        [9.4e-10, 0.58147434179, 14128.2427712456],
                        [9.1e-10, 1.16317999954, 3495.9655158312],
                        [8.4e-10, 4.04104644774, 9815.6517316622],
                        [8.2e-10, 1.83662951627, 19190.4781784468],
                        [8e-10, 4.04733274699, 3188.7151456146],
                        [8.4e-10, 2.71620952175, 12089.768681172],
                        [8e-10, 2.7736315821, 9495.6694333538],
                        [7.8e-10, 5.77285430206, 10397.6030116696],
                        [8.4e-10, 0.78188080031, 7214.4389368432],
                        [9.4e-10, 2.14762315943, 13532.0298899322],
                        [1.01e-09, 5.76349087526, 1484.9324896942],
                        [8.2e-10, 3.11421789241, 8446.9914788172],
                        [9.6e-10, 5.85152670536, 3492.509707785],
                        [7.9e-10, 4.69625309523, 5298.337506553],
                        [9.7e-10, 3.97960395898, 18208.349942592],
                        [1.05e-09, 1.74376904536, 36.6485629295],
                        [9.4e-10, 4.18941238607, 20043.6573065466],
                        [7.5e-10, 3.46629875063, 13341.6743113068],
                        [9.2e-10, 2.67278833288, 6680.7949702729],
                        [7.5e-10, 4.59723160021, 9993.3880926316],
                        [8.7e-10, 0.91979096638, 8425.7181481176],
                        [7.4e-10, 0.42228487063, 48429.2821823244],
                        [7.4e-10, 0.48470953224, 11456.9849418588],
                        [7.7e-10, 0.10707484151, 1371.411763456],
                        [9.3e-10, 1.38010528069, 3145.6410422392],
                        [7.5e-10, 5.2806125707, 12306.590894959],
                        [7.9e-10, 3.7866638604, 7.5786792096],
                        [7.3e-10, 4.42902162523, 14.7372823256],
                        [8.4e-10, 3.41538432898, 6637.5059410946],
                        [9.3e-10, 3.41302342683, 1596.1191319818],
                        [7.1e-10, 3.13537213242, 9488.6231966558],
                        [7.9e-10, 2.33442828498, 12465.5344127422],
                        [7.8e-10, 2.21525134547, 2810.988771908],
                        [9.9e-10, 0.48801369293, 17499.3601403154],
                        [7.5e-10, 4.10299895268, 5525.8636959926],
                        [7.1e-10, 4.04186021414, 259.493494721],
                        [7.3e-10, 2.20102876718, 30774.5016425748],
                        [7.4e-10, 4.93439968296, 13517.8027959306],
                        [7.1e-10, 5.32625652676, 6670.1791531357],
                        [7.8e-10, 2.17664185326, 13421.8235687128],
                        [8.8e-10, 5.38469204503, 17762.4440636882],
                        [8.1e-10, 2.48353174238, 73.6009559152],
                        [9.2e-10, 1.1308844819, 7747.7203305896],
                        [7e-10, 1.16361323015, 5220.1708014532],
                        [8.4e-10, 5.8322038791, 22.3782713026],
                        [7.6e-10, 5.21065604639, 4271.9755135516],
                        [8e-10, 4.01817623627, 3311.18291816379],
                        [6.8e-10, 2.4593769794, 6279.5527316424],
                        [6.7e-10, 4.31723563048, 2281.2978068134],
                        [6.7e-10, 4.88776321797, 4379.6390374902],
                        [6.9e-10, 3.57006764536, 14955.045720432],
                        [7.8e-10, 2.62374773232, 2810.8541513024],
                        [6.7e-10, 4.76301301456, 6812.766815086],
                        [7e-10, 5.60319851277, 13383.2251022916],
                        [7e-10, 3.05647570196, 10081.211142013],
                        [8.1e-10, 4.91537623765, 3333.9287628257],
                        [8.2e-10, 5.4920498711, 5483.254724826],
                        [6.5e-10, 3.50466797067, 9161.5273513466],
                        [6.5e-10, 2.79212460026, 13497.5147868346],
                        [7e-10, 0.93640431668, 6106.8800550648],
                        [7.3e-10, 2.57583496978, 6614.7374444852],
                        [7e-10, 0.8417007058, 16695.9485864982],
                        [6.9e-10, 1.10040627005, 2544.3316735356],
                        [6.3e-10, 6.05841309176, 6453.7487206106],
                        [6.9e-10, 2.67053540192, 2641.3412784722],
                        [8.6e-10, 1.73112264739, 6286.5989683404],
                        [6.2e-10, 5.49002783256, 4957.0868780804],
                        [7.2e-10, 3.38857910283, 3184.2117061974],
                        [6.9e-10, 5.35281990892, 2544.2971662312],
                        [6.4e-10, 4.79175268505, 3181.6689089166],
                        [6e-10, 6.18449904353, 3361.9480671668],
                        [6.5e-10, 1.48236627574, 4819.4790007642],
                        [5.4e-10, 3.66018290396, 2917.5373541728],
                        [6.4e-10, 4.72286914683, 2281.1631862078],
                        [5.3e-10, 4.65521663671, 3448.2759506384],
                        [6e-10, 0.77450276964, 3319.2767862328],
                        [5.1e-10, 1.45142985881, 3547.3131639964],
                        [5.1e-10, 4.81258158513, 4403.517475238],
                        [5e-10, 0.37366902835, 3322.7999045818],
                        [5e-10, 4.68787711774, 3253.30422216],
                        [6.7e-10, 4.63578431535, 4694.0029547076],
                        [4.9e-10, 3.17471347671, 5452.2627400774],
                        [5.1e-10, 2.54791773443, 4001.8453534808],
                        [4.8e-10, 2.81171553464, 3372.5847325166],
                        [5.4e-10, 4.45945188023, 10284.9212034722],
                        [5.3e-10, 3.8513121352, 9758.7533567266],
                        [5.1e-10, 1.11244863072, 6901.6374958384],
                        [6.2e-10, 1.4219800963, 6830.7880505342],
                        [5.5e-10, 5.6167298818, 45494.5814297488],
                        [5.4e-10, 0.61701959453, 4716.3862265456],
                        [5.4e-10, 4.28556326526, 2910.4911174748],
                        [4.5e-10, 3.14626081312, 13951.5145338074],
                        [5e-10, 4.16235480519, 12979.553174576],
                        [4.6e-10, 1.66182208107, 7768.0083396856],
                        [4.5e-10, 5.07701425888, 14951.522602083],
                        [4.3e-10, 4.3172345953, 5881.4037282342],
                        [4.5e-10, 2.39713581676, 8852.2490286908],
                        [4.3e-10, 2.10202660495, 3337.1566186536],
                        [4.8e-10, 0.19934255781, 1905.4647649404],
                        [5.6e-10, 5.25687695855, 12808.8803039568],
                        [4.9e-10, 2.06320966659, 4296.9015826704],
                        [4.2e-10, 6.07282126953, 4295.8539512994],
                        [4.3e-10, 1.7457161378, 3130.8364496108],
                        [5e-10, 2.27112469544, 3427.9206312396],
                        [5e-10, 0.30214747765, 3358.4249488178],
                        [4.3e-10, 5.05297177283, 3229.4257844122],
                        [5.4e-10, 6.11998016428, 16894.5103996106],
                        [4.3e-10, 1.90603004035, 3451.7990689874],
                        [3.9e-10, 0.50727886431, 10011.2006147496],
                        [5.2e-10, 3.17851184154, 2324.9494088156],
                        [3.8e-10, 4.88249540246, 3499.555944483],
                        [3.9e-10, 5.28113083211, 3343.1552239806],
                        [3.9e-10, 4.98185580267, 3468.5639597344],
                        [4.7e-10, 2.16244218985, 10027.3602044068],
                        [3.7e-10, 5.84953090935, 6791.431174619],
                        [4.8e-10, 5.03779546898, 7064.1041319706],
                        [3.8e-10, 0.58076516432, 8966.3875031733],
                        [5.1e-10, 3.36181117037, 8976.6824439118],
                        [4.2e-10, 4.13725767158, 8336.7851575978],
                        [3.8e-10, 5.75425648893, 4531.5363185754],
                        [3.8e-10, 3.55681323215, 5351.7127631396],
                        [4e-10, 2.79414141035, 3067.9394693482],
                        [4e-10, 4.99798468494, 10042.1925994982],
                        [3.7e-10, 1.82286411009, 10017.9559447414],
                        [3.6e-10, 6.02115369796, 6474.524116103],
                        [4.4e-10, 3.01299253859, 7417.1013669314],
                        [4.5e-10, 2.33470159894, 3123.7902129128],
                        [3.9e-10, 4.91767933978, 8034.6153814074],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [3340.85627474342, 0, 0],
                        [0.01458227051, 3.60426053609, 3340.6124266998],
                        [0.00164901343, 3.92631250962, 6681.2248533996],
                        [0.00019963338, 4.2659406103, 10021.8372800994],
                        [3.452399e-05, 4.73210386365, 3.523118349],
                        [2.48548e-05, 4.61277567318, 13362.4497067992],
                        [8.41551e-06, 4.45858256765, 2281.2304965106],
                        [5.37566e-06, 5.01589727492, 398.1490034082],
                        [5.21041e-06, 4.99422678175, 3344.1355450488],
                        [4.32614e-06, 2.5606640286, 191.4482661116],
                        [4.29656e-06, 5.31646162367, 155.4203994342],
                        [3.81747e-06, 3.53881289437, 796.2980068164],
                        [3.14129e-06, 4.96335266049, 16703.062133499],
                        [2.82804e-06, 3.15967518204, 2544.3144198834],
                        [2.05664e-06, 4.5689145566, 2146.1654164752],
                        [1.68805e-06, 1.32894813366, 3337.0893083508],
                        [1.57587e-06, 4.18501035954, 1751.539531416],
                        [1.33686e-06, 2.23325104196, 0.9803210682],
                        [1.16561e-06, 2.21347652545, 1059.3819301892],
                        [1.17591e-06, 6.02407213861, 6151.533888305],
                        [1.13595e-06, 5.42803224317, 3738.761430108],
                        [1.33563e-06, 5.97421903927, 1748.016413067],
                        [9.1098e-07, 1.09627836591, 1349.8674096588],
                        [8.3301e-07, 5.29636626272, 6684.7479717486],
                        [1.13876e-06, 2.12869455089, 1194.4470102246],
                        [8.0776e-07, 4.42813405865, 529.6909650946],
                        [7.9531e-07, 2.2486426633, 8962.4553499102],
                        [7.2505e-07, 5.8420816324, 242.728603974],
                        [7.2946e-07, 2.50189460554, 951.7184062506],
                        [7.1487e-07, 3.85636094435, 2914.0142358238],
                        [8.5342e-07, 3.90854841008, 553.5694028424],
                        [6.7582e-07, 5.02327686473, 382.8965322232],
                        [6.5089e-07, 1.01802439311, 3340.5951730476],
                        [6.5089e-07, 3.04879603978, 3340.629680352],
                        [6.1508e-07, 4.151831598, 3149.1641605882],
                        [4.8477e-07, 4.87362121538, 213.299095438],
                        [4.6584e-07, 1.31452419914, 3185.1920272656],
                        [5.652e-07, 3.8881369932, 4136.9104335162],
                        [4.7613e-07, 1.18238046057, 3333.498879699],
                        [4.1343e-07, 0.71385375517, 1592.5960136328],
                        [4.0055e-07, 5.31611875491, 20043.6745601988],
                        [4.0272e-07, 2.72542480614, 7.1135470008],
                        [3.2886e-07, 5.41067411968, 6283.0758499914],
                        [2.8244e-07, 0.04534124888, 9492.1463150048],
                        [2.2294e-07, 5.88516997273, 3870.3033917944],
                        [2.2431e-07, 5.46592525433, 20.3553193988],
                        [2.2612e-07, 0.83775884934, 3097.88382272579],
                        [2.1418e-07, 5.37934044204, 3340.545116397],
                        [2.3335e-07, 6.16762213077, 3532.0606928114],
                        [2.6579e-07, 3.88960724782, 1221.8485663214],
                        [2.2797e-07, 1.54504711003, 2274.1169495098],
                        [2.0431e-07, 2.36353950189, 1589.0728952838],
                        [2.0186e-07, 3.36375535766, 5088.6288397668],
                        [2.6554e-07, 5.11271747607, 2700.7151403858],
                        [1.9675e-07, 2.57805423988, 12303.06777661],
                        [1.9468e-07, 0.49216434489, 6677.7017350506],
                        [2.1104e-07, 3.52525428062, 15.252471185],
                        [2.1425e-07, 4.97081508139, 3340.6797370026],
                        [1.8505e-07, 5.57863503922, 1990.745017041],
                        [1.7811e-07, 6.12537931996, 4292.3308329504],
                        [1.6472e-07, 2.60291845066, 3341.592747768],
                        [1.6599e-07, 1.25519718278, 3894.1818295422],
                        [1.9455e-07, 2.53112676345, 4399.994356889],
                        [1.5e-07, 1.03464802434, 2288.3440435114],
                        [2.0029e-07, 4.73119428749, 4690.4798363586],
                        [1.5381e-07, 2.4700947035, 4535.0594369244],
                        [1.9964e-07, 5.78652958398, 7079.3738568078],
                        [1.5307e-07, 2.26515985343, 3723.508958923],
                        [1.4705e-07, 3.36979890389, 6681.2421070518],
                        [1.3535e-07, 2.1233441041, 5486.777843175],
                        [1.295e-07, 5.61929676688, 10025.3603984484],
                        [1.2682e-07, 2.95022113262, 3496.032826134],
                        [1.3644e-07, 1.97739547259, 5614.7293762096],
                        [1.3013e-07, 1.51424752315, 5628.9564702112],
                        [1.4705e-07, 1.33902715586, 6681.2075997474],
                        [1.1353e-07, 6.23438193885, 135.0650800354],
                        [1.3275e-07, 3.42243595774, 5621.8429232104],
                        [1.0867e-07, 5.28184140482, 2818.035008606],
                        [1.185e-07, 3.12701832949, 426.598190876],
                        [1.0472e-07, 2.73581537999, 2787.0430238574],
                        [1.1132e-07, 5.84178807242, 2803.8079146044],
                        [1.1764e-07, 2.58551521265, 8432.7643848156],
                        [1.1854e-07, 5.4763068691, 3553.9115221378],
                        [8.49e-08, 1.91378007528, 11773.3768115154],
                        [9.708e-08, 4.52957217749, 6489.776587288],
                        [8.562e-08, 3.16141186861, 162.4666361322],
                        [1.0958e-07, 4.15771850822, 2388.8940204492],
                        [8.133e-08, 1.61295625304, 2957.7158944766],
                        [8.84e-08, 4.23294294197, 7477.522860216],
                        [8.034e-08, 5.69983564288, 6041.3275670856],
                        [8.344e-08, 2.18273563186, 23.8784377478],
                        [7.696e-08, 5.71877332978, 9623.6882766912],
                        [8.695e-08, 4.43542512603, 5092.1519581158],
                        [8.434e-08, 3.16292250873, 3347.7259737006],
                        [6.664e-08, 5.07517838003, 8031.0922630584],
                        [8.65e-08, 4.33256981793, 3339.6321056316],
                        [7.372e-08, 6.17831593269, 3583.3410306738],
                        [5.726e-08, 3.68120120299, 8429.2412664666],
                        [6.186e-08, 3.54165967734, 692.1576012268],
                        [5.438e-08, 1.0512968958, 4933.2084403326],
                        [6.108e-08, 1.66240879939, 6525.8044539654],
                        [5.154e-08, 1.14703246368, 28.4491874678],
                        [4.85e-08, 5.29254832907, 6681.2921637024],
                        [5.467e-08, 6.12511022569, 2487.4160449478],
                        [4.866e-08, 3.10475368803, 5.5229243074],
                        [6.36e-08, 2.11896608283, 5884.9268465832],
                        [5.223e-08, 0.3744626412, 12832.7587417046],
                        [4.71e-08, 0.23326120326, 36.0278666774],
                        [4.954e-08, 2.44806818502, 5099.2655051166],
                        [4.861e-08, 5.6050529887, 6467.9257579616],
                        [4.706e-08, 0.02998416568, 7210.9158184942],
                        [4.845e-08, 5.70115105957, 6681.1575430968],
                        [5.496e-08, 2.01006612503, 522.5774180938],
                        [4.964e-08, 1.51006845561, 1744.4259844152],
                        [4.443e-08, 0.31208413867, 10018.3141617504],
                        [5.381e-08, 0.18359380473, 2942.4634232916],
                        [4.075e-08, 3.9558210833, 3.881335358],
                        [5.462e-08, 0.19274227117, 7632.9432596502],
                        [4.11e-08, 1.59535768711, 7234.794256242],
                        [4.287e-08, 2.87635993968, 2810.9214616052],
                        [5.276e-08, 2.22638595594, 3127.3133312618],
                        [4.45e-08, 4.17005729081, 2906.900688823],
                        [5.144e-08, 5.66878565669, 23384.2869868986],
                        [3.844e-08, 2.2644218316, 2699.7348193176],
                        [3.514e-08, 1.76463961051, 1758.6530784168],
                        [3.351e-08, 2.66194137496, 4929.6853219836],
                        [4.299e-08, 4.43057446968, 640.8776073822],
                        [3.14e-08, 1.75866226873, 9595.2390892234],
                        [3.716e-08, 2.91969220147, 15643.6802033098],
                        [3.249e-08, 6.13937134379, 10419.9862835076],
                        [3.077e-08, 2.56115174488, 7064.1213856228],
                        [3.208e-08, 2.3251945308, 5085.038411115],
                        [2.93e-08, 1.27797225349, 574.3447983348],
                        [2.771e-08, 1.75664216142, 639.897286314],
                        [3.325e-08, 2.58945297384, 2118.7638603784],
                        [3.187e-08, 2.8664675151, 7740.6067835888],
                        [2.78e-08, 0.43157089331, 5828.0284716476],
                        [2.824e-08, 0.98500544471, 3191.0492295652],
                        [3.016e-08, 1.86555882509, 7.046236698],
                        [3.364e-08, 1.52847138842, 6674.1113063988],
                        [2.672e-08, 3.70855172347, 10021.8545337516],
                        [2.636e-08, 3.11790581052, 6836.6452528338],
                        [2.672e-08, 1.67778079449, 10021.8200264472],
                        [2.563e-08, 3.77294986894, 2921.1277828246],
                        [2.509e-08, 0.30454165124, 3475.6775067352],
                        [2.4e-08, 0.96972421975, 3319.8370312074],
                        [2.262e-08, 2.8139431495, 7875.6718636242],
                        [2.395e-08, 2.96002707485, 6682.2051744678],
                        [2.21e-08, 0.61263930586, 10973.55568635],
                        [2.248e-08, 4.12382007742, 59.3738619136],
                        [2.426e-08, 5.91508357946, 5331.3574437408],
                        [2.158e-08, 2.17583545077, 15113.9892382152],
                        [1.941e-08, 5.47668312685, 11371.7046897582],
                        [1.903e-08, 5.11165653855, 1066.49547719],
                        [2.37e-08, 3.87889340214, 3355.8648978848],
                        [2.299e-08, 1.15914205086, 3320.257107301],
                        [1.944e-08, 5.89081872133, 6894.5239488376],
                        [1.843e-08, 3.07643314617, 3325.3599555148],
                        [1.809e-08, 4.97905218276, 1648.4467571974],
                        [2.136e-08, 1.91364787635, 8969.568896911],
                        [2.099e-08, 3.00410255642, 6254.6266625236],
                        [1.915e-08, 3.5590743174, 3767.2106175758],
                        [1.991e-08, 5.37274107053, 206.1855484372],
                        [1.685e-08, 5.49701299817, 266.6070417218],
                        [1.646e-08, 1.31923405548, 3264.3463554242],
                        [1.732e-08, 1.81361103995, 536.8045120954],
                        [1.723e-08, 3.25900379342, 7903.073419721],
                        [1.564e-08, 5.75428852012, 3360.96774609859],
                        [1.589e-08, 1.73273563259, 3134.4268782626],
                        [1.69e-08, 2.43213510013, 3120.199784261],
                        [1.549e-08, 1.54016426558, 8425.6508378148],
                        [1.536e-08, 5.88431472627, 20.7753954924],
                        [1.46e-08, 4.89733072879, 9830.3890139878],
                        [2.023e-08, 5.94808387002, 13365.9728251482],
                        [1.991e-08, 3.11613326265, 3361.3878221922],
                        [1.401e-08, 2.24482184868, 3344.2028553516],
                        [1.365e-08, 4.58006320751, 10818.1352869158],
                        [1.392e-08, 5.48931017516, 170.6728706192],
                        [1.36e-08, 3.07974035205, 6127.6554505572],
                        [1.345e-08, 1.18653158091, 14584.2982731206],
                        [1.717e-08, 5.62501515015, 6158.6474353058],
                        [1.408e-08, 1.82072980335, 3337.021998048],
                        [1.736e-08, 2.01921900546, 10575.4066829418],
                        [1.402e-08, 4.50079374387, 5729.506447149],
                        [1.266e-08, 5.91088435118, 9808.5381846614],
                        [1.433e-08, 6.05024653324, 12964.300703391],
                        [1.223e-08, 0.82796258263, 419.4846438752],
                        [1.393e-08, 1.05117949107, 6438.4962494256],
                        [1.272e-08, 1.50116723856, 8439.8779318164],
                        [1.143e-08, 4.89747373731, 220.4126424388],
                        [1.183e-08, 3.52587190041, 6688.3384004004],
                        [1.132e-08, 6.19236255633, 6144.4203413042],
                        [1.154e-08, 2.2305848597, 8955.3418029094],
                        [1.129e-08, 3.44264300692, 10177.2576795336],
                        [1.152e-08, 5.29913300616, 27.4015560968],
                        [1.274e-08, 4.5842123844, 6247.5131155228],
                        [1.093e-08, 2.8262333236, 4569.574540022],
                        [1.303e-08, 0.44350560735, 87.30820453981],
                        [1.335e-08, 2.1420445773, 11243.6858464208],
                        [1.102e-08, 1.96260837539, 6298.3283211764],
                        [1.066e-08, 2.89865914321, 10404.7338123226],
                        [1.027e-08, 4.79269049654, 3914.9572250346],
                        [1.015e-08, 0.2284781873, 3230.4061054804],
                        [1.041e-08, 3.73274497451, 10213.285546211],
                        [1.154e-08, 4.14326179244, 6261.7402095244],
                        [1.306e-08, 3.67645557029, 2301.58581590939],
                        [1.145e-08, 5.12292846748, 4562.4609930212],
                        [1.275e-08, 5.14333847164, 2693.601593385],
                        [9.14e-09, 1.22398892152, 103.0927742186],
                        [9.55e-09, 1.52875141393, 3369.0616141676],
                        [9.08e-09, 0.48223420834, 13358.9265884502],
                        [8.92e-09, 1.35161136807, 1214.7350193206],
                        [9.98e-09, 3.2966588195, 3178.1457905676],
                        [9.8e-09, 1.69212466625, 43.718912305],
                        [9.19e-09, 2.45445889752, 13916.0191096416],
                        [8.99e-09, 5.94990531529, 12168.0026965746],
                        [8.91e-09, 5.63297246408, 10021.9045904022],
                        [9.22e-09, 3.91483430303, 9225.539273283],
                        [9.3e-09, 0.240730047, 6923.9534573736],
                        [9.23e-09, 1.1039607445, 29.429508536],
                        [8.16e-09, 4.65198282005, 2707.8286873866],
                        [7.91e-09, 6.08595583868, 2384.3232707292],
                        [8.2e-09, 4.80968546763, 533.2140834436],
                        [7.58e-09, 2.06012386134, 12935.8515159232],
                        [7.38e-09, 1.03564559078, 14314.1681130498],
                        [9.08e-09, 0.69862047595, 16173.3711684044],
                        [7e-09, 4.0878823461, 5202.3582793352],
                        [8.29e-09, 2.01062325398, 9866.4168806652],
                        [8.87e-09, 6.04145842617, 10021.7699697966],
                        [7.68e-09, 1.39532897827, 8273.8208670324],
                        [8.73e-09, 4.45446600602, 3316.733988952],
                        [6.73e-09, 3.02440642752, 1039.0266107904],
                        [6.6e-09, 2.83410276989, 107.6635239386],
                        [8.38e-09, 0.39195370222, 10551.528245194],
                        [7.08e-09, 3.27560955336, 18984.2926300096],
                        [6.58e-09, 6.01853128902, 26724.8994135984],
                        [6.85e-09, 1.98132615912, 1228.9621133222],
                        [5.95e-09, 0.10260171285, 111.1866422876],
                        [5.63e-09, 1.59138368358, 2391.43681773],
                        [5.55e-09, 2.7080196219, 4555.3474460204],
                        [6.96e-09, 2.89276686038, 2648.454825473],
                        [5.87e-09, 4.56017988729, 6680.2445323314],
                        [5.4e-09, 2.86002662919, 5459.3762870782],
                        [5.3e-09, 5.64877399946, 6034.2140200848],
                        [5.2e-09, 0.20012848836, 13760.5987102074],
                        [5.52e-09, 5.08766140543, 1903.4368125012],
                        [5.12e-09, 3.21411265909, 11081.2192102886],
                        [6.41e-09, 5.19459033638, 6048.4411140864],
                        [6.77e-09, 3.87723948458, 13517.8701062334],
                        [5.34e-09, 0.23224033336, 51.28033786241],
                        [6.7e-09, 3.69368226469, 3335.0895023924],
                        [4.86e-09, 2.41879628327, 3364.4908644476],
                        [5e-09, 4.31447859057, 3344.4937620578],
                        [4.81e-09, 1.56481992611, 1964.838626854],
                        [5.04e-09, 2.47456295599, 3863.1898447936],
                        [5.23e-09, 0.65856269237, 853.196381752],
                        [4.81e-09, 0.12971954679, 66.4874089144],
                        [5.35e-09, 2.98601678918, 8270.2977486834],
                        [4.5e-09, 2.02303462834, 13362.432453147],
                        [4.48e-09, 5.59827312967, 149.5631971346],
                        [5.19e-09, 2.75931838722, 3503.079062832],
                        [5.34e-09, 4.77352933347, 1118.7557921028],
                        [4.5e-09, 4.05380888708, 13362.4669604514],
                        [4.39e-09, 4.83194205477, 3116.2676309979],
                        [5.67e-09, 5.67483490268, 227.476132789],
                        [4.59e-09, 3.44555998004, 6702.000248892],
                        [5.45e-09, 2.01193901951, 7910.1869667218],
                        [4.25e-09, 2.79854459343, 433.7117378768],
                        [4.29e-09, 4.30113040289, 16858.4825329332],
                        [4.09e-09, 0.0544800954, 3304.5845600224],
                        [4.34e-09, 5.70806855136, 21.8508293264],
                        [3.99e-09, 4.93233684937, 9779.1086761254],
                        [5.32e-09, 1.31038986189, 6660.4494579072],
                        [3.98e-09, 5.31345458361, 13119.7211028252],
                        [4.59e-09, 2.53671963587, 74.7815985673],
                        [3.84e-09, 2.29906801437, 12310.1813236108],
                        [4.67e-09, 5.12562716972, 1596.1864422846],
                        [5.16e-09, 5.84767782422, 1052.2683831884],
                        [4.14e-09, 4.7540958261, 3981.490034082],
                        [3.65e-09, 3.73271671549, 5518.7501489918],
                        [3.67e-09, 0.13506394328, 56.8983749356],
                        [4.59e-09, 0.15582180531, 9381.9399937854],
                        [3.92e-09, 2.15845463651, 3980.5097130138],
                        [3.96e-09, 1.48538591462, 17924.9106998204],
                        [4.56e-09, 0.64517343174, 6816.289933435],
                        [3.58e-09, 5.87219240658, 3607.2194684216],
                        [4.9e-09, 0.65766946042, 3376.6402933772],
                        [3.65e-09, 1.91816243676, 3347.6586633978],
                        [3.97e-09, 1.80006148744, 7895.9598727202],
                        [3.36e-09, 2.14687780119, 6677.6344247478],
                        [3.4e-09, 2.88185925998, 17256.6315363414],
                        [3.34e-09, 6.13670038311, 5724.935697429],
                        [3.39e-09, 4.08527025169, 664.75604513],
                        [4.32e-09, 2.52188285182, 18454.601664915],
                        [3.36e-09, 4.22863444521, 6696.4773245846],
                        [3.42e-09, 5.96724705923, 3546.797975137],
                        [3.26e-09, 4.02557052581, 6872.6731195112],
                        [3.23e-09, 5.05444843838, 3237.5196524812],
                        [3.24e-09, 2.89151245241, 8329.671610597],
                        [3.21e-09, 6.25886976298, 10235.1363755374],
                        [3.33e-09, 2.57725424455, 6684.8152820514],
                        [3.56e-09, 6.27424874986, 8671.9698704406],
                        [3.19e-09, 5.05665355586, 36.6053653042],
                        [3.05e-09, 3.88755666972, 7107.8230442756],
                        [3.22e-09, 6.28125601341, 16706.585251848],
                        [3.34e-09, 3.15240620873, 11216.284290324],
                        [2.87e-09, 6.16467002771, 3973.396166013],
                        [2.83e-09, 2.67802456636, 3877.4169387952],
                        [2.83e-09, 1.6629315709, 1692.1656695024],
                        [2.76e-09, 2.94210551399, 3415.3940252671],
                        [2.75e-09, 0.53418048945, 17395.2197347258],
                        [3.55e-09, 3.31406527401, 10022.8176011676],
                        [3.11e-09, 1.50310910269, 6660.8695340008],
                        [2.69e-09, 1.84517097065, 11780.4903585162],
                        [2.7e-09, 4.42425307819, 310.8407988684],
                        [2.75e-09, 3.58464612058, 128.0188433374],
                        [2.75e-09, 2.2252353958, 3017.1070100424],
                        [3.12e-09, 5.15950395287, 7255.5696517344],
                        [2.99e-09, 0.72552273097, 155.3530891314],
                        [3.53e-09, 5.7004779835, 16460.333529525],
                        [2.67e-09, 5.97864271046, 9499.2598620056],
                        [2.7e-09, 0.77063210836, 11236.57229942],
                        [3.39e-09, 3.360921489, 5625.3660415594],
                        [3.15e-09, 2.33795159922, 3281.2385647862],
                        [2.47e-09, 3.71002922076, 7373.3824546264],
                        [3.28e-09, 0.18162415648, 5618.3198048614],
                        [2.47e-09, 6.27486009856, 15508.6151232744],
                        [2.92e-09, 0.14989609091, 16304.9131300908],
                        [3.26e-09, 4.53606745007, 2178.137722292],
                        [2.86e-09, 5.47710043383, 9168.6408983474],
                        [2.46e-09, 1.4983871248, 15110.4661198662],
                        [2.62e-09, 2.58821936465, 3336.7310913418],
                        [2.44e-09, 0.84015413449, 16062.1845261168],
                        [2.45e-09, 0.37772563756, 12721.572099417],
                        [2.5e-09, 2.26824758119, 6784.3176276182],
                        [2.48e-09, 6.22740483254, 13149.1506113612],
                        [2.55e-09, 4.93078809107, 14158.7477136156],
                        [2.4e-09, 6.15843594225, 19800.9459562248],
                        [2.49e-09, 5.47044926479, 4407.1079038898],
                        [2.35e-09, 5.38750866169, 76.2660712756],
                        [2.58e-09, 6.10384464886, 2480.302497947],
                        [3.06e-09, 5.35546231697, 2766.267628365],
                        [2.36e-09, 5.25670707064, 13171.0014406876],
                        [2.24e-09, 4.52466909993, 12566.1516999828],
                        [2.2e-09, 5.83694256642, 13936.794505134],
                        [2.71e-09, 1.42460945147, 14054.607308026],
                        [2.13e-09, 0.21127914063, 1505.28780909299],
                        [2.67e-09, 5.16501015011, 3205.5473466644],
                        [2.12e-09, 4.26202838353, 6546.1597733642],
                        [2.11e-09, 6.21401684263, 3253.30422216],
                        [2.33e-09, 3.72007597749, 3346.1353510072],
                        [2.74e-09, 2.91986569135, 10713.9948813262],
                        [2.01e-09, 3.36695295492, 6.6836638741],
                        [2.23e-09, 3.08788599159, 401.6721217572],
                        [2.34e-09, 2.24268269202, 110.2063212194],
                        [2.64e-09, 2.0817874274, 6475.0393049624],
                        [2.31e-09, 4.5380638448, 9602.3526362242],
                        [2.13e-09, 2.85452302656, 5415.6573747732],
                        [1.95e-09, 0.99589439506, 5642.1982426092],
                        [2.59e-09, 0.00464351114, 9380.9596727172],
                        [1.97e-09, 3.32573550633, 3657.0042963564],
                        [2.28e-09, 5.33299975472, 3561.0250691386],
                        [1.93e-09, 1.25502846507, 6606.4432548323],
                        [1.99e-09, 1.13665869139, 685.044054226],
                        [2.27e-09, 4.49610509002, 589.0648270082],
                        [2.17e-09, 5.48740879816, 10596.1820784342],
                        [1.92e-09, 4.26501800444, 3333.5661900018],
                        [1.88e-09, 1.44301618203, 4885.9664096786],
                        [1.78e-09, 4.82506490541, 9070.1188738488],
                        [1.84e-09, 5.69637552141, 3351.2490920496],
                        [1.87e-09, 0.76021337348, 16699.53901515],
                        [2.26e-09, 0.82767654373, 3265.8308281325],
                        [2.04e-09, 6.20933387021, 394.6258850592],
                        [1.76e-09, 3.89567349231, 10028.9508271002],
                        [1.74e-09, 3.68843293982, 735.8765135318],
                        [1.73e-09, 2.44269377255, 3603.6963500726],
                        [1.77e-09, 1.24154853329, 12722.5524204852],
                        [1.84e-09, 4.77203925989, 286.9623611206],
                        [1.71e-09, 4.67140116008, 20199.094959633],
                        [1.7e-09, 5.13753345526, 1332.0548875408],
                        [2.01e-09, 2.37863157745, 16276.463942623],
                        [2.09e-09, 0.57156268506, 11250.7993934216],
                        [1.64e-09, 1.98441291396, 10014.7237330986],
                        [1.91e-09, 0.60250751218, 56.8032621698],
                        [1.71e-09, 6.22556266993, 17277.4069318338],
                        [1.66e-09, 1.05948008727, 19513.9835951042],
                        [1.63e-09, 1.59661610701, 1437.1756141986],
                        [1.65e-09, 3.36308723589, 6665.9723822146],
                        [1.84e-09, 3.20554894393, 263.0839233728],
                        [2.12e-09, 3.10485836003, 4039.8835749274],
                        [1.76e-09, 3.41768939214, 9468.267877257],
                        [1.63e-09, 1.39275730949, 8982.810669309],
                        [2.13e-09, 3.39734274482, 931.3630868518],
                        [1.89e-09, 4.54004144896, 8542.970706035],
                        [1.91e-09, 1.15555618959, 3169.9395560806],
                        [1.55e-09, 1.41249963094, 22.7684966094],
                        [1.53e-09, 5.14168081601, 156.4007205024],
                        [1.59e-09, 3.64996617906, 8013.2797409404],
                        [1.51e-09, 1.93804487507, 3384.3313390048],
                        [1.57e-09, 0.58554505759, 158.9435177832],
                        [1.73e-09, 2.72517427493, 2807.3983432562],
                        [1.59e-09, 0.67192454133, 13892.1406718938],
                        [1.5e-09, 2.66045714174, 19004.6479494084],
                        [1.92e-09, 5.73782632783, 206.7007372966],
                        [1.43e-09, 3.19213280913, 6843.6914895318],
                        [1.94e-09, 1.32358882667, 19402.7969528166],
                        [1.43e-09, 2.3647816372, 13207.029307365],
                        [1.4e-09, 1.8880056884, 11766.2632645146],
                        [1.44e-09, 0.69018080218, 17085.9586657222],
                        [1.83e-09, 5.98085295555, 13362.517017102],
                        [1.61e-09, 2.92764155222, 5.8572022996],
                        [1.62e-09, 6.07051064413, 6701.5801727984],
                        [1.92e-09, 0.86266150575, 2814.4445799542],
                        [1.82e-09, 5.26446797092, 3873.8265101434],
                        [1.37e-09, 0.41563614709, 5820.9149246468],
                        [1.44e-09, 3.02314051168, 708.98980227659],
                        [1.84e-09, 4.61314496499, 3329.97576135],
                        [1.31e-09, 3.48156082643, 367.2243289624],
                        [1.73e-09, 3.09922849765, 12295.9542296092],
                        [1.35e-09, 2.23311632892, 15664.0355227086],
                        [1.47e-09, 1.95810911154, 5732.0492444298],
                        [1.58e-09, 1.48909254724, 29.4918183034],
                        [1.27e-09, 5.5553408004, 3368.0139827966],
                        [1.29e-09, 1.78002583252, 22743.4093795164],
                        [1.32e-09, 2.81496895377, 21795.2140916148],
                        [1.27e-09, 5.73090203501, 3340.19235060619],
                        [1.64e-09, 1.87613918877, 6709.6740408674],
                        [1.23e-09, 3.61238958991, 22324.9050567094],
                        [1.29e-09, 4.92064308735, 2540.7913015344],
                        [1.21e-09, 6.16922638434, 20206.141196331],
                        [1.22e-09, 5.79901866314, 1854.6323056346],
                        [1.33e-09, 0.50941998058, 3274.1250177854],
                        [1.51e-09, 1.61342807879, 1107.1388056848],
                        [1.65e-09, 2.02795177586, 290.4854794696],
                        [1.25e-09, 0.52719797619, 2604.735913168],
                        [1.44e-09, 5.68526782434, 8827.3902698748],
                        [1.26e-09, 3.80246508251, 765.7930644464],
                        [1.16e-09, 1.79450246249, 647.0108333148],
                        [1.26e-09, 2.00195272473, 699.2711482276],
                        [1.47e-09, 6.22619740782, 6040.3472460174],
                        [1.19e-09, 2.05840518265, 15121.102785216],
                        [1.14e-09, 2.7487709147, 6460.8122109608],
                        [1.55e-09, 1.78154091696, 21265.5231265202],
                        [1.46e-09, 3.37351237411, 1861.7458526354],
                        [1.18e-09, 4.07281676691, 418.504322807],
                        [1.16e-09, 0.10434606071, 13362.3823964964],
                        [1.29e-09, 0.78419803719, 3427.9206312396],
                        [1.52e-09, 0.32620694442, 3443.7052009184],
                        [1.1e-09, 0.56398082486, 661.232926781],
                        [1.11e-09, 4.05380946072, 568.8218740274],
                        [1.08e-09, 3.17700641574, 3448.2759506384],
                        [1.38e-09, 4.47698517191, 3326.3853326982],
                        [1.08e-09, 4.89922372003, 9588.1255422226],
                        [1.14e-09, 4.80828825403, 6657.3464156518],
                        [1.08e-09, 4.10637483972, 13553.8979729108],
                        [1.25e-09, 0.33573243959, 18849.2275499742],
                        [1.15e-09, 3.18885465852, 2409.249339848],
                        [1.04e-09, 3.23074163851, 3472.1543883862],
                        [1.04e-09, 0.09799515047, 30065.5118402982],
                        [1.12e-09, 1.64487733528, 10001.061884607],
                        [1.43e-09, 3.53781769283, 6518.7582172674],
                        [1.13e-09, 5.20979306912, 2125.8774073792],
                        [1.04e-09, 2.77582098882, 38.1330356378],
                        [1.33e-09, 5.88513337452, 5835.1420186484],
                        [1.05e-09, 4.11662579413, 6675.7019290922],
                        [1.02e-09, 0.60100887043, 10264.5658840734],
                        [1.01e-09, 3.78636130664, 10042.6126755918],
                        [1.39e-09, 1.80936944447, 12323.4230960088],
                        [1.01e-09, 2.47217208753, 7380.4960016272],
                        [1.3e-09, 2.53454569863, 11769.8536931664],
                        [1e-09, 5.72291104291, 14.2270940016],
                        [1.35e-09, 4.2023756451, 4672.6673142406],
                        [1.33e-09, 0.34413768012, 16489.763038061],
                        [9.8e-10, 1.44874403589, 3370.0419352358],
                        [1.31e-09, 1.31336606248, 3313.210870603],
                        [1.11e-09, 3.12463539337, 309.2783226558],
                        [1.01e-09, 3.15369992044, 24150.080051345],
                        [1.02e-09, 6.13479937096, 2277.7073781616],
                        [9.9e-10, 0.10085261274, 12839.8722887054],
                        [1.34e-09, 2.91637947295, 57.8786960038],
                        [1.04e-09, 3.3028305233, 3399.9862886134],
                        [1.08e-09, 4.92699760221, 802.3639224462],
                        [1.06e-09, 2.89298330043, 7799.9806455024],
                        [1.12e-09, 3.12761163915, 5989.0672521728],
                        [9.4e-10, 3.42562596561, 3510.1926098328],
                        [1.02e-09, 0.94285421551, 3209.0704650134],
                        [9.6e-10, 0.79636181668, 3024.2205570432],
                        [9.3e-10, 1.08979608844, 14577.1847261198],
                        [9.7e-10, 3.56551535742, 14421.8316369884],
                        [9.2e-10, 5.0227963751, 2494.5295919486],
                        [1.23e-09, 5.83481108101, 7747.7203305896],
                        [1.11e-09, 3.31406538379, 11610.9101753832],
                        [1.18e-09, 5.0084532296, 1581.959348283],
                        [9.1e-10, 2.36839307589, 11140.5930722022],
                        [9.9e-10, 2.93269536697, 2067.9314010726],
                        [1.24e-09, 3.15220420912, 22345.2603761082],
                        [9e-10, 0.85462370851, 17232.7530985936],
                        [1.25e-09, 1.54866979468, 1435.1476617594],
                        [1.13e-09, 4.57220387105, 14712.317116458],
                        [1.03e-09, 0.11158194413, 11.0457002639],
                        [1.13e-09, 2.41110151532, 5244.049239201],
                        [9.1e-10, 1.7718473028, 2221.856634597],
                        [1.14e-09, 1.92696878615, 8226.5788363784],
                        [1.18e-09, 0.29322259611, 2945.9865416406],
                        [8.9e-10, 4.49875865671, 21947.1113727],
                        [1.04e-09, 1.36766858693, 4032.7700279266],
                        [1.16e-09, 4.67476277278, 272.6729573516],
                        [1.05e-09, 3.7332797385, 4989.0591838972],
                        [9.5e-10, 0.34653808205, 13517.8027959306],
                        [8.6e-10, 2.70925448214, 7218.029365495],
                        [1.12e-09, 5.27572276726, 17499.3601403154],
                        [1.14e-09, 3.37335971932, 2938.9403049426],
                        [9e-10, 0.26623024836, 9485.032768004],
                        [8.6e-10, 3.66786582491, 6997.6167230562],
                        [8.7e-10, 4.0782360868, 18606.4989460002],
                        [1.17e-09, 5.61863859185, 16511.6138673874],
                        [8.4e-10, 2.80171829534, 8584.6616659008],
                        [8.6e-10, 5.87459621301, 73.6009559152],
                        [9e-10, 1.07789160729, 10721.108428327],
                        [8.4e-10, 0.78729386249, 146.8116865236],
                        [1.12e-09, 2.31690430881, 9638.9407478762],
                        [8.3e-10, 5.90575201511, 16858.4152226304],
                        [8.2e-10, 4.316905577, 9374.8264467846],
                        [8.3e-10, 1.41315204958, 22854.596021804],
                        [8.4e-10, 0.90320571725, 2171.0241752912],
                        [8.2e-10, 1.59442952041, 9947.0556815321],
                        [8.2e-10, 0.44163602941, 4782.87363546],
                        [8.6e-10, 5.18335054161, 12410.7313005486],
                        [8.5e-10, 3.61669636863, 8965.9784682592],
                        [9.7e-10, 5.3551176514, 4996.172730898],
                        [8.5e-10, 2.36814442737, 1062.9050485382],
                        [7.8e-10, 1.75580354602, 2060.8178540718],
                        [8.7e-10, 0.98702744399, 10156.9023601348],
                        [9.8e-10, 0.35294347682, 23546.7536230308],
                        [1.01e-09, 1.03298143418, 20040.1514418498],
                        [8.8e-10, 0.56201084357, 17101.2111369072],
                        [8.2e-10, 2.65765057749, 12979.553174576],
                        [8.5e-10, 1.07007237991, 10706.8813343254],
                        [8.2e-10, 0.8058839632, 20735.8321614256],
                        [9.2e-10, 4.87180501294, 9389.0535407862],
                        [7.8e-10, 3.22869264518, 11925.2740926006],
                        [7.4e-10, 5.59171946181, 8535.8571590342],
                        [8e-10, 0.42260849968, 956.2891559706],
                        [8.2e-10, 1.47379060963, 16.83220104979],
                        [7.3e-10, 3.76950560688, 8859.3625756916],
                        [7.3e-10, 4.5913018263, 362.1211367308],
                        [7.2e-10, 5.15373872266, 9872.2740829648],
                        [9.8e-10, 2.47740242208, 5401.4302807716],
                        [7.1e-10, 0.08395696279, 15849.865751747],
                        [7.8e-10, 0.04212599783, 16703.1294438018],
                        [7.5e-10, 3.77172360793, 4845.9002357928],
                        [7.2e-10, 2.01742377451, 1329.51209026],
                        [7.6e-10, 0.30413402871, 72.0557333548],
                        [9.7e-10, 5.1510931855, 1.4844727083],
                        [7e-10, 0.33648335823, 23141.5583829246],
                        [6.8e-10, 0.34828385806, 20047.1976785478],
                        [7.8e-10, 1.42772075938, 16063.164847185],
                        [8.1e-10, 2.37498404818, 16703.0448798468],
                        [6.9e-10, 3.66727984195, 13363.4300278674],
                        [6.7e-10, 1.77194706681, 18451.078546566],
                        [7.3e-10, 0.41181711796, 33406.124266998],
                        [6.7e-10, 3.1594684038, 8799.988713778],
                        [6.7e-10, 4.07602260745, 10448.4354709754],
                        [6.8e-10, 1.78981361818, 224.3447957019],
                        [6.6e-10, 1.01449371817, 4193.8088084518],
                        [6.7e-10, 4.89249339125, 12082.6551341712],
                        [8.1e-10, 0.61914094848, 949.1756089698],
                        [6.6e-10, 3.39914635235, 10184.3039162316],
                        [6.4e-10, 5.50528849889, 4936.7988689844],
                        [6.4e-10, 1.8260823549, 3077.528503327],
                        [6.9e-10, 2.48571574894, 10018.2468514476],
                        [6.4e-10, 2.8044732232, 20809.4676246452],
                        [6.8e-10, 0.9790733543, 6717.252720077],
                        [8.7e-10, 2.45966764758, 7321.1221397136],
                        [6.2e-10, 1.69131771765, 632.7837393132],
                        [8.1e-10, 4.40575713075, 16703.0793871512],
                        [6.3e-10, 3.63625395496, 25685.872802808],
                        [7.5e-10, 5.54907590704, 16872.642316632],
                        [6.1e-10, 0.33159827734, 12012.5822971404],
                        [6.3e-10, 3.16314818302, 11670.2840372968],
                        [6.2e-10, 0.23148800541, 7314.0085927128],
                        [7.8e-10, 1.65377731167, 11614.4332937322],
                        [6.8e-10, 1.10866475394, 6155.057006654],
                        [6.8e-10, 4.45713540461, 9175.7544453482],
                        [8.1e-10, 3.66553577428, 15265.8865193004],
                        [6.8e-10, 5.59792852411, 377.3736079158],
                        [5.9e-10, 6.25689995147, 41427.4869831788],
                        [7.2e-10, 3.39739853142, 685.1113645288],
                        [6.2e-10, 0.11206359088, 14047.4937610252],
                        [5.7e-10, 4.31819630987, 95.9792272178],
                        [7e-10, 5.98596344975, 6531.661656265],
                        [6.6e-10, 5.93804470886, 3490.1756238344],
                        [5.6e-10, 5.11205539684, 7322.1024607818],
                        [5.6e-10, 3.36788837326, 4379.6390374902],
                        [5.6e-10, 2.20908914878, 6688.2710900976],
                        [5.7e-10, 4.57828186723, 10037.0897512844],
                        [5.7e-10, 0.04695703833, 24889.5747959916],
                        [6.5e-10, 2.70973517401, 19617.0763693228],
                        [6.8e-10, 3.51423189318, 14556.8967170238],
                        [5.6e-10, 5.94452825242, 21548.9623692918],
                        [5.6e-10, 3.94541346495, 25665.5174834092],
                        [5.5e-10, 0.45166365461, 16702.9948231962],
                        [6.2e-10, 0.05229160039, 14061.7208550268],
                        [5.5e-10, 1.14774475393, 4459.3682188026],
                        [6.5e-10, 6.21442820689, 6947.8318951214],
                        [5.6e-10, 5.01712943722, 485.9720527896],
                        [6.5e-10, 1.51615558729, 5511.636601991],
                        [7.2e-10, 4.90742373357, 25287.7237993998],
                        [5.7e-10, 5.31542907454, 28628.3362260996],
                        [5.5e-10, 4.02023620788, 4005.3684718298],
                        [5.4e-10, 5.51196184505, 44.6538332402],
                        [5.3e-10, 0.46840976995, 19645.5255567906],
                        [5.3e-10, 4.51539970261, 9886.772200064],
                        [6.9e-10, 3.37092084432, 41.5507909848],
                        [7.2e-10, 4.66520155151, 6685.1061887576],
                        [5.2e-10, 2.05209599225, 7366.2689076256],
                        [5.2e-10, 6.25882226723, 12509.2533250472],
                        [6e-10, 0.33350021257, 13575.7488022372],
                        [5.9e-10, 5.94433755684, 625.6701923124],
                        [5e-10, 2.65624501709, 10124.930054318],
                        [6.8e-10, 2.92105834159, 10025.4277087512],
                        [5.1e-10, 2.88289068067, 39601.8919124496],
                        [6.9e-10, 1.09637075565, 24076.4445881254],
                        [5.2e-10, 2.65290577481, 15650.7937503106],
                        [5.2e-10, 3.2868331301, 6756.0064519669],
                        [5.4e-10, 5.34683925496, 6578.132079181],
                        [5.4e-10, 2.77410607136, 6705.1032911474],
                        [4.9e-10, 2.657002099, 6944.3087767724],
                        [5.3e-10, 5.67436244967, 1883.0814931024],
                        [4.8e-10, 5.68336050679, 8646.0634802536],
                        [5.1e-10, 0.113906433, 17402.3332817266],
                        [6.5e-10, 1.03099992649, 4106.4054911462],
                        [6e-10, 1.00159365247, 151.8972810852],
                        [5e-10, 3.84651247899, 45494.5814297488],
                        [4.7e-10, 3.03959709242, 5408.5438277724],
                        [6.3e-10, 4.16165369755, 8186.5126624926],
                        [4.6e-10, 2.69368087378, 16547.6417340648],
                        [5.1e-10, 2.99576014378, 3774.3241645766],
                        [4.4e-10, 2.00664763411, 6418.1409300268],
                        [4.5e-10, 4.01853755929, 19406.6782881746],
                        [5.8e-10, 3.1447475355, 4025.6564809258],
                        [5e-10, 2.59881540437, 6621.850991486],
                        [4.3e-10, 4.87912487459, 6414.6178116778],
                        [4.2e-10, 5.20400092044, 4447.7512323846],
                        [5.1e-10, 1.99634375899, 5032.7780962022],
                        [4.3e-10, 1.28813888865, 6643.0918177618],
                        [4e-10, 0.9680161856, 14591.4118201214],
                        [3.9e-10, 1.84985100829, 10001.4819607006],
                        [3.9e-10, 5.69967200167, 6106.8800550648],
                        [3.8e-10, 3.27498743518, 18052.9295431578],
                        [3.9e-10, 2.84167905068, 6652.7756659318],
                        [4.4e-10, 0.57891618854, 16865.5287696312],
                        [4.3e-10, 4.61937364869, 3341.0325027934],
                        [4.2e-10, 6.02555835659, 6691.8615187494],
                        [3.4e-10, 4.9773499235, 6670.5881880498],
                        [3.3e-10, 1.39167727215, 4825.544916394],
                        [3.5e-10, 6.02955363644, 3568.0885594888],
                        [3.5e-10, 0.31961016732, 6645.1969867222],
                        [3.2e-10, 5.63043769073, 3511.285297319],
                        [3.1e-10, 5.4297846421, 9945.5712088238],
                        [3.8e-10, 5.66461657503, 3416.8784979754],
                        [3e-10, 0.98518793666, 20426.571092422],
                        [3.8e-10, 0.12870962242, 6604.958782124],
                        [3.7e-10, 5.48374357342, 3311.18291816379],
                        [3.2e-10, 6.1110697981, 4392.8808098882],
                        [3.1e-10, 3.18481282781, 3341.0423098265],
                        [3.4e-10, 2.32358226279, 9072.6616711296],
                        [3.9e-10, 4.11042361929, 3312.163239232],
                        [2.7e-10, 0.57810321636, 3391.89276456221],
                        [2.9e-10, 2.48646403166, 9815.6517316622],
                        [3.1e-10, 0.44265747667, 3451.7990689874],
                        [2.7e-10, 6.13498177783, 3362.4632560262],
                        [2.7e-10, 6.21846173482, 5223.6939198022],
                        [2.7e-10, 2.94945830517, 7203.8022714934],
                        [2.7e-10, 3.261798558, 8756.269801473],
                        [2.7e-10, 3.943852717, 23958.6317852334],
                        [3.3e-10, 3.77237326006, 12808.8803039568],
                        [3e-10, 4.75096367323, 15906.7641266826],
                        [3.1e-10, 0.88248871193, 3340.1825435731],
                        [2.5e-10, 0.31303295413, 6571.0185321802],
                        [3.1e-10, 4.29076841627, 10020.8569590312],
                        [2.6e-10, 2.22427360058, 10050.2864675672],
                        [2.5e-10, 0.67881122439, 23937.856389741],
                        [3.1e-10, 1.72899093511, 13745.3462390224],
                        [2.4e-10, 0.20355912395, 3229.4257844122],
                        [3.2e-10, 3.37195631109, 2284.7536148596],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00058015791, 2.04979463279, 3340.6124266998],
                        [0.00054187645, 0, 0],
                        [0.00013908426, 2.45742359888, 6681.2248533996],
                        [2.465104e-05, 2.80000020929, 10021.8372800994],
                        [3.98379e-06, 3.14118428289, 13362.4497067992],
                        [2.22022e-06, 3.19436080019, 3.523118349],
                        [1.20957e-06, 0.54325292454, 155.4203994342],
                        [6.1517e-07, 3.48529427371, 16703.062133499],
                        [5.3638e-07, 3.54191121461, 3344.1355450488],
                        [3.4268e-07, 6.00188499119, 2281.2304965106],
                        [3.1665e-07, 4.14015171788, 191.4482661116],
                        [2.9839e-07, 1.99870679845, 796.2980068164],
                        [2.3168e-07, 4.33403365928, 242.728603974],
                        [2.1659e-07, 3.44532466378, 398.1490034082],
                        [1.6044e-07, 6.11000472441, 2146.1654164752],
                        [2.037e-07, 5.421913754, 553.5694028424],
                        [1.4927e-07, 6.09541783564, 3185.1920272656],
                        [1.6227e-07, 0.65678953303, 0.9803210682],
                        [1.4317e-07, 2.61851897591, 1349.8674096588],
                        [1.4416e-07, 4.01923812101, 951.7184062506],
                        [1.1934e-07, 3.86122163021, 6684.7479717486],
                        [1.5648e-07, 1.2208612194, 1748.016413067],
                        [1.126e-07, 4.71822363671, 2544.3144198834],
                        [1.3352e-07, 0.60189008414, 1194.4470102246],
                        [1.0396e-07, 0.25038714677, 382.8965322232],
                        [9.468e-08, 0.68170713564, 1059.3819301892],
                        [9.229e-08, 3.83209092321, 20043.6745601988],
                        [9.005e-08, 3.88271826102, 3738.761430108],
                        [7.501e-08, 5.46498630412, 1751.539531416],
                        [6.497e-08, 5.47773072872, 1592.5960136328],
                        [6.311e-08, 2.34104793674, 3097.88382272579],
                        [6.859e-08, 2.57522504136, 3149.1641605882],
                        [5.87e-08, 1.14783576679, 7.1135470008],
                        [6.681e-08, 2.37843690339, 4136.9104335162],
                        [4.647e-08, 4.42957708526, 6151.533888305],
                        [4.166e-08, 3.68631477611, 5614.7293762096],
                        [4.764e-08, 2.89684755585, 3333.498879699],
                        [4.045e-08, 6.12493402657, 5628.9564702112],
                        [3.653e-08, 4.06679068397, 1990.745017041],
                        [3.618e-08, 2.46868561769, 529.6909650946],
                        [3.277e-08, 0.68101740787, 8962.4553499102],
                        [3.253e-08, 2.7956534039, 3894.1818295422],
                        [3.091e-08, 4.56861203364, 3496.032826134],
                        [2.921e-08, 5.41458945995, 2914.0142358238],
                        [2.921e-08, 1.23050883841, 2787.0430238574],
                        [2.784e-08, 1.38911141844, 4292.3308329504],
                        [2.62e-08, 1.04061894134, 3341.592747768],
                        [2.888e-08, 3.41062353663, 3337.0893083508],
                        [2.418e-08, 0.96341462666, 4535.0594369244],
                        [2.357e-08, 4.84628239765, 9492.1463150048],
                        [2.593e-08, 5.74934234498, 3340.5951730476],
                        [2.191e-08, 3.26449527357, 213.299095438],
                        [2.594e-08, 1.49510566123, 3340.629680352],
                        [2.344e-08, 4.18104725028, 10025.3603984484],
                        [2.63e-08, 4.67640929857, 3583.3410306738],
                        [2.602e-08, 2.64911714813, 2388.8940204492],
                        [1.83e-08, 0.97181050149, 1589.0728952838],
                        [2.416e-08, 1.04749173375, 4399.994356889],
                        [2.386e-08, 4.2707257555, 7079.3738568078],
                        [2.187e-08, 0.16036551231, 6525.8044539654],
                        [2.344e-08, 0.01425578204, 4690.4798363586],
                        [1.617e-08, 4.95614491689, 5088.6288397668],
                        [1.633e-08, 1.10703599922, 12303.06777661],
                        [2.126e-08, 0.48290227706, 2700.7151403858],
                        [1.629e-08, 4.94267977718, 1221.8485663214],
                        [1.504e-08, 0.11031912519, 2957.7158944766],
                        [1.759e-08, 3.81170701376, 3723.508958923],
                        [1.401e-08, 3.85907867678, 6283.0758499914],
                        [1.338e-08, 5.29685392418, 6677.7017350506],
                        [1.763e-08, 2.51660121293, 2810.9214616052],
                        [1.392e-08, 2.73498041122, 7477.522860216],
                        [1.431e-08, 2.97747408389, 6489.776587288],
                        [1.236e-08, 3.7724596559, 2699.7348193176],
                        [1.234e-08, 1.88931735265, 6681.2421070518],
                        [1.513e-08, 2.92614134711, 640.8776073822],
                        [1.234e-08, 6.14168429036, 6681.2075997474],
                        [1.408e-08, 1.54395721611, 3347.7259737006],
                        [1.038e-08, 5.82880072933, 4933.2084403326],
                        [1.156e-08, 1.50825464304, 426.598190876],
                        [1.362e-08, 4.1779429752, 23384.2869868986],
                        [1.135e-08, 3.77506455273, 3870.3033917944],
                        [9.16e-09, 3.81726339298, 5092.1519581158],
                        [8.53e-09, 3.82520490669, 3340.545116397],
                        [1.077e-08, 5.0506282876, 5621.8429232104],
                        [1.074e-08, 3.8144692047, 3553.9115221378],
                        [8.47e-09, 3.41702696402, 3340.6797370026],
                        [9.2e-09, 1.91108056416, 3532.0606928114],
                        [7.38e-09, 4.25786145387, 9623.6882766912],
                        [9.08e-09, 4.12911006922, 162.4666361322],
                        [6.47e-09, 3.10301033831, 7234.794256242],
                        [8e-09, 5.20674574801, 87.30820453981],
                        [6.57e-09, 1.57895580467, 2487.4160449478],
                        [6.5e-09, 2.78932995437, 574.3447983348],
                        [6.59e-09, 5.16655918817, 12832.7587417046],
                        [7.12e-09, 5.79288230676, 3339.6321056316],
                        [6.6e-09, 0.25125103909, 8969.568896911],
                        [5.27e-09, 4.62218528897, 10419.9862835076],
                        [6.07e-09, 3.84724721085, 5486.777843175],
                        [5e-09, 4.66323134619, 6836.6452528338],
                        [5.09e-09, 0.32548381735, 8031.0922630584],
                        [6.13e-09, 1.72250879737, 7632.9432596502],
                        [5.16e-09, 1.37906978509, 7740.6067835888],
                        [4.69e-09, 1.31324778369, 7875.6718636242],
                        [4.42e-09, 5.34515135225, 10018.3141617504],
                        [4.96e-09, 4.49656852602, 692.1576012268],
                        [5.44e-09, 1.444653692, 15643.6802033098],
                        [4.67e-09, 1.40928870138, 6682.2051744678],
                        [5.47e-09, 4.42021065522, 5331.3574437408],
                        [4.33e-09, 1.25048504108, 4929.6853219836],
                        [4.09e-09, 3.80689273098, 6681.2921637024],
                        [4.03e-09, 1.5719023931, 6127.6554505572],
                        [4.01e-09, 4.59976459753, 7210.9158184942],
                        [4.06e-09, 0.60945437905, 11773.3768115154],
                        [3.67e-09, 0.97726583907, 6041.3275670856],
                        [3.61e-09, 0.13117924893, 639.897286314],
                        [4.11e-09, 4.21323421517, 6681.1575430968],
                        [4.41e-09, 4.49050100878, 13365.9728251482],
                        [4.74e-09, 5.1856252413, 2301.58581590939],
                        [3.34e-09, 2.21001303889, 10021.8545337516],
                        [3.7e-09, 5.02880065186, 6923.9534573736],
                        [3.33e-09, 0.18229887483, 10021.8200264472],
                        [3.42e-09, 2.49988747611, 6438.4962494256],
                        [3.2e-09, 1.3237447689, 2118.7638603784],
                        [3.3e-09, 2.98027481579, 5729.506447149],
                        [3.4e-09, 0.51409045792, 9866.4168806652],
                        [2.83e-09, 4.03219455446, 8955.3418029094],
                        [2.81e-09, 3.33891891806, 9830.3890139878],
                        [2.71e-09, 1.53144358045, 1039.0266107904],
                        [2.52e-09, 3.04356928941, 10818.1352869158],
                        [2.7e-09, 2.22972724035, 5828.0284716476],
                        [2.59e-09, 4.24406546278, 6894.5239488376],
                        [2.37e-09, 5.07818982743, 8429.2412664666],
                        [2.63e-09, 2.00552313665, 3767.2106175758],
                        [2.41e-09, 4.06396704332, 7064.1213856228],
                        [2.5e-09, 0.45422818547, 6298.3283211764],
                        [2.4e-09, 1.94655459341, 6688.3384004004],
                        [2.09e-09, 0.03043017984, 3914.9572250346],
                        [2.18e-09, 4.5320181825, 26724.8994135984],
                        [2.46e-09, 3.85272742042, 4562.4609930212],
                        [2.54e-09, 1.19313236635, 8432.7643848156],
                        [2.31e-09, 1.70340106651, 2942.4634232916],
                        [2.09e-09, 3.82345999055, 6467.9257579616],
                        [1.75e-09, 3.26444055581, 3981.490034082],
                        [2.1e-09, 3.55052707697, 10575.4066829418],
                        [1.62e-09, 5.95176683701, 310.8407988684],
                        [1.65e-09, 5.04267055142, 10177.2576795336],
                        [1.98e-09, 0.80464315638, 15113.9892382152],
                        [1.88e-09, 1.99007233842, 3127.3133312618],
                        [1.88e-09, 4.55406803143, 12964.300703391],
                        [1.63e-09, 2.14874886056, 10973.55568635],
                        [1.54e-09, 4.35708331036, 3360.96774609859],
                        [1.69e-09, 2.40504327781, 3355.8648978848],
                        [1.64e-09, 5.5387562097, 16173.3711684044],
                        [1.44e-09, 0.30186831602, 1903.4368125012],
                        [1.61e-09, 3.18977924032, 6674.1113063988],
                        [1.35e-09, 1.65570006128, 3325.3599555148],
                        [1.43e-09, 6.25825818399, 9595.2390892234],
                        [1.58e-09, 6.1425560834, 8273.8208670324],
                        [1.7e-09, 5.98413937993, 3320.257107301],
                        [1.24e-09, 1.74571336137, 11081.2192102886],
                        [1.46e-09, 2.22851709304, 3178.1457905676],
                        [1.26e-09, 5.02927593525, 3475.6775067352],
                        [1.23e-09, 4.99342648375, 13760.5987102074],
                        [1.41e-09, 4.5673581549, 10021.7699697966],
                        [1.18e-09, 5.42945437851, 13358.9265884502],
                        [1.16e-09, 4.22080571309, 5884.9268465832],
                        [1.19e-09, 4.09962692144, 10021.9045904022],
                        [1.24e-09, 1.79723243306, 18984.2926300096],
                        [1.35e-09, 1.00085140609, 18454.601664915],
                        [1.06e-09, 5.76342924005, 2288.3440435114],
                        [1.03e-09, 0.63812052706, 12310.1813236108],
                        [1e-09, 4.3794694526, 9808.5381846614],
                        [1.04e-09, 4.01151451052, 13916.0191096416],
                        [1.25e-09, 4.94825577002, 10551.528245194],
                        [9.8e-10, 5.91086068785, 14584.2982731206],
                        [1.26e-09, 1.55752034021, 8270.2977486834],
                        [9.8e-10, 2.5286981053, 3191.0492295652],
                        [9.5e-10, 5.5080831162, 3319.8370312074],
                        [1.08e-09, 1.67115668669, 11216.284290324],
                        [9e-10, 1.71281301325, 1505.28780909299],
                        [8.8e-10, 0.42472333366, 11371.7046897582],
                        [8.9e-10, 4.83867235269, 16706.585251848],
                        [1.06e-09, 1.78998252916, 10022.8176011676],
                        [8.7e-10, 5.8960268815, 16858.4825329332],
                        [8.5e-10, 0.55423657166, 13362.432453147],
                        [9.1e-10, 1.61117547913, 24093.2767891752],
                        [8.3e-10, 0.55328893146, 3344.2028553516],
                        [8.3e-10, 1.06830368571, 3364.4908644476],
                        [8.4e-10, 6.22980173043, 3369.0616141676],
                        [8.5e-10, 2.58442459869, 13362.4669604514],
                        [7.9e-10, 3.08636079495, 2818.035008606],
                        [7.7e-10, 1.53791408869, 5459.3762870782],
                        [7.5e-10, 3.34890581175, 9070.1188738488],
                        [9.7e-10, 2.99973987655, 3316.733988952],
                        [8.4e-10, 5.55309637085, 3427.9206312396],
                        [8.9e-10, 4.16432726564, 6158.6474353058],
                        [7.8e-10, 3.7237573039, 13171.0014406876],
                        [8.3e-10, 0.11917380846, 3337.021998048],
                        [7.3e-10, 4.91632010974, 13362.3823964964],
                        [7.6e-10, 4.52961122356, 708.98980227659],
                        [7.1e-10, 5.37905772348, 10264.5658840734],
                        [8.4e-10, 1.93007660929, 9468.267877257],
                        [7.3e-10, 5.28498987702, 4845.9002357928],
                        [8e-10, 4.81193020727, 13149.1506113612],
                        [7.6e-10, 4.77873149036, 8671.9698704406],
                        [6.9e-10, 0.86312560839, 13207.029307365],
                        [7e-10, 1.22001285505, 2274.1169495098],
                        [7e-10, 0.53977528244, 13119.7211028252],
                        [7e-10, 0.09801356525, 1437.1756141986],
                        [6.9e-10, 2.23597403243, 7107.8230442756],
                        [7.4e-10, 0.67876411085, 16460.333529525],
                        [6.8e-10, 0.5439361719, 12935.8515159232],
                        [8.4e-10, 5.1161735664, 13892.1406718938],
                        [7.8e-10, 5.27206373031, 853.196381752],
                        [6.5e-10, 4.74504626032, 6144.4203413042],
                        [6.5e-10, 2.89744951086, 7903.073419721],
                        [8.9e-10, 5.44755326514, 13517.8701062334],
                        [7.3e-10, 3.81554166604, 3503.079062832],
                        [6.6e-10, 0.47312197978, 3980.5097130138],
                        [6.5e-10, 1.38901912957, 3253.30422216],
                        [8.6e-10, 5.44050231013, 6816.289933435],
                        [7.2e-10, 3.44697351738, 14158.7477136156],
                        [8.6e-10, 4.50213985772, 13362.517017102],
                        [7.4e-10, 1.34701853675, 3361.3878221922],
                        [7.6e-10, 6.0400295943, 5085.038411115],
                        [6.5e-10, 0.07623776004, 5099.2655051166],
                        [6.6e-10, 2.0916071729, 14421.8316369884],
                        [7.7e-10, 2.75740817982, 19402.7969528166],
                        [5.9e-10, 3.61679189501, 7322.1024607818],
                        [6e-10, 4.67079289372, 10235.1363755374],
                        [6.4e-10, 6.17220244155, 9381.9399937854],
                        [6.6e-10, 0.35824154106, 7255.5696517344],
                        [5.9e-10, 4.52818219212, 9499.2598620056],
                        [6.5e-10, 1.86765892646, 11610.9101753832],
                        [7.4e-10, 3.12276411101, 1107.1388056848],
                        [6e-10, 1.35069679183, 19800.9459562248],
                        [5.5e-10, 0.64581579779, 6677.6344247478],
                        [5.5e-10, 0.65206957868, 7373.3824546264],
                        [5.5e-10, 0.41979092764, 9779.1086761254],
                        [7.4e-10, 3.8527624282, 2766.267628365],
                        [5.6e-10, 2.49261586879, 5642.1982426092],
                        [5.5e-10, 2.62555306434, 14314.1681130498],
                        [5.4e-10, 3.95212835807, 4032.7700279266],
                        [5.5e-10, 0.51062350773, 15110.4661198662],
                        [5.3e-10, 5.88757767795, 21265.5231265202],
                        [5.1e-10, 5.99253934388, 21947.1113727],
                        [4.9e-10, 5.16723732129, 20047.1976785478],
                        [6.7e-10, 1.53758821512, 9380.9596727172],
                        [5.7e-10, 5.34893894346, 17101.2111369072],
                        [4.9e-10, 1.9267860277, 12721.572099417],
                        [4.6e-10, 2.3159032048, 10028.9508271002],
                        [5.2e-10, 4.92463460288, 16304.9131300908],
                        [5e-10, 1.69803302925, 9225.539273283],
                        [4.5e-10, 2.91271003676, 8982.810669309],
                        [4.4e-10, 4.38728556203, 12168.0026965746],
                        [4.7e-10, 4.44933635857, 6872.6731195112],
                        [4.3e-10, 2.13295656057, 22324.9050567094],
                        [5e-10, 1.34759191325, 8439.8779318164],
                        [4.4e-10, 0.89037464728, 20752.6643624754],
                        [4.1e-10, 2.76164156557, 6696.4773245846],
                        [4.2e-10, 4.45031185062, 10404.7338123226],
                        [4.4e-10, 3.20262780268, 22743.4093795164],
                        [4.2e-10, 3.54559408987, 30376.3526391666],
                        [4.2e-10, 0.82118836477, 20597.2439630412],
                        [5.2e-10, 4.59037852162, 22345.2603761082],
                        [4.2e-10, 3.79872109079, 28628.3362260996],
                        [4.1e-10, 2.3625360208, 16062.1845261168],
                        [5e-10, 1.48377570574, 6040.3472460174],
                        [4.1e-10, 5.33088551342, 765.7930644464],
                        [3.9e-10, 1.57984331116, 24889.5747959916],
                        [3.8e-10, 0.21571600948, 9168.6408983474],
                        [3.8e-10, 3.47667842127, 1066.49547719],
                        [5.2e-10, 0.81427285458, 9638.9407478762],
                        [4.1e-10, 0.04356010851, 6660.8695340008],
                        [4.6e-10, 0.89345529755, 16703.0448798468],
                        [4.4e-10, 0.85335841824, 17468.8551979454],
                        [3.9e-10, 0.27098916103, 11614.4332937322],
                        [3.6e-10, 3.93388136028, 33716.9650658664],
                        [4.7e-10, 3.90896957151, 5244.049239201],
                        [3.4e-10, 2.37310468308, 10213.285546211],
                        [3.4e-10, 4.85454495742, 14469.588512484],
                        [3.5e-10, 1.96497348634, 6702.000248892],
                        [3.3e-10, 2.14488758889, 13363.4300278674],
                        [4.6e-10, 2.92422266239, 16703.0793871512],
                        [3.5e-10, 1.78692835372, 2648.454825473],
                        [3.3e-10, 4.24484480826, 8584.6616659008],
                        [4.3e-10, 6.09391349922, 6660.4494579072],
                        [3.5e-10, 5.72426647579, 16699.53901515],
                        [3.1e-10, 1.95254273311, 6665.9723822146],
                        [2.8e-10, 5.88548900893, 19513.9835951042],
                        [3e-10, 4.38908125588, 12295.9542296092],
                        [2.9e-10, 6.25276686131, 17924.9106998204],
                        [2.5e-10, 4.89000247975, 30065.5118402982],
                        [2.6e-10, 2.43119321236, 6518.7582172674],
                        [2.8e-10, 3.97032105354, 4407.1079038898],
                        [2.5e-10, 1.88631752737, 4379.6390374902],
                        [2.8e-10, 3.06196380356, 6247.5131155228],
                        [2.9e-10, 5.98057498931, 6680.2445323314],
                        [3.2e-10, 4.65556810177, 6701.5801727984],
                        [2.6e-10, 0.76018385758, 3863.1898447936],
                        [2.3e-10, 0.31107548102, 8827.3902698748],
                        [2.2e-10, 1.11553014451, 6684.8152820514],
                        [2e-10, 4.81193192299, 15508.6151232744],
                        [1.9e-10, 5.11656455993, 12012.5822971404],
                        [2.6e-10, 1.07254469525, 8425.6508378148],
                        [2.1e-10, 2.68436255141, 6261.7402095244],
                        [2.2e-10, 2.15631095909, 3335.0895023924],
                        [1.7e-10, 0.03684125273, 3877.4169387952],
                        [1.7e-10, 2.84467149903, 3344.4937620578],
                        [2e-10, 5.41519706836, 3205.5473466644],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [1.482423e-05, 0.44434694876, 3340.6124266998],
                        [6.62095e-06, 0.88469178686, 6681.2248533996],
                        [1.88268e-06, 1.28799982497, 10021.8372800994],
                        [4.1474e-07, 1.64850786997, 13362.4497067992],
                        [2.2661e-07, 2.05267665262, 155.4203994342],
                        [2.5994e-07, 0, 0],
                        [8.024e-08, 1.99858757687, 16703.062133499],
                        [1.0454e-07, 1.58006906385, 3.523118349],
                        [4.9e-08, 2.82452457966, 242.728603974],
                        [3.782e-08, 2.01914272515, 3344.1355450488],
                        [3.176e-08, 4.59144897927, 3185.1920272656],
                        [3.134e-08, 0.65044714325, 553.5694028424],
                        [1.684e-08, 5.53835848782, 951.7184062506],
                        [1.511e-08, 5.71795850828, 191.4482661116],
                        [1.448e-08, 0.45869142895, 796.2980068164],
                        [1.442e-08, 2.34368495577, 20043.6745601988],
                        [1.302e-08, 5.36284013048, 0.9803210682],
                        [1.169e-08, 4.14601161433, 1349.8674096588],
                        [1.133e-08, 2.38180830662, 6684.7479717486],
                        [1.037e-08, 1.76892750558, 382.8965322232],
                        [8.94e-09, 5.33688328934, 1194.4470102246],
                        [8.07e-09, 2.74798886181, 1748.016413067],
                        [6.4e-09, 6.10665147849, 3496.032826134],
                        [5.58e-09, 1.8521234236, 398.1490034082],
                        [5.67e-09, 5.85922384979, 7.1135470008],
                        [6.47e-09, 3.17645475605, 3583.3410306738],
                        [4.52e-09, 5.98109989317, 2787.0430238574],
                        [5.08e-09, 1.01139298015, 3149.1641605882],
                        [5.19e-09, 4.93376176788, 6525.8044539654],
                        [4.05e-09, 1.27295444059, 2281.2304965106],
                        [3.99e-09, 2.32888685659, 3738.761430108],
                        [4.72e-09, 0.84411483892, 4136.9104335162],
                        [3.33e-09, 5.42704539231, 1059.3819301892],
                        [3.13e-09, 3.70599897858, 3097.88382272579],
                        [2.81e-09, 5.74581724084, 3341.592747768],
                        [2.87e-09, 2.69304799864, 10025.3603984484],
                        [2.37e-09, 5.68519881994, 4535.0594369244],
                        [2.15e-09, 2.49494803822, 1990.745017041],
                        [2.6e-09, 2.67996877129, 23384.2869868986],
                        [2.69e-09, 1.10390153866, 2388.8940204492],
                        [1.86e-09, 4.86408411823, 2957.7158944766],
                        [1.76e-09, 3.86618588087, 1592.5960136328],
                        [1.77e-09, 0.85374318134, 3894.1818295422],
                        [1.91e-09, 4.58805692093, 3337.0893083508],
                        [1.85e-09, 5.8089931655, 4399.994356889],
                        [1.43e-09, 1.15592612974, 7477.522860216],
                        [1.73e-09, 2.70622920014, 7079.3738568078],
                        [1.46e-09, 1.37569151302, 6489.776587288],
                        [1.21e-09, 3.24333934982, 9492.1463150048],
                        [1.16e-09, 5.7163981953, 12303.06777661],
                        [1.11e-09, 2.69566947038, 6151.533888305],
                        [1.03e-09, 3.53587741373, 6923.9534573736],
                        [9.7e-10, 5.23712981002, 8962.4553499102],
                        [8.9e-10, 0.0595132422, 6127.6554505572],
                        [9.3e-10, 5.29818155587, 9866.4168806652],
                        [8.4e-10, 5.68544044325, 4292.3308329504],
                        [9.1e-10, 6.16223680965, 6682.2051744678],
                        [8.1e-10, 4.3272333062, 4933.2084403326],
                        [7.7e-10, 5.6318982417, 1589.0728952838],
                        [1.02e-09, 6.26937663026, 3347.7259737006],
                        [7.6e-10, 3.05724276091, 13365.9728251482],
                        [6.3e-10, 3.12770931753, 10419.9862835076],
                        [6.2e-10, 1.45647168723, 7234.794256242],
                        [6.9e-10, 4.82266605869, 6677.7017350506],
                        [6.4e-10, 1.73713448446, 3870.3033917944],
                        [5.8e-10, 4.85723088492, 5486.777843175],
                        [5.8e-10, 6.0984951679, 7875.6718636242],
                        [6.3e-10, 4.14716431158, 3340.5951730476],
                        [6.5e-10, 6.17932665318, 3340.629680352],
                        [5.7e-10, 1.48905992502, 5729.506447149],
                        [6e-10, 6.08710604997, 7740.6067835888],
                        [5.6e-10, 1.96253427165, 3553.9115221378],
                        [5.9e-10, 0.89874385953, 3339.6321056316],
                        [5.3e-10, 3.04776975379, 26724.8994135984],
                        [6.1e-10, 3.63390789623, 12832.7587417046],
                        [5.9e-10, 0.2298974604, 6681.2421070518],
                        [5.3e-10, 3.97996929188, 5092.1519581158],
                        [5.9e-10, 4.48255178273, 6681.2075997474],
                        [4.5e-10, 3.88055745121, 10264.5658840734],
                        [5.8e-10, 4.85371375265, 5621.8429232104],
                        [4.9e-10, 4.03623343126, 16173.3711684044],
                        [6.1e-10, 2.90942510134, 5331.3574437408],
                        [4.3e-10, 1.8099071834, 9830.3890139878],
                        [4.4e-10, 4.10828944542, 4690.4798363586],
                        [4.4e-10, 3.49332765553, 13760.5987102074],
                        [4.8e-10, 1.81207342615, 3723.508958923],
                        [4.1e-10, 1.59906754314, 10818.1352869158],
                        [4.1e-10, 2.05797417369, 6681.2921637024],
                        [3.8e-10, 3.38619280993, 16706.585251848],
                        [4.1e-10, 2.53336616026, 6681.1575430968],
                        [4.1e-10, 1.79026132252, 3340.545116397],
                        [5e-10, 4.7032478409, 8273.8208670324],
                        [3.7e-10, 3.37898394417, 30065.5118402982],
                        [3.9e-10, 2.65566008587, 6894.5239488376],
                        [3.5e-10, 2.58475025674, 9623.6882766912],
                        [3.7e-10, 6.07442797404, 4929.6853219836],
                        [4.2e-10, 3.04642561189, 12964.300703391],
                        [3.7e-10, 5.23784488646, 6298.3283211764],
                        [4.3e-10, 6.17835198533, 15643.6802033098],
                        [3.4e-10, 2.44806511268, 7210.9158184942],
                        [3.8e-10, 0.26295105909, 10022.8176011676],
                        [2.8e-10, 0.74281728305, 10021.8545337516],
                        [2.8e-10, 4.99536302577, 10021.8200264472],
                        [3.4e-10, 5.04118058624, 8969.568896911],
                        [2.5e-10, 2.59849002421, 8955.3418029094],
                        [3e-10, 1.14354290938, 2146.1654164752],
                        [2.7e-10, 0.26980783576, 18984.2926300096],
                        [2.5e-10, 0.39810308575, 6688.3384004004],
                        [2.4e-10, 5.64558695441, 13207.029307365],
                        [2.7e-10, 6.24398988438, 5088.6288397668],
                        [2.4e-10, 0.25455613132, 11081.2192102886],
                        [2.3e-10, 0.53673547304, 3333.498879699],
                        [2.4e-10, 1.80155161992, 6674.1113063988],
                        [2.9e-10, 4.3995350792, 10018.3141617504],
                        [2.3e-10, 2.91040060956, 10551.528245194],
                        [2.2e-10, 1.20895727897, 529.6909650946],
                        [2.6e-10, 0.08254324904, 7632.9432596502],
                        [2.6e-10, 1.81668969835, 6283.0758499914],
                        [2.1e-10, 0.67232850824, 6836.6452528338],
                        [1.7e-10, 5.19518401928, 2914.0142358238],
                        [1.7e-10, 5.16488977775, 8031.0922630584],
                        [2.1e-10, 3.62973082412, 5884.9268465832],
                        [1.8e-10, 5.06870872024, 2544.3144198834],
                        [1.4e-10, 2.50522181917, 7064.1213856228],
                        [1.7e-10, 0.4183559895, 9468.267877257],
                        [1.1e-10, 2.21363101654, 6438.4962494256],
                        [1.3e-10, 1.38424462832, 3340.6797370026],
                        [1.2e-10, 3.28248484262, 8671.9698704406],
                        [1.4e-10, 0.23027665815, 3767.2106175758],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.13969e-06, 3.14159265359, 0],
                        [2.8725e-07, 5.63662412043, 6681.2248533996],
                        [2.4447e-07, 5.13868481454, 3340.6124266998],
                        [1.1187e-07, 6.03161074431, 10021.8372800994],
                        [3.19e-08, 3.56267988299, 155.4203994342],
                        [3.252e-08, 0.13228350651, 13362.4497067992],
                        [7.87e-09, 0.49340783377, 16703.062133499],
                        [7.76e-09, 1.31734531594, 242.728603974],
                        [4.94e-09, 3.06356214498, 3185.1920272656],
                        [3.74e-09, 2.15785846355, 553.5694028424],
                        [3.31e-09, 6.23159792887, 3.523118349],
                        [1.97e-09, 0.44350153983, 3344.1355450488],
                        [1.81e-09, 0.81531283571, 20043.6745601988],
                        [1.68e-09, 3.73509781785, 3496.032826134],
                        [8.6e-10, 0.79259553758, 6684.7479717486],
                        [1.15e-09, 1.66898531261, 3583.3410306738],
                        [9.2e-10, 3.40530361815, 6525.8044539654],
                        [6.4e-10, 4.47443580658, 2787.0430238574],
                        [4.5e-10, 5.17216217058, 3097.88382272579],
                        [4.1e-10, 1.21875027733, 23384.2869868986],
                        [3.6e-10, 5.53975653407, 3149.1641605882],
                        [3.9e-10, 5.40966345885, 4136.9104335162],
                        [2.8e-10, 4.85378781404, 6127.6554505572],
                        [2.7e-10, 0.42811091036, 3738.761430108],
                        [3.2e-10, 1.22337093927, 10025.3603984484],
                        [2.5e-10, 1.56348878811, 26724.8994135984],
                        [2.9e-10, 2.40178626971, 3894.1818295422],
                        [2.3e-10, 4.16371253947, 3341.592747768],
                        [2.2e-10, 5.98429191667, 7477.522860216],
                        [1.9e-10, 2.03228980685, 6923.9534573736],
                        [2e-10, 3.79275573433, 9866.4168806652],
                        [2.1e-10, 4.27532111122, 6836.6452528338],
                        [1.5e-10, 1.56315497374, 13365.9728251482],
                        [1.1e-10, 1.33261955275, 2281.2304965106],
                        [9e-11, 6.15390464542, 6489.776587288],
                        [7e-11, 4.23894194106, 4535.0594369244],
                      ],
          },
          {
            series => "L5",
            terms  => [
                        [7.1e-09, 4.04089996521, 6681.2248533996],
                        [8.68e-09, 3.14159265359, 0],
                        [5.1e-09, 4.49214901625, 10021.8372800994],
                        [3.57e-09, 5.07435505061, 155.4203994342],
                        [2.23e-09, 3.51351884241, 3340.6124266998],
                        [1.99e-09, 4.85313666795, 13362.4497067992],
                        [1e-09, 6.09089356066, 242.728603974],
                        [6.9e-10, 5.19017483537, 16703.062133499],
                        [6.4e-10, 1.55783055571, 3185.1920272656],
                        [3.5e-10, 3.68246171643, 553.5694028424],
                        [2.5e-10, 5.22079788019, 3496.032826134],
                        [2.4e-10, 0.17861991485, 3583.3410306738],
                        [1.9e-10, 5.5918471446, 20043.6745601988],
                        [1.4e-10, 5.95565787085, 23384.2869868986],
                        [1.2e-10, 1.93859256739, 6525.8044539654],
                      ],
          },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.03197134986, 3.76832042432, 3340.6124266998],
                        [0.00298033234, 4.10616996243, 6681.2248533996],
                        [0.00289104742, 0, 0],
                        [0.00031365538, 4.44651052853, 10021.8372800994],
                        [3.4841e-05, 4.78812547889, 13362.4497067992],
                        [4.42999e-06, 5.65233015876, 3337.0893083508],
                        [4.43401e-06, 5.02642620491, 3344.1355450488],
                        [3.99109e-06, 5.130568147, 16703.062133499],
                        [2.92506e-06, 3.79290644595, 2281.2304965106],
                        [1.81982e-06, 6.13648011704, 6151.533888305],
                        [1.63159e-06, 4.26399626634, 529.6909650946],
                        [1.59678e-06, 2.23194610246, 1059.3819301892],
                        [1.39323e-06, 2.41796344238, 8962.4553499102],
                        [1.49297e-06, 2.16501209917, 5621.8429232104],
                        [1.42686e-06, 1.1821501611, 3340.5951730476],
                        [1.42685e-06, 3.2129218082, 3340.629680352],
                        [8.2544e-07, 5.36667872319, 6684.7479717486],
                        [7.364e-07, 5.09187524843, 398.1490034082],
                        [7.266e-07, 5.53775710437, 6283.0758499914],
                        [8.6377e-07, 5.74429648412, 3738.761430108],
                        [8.3276e-07, 5.98866315739, 6677.7017350506],
                        [6.0116e-07, 3.67960808826, 796.2980068164],
                        [6.3111e-07, 0.73049113369, 5884.9268465832],
                        [6.2338e-07, 4.85071999184, 2942.4634232916],
                        [4.6951e-07, 5.54339723804, 3340.545116397],
                        [4.6953e-07, 5.13486627234, 3340.6797370026],
                        [4.663e-07, 5.47361665459, 20043.6745601988],
                        [4.5588e-07, 2.13262507507, 2810.9214616052],
                        [4.1269e-07, 0.20003189001, 9492.1463150048],
                        [4.7199e-07, 4.52184736343, 3149.1641605882],
                        [3.854e-07, 4.08008443274, 4136.9104335162],
                        [3.3069e-07, 4.06581918329, 1751.539531416],
                        [2.9694e-07, 5.92218297386, 3532.0606928114],
                        [3.2736e-07, 2.62071056958, 2914.0142358238],
                        [2.9521e-07, 2.75342566734, 12303.06777661],
                        [2.8169e-07, 2.06282533993, 5486.777843175],
                        [2.8618e-07, 4.94710527914, 3870.3033917944],
                        [2.6603e-07, 3.5508584402, 6681.2421070518],
                        [2.6603e-07, 1.52008675291, 6681.2075997474],
                        [2.3336e-07, 2.27624532707, 1589.0728952838],
                        [2.6052e-07, 2.60064548916, 4399.994356889],
                        [2.2637e-07, 2.27507466406, 1194.4470102246],
                        [1.8887e-07, 6.04416196149, 7079.3738568078],
                        [1.4846e-07, 3.41358603159, 5088.6288397668],
                        [1.9947e-07, 2.67365368471, 8432.7643848156],
                        [1.4682e-07, 5.89211938785, 9623.6882766912],
                        [1.4152e-07, 2.42512744356, 3333.498879699],
                        [1.331e-07, 2.62839773036, 426.598190876],
                        [1.4008e-07, 1.67425558329, 6254.6266625236],
                        [1.5104e-07, 2.81013535571, 3496.032826134],
                        [1.3011e-07, 5.70759434129, 10025.3603984484],
                        [1.208e-07, 1.51804981987, 3185.1920272656],
                        [1.3183e-07, 0.04521207632, 10018.3141617504],
                        [1.1554e-07, 5.5741897182, 191.4482661116],
                        [1.1196e-07, 0.55829576311, 5092.1519581158],
                        [1.153e-07, 2.13314819584, 11773.3768115154],
                        [1.0435e-07, 5.72414012635, 6467.9257579616],
                        [9.846e-08, 0.86942245495, 1592.5960136328],
                        [9.761e-08, 1.0934228866, 2544.3144198834],
                        [8.754e-08, 5.47281660412, 6681.2921637024],
                        [8.937e-08, 4.8379038561, 6489.776587288],
                        [8.652e-08, 4.72118876809, 213.299095438],
                        [8.797e-08, 2.86597575792, 3341.592747768],
                        [8.384e-08, 2.65895230037, 4535.0594369244],
                        [8.213e-08, 4.8260813471, 3553.9115221378],
                        [8.799e-08, 1.52910882795, 3339.6321056316],
                        [8.103e-08, 1.00994045172, 9225.539273283],
                        [8.754e-08, 5.88131160438, 6681.1575430968],
                        [7.209e-08, 4.41679446871, 7477.522860216],
                        [8.56e-08, 4.79003986337, 4690.4798363586],
                        [6.087e-08, 1.89071507516, 9595.2390892234],
                        [6.974e-08, 0.53246284561, 12832.7587417046],
                        [5.584e-08, 6.18909308524, 4292.3308329504],
                        [5.038e-08, 6.06393121994, 7210.9158184942],
                        [5.126e-08, 0.11856805, 4562.4609930212],
                        [4.863e-08, 1.33051301524, 3894.1818295422],
                        [5.592e-08, 3.97792577165, 3127.3133312618],
                        [4.965e-08, 5.74589127183, 1990.745017041],
                        [5.53e-08, 5.81711987294, 23384.2869868986],
                        [4.184e-08, 3.88899446923, 10021.8545337516],
                        [4.184e-08, 1.8582188554, 10021.8200264472],
                        [4.685e-08, 1.11750235736, 3319.8370312074],
                        [3.954e-08, 2.65573703692, 4929.6853219836],
                        [5.174e-08, 3.62343554596, 2700.7151403858],
                        [4.639e-08, 6.14089337232, 7.1135470008],
                        [4.686e-08, 3.27731664264, 3361.3878221922],
                        [4.999e-08, 3.09121636067, 15643.6802033098],
                        [3.919e-08, 2.96552252075, 7740.6067835888],
                        [3.361e-08, 1.85016770821, 2957.7158944766],
                        [4.246e-08, 4.1963927863, 2146.1654164752],
                        [4.101e-08, 6.22532797325, 10213.285546211],
                        [3.124e-08, 0.08536218671, 10419.9862835076],
                        [3.079e-08, 2.41163389513, 3344.2028553516],
                        [3.093e-08, 1.98041729732, 3337.021998048],
                        [3.044e-08, 4.38894419912, 1221.8485663214],
                        [2.879e-08, 2.93292197885, 2787.0430238574],
                        [3.372e-08, 4.45558202843, 6674.1113063988],
                        [2.51e-08, 4.06249795775, 6872.6731195112],
                        [2.616e-08, 1.23659420897, 4933.2084403326],
                        [3.011e-08, 4.33965766608, 2388.8940204492],
                        [3.094e-08, 2.40385309455, 2118.7638603784],
                        [2.516e-08, 2.30275910483, 3723.508958923],
                        [2.192e-08, 1.688775987, 639.897286314],
                        [2.157e-08, 6.07600403318, 9808.5381846614],
                        [2.686e-08, 2.38172448359, 15113.9892382152],
                        [2.156e-08, 2.87771528495, 6041.3275670856],
                        [2.495e-08, 3.87395320804, 7903.073419721],
                        [2.253e-08, 0.47469626036, 3475.6775067352],
                        [2.443e-08, 3.02632351975, 3767.2106175758],
                        [1.937e-08, 0.38000997629, 13358.9265884502],
                        [2.213e-08, 3.9198232636, 3205.5473466644],
                        [2.385e-08, 6.23883456815, 12964.300703391],
                        [1.806e-08, 2.38408432339, 11243.6858464208],
                        [2.265e-08, 1.8577388518, 6525.8044539654],
                        [1.642e-08, 1.86812936557, 6680.2445323314],
                        [1.616e-08, 3.39954231101, 8429.2412664666],
                        [1.646e-08, 0.73261192032, 2274.1169495098],
                        [1.91e-08, 6.04319894051, 13365.9728251482],
                        [1.492e-08, 2.9936092905, 7875.6718636242],
                        [1.567e-08, 1.76860259924, 382.8965322232],
                        [1.459e-08, 1.40571286543, 14584.2982731206],
                        [1.527e-08, 5.79343536555, 6894.5239488376],
                        [1.409e-08, 5.17099876287, 9830.3890139878],
                        [1.665e-08, 3.60183854165, 2288.3440435114],
                        [1.616e-08, 2.1944777548, 8827.3902698748],
                        [1.746e-08, 0.10485504333, 3583.3410306738],
                        [1.637e-08, 3.20410489018, 6682.2051744678],
                        [1.269e-08, 2.02253791623, 155.4203994342],
                        [1.507e-08, 5.80795976424, 1748.016413067],
                        [1.296e-08, 2.92899986522, 9381.9399937854],
                        [1.291e-08, 2.98932404463, 6836.6452528338],
                        [1.377e-08, 5.8098082145, 10021.9045904022],
                        [1.357e-08, 0.32856318286, 4032.7700279266],
                        [1.377e-08, 6.21830533138, 10021.7699697966],
                        [1.227e-08, 2.20421067322, 12935.8515159232],
                        [1.08e-08, 4.75502761725, 10818.1352869158],
                        [1.016e-08, 1.33950348904, 12566.1516999828],
                        [1.083e-08, 0.87622049125, 16173.3711684044],
                        [9.57e-09, 5.29505019432, 1066.49547719],
                        [1.035e-08, 2.44286811558, 1052.2683831884],
                        [1.153e-08, 4.73786864168, 8031.0922630584],
                        [1.042e-08, 1.73541825729, 3369.0616141676],
                        [8.99e-09, 1.87265511538, 3077.528503327],
                        [8.92e-09, 2.51347636401, 3603.6963500726],
                        [9.04e-09, 0.27361540197, 3325.3599555148],
                        [8.83e-09, 5.4653793674, 5614.7293762096],
                        [9.49e-09, 0.04595688771, 7064.1213856228],
                        [8.72e-09, 3.61205859852, 6702.000248892],
                        [8.42e-09, 5.61713543212, 8955.3418029094],
                        [8.42e-09, 0.57536275896, 3191.0492295652],
                        [9.04e-09, 4.11832249537, 3355.8648978848],
                        [1.044e-08, 2.6588954211, 3312.163239232],
                        [8.07e-09, 2.2644325982, 8969.568896911],
                        [1.046e-08, 6.11317298058, 5331.3574437408],
                        [9.33e-09, 0.82551054416, 3503.079062832],
                        [9.46e-09, 1.92368414869, 5628.9564702112],
                        [9.78e-09, 4.55697167317, 3097.88382272579],
                        [8.46e-09, 4.65096242323, 6438.4962494256],
                        [9.01e-09, 1.46788821922, 6660.4494579072],
                        [7.39e-09, 4.97716008834, 10014.7237330986],
                        [7.62e-09, 3.42576079312, 18984.2926300096],
                        [9.34e-09, 0.35014113954, 3264.3463554242],
                        [8.94e-09, 0.34991139502, 10551.528245194],
                        [6.65e-09, 6.05561837558, 7632.9432596502],
                        [6.05e-09, 4.68480399923, 5729.506447149],
                        [5.93e-09, 2.97207045977, 3178.1457905676],
                        [6.17e-09, 2.19529512598, 13362.432453147],
                        [5.79e-09, 3.32303439858, 11081.2192102886],
                        [5.79e-09, 2.31217959727, 6677.6344247478],
                        [5.72e-09, 4.27984088783, 6546.1597733642],
                        [5.84e-09, 4.51625727923, 1648.4467571974],
                        [6.26e-09, 4.60715188203, 2487.4160449478],
                        [6.49e-09, 2.17894376907, 6298.3283211764],
                        [6.17e-09, 4.22635718375, 13362.4669604514],
                        [5.5e-09, 3.11161314141, 6144.4203413042],
                        [5.51e-09, 3.27081871281, 6127.6554505572],
                        [5.36e-09, 0.18973312148, 3346.1353510072],
                        [5.57e-09, 6.13686769377, 26724.8994135984],
                        [5.71e-09, 5.6534146366, 2921.1277828246],
                        [5.52e-09, 5.75724124958, 149.5631971346],
                        [6.38e-09, 4.49647258906, 3.523118349],
                        [5.52e-09, 1.07795672495, 536.8045120954],
                        [5.37e-09, 4.19207200801, 3335.0895023924],
                        [5.67e-09, 2.62806466971, 2648.454825473],
                        [6.41e-09, 3.24534699403, 3347.7259737006],
                        [5.46e-09, 2.76744357149, 5459.3762870782],
                        [5.56e-09, 4.98610303145, 6531.661656265],
                        [5.78e-09, 2.74445077242, 6684.8152820514],
                        [6.13e-09, 3.01718810256, 8270.2977486834],
                        [5.58e-09, 5.89236366633, 6158.6474353058],
                        [4.89e-09, 4.59082197201, 522.5774180938],
                        [4.45e-09, 3.64293918046, 10713.9948813262],
                        [5.39e-09, 0.59284523316, 553.5694028424],
                        [4.34e-09, 1.99641894213, 26087.9031415742],
                        [4.59e-09, 4.84216944554, 1758.6530784168],
                        [4.23e-09, 3.77854586358, 6688.3384004004],
                        [4.21e-09, 3.10245838137, 8329.671610597],
                        [4.21e-09, 4.43540354818, 103.0927742186],
                        [5.02e-09, 3.0314151263, 3360.96774609859],
                        [4.22e-09, 5.99158563064, 242.728603974],
                        [4.01e-09, 2.06012045711, 3980.5097130138],
                        [4.1e-09, 5.85255605682, 3351.2490920496],
                        [3.75e-09, 2.5080334092, 6784.3176276182],
                        [4.07e-09, 0.3011732839, 16304.9131300908],
                        [5.07e-09, 1.350164178, 3320.257107301],
                        [3.85e-09, 1.06248122739, 7234.794256242],
                        [5.19e-09, 4.61705823333, 7373.3824546264],
                        [4.01e-09, 0.51161484292, 17085.9586657222],
                        [3.71e-09, 0.41707432281, 13760.5987102074],
                        [4.76e-09, 0.81142637639, 6816.289933435],
                        [3.48e-09, 3.36497054127, 8439.8779318164],
                        [3.66e-09, 6.05186692577, 3607.2194684216],
                        [4.02e-09, 2.67375675473, 18454.601664915],
                        [4.39e-09, 0.41122589061, 10404.7338123226],
                        [4.12e-09, 4.81039654306, 3329.97576135],
                        [4.13e-09, 0.21011211689, 13149.1506113612],
                        [3.63e-09, 2.19017574725, 9866.4168806652],
                        [3.37e-09, 5.46398740226, 6604.958782124],
                        [3.4e-09, 1.7339266228, 1692.1656695024],
                        [3.44e-09, 3.58310197017, 7107.8230442756],
                        [4.2e-09, 2.77274750272, 2906.900688823],
                        [3.35e-09, 2.02339633221, 3333.5661900018],
                        [3.36e-09, 2.78173647754, 4989.0591838972],
                        [3.54e-09, 5.41265456299, 951.7184062506],
                        [3.28e-09, 0.43464916253, 6923.9534573736],
                        [4.22e-09, 1.5759173708, 8273.8208670324],
                        [3.24e-09, 4.99165215532, 11371.7046897582],
                        [3.51e-09, 4.60766539695, 3074.005384978],
                        [3.33e-09, 4.86991808664, 3863.1898447936],
                        [3.19e-09, 1.44510282827, 11769.8536931664],
                        [2.96e-09, 5.25637576704, 76.2660712756],
                        [3.49e-09, 1.62483962938, 17924.9106998204],
                        [2.93e-09, 2.20643287367, 3347.6586633978],
                        [3.15e-09, 4.5522730677, 5828.0284716476],
                        [2.8e-09, 1.4213429154, 6606.4432548323],
                        [3.36e-09, 1.56854533505, 1581.959348283],
                        [3.43e-09, 0.27605726543, 10973.55568635],
                        [2.71e-09, 0.08314924409, 10235.1363755374],
                        [2.8e-09, 0.76436434398, 853.196381752],
                        [3.17e-09, 4.91466081381, 3443.7052009184],
                        [2.57e-09, 0.15709629188, 12168.0026965746],
                        [2.37e-09, 3.13380421805, 74.7815985673],
                        [2.71e-09, 1.83008759256, 3399.9862886134],
                        [2.33e-09, 3.20163702613, 10177.2576795336],
                        [3.12e-09, 0.28436027987, 13745.3462390224],
                        [2.73e-09, 4.53535816659, 3344.4937620578],
                        [2.35e-09, 0.67980074869, 17395.2197347258],
                        [2.62e-09, 3.84436620806, 9168.6408983474],
                        [2.71e-09, 4.94509131052, 692.1576012268],
                        [2.54e-09, 2.19491751584, 3281.2385647862],
                        [2.2e-09, 1.65400798925, 3546.797975137],
                        [2.83e-09, 5.57884389098, 3973.396166013],
                        [2.29e-09, 5.93153003758, 3364.4908644476],
                        [2.23e-09, 4.82744958322, 9779.1086761254],
                        [2.22e-09, 0.71788606092, 16699.53901515],
                        [2.19e-09, 0.09831940529, 16706.585251848],
                        [2.21e-09, 1.66596576205, 10575.4066829418],
                        [2.59e-09, 1.10208840059, 1744.4259844152],
                        [2.43e-09, 1.52425310144, 14054.607308026],
                        [2.73e-09, 6.12932898811, 3336.7310913418],
                        [2.32e-09, 4.73422268172, 3316.733988952],
                        [2.1e-09, 5.97305256642, 419.4846438752],
                        [2.13e-09, 5.35378111313, 1596.1864422846],
                        [1.97e-09, 3.32400761027, 5085.038411115],
                        [1.93e-09, 0.90522037315, 14314.1681130498],
                        [1.92e-09, 2.63243342989, 433.7117378768],
                        [1.88e-09, 1.14983778034, 13892.1406718938],
                        [2e-09, 4.79567916236, 6261.7402095244],
                        [2.04e-09, 2.3227216771, 13916.0191096416],
                        [1.91e-09, 5.08454560792, 2178.137722292],
                        [1.91e-09, 5.88821293073, 3340.19235060619],
                        [2.36e-09, 0.97341490472, 3230.4061054804],
                        [2e-09, 3.60041329896, 3304.5845600224],
                        [1.65e-09, 2.91701234796, 3415.3940252671],
                        [1.91e-09, 4.7764733812, 3341.0325027934],
                        [1.74e-09, 2.20549134205, 10020.8569590312],
                        [1.61e-09, 2.64795288862, 3304.0070613956],
                        [1.73e-09, 3.54115285115, 10022.8176011676],
                        [1.54e-09, 2.45916882835, 12722.5524204852],
                        [1.6e-09, 1.73968020026, 3377.217792004],
                        [1.96e-09, 0.78013533938, 3376.6402933772],
                        [1.53e-09, 0.27328628499, 13362.3823964964],
                        [1.9e-09, 2.65143864216, 3657.0042963564],
                        [1.72e-09, 5.71092117488, 2384.3232707292],
                        [1.57e-09, 1.00235389487, 3209.0704650134],
                        [1.5e-09, 3.39592748537, 3472.1543883862],
                        [1.65e-09, 5.86551673354, 2803.8079146044],
                        [1.54e-09, 0.32136196834, 6665.9723822146],
                        [1.78e-09, 3.34059693754, 11216.284290324],
                        [1.92e-09, 0.66079944629, 3134.4268782626],
                        [1.61e-09, 2.87915391245, 4392.8808098882],
                        [1.59e-09, 3.72249746113, 13517.8701062334],
                        [1.68e-09, 0.55746622745, 110.2063212194],
                        [1.58e-09, 5.67248197213, 4407.1079038898],
                        [1.61e-09, 1.76789928464, 6709.6740408674],
                        [1.58e-09, 5.50643845256, 13171.0014406876],
                        [1.29e-09, 1.21297315367, 19513.9835951042],
                        [1.73e-09, 0.17070148373, 3024.2205570432],
                        [1.32e-09, 4.25407099272, 16858.4825329332],
                        [1.25e-09, 2.88510294667, 17256.6315363414],
                        [1.24e-09, 2.59724598646, 12310.1813236108],
                        [1.7e-09, 4.05945259741, 2818.035008606],
                        [1.21e-09, 5.23997785185, 9872.2740829648],
                        [1.42e-09, 3.02798835989, 3511.285297319],
                        [1.65e-09, 2.53171951288, 16276.463942623],
                        [1.53e-09, 6.14783670557, 13362.517017102],
                        [1.19e-09, 4.15694365082, 3760.097070575],
                        [1.2e-09, 0.64287725481, 4459.3682188026],
                        [1.3e-09, 4.9500230946, 13553.8979729108],
                        [1.2e-09, 0.17087854222, 8671.9698704406],
                        [1.12e-09, 0.16822264326, 135.0650800354],
                        [1.37e-09, 3.34809361979, 3341.0423098265],
                        [1.25e-09, 1.32195559043, 1349.8674096588],
                        [1.11e-09, 3.14151030451, 13524.9163429314],
                        [1.19e-09, 5.9536134805, 12295.9542296092],
                        [1.31e-09, 5.09769375731, 14158.7477136156],
                        [1.41e-09, 1.37128440708, 3169.9395560806],
                        [1.12e-09, 3.35831868034, 5989.0672521728],
                        [1.04e-09, 5.00696041032, 13119.7211028252],
                        [1.1e-09, 5.23317664736, 1375.7737998458],
                        [1.05e-09, 2.72692368303, 1162.4747044078],
                        [1.04e-09, 1.73769165705, 2221.856634597],
                        [1.37e-09, 1.0457695039, 3340.1825435731],
                        [1.06e-09, 6.13415161313, 162.4666361322],
                        [1.19e-09, 2.63312561442, 7321.1221397136],
                        [1.05e-09, 3.09551802365, 20618.0193585336],
                        [9.9e-10, 4.25515697974, 23539.7073863328],
                        [1.08e-09, 1.01854506729, 3265.8308281325],
                        [1.19e-09, 4.07277528003, 10184.3039162316],
                        [9.6e-10, 1.81122023425, 10001.061884607],
                        [9.3e-10, 3.58905885066, 5099.2655051166],
                        [9.5e-10, 4.94756054764, 3981.490034082],
                        [9.4e-10, 5.3749336802, 13355.3361597984],
                        [9.5e-10, 0.13037485775, 15508.6151232744],
                        [1.03e-09, 0.43484130196, 1861.7458526354],
                        [9e-10, 3.76370412628, 22324.9050567094],
                        [9.1e-10, 3.95041101283, 10042.6126755918],
                        [1.06e-09, 4.30186500383, 640.8776073822],
                        [1.09e-09, 6.18873749839, 1478.8665740644],
                        [8.8e-10, 1.79608901332, 6247.5131155228],
                        [1.02e-09, 5.58754073056, 2766.267628365],
                        [1.1e-09, 0.94707767481, 3274.1250177854],
                        [8.4e-10, 4.45487801845, 6696.4773245846],
                        [8.5e-10, 2.74791518135, 3407.0998356142],
                        [8.7e-10, 4.51145821088, 220.4126424388],
                        [1.01e-09, 5.94930983227, 8425.6508378148],
                        [8.2e-10, 0.01837230371, 9499.2598620056],
                        [8e-10, 0.4255098998, 18052.9295431578],
                        [8.3e-10, 2.96589752213, 6652.7756659318],
                        [8e-10, 4.61446168762, 3914.9572250346],
                        [7.9e-10, 1.50228636499, 2111.6503133776],
                        [8.9e-10, 3.52977975496, 9485.032768004],
                        [8.6e-10, 0.41976545794, 956.2891559706],
                        [8.8e-10, 5.46013317934, 16460.333529525],
                        [9.1e-10, 2.09965252231, 949.1756089698],
                        [1.04e-09, 1.72206104768, 3296.8935143948],
                        [1.03e-09, 1.25691413032, 3384.3313390048],
                        [8.4e-10, 5.78647729498, 5518.7501489918],
                        [7.9e-10, 1.79313426804, 38.1330356378],
                        [7.3e-10, 0.10667695992, 29822.7832363242],
                        [8.7e-10, 2.11654357529, 3450.8187479192],
                        [7.2e-10, 3.89476829327, 9380.9596727172],
                        [7.5e-10, 2.5934030534, 1964.838626854],
                        [9.8e-10, 4.01577665825, 6843.6914895318],
                        [7.4e-10, 5.32032289064, 11766.2632645146],
                        [6.8e-10, 0.04775525953, 2125.8774073792],
                        [6.9e-10, 6.07427052412, 26482.1708096244],
                        [6.9e-10, 2.050189992, 29424.634232916],
                        [8.4e-10, 0.16960920719, 263.0839233728],
                        [6.8e-10, 5.03013252197, 9070.1188738488],
                        [7.6e-10, 2.00296087293, 224.3447957019],
                        [7.8e-10, 2.17362706851, 30220.9322397324],
                        [6.6e-10, 3.85497672006, 19406.6782881746],
                        [6.6e-10, 5.70059718737, 33561.5446664322],
                        [6.7e-10, 0.16600936321, 22743.4093795164],
                        [6.5e-10, 4.65423392949, 2807.3983432562],
                        [6.9e-10, 3.34387224268, 11670.2840372968],
                        [8.7e-10, 4.9783802188, 1118.7557921028],
                        [6.3e-10, 0.1890710618, 30065.5118402982],
                        [6.4e-10, 4.61909647015, 9886.772200064],
                        [7.3e-10, 0.93706647938, 20735.8321614256],
                        [6e-10, 5.83757395809, 8646.0634802536],
                        [6.2e-10, 4.81389895867, 20199.094959633],
                        [5.9e-10, 5.00150762621, 6414.6178116778],
                        [6.8e-10, 3.84252763135, 6571.0185321802],
                        [6.2e-10, 2.81689634717, 6944.3087767724],
                        [6.5e-10, 4.49078808776, 632.7837393132],
                        [5.8e-10, 5.64889513615, 9945.5712088238],
                        [7e-10, 2.51605694403, 9638.9407478762],
                        [5.7e-10, 3.28105791201, 206.1855484372],
                        [5.7e-10, 2.97448265957, 21795.2140916148],
                        [5.6e-10, 2.23565630779, 20995.3929664494],
                        [5.7e-10, 1.88614831237, 18451.078546566],
                        [7.1e-10, 4.82445647307, 8542.970706035],
                        [6.1e-10, 3.659450739, 14421.8316369884],
                        [5.6e-10, 3.13789031275, 8799.988713778],
                        [5.7e-10, 4.89927831599, 9602.3526362242],
                        [6.5e-10, 3.37109873211, 11610.9101753832],
                        [6.7e-10, 1.92945007459, 21265.5231265202],
                        [5.5e-10, 1.95164531764, 9588.1255422226],
                        [5.7e-10, 2.82240075154, 10124.930054318],
                        [5.7e-10, 6.10407356832, 19800.9459562248],
                        [5.5e-10, 5.20976473824, 3237.5196524812],
                        [5.7e-10, 4.12235760406, 10028.9508271002],
                        [5.5e-10, 1.41700952855, 15906.7641266826],
                        [5.3e-10, 2.16328741039, 6418.1409300268],
                        [6e-10, 2.64683840328, 10018.2468514476],
                        [6.8e-10, 5.36539876845, 1228.9621133222],
                        [5.1e-10, 5.73824213507, 6048.4411140864],
                        [5.3e-10, 0.31937174553, 12721.572099417],
                        [5.1e-10, 0.06312524105, 20206.141196331],
                        [4.9e-10, 4.53401402385, 6675.7019290922],
                        [5.1e-10, 1.15475560534, 10156.9023601348],
                        [6.4e-10, 4.5633226877, 16703.0793871512],
                        [6e-10, 3.61007443614, 9468.267877257],
                        [5.9e-10, 3.08413561767, 10025.4277087512],
                        [6.4e-10, 2.53229538141, 16703.0448798468],
                        [5.6e-10, 3.31988072467, 6518.7582172674],
                        [4.7e-10, 1.44559165677, 6643.0918177618],
                        [5e-10, 1.92342238827, 11614.4332937322],
                        [4.7e-10, 4.03794177027, 23958.6317852334],
                        [4.6e-10, 3.70927352724, 8859.3625756916],
                        [6e-10, 2.55506470511, 11780.4903585162],
                        [4.7e-10, 1.69256878711, 6660.8695340008],
                        [4.4e-10, 6.09481217162, 6460.8122109608],
                        [4.4e-10, 2.6304062214, 13936.794505134],
                        [5.3e-10, 0.77878945764, 16865.5287696312],
                        [4.9e-10, 1.8336854455, 17654.7805397496],
                        [4.8e-10, 0.52828042378, 6686.747777707],
                        [4.2e-10, 4.30347553493, 9065.5481241288],
                        [4.2e-10, 5.71964550673, 7203.8022714934],
                        [4.1e-10, 0.98427208931, 20426.571092422],
                        [5.1e-10, 3.54335413699, 20597.2439630412],
                        [4.1e-10, 0.21219617682, 7314.0085927128],
                        [3.8e-10, 2.53074981011, 13207.029307365],
                        [3.9e-10, 5.15577369902, 6670.5881880498],
                        [5.1e-10, 3.25271478667, 7799.9806455024],
                        [4.9e-10, 0.77060706107, 17101.2111369072],
                        [3.8e-10, 6.06684699984, 9389.0535407862],
                        [4.3e-10, 0.51983815091, 16489.763038061],
                        [3.6e-10, 0.84102576439, 23937.856389741],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00350068845, 5.36847836211, 3340.6124266998],
                        [0.0001411603, 3.14159265359, 0],
                        [9.670755e-05, 5.47877786506, 6681.2248533996],
                        [1.471918e-05, 3.20205766795, 10021.8372800994],
                        [4.25864e-06, 3.40843812875, 13362.4497067992],
                        [1.02039e-06, 0.77617286189, 3337.0893083508],
                        [7.8848e-07, 3.71768293865, 16703.062133499],
                        [2.6171e-07, 2.48293558065, 2281.2304965106],
                        [3.2708e-07, 3.45803723682, 5621.8429232104],
                        [2.0712e-07, 1.44120802297, 6151.533888305],
                        [1.8294e-07, 6.03102943125, 529.6909650946],
                        [1.568e-07, 3.93075566599, 8962.4553499102],
                        [1.6975e-07, 4.81115186866, 3344.1355450488],
                        [1.3067e-07, 0.97324736181, 6677.7017350506],
                        [1.5622e-07, 2.78241383265, 3340.5951730476],
                        [1.5622e-07, 4.81318636318, 3340.629680352],
                        [1.3771e-07, 1.67983063909, 3532.0606928114],
                        [1.2711e-07, 4.04546734935, 20043.6745601988],
                        [1.4268e-07, 0.24640247719, 2942.4634232916],
                        [1.2493e-07, 2.25620513522, 5884.9268465832],
                        [8.8e-08, 0.34079528233, 398.1490034082],
                        [8.637e-08, 1.75213704409, 2544.3144198834],
                        [8.903e-08, 5.95437916504, 2810.9214616052],
                        [8.102e-08, 0.84279830287, 6283.0758499914],
                        [9.25e-08, 4.35071778619, 3496.032826134],
                        [8.085e-08, 4.29614034209, 6684.7479717486],
                        [5.811e-08, 3.55479498415, 5092.1519581158],
                        [5.864e-08, 3.69652093329, 5486.777843175],
                        [5.618e-08, 0.03475872145, 3185.1920272656],
                        [5.148e-08, 0.85886443528, 3340.545116397],
                        [5.145e-08, 0.45169791514, 3340.6797370026],
                        [4.898e-08, 4.12922007874, 1059.3819301892],
                        [3.471e-08, 5.07253485267, 5088.6288397668],
                        [3.102e-08, 3.11487063736, 3339.6321056316],
                        [3.013e-08, 1.00910437496, 2914.0142358238],
                        [3.171e-08, 1.24730004776, 3738.761430108],
                        [3.194e-08, 2.86899092087, 1751.539531416],
                        [2.304e-08, 1.38460565999, 3870.3033917944],
                        [2.233e-08, 2.91238180064, 3894.1818295422],
                        [2.792e-08, 4.27117916474, 8432.7643848156],
                        [2.431e-08, 0.14615904873, 4690.4798363586],
                        [2.577e-08, 2.78651098185, 6254.6266625236],
                        [1.996e-08, 1.51200589223, 4292.3308329504],
                        [1.86e-08, 5.15222219319, 796.2980068164],
                        [2.014e-08, 5.48528849094, 3127.3133312618],
                        [1.922e-08, 4.37668623732, 23384.2869868986],
                        [2.248e-08, 4.46756441051, 10025.3603984484],
                        [1.782e-08, 2.70229954651, 4136.9104335162],
                        [1.621e-08, 2.26742355334, 3149.1641605882],
                        [1.452e-08, 1.53948251192, 9492.1463150048],
                        [1.373e-08, 3.20232312108, 2146.1654164752],
                        [1.332e-08, 5.6796683701, 1592.5960136328],
                        [1.378e-08, 4.12087865376, 3723.508958923],
                        [1.215e-08, 0.33914405698, 6674.1113063988],
                        [1.168e-08, 3.52407129935, 11773.3768115154],
                        [1.179e-08, 6.15475441355, 213.299095438],
                        [1.173e-08, 1.2603660844, 3341.592747768],
                        [1.211e-08, 0.97241747335, 6467.9257579616],
                        [1.204e-08, 0.95200561837, 10018.3141617504],
                        [1.107e-08, 1.44142157852, 2787.0430238574],
                        [1.194e-08, 0.84501638145, 1194.4470102246],
                        [1.043e-08, 3.98123209815, 12303.06777661],
                        [1.029e-08, 1.21951732572, 4535.0594369244],
                        [9.39e-09, 2.99716248257, 7477.522860216],
                        [1.303e-08, 1.12409937702, 4399.994356889],
                        [1.032e-08, 4.26592917807, 1990.745017041],
                        [1.23e-08, 0.37904885593, 6525.8044539654],
                        [9.89e-09, 2.37220445455, 9225.539273283],
                        [9.46e-09, 3.14940196742, 6489.776587288],
                        [1.013e-08, 5.90131661122, 3097.88382272579],
                        [9.13e-09, 2.86098924372, 2388.8940204492],
                        [9.54e-09, 4.90448639106, 3583.3410306738],
                        [8.66e-09, 4.92421595837, 6681.2421070518],
                        [7.97e-09, 4.53307543814, 7079.3738568078],
                        [8.66e-09, 2.89344915945, 6681.2075997474],
                        [6.59e-09, 0.33901474348, 2957.7158944766],
                        [6.7e-09, 3.23650405278, 9595.2390892234],
                        [7.82e-09, 1.56739177814, 3333.498879699],
                        [6.41e-09, 4.4691872125, 6836.6452528338],
                        [6.11e-09, 3.97393774087, 6041.3275670856],
                        [7.38e-09, 3.7871562478, 4562.4609930212],
                        [5.58e-09, 2.92718433901, 1589.0728952838],
                        [5.13e-09, 0.96852780537, 9623.6882766912],
                        [5.08e-09, 4.07262127921, 7.1135470008],
                        [5.12e-09, 1.53960708348, 7740.6067835888],
                        [4.81e-09, 3.51023225206, 155.4203994342],
                        [5.28e-09, 6.0619072177, 4933.2084403326],
                        [5.58e-09, 2.09491968451, 2288.3440435114],
                        [4.45e-09, 3.4243988628, 6680.2445323314],
                        [4.82e-09, 4.73460866232, 13365.9728251482],
                        [5.34e-09, 4.88536251621, 3361.3878221922],
                        [5.2e-09, 6.19100285186, 6438.4962494256],
                        [4.41e-09, 1.82408206251, 3325.3599555148],
                        [4.87e-09, 2.72879191049, 3319.8370312074],
                        [4.17e-09, 4.48716253276, 7903.073419721],
                        [4.3e-09, 0.62845892205, 5614.7293762096],
                        [3.95e-09, 4.89021898045, 10419.9862835076],
                        [3.8e-09, 1.91138845097, 3553.9115221378],
                        [3.58e-09, 4.21584518245, 426.598190876],
                        [4.09e-09, 4.53421956625, 3360.96774609859],
                        [4.26e-09, 5.47172830908, 3205.5473466644],
                        [3.3e-09, 1.00078638665, 8955.3418029094],
                        [3.22e-09, 2.42607399606, 2274.1169495098],
                        [3.16e-09, 3.2206408943, 1221.8485663214],
                        [3.12e-09, 3.66073476074, 3337.021998048],
                        [3.1e-09, 4.09100416919, 3344.2028553516],
                        [2.95e-09, 2.87635162282, 7210.9158184942],
                        [3.29e-09, 5.64440592793, 12832.7587417046],
                        [3.06e-09, 1.52567836482, 7875.6718636242],
                        [2.84e-09, 0.56373187712, 6681.2921637024],
                        [3.58e-09, 4.21258737082, 1052.2683831884],
                        [3.47e-09, 1.52200237477, 10213.285546211],
                        [2.68e-09, 3.57749600251, 9830.3890139878],
                        [3.46e-09, 1.65247014273, 6682.2051744678],
                        [2.69e-09, 4.4518241708, 9381.9399937854],
                        [2.85e-09, 0.97118840317, 6681.1575430968],
                        [2.56e-09, 3.67744143301, 1066.49547719],
                        [2.69e-09, 1.78448639785, 6127.6554505572],
                        [3.12e-09, 4.63751658715, 5331.3574437408],
                        [3.17e-09, 6.15274242841, 3320.257107301],
                        [2.45e-09, 4.71030710599, 26724.8994135984],
                        [2.49e-09, 3.31328995337, 10818.1352869158],
                        [2.4e-09, 4.87364672707, 6144.4203413042],
                        [2.39e-09, 1.35709001659, 7064.1213856228],
                        [2.37e-09, 3.19837233399, 5729.506447149],
                        [2.78e-09, 1.5084206034, 4929.6853219836],
                        [2.74e-09, 3.61160906396, 191.4482661116],
                        [2.48e-09, 3.93789974497, 11243.6858464208],
                        [2.42e-09, 2.57630671866, 3355.8648978848],
                        [2.41e-09, 1.89683861728, 15643.6802033098],
                        [2.28e-09, 0.71217112323, 9866.4168806652],
                        [2.46e-09, 0.16913226579, 2700.7151403858],
                        [2.19e-09, 0.03864812268, 522.5774180938],
                        [2.15e-09, 3.44260776071, 8827.3902698748],
                        [2.06e-09, 5.23615052385, 6923.9534573736],
                        [2.02e-09, 0.60277862639, 10021.8200264472],
                        [2.26e-09, 2.4333250327, 8429.2412664666],
                        [2.02e-09, 2.63373646725, 10021.8545337516],
                        [1.99e-09, 3.26545613445, 382.8965322232],
                        [1.98e-09, 4.50685315424, 242.728603974],
                        [2.15e-09, 2.12744795327, 553.5694028424],
                        [1.77e-09, 3.92599588022, 8031.0922630584],
                        [1.62e-09, 3.94498519498, 2921.1277828246],
                        [1.99e-09, 4.22948972595, 3312.163239232],
                        [1.88e-09, 0.67072289565, 6298.3283211764],
                        [1.6e-09, 2.90951395323, 6872.6731195112],
                        [1.55e-09, 1.24529852403, 3364.4908644476],
                        [1.86e-09, 2.44723831367, 3503.079062832],
                        [1.39e-09, 5.7549355704, 7632.9432596502],
                        [1.49e-09, 0.49665393273, 8969.568896911],
                        [1.32e-09, 4.97828413367, 1748.016413067],
                        [1.3e-09, 0.66881298338, 10014.7237330986],
                        [1.28e-09, 2.80753554051, 14584.2982731206],
                        [1.76e-09, 2.37291314099, 2118.7638603784],
                        [1.27e-09, 1.76223414864, 11081.2192102886],
                        [1.27e-09, 0.26234206855, 13358.9265884502],
                        [1.63e-09, 5.83356697025, 639.897286314],
                        [1.29e-09, 2.02607662846, 3346.1353510072],
                        [1.55e-09, 1.5718930764, 3767.2106175758],
                        [1.33e-09, 4.20989922795, 11371.7046897582],
                        [1.14e-09, 2.12636383988, 6688.3384004004],
                        [1.3e-09, 1.33114943655, 3347.7259737006],
                        [1.1e-09, 5.78893316282, 16173.3711684044],
                        [1.05e-09, 3.27202438053, 15113.9892382152],
                        [1.17e-09, 5.66812806862, 536.8045120954],
                        [1.06e-09, 1.21268139587, 7234.794256242],
                        [1.08e-09, 0.94652521237, 9808.5381846614],
                        [1.21e-09, 4.22204758443, 6158.6474353058],
                        [1.24e-09, 4.92495255567, 12964.300703391],
                        [1.42e-09, 3.85764234922, 6894.5239488376],
                        [9.9e-10, 5.62543167, 10973.55568635],
                        [1e-09, 2.56456804207, 3178.1457905676],
                        [1.31e-09, 0.08971075365, 8273.8208670324],
                        [1.12e-09, 3.14240135508, 3316.733988952],
                        [9.5e-10, 0.64723185059, 2487.4160449478],
                        [8.7e-10, 4.14322802003, 3603.6963500726],
                        [8.7e-10, 3.50260474148, 3077.528503327],
                        [9.6e-10, 5.13010621713, 3304.5845600224],
                        [8.2e-10, 4.87880877413, 5828.0284716476],
                        [8.3e-10, 2.04400907684, 18984.2926300096],
                        [8.5e-10, 3.33671991814, 1758.6530784168],
                        [9.9e-10, 3.28955694324, 17654.7805397496],
                        [7.8e-10, 0.89238228021, 2699.7348193176],
                        [9.5e-10, 0.32948273562, 3863.1898447936],
                        [8.3e-10, 0.80327899268, 5085.038411115],
                        [9.1e-10, 1.48623539837, 8270.2977486834],
                        [7.5e-10, 4.91191036053, 10021.7699697966],
                        [7.9e-10, 4.25171159471, 7373.3824546264],
                        [8.4e-10, 2.16662156833, 12566.1516999828],
                        [8.8e-10, 2.78893554858, 11769.8536931664],
                        [9.5e-10, 0.29428946155, 5628.9564702112],
                        [7.6e-10, 5.23354729169, 13760.5987102074],
                        [9.2e-10, 1.40883592065, 3336.7310913418],
                        [6.9e-10, 3.5047791691, 10713.9948813262],
                        [7.9e-10, 0.61833410504, 951.7184062506],
                        [7e-10, 1.93458925881, 3475.6775067352],
                        [6.6e-10, 5.01996258363, 16706.585251848],
                        [6.7e-10, 3.68731475523, 4032.7700279266],
                        [7.1e-10, 1.71691035008, 10575.4066829418],
                        [8.6e-10, 1.82073461894, 10404.7338123226],
                        [6.4e-10, 2.43149744819, 2648.454825473],
                        [6.2e-10, 0.25250107112, 3980.5097130138],
                        [6.2e-10, 3.1642052001, 13517.8701062334],
                        [7.8e-10, 1.41762772678, 3.523118349],
                        [8.6e-10, 3.34935714534, 1581.959348283],
                        [6.4e-10, 3.75812808116, 1596.1864422846],
                        [6.1e-10, 1.37421861116, 419.4846438752],
                        [5.5e-10, 1.11154560464, 433.7117378768],
                        [6.1e-10, 5.33515994167, 853.196381752],
                        [5.9e-10, 0.8038238079, 13362.432453147],
                        [5.5e-10, 0.37478855406, 149.5631971346],
                        [5.3e-10, 0.55329112916, 14314.1681130498],
                        [5.9e-10, 0.07234691744, 6531.661656265],
                        [5.9e-10, 2.83458587563, 13362.4669604514],
                        [5.9e-10, 4.13409540555, 4407.1079038898],
                        [5.7e-10, 5.57913927474, 3376.6402933772],
                        [4.9e-10, 4.58036235824, 10551.528245194],
                        [5e-10, 2.01769015785, 10022.8176011676],
                        [5.5e-10, 1.36081433917, 21393.5419698576],
                        [4.8e-10, 1.59939595487, 18052.9295431578],
                        [4.5e-10, 4.97928157994, 8671.9698704406],
                        [4.4e-10, 2.58542985685, 13916.0191096416],
                        [4.7e-10, 1.40206686464, 8425.6508378148],
                        [4.3e-10, 0.21864618144, 9779.1086761254],
                        [4.2e-10, 6.22365857047, 3914.9572250346],
                        [4.8e-10, 3.44104044998, 692.1576012268],
                        [4.3e-10, 3.21191030055, 6247.5131155228],
                        [5.5e-10, 4.013214817, 10177.2576795336],
                        [5.3e-10, 2.9328571132, 3981.490034082],
                        [3.9e-10, 5.54634215618, 6702.000248892],
                        [4.1e-10, 2.46188112193, 6660.4494579072],
                        [4.9e-10, 3.0423606533, 640.8776073822],
                        [3.9e-10, 1.62689158397, 3335.0895023924],
                        [3.8e-10, 3.31198341709, 1744.4259844152],
                        [3.8e-10, 6.16317067723, 2818.035008606],
                        [3.8e-10, 4.03534957207, 103.0927742186],
                        [4.4e-10, 0.91040525278, 5459.3762870782],
                        [4.9e-10, 1.88325571471, 11216.284290324],
                        [4.6e-10, 5.62762941168, 9168.6408983474],
                        [3.5e-10, 1.65976191407, 12168.0026965746],
                        [4.7e-10, 4.52334272666, 10021.9045904022],
                        [3.9e-10, 2.08367076229, 13745.3462390224],
                        [3.9e-10, 4.76186135572, 20597.2439630412],
                        [3.9e-10, 3.00951950244, 3344.4937620578],
                        [3.7e-10, 1.33065895739, 12295.9542296092],
                        [4e-10, 3.96893429107, 13171.0014406876],
                        [3.2e-10, 0.91212661789, 12310.1813236108],
                        [3.2e-10, 2.22618836835, 7107.8230442756],
                        [3.2e-10, 4.9607870365, 24734.1543965574],
                        [3.7e-10, 3.30085609301, 20995.3929664494],
                        [3.3e-10, 3.70858397913, 10020.8569590312],
                        [3.1e-10, 4.18674524484, 17256.6315363414],
                        [3.4e-10, 3.25657016622, 14054.607308026],
                        [3.2e-10, 5.75360661734, 6546.1597733642],
                        [3.1e-10, 3.16209740784, 12935.8515159232],
                        [3.7e-10, 2.14901622101, 6665.9723822146],
                        [3e-10, 0.21926429217, 6660.8695340008],
                        [3e-10, 3.55459460301, 9070.1188738488],
                        [2.9e-10, 2.97927335664, 2766.267628365],
                        [2.9e-10, 4.65051930186, 10235.1363755374],
                        [3e-10, 5.168824354, 16304.9131300908],
                        [3.2e-10, 5.01760544488, 3191.0492295652],
                        [2.9e-10, 2.93988761068, 6696.4773245846],
                        [2.9e-10, 5.06447742493, 5099.2655051166],
                        [2.9e-10, 5.68073325802, 3329.97576135],
                        [2.9e-10, 0.43949269085, 3351.2490920496],
                        [3.2e-10, 1.37056688814, 6040.3472460174],
                        [3.2e-10, 1.42334455474, 76.2660712756],
                        [3.3e-10, 0.36423446435, 6604.958782124],
                        [3.3e-10, 4.85478789063, 6701.5801727984],
                        [3e-10, 3.33348460172, 3369.0616141676],
                        [2.8e-10, 0.60182098585, 11766.2632645146],
                        [2.6e-10, 1.05197848649, 13207.029307365],
                        [2.6e-10, 5.03535225585, 30065.5118402982],
                        [3.4e-10, 3.65553061498, 14158.7477136156],
                        [2.5e-10, 4.60925601393, 8329.671610597],
                        [2.5e-10, 2.05970140678, 17395.2197347258],
                        [3e-10, 5.22285260441, 9485.032768004],
                        [2.5e-10, 4.84964369679, 1648.4467571974],
                        [2.6e-10, 5.47626814223, 3074.005384978],
                        [2.4e-10, 2.45239543931, 17085.9586657222],
                        [2.9e-10, 5.36428737888, 2707.8286873866],
                        [2.4e-10, 5.574885448, 10264.5658840734],
                        [2.5e-10, 4.22744782935, 1692.1656695024],
                        [2.3e-10, 6.09244870438, 20199.094959633],
                        [2.8e-10, 1.30366587075, 8439.8779318164],
                        [3.2e-10, 2.13597148493, 9468.267877257],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [0.0001672669, 0.60221392419, 3340.6124266998],
                        [4.986799e-05, 3.14159265359, 0],
                        [3.02141e-06, 5.55871276021, 6681.2248533996],
                        [2.5767e-07, 1.89662673499, 13362.4497067992],
                        [2.1452e-07, 0.91749968618, 10021.8372800994],
                        [1.182e-07, 2.242407387, 3337.0893083508],
                        [7.985e-08, 2.24892866611, 16703.062133499],
                        [2.96e-08, 5.89425825808, 3496.032826134],
                        [2.445e-08, 5.18770525274, 5621.8429232104],
                        [1.428e-08, 1.2523814058, 2281.2304965106],
                        [1.779e-08, 2.5875996852, 20043.6745601988],
                        [1.501e-08, 3.18533003542, 3532.0606928114],
                        [1.259e-08, 4.80695172904, 3185.1920272656],
                        [1.029e-08, 2.35029907056, 6677.7017350506],
                        [1.109e-08, 3.80982317372, 5884.9268465832],
                        [9.28e-09, 0.29719160927, 3344.1355450488],
                        [8.6e-09, 3.1169831893, 6151.533888305],
                        [8.53e-09, 1.33003321402, 529.6909650946],
                        [8.83e-09, 5.18681316017, 5486.777843175],
                        [1.1e-08, 1.82962075794, 2942.4634232916],
                        [8.15e-09, 3.40910567373, 2544.3144198834],
                        [7.02e-09, 5.49076132554, 8962.4553499102],
                        [6.44e-09, 0.31400306761, 5088.6288397668],
                        [7.45e-09, 4.30248377111, 3340.5951730476],
                        [5.86e-09, 4.48071459693, 3894.1818295422],
                        [6.81e-09, 5.40951261308, 2810.9214616052],
                        [7.45e-09, 0.05006463495, 3340.629680352],
                        [5.42e-09, 4.68895461946, 3339.6321056316],
                        [4.97e-09, 4.65665197749, 5092.1519581158],
                        [4.6e-09, 1.0667034361, 3097.88382272579],
                        [4.23e-09, 3.08034568777, 4292.3308329504],
                        [3.81e-09, 2.2493311519, 6283.0758499914],
                        [4.29e-09, 1.70668733378, 4690.4798363586],
                        [3.39e-09, 2.92195933142, 23384.2869868986],
                        [3.1e-09, 5.63324402105, 3723.508958923],
                        [2.87e-09, 1.98619629868, 398.1490034082],
                        [2.98e-09, 2.58990636818, 6684.7479717486],
                        [3.23e-09, 5.1523014439, 6525.8044539654],
                        [2.47e-09, 2.36923535528, 3340.545116397],
                        [2.47e-09, 1.96071951597, 3340.6797370026],
                        [2.23e-09, 4.75562842441, 2146.1654164752],
                        [2.4e-09, 3.53331653789, 3583.3410306738],
                        [2.38e-09, 4.69268478666, 6254.6266625236],
                        [1.98e-09, 6.21548965568, 2787.0430238574],
                        [2.02e-09, 4.25439775032, 3333.498879699],
                        [1.58e-09, 1.89216973387, 6674.1113063988],
                        [1.85e-09, 2.99350590687, 10025.3603984484],
                        [1.77e-09, 1.41002572971, 6438.4962494256],
                        [1.38e-09, 1.23172102079, 3127.3133312618],
                        [1.53e-09, 5.93528616595, 6836.6452528338],
                        [1.06e-09, 5.35414400998, 3738.761430108],
                        [1.02e-09, 3.67040445208, 1059.3819301892],
                        [1.36e-09, 1.06039656714, 2388.8940204492],
                        [9.3e-10, 5.04434801864, 155.4203994342],
                        [9.3e-10, 2.7081739491, 8955.3418029094],
                        [1.08e-09, 6.13917250674, 1748.016413067],
                        [1.16e-09, 5.9773948353, 2914.0142358238],
                        [9.9e-10, 1.50221319099, 1751.539531416],
                        [9.2e-10, 2.68470906437, 1990.745017041],
                        [7.7e-10, 4.01966292109, 1592.5960136328],
                        [7.6e-10, 4.49660101731, 4562.4609930212],
                        [7.6e-10, 5.67354102576, 6041.3275670856],
                        [7.8e-10, 0.79220883728, 2288.3440435114],
                        [7.4e-10, 5.84795427965, 3341.592747768],
                        [8e-10, 5.48556941416, 8432.7643848156],
                        [6.5e-10, 2.11705931744, 10018.3141617504],
                        [6.6e-10, 5.08073805943, 2957.7158944766],
                        [5.9e-10, 3.79695096075, 6923.9534573736],
                        [6.1e-10, 4.51116100631, 4933.2084403326],
                        [5.9e-10, 0.27765984344, 6127.6554505572],
                        [5.2e-10, 5.84885902302, 4535.0594369244],
                        [5.1e-10, 1.45495904398, 7477.522860216],
                        [5.4e-10, 1.50278239577, 6489.776587288],
                        [5.6e-10, 5.23212313891, 9866.4168806652],
                        [5.7e-10, 4.73711357046, 2274.1169495098],
                        [5.1e-10, 2.48654805044, 6467.9257579616],
                        [4.7e-10, 3.25899585469, 26724.8994135984],
                        [4.8e-10, 1.12255878532, 1349.8674096588],
                        [4.8e-10, 2.87122326236, 242.728603974],
                        [4.5e-10, 1.61358524585, 5729.506447149],
                        [4.3e-10, 2.2433473149, 7.1135470008],
                        [4.4e-10, 4.61065704096, 11773.3768115154],
                        [4.2e-10, 3.32038536161, 13365.9728251482],
                        [4.7e-10, 5.10736479739, 8969.568896911],
                        [4.4e-10, 4.64194663616, 4399.994356889],
                        [3.9e-10, 5.45779680648, 8031.0922630584],
                        [4.4e-10, 5.2140954242, 4136.9104335162],
                        [4.5e-10, 4.2620606379, 796.2980068164],
                        [4.8e-10, 3.04342098072, 5331.3574437408],
                        [4.2e-10, 2.12882700518, 213.299095438],
                        [3.8e-10, 2.49365585516, 951.7184062506],
                        [3.7e-10, 3.44816851943, 3325.3599555148],
                        [3.8e-10, 3.1398138598, 3149.1641605882],
                        [3.9e-10, 3.6498494618, 553.5694028424],
                        [3.6e-10, 0.54858124109, 7632.9432596502],
                        [3.2e-10, 4.29985057106, 3355.8648978848],
                        [3.7e-10, 6.26349600634, 6682.2051744678],
                        [3.7e-10, 3.83188032092, 3870.3033917944],
                        [3.1e-10, 4.94959395405, 6680.2445323314],
                        [3.5e-10, 6.14813219827, 3360.96774609859],
                        [2.9e-10, 0.54115054572, 6681.2921637024],
                        [3.5e-10, 1.49899662719, 3320.257107301],
                        [3.3e-10, 0.19183878029, 3347.7259737006],
                        [3.6e-10, 3.28055425527, 1589.0728952838],
                        [3.1e-10, 5.66015228291, 1066.49547719],
                        [2.8e-10, 4.1817845554, 7210.9158184942],
                        [2.5e-10, 1.21627749818, 9492.1463150048],
                        [2.9e-10, 2.02283118033, 7234.794256242],
                        [2.4e-10, 2.96777681837, 7064.1213856228],
                        [2.4e-10, 2.16823248221, 10419.9862835076],
                        [2.2e-10, 4.67496434823, 1194.4470102246],
                        [2.2e-10, 5.01797528499, 9595.2390892234],
                        [2.8e-10, 4.19843924702, 8429.2412664666],
                        [2.3e-10, 6.2119501005, 7740.6067835888],
                        [2.5e-10, 1.45100528915, 6872.6731195112],
                        [2.4e-10, 1.93342510858, 2699.7348193176],
                        [2.8e-10, 5.8700989815, 1052.2683831884],
                        [2.5e-10, 2.49707182259, 2118.7638603784],
                        [2e-10, 0.15682384975, 3205.5473466644],
                        [1.9e-10, 3.82087005916, 12303.06777661],
                        [2e-10, 6.26534330674, 7875.6718636242],
                        [1.9e-10, 0.99282533197, 522.5774180938],
                        [1.8e-10, 4.11668144665, 426.598190876],
                        [2e-10, 3.28531167827, 9225.539273283],
                        [1.9e-10, 5.72169822815, 11371.7046897582],
                        [1.8e-10, 4.76871968197, 382.8965322232],
                        [1.7e-10, 0.96519535826, 191.4482661116],
                        [1.7e-10, 0.86184324841, 10973.55568635],
                        [1.8e-10, 6.22706341047, 9381.9399937854],
                        [1.5e-10, 0.54135050421, 640.8776073822],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [6.06506e-06, 1.98050633529, 3340.6124266998],
                        [4.2611e-07, 0, 0],
                        [1.3652e-07, 1.795882288, 6681.2248533996],
                        [2.73e-08, 3.45377082121, 10021.8372800994],
                        [9.29e-09, 3.75226159072, 3337.0893083508],
                        [6.07e-09, 0.10618486408, 13362.4497067992],
                        [6.17e-09, 1.14471772765, 3496.032826134],
                        [4.79e-09, 0.70504966293, 16703.062133499],
                        [1.85e-09, 3.28778562029, 3185.1920272656],
                        [1.69e-09, 0.29980532608, 5621.8429232104],
                        [1.58e-09, 1.09025317222, 20043.6745601988],
                        [1.23e-09, 2.55664973413, 3097.88382272579],
                        [1.26e-09, 4.74517022983, 3532.0606928114],
                        [9.3e-10, 6.03607685759, 3894.1818295422],
                        [9.9e-10, 4.92257049901, 2544.3144198834],
                        [1.06e-09, 3.41315845439, 2942.4634232916],
                        [6.2e-10, 6.257389499, 3339.6321056316],
                        [5.8e-10, 4.64867983361, 4292.3308329504],
                        [5e-10, 3.75358626972, 6677.7017350506],
                        [5e-10, 1.89408668049, 5088.6288397668],
                        [5.8e-10, 3.65295480755, 6525.8044539654],
                        [4.5e-10, 0.38295906298, 5486.777843175],
                        [5.2e-10, 3.25535694335, 4690.4798363586],
                        [4.4e-10, 1.89342588822, 3583.3410306738],
                        [3.7e-10, 0.04871920725, 2146.1654164752],
                        [3.9e-10, 0.91787211117, 3723.508958923],
                        [5.1e-10, 5.24063514394, 5884.9268465832],
                        [3.6e-10, 2.79633276263, 529.6909650946],
                        [3.2e-10, 1.44641701752, 23384.2869868986],
                        [2.4e-10, 5.41362501363, 3340.5951730476],
                        [2.3e-10, 4.70639896508, 2787.0430238574],
                        [2.1e-10, 1.12581894224, 3340.629680352],
                        [2.1e-10, 0.51744721589, 8962.4553499102],
                        [1.8e-10, 0.36433365806, 155.4203994342],
                        [1.8e-10, 5.53170427847, 3333.498879699],
                        [1.9e-10, 4.34401282378, 6151.533888305],
                        [2.1e-10, 2.9476550159, 398.1490034082],
                        [2e-10, 5.96181389299, 5092.1519581158],
                        [1.7e-10, 0.80891817293, 1194.4470102246],
                        [1.1e-10, 0.43817745316, 1059.3819301892],
                        [1.4e-10, 1.06654064248, 6836.6452528338],
                      ],
          },
          {
            series => "B4",
            terms  => [
                        [1.1334e-07, 3.45724352586, 3340.6124266998],
                        [1.3369e-07, 0, 0],
                        [7.44e-09, 0.50445805257, 6681.2248533996],
                        [1.48e-09, 1.05056602649, 10021.8372800994],
                        [1.02e-09, 2.66185835593, 3496.032826134],
                        [5.3e-10, 5.27888218929, 3337.0893083508],
                        [2.2e-10, 4.09971603267, 3097.88382272579],
                        [2.3e-10, 1.7242234213, 3185.1920272656],
                        [1.3e-10, 5.41704779112, 16703.062133499],
                        [1.3e-10, 2.06957065662, 13362.4497067992],
                        [1e-10, 0.959895956, 3894.1818295422],
                      ],
          },
          {
            series => "B5",
            terms  => [
                        [4.57e-09, 4.86794125358, 3340.6124266998],
                        [5.3e-10, 5.30547050586, 6681.2248533996],
                        [1.2e-10, 5.75114070583, 10021.8372800994],
                        [1.3e-10, 4.17736925293, 3496.032826134],
                        [7e-11, 0, 0],
                      ],
          },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [1.53033488276, 0, 0],
                        [0.14184953153, 3.47971283519, 3340.6124266998],
                        [0.00660776357, 3.81783442097, 6681.2248533996],
                        [0.00046179117, 4.15595316284, 10021.8372800994],
                        [8.109738e-05, 5.55958460165, 2810.9214616052],
                        [7.485315e-05, 1.77238998069, 5621.8429232104],
                        [5.523193e-05, 1.3643631888, 2281.2304965106],
                        [3.82516e-05, 4.49407182408, 13362.4497067992],
                        [2.306539e-05, 0.09081742493, 2544.3144198834],
                        [1.999399e-05, 5.36059605227, 3337.0893083508],
                        [2.484385e-05, 4.92545577893, 2942.4634232916],
                        [1.960198e-05, 4.74249386323, 3344.1355450488],
                        [1.167115e-05, 2.11261501155, 5092.1519581158],
                        [1.102828e-05, 5.0090826416, 398.1490034082],
                        [8.99077e-06, 4.40790433994, 529.6909650946],
                        [9.92252e-06, 5.83862401067, 6151.533888305],
                        [8.07348e-06, 2.10216647104, 1059.3819301892],
                        [7.9791e-06, 3.44839026172, 796.2980068164],
                        [7.4098e-06, 1.49906336892, 2146.1654164752],
                        [6.9234e-06, 2.13378814785, 8962.4553499102],
                        [6.33144e-06, 0.89353285018, 3340.5951730476],
                        [7.25583e-06, 1.24516913473, 8432.7643848156],
                        [6.3314e-06, 2.92430448169, 3340.629680352],
                        [5.74352e-06, 0.82896196337, 2914.0142358238],
                        [5.26187e-06, 5.38292276228, 3738.761430108],
                        [6.29976e-06, 1.28738135858, 1751.539531416],
                        [4.72776e-06, 5.19850457873, 3127.3133312618],
                        [3.48095e-06, 4.83219198908, 16703.062133499],
                        [2.83702e-06, 2.90692294913, 3532.0606928114],
                        [2.79552e-06, 5.25749247548, 6283.0758499914],
                        [2.33827e-06, 5.10546492529, 5486.777843175],
                        [2.19428e-06, 5.58340248784, 191.4482661116],
                        [2.69891e-06, 3.76394728622, 5884.9268465832],
                        [2.08333e-06, 5.25476080773, 3340.545116397],
                        [2.75224e-06, 2.90818883832, 1748.016413067],
                        [2.75501e-06, 1.21767967781, 6254.6266625236],
                        [2.39133e-06, 2.03669896238, 1194.4470102246],
                        [2.2319e-06, 4.19861593779, 3149.1641605882],
                        [1.82686e-06, 5.08062683355, 6684.7479717486],
                        [1.86213e-06, 5.69871555748, 6677.7017350506],
                        [1.75995e-06, 5.95341786369, 3870.3033917944],
                        [1.78613e-06, 4.18423025538, 3333.498879699],
                        [2.08336e-06, 4.84626442122, 3340.6797370026],
                        [2.28128e-06, 3.2552902062, 6872.6731195112],
                        [1.44286e-06, 0.21296012258, 5088.6288397668],
                        [1.63534e-06, 3.79889068111, 4136.9104335162],
                        [1.3312e-06, 1.5391010671, 7903.073419721],
                        [1.41759e-06, 2.47790321309, 4562.4609930212],
                        [1.14941e-06, 4.31745088059, 1349.8674096588],
                        [1.18781e-06, 2.12178071222, 1589.0728952838],
                        [1.02096e-06, 6.18138550087, 9492.1463150048],
                        [1.28555e-06, 5.49883294915, 8827.3902698748],
                        [1.11538e-06, 0.55339169625, 11243.6858464208],
                        [8.2498e-07, 1.6222704459, 11773.3768115154],
                        [8.3212e-07, 0.61553380568, 8429.2412664666],
                        [8.447e-07, 0.6227459311, 1592.5960136328],
                        [8.6659e-07, 1.74988330093, 2700.7151403858],
                        [7.1826e-07, 2.47489899385, 12303.06777661],
                        [8.5312e-07, 1.61621097912, 4690.4798363586],
                        [6.3641e-07, 2.67334126661, 426.598190876],
                        [6.8599e-07, 2.40197828418, 4399.994356889],
                        [5.8559e-07, 4.72052787516, 213.299095438],
                        [6.2015e-07, 1.10065866221, 1221.8485663214],
                        [6.6509e-07, 2.21307705185, 6041.3275670856],
                        [5.5811e-07, 1.23288325946, 3185.1920272656],
                        [5.4989e-07, 5.72691385306, 951.7184062506],
                        [5.2418e-07, 3.02366828926, 4292.3308329504],
                        [5.5686e-07, 5.44686699242, 3723.508958923],
                        [5.8959e-07, 3.26242666052, 6681.2421070518],
                        [4.4629e-07, 2.0147364039, 8031.0922630584],
                        [5.8959e-07, 1.23165502899, 6681.2075997474],
                        [4.2444e-07, 2.26551590902, 155.4203994342],
                        [3.8956e-07, 2.57760416009, 3341.592747768],
                        [5.1561e-07, 5.72326937712, 7079.3738568078],
                        [4.8939e-07, 5.61614696751, 3553.9115221378],
                        [4.5414e-07, 5.43290921705, 6467.9257579616],
                        [3.6435e-07, 4.43921812388, 3894.1818295422],
                        [3.598e-07, 1.15966567007, 2288.3440435114],
                        [3.5265e-07, 5.49029710802, 1990.745017041],
                        [4.2191e-07, 1.6325374276, 5628.9564702112],
                        [4.4292e-07, 5.0034136685, 5614.7293762096],
                        [3.3623e-07, 5.17029029766, 20043.6745601988],
                        [4.3256e-07, 1.03732072925, 11769.8536931664],
                        [3.9237e-07, 1.24237122859, 3339.6321056316],
                        [3.1943e-07, 4.59258406791, 2274.1169495098],
                        [3.0345e-07, 2.4417767013, 11371.7046897582],
                        [3.2259e-07, 2.38215172582, 4535.0594369244],
                        [3.187e-07, 4.37521442752, 3.523118349],
                        [2.935e-07, 4.06034813442, 3097.88382272579],
                        [3.1972e-07, 1.93970478412, 382.8965322232],
                        [2.6166e-07, 5.58466944895, 9623.6882766912],
                        [2.7904e-07, 4.25805969214, 3191.0492295652],
                        [3.3065e-07, 0.85467740581, 553.5694028424],
                        [2.7543e-07, 1.57668567401, 9595.2390892234],
                        [2.5159e-07, 0.81355213242, 10713.9948813262],
                        [2.207e-07, 0.85747723964, 3319.8370312074],
                        [2.4772e-07, 5.38970742761, 2818.035008606],
                        [2.3359e-07, 6.01453778225, 3496.032826134],
                        [2.4732e-07, 2.58034797703, 2803.8079146044],
                        [1.9365e-07, 5.18528750472, 6681.2921637024],
                        [1.9122e-07, 5.41968559451, 10025.3603984484],
                        [1.9364e-07, 5.59378382138, 6681.1575430968],
                        [1.833e-07, 5.7956732424, 7064.1213856228],
                        [1.8193e-07, 5.61307426173, 7.1135470008],
                        [2.0392e-07, 4.53637816869, 6489.776587288],
                        [2.126e-07, 6.19160142215, 14054.607308026],
                        [1.7094e-07, 1.55004739305, 2957.7158944766],
                        [2.2791e-07, 3.41709388606, 7632.9432596502],
                        [2.0585e-07, 2.98697279083, 3361.3878221922],
                        [1.8005e-07, 2.81431094394, 4032.7700279266],
                        [1.7049e-07, 6.15528099726, 10404.7338123226],
                        [1.6488e-07, 3.84534700818, 10973.55568635],
                        [1.6052e-07, 0.92823508003, 14584.2982731206],
                        [2.1027e-07, 2.38474290907, 4989.0591838972],
                        [1.6267e-07, 1.92321585819, 7373.3824546264],
                        [1.6291e-07, 6.28233085307, 7210.9158184942],
                        [1.8585e-07, 4.07325116588, 2388.8940204492],
                        [1.5977e-07, 4.58368417141, 3264.3463554242],
                        [1.9913e-07, 2.7351844595, 5099.2655051166],
                        [1.9661e-07, 1.86285979, 3443.7052009184],
                        [1.65e-07, 4.14061745086, 7477.522860216],
                        [1.9495e-07, 6.03778234182, 10018.3141617504],
                        [1.5104e-07, 2.65433427561, 2787.0430238574],
                        [1.9099e-07, 0.22623441108, 13745.3462390224],
                        [1.7163e-07, 3.18825562972, 3347.7259737006],
                        [1.3423e-07, 2.12818658793, 3344.2028553516],
                        [1.541e-07, 2.2077350796, 2118.7638603784],
                        [1.7238e-07, 3.67067776368, 3205.5473466644],
                        [1.3113e-07, 4.27490214998, 14314.1681130498],
                        [1.6451e-07, 2.86641622696, 14712.317116458],
                        [1.3734e-07, 1.68629769646, 3337.021998048],
                        [1.6659e-07, 4.52130808861, 6674.1113063988],
                        [1.183e-07, 0.19684525299, 3475.6775067352],
                        [1.1767e-07, 3.22897247987, 5828.0284716476],
                        [1.1886e-07, 4.82057654742, 7234.794256242],
                        [1.0609e-07, 1.73997337551, 639.897286314],
                        [1.1154e-07, 0.23859830185, 12832.7587417046],
                        [1.103e-07, 0.4454170644, 10213.285546211],
                        [1.024e-07, 5.74758340632, 242.728603974],
                        [1.0051e-07, 2.45102946726, 4929.6853219836],
                        [1.0061e-07, 0.78907665448, 9381.9399937854],
                        [1.0065e-07, 5.37506605762, 5085.038411115],
                        [1.1902e-07, 0.79897698904, 3265.8308281325],
                        [8.99e-08, 0.96463418322, 4933.2084403326],
                        [8.97e-08, 4.18326774405, 9225.539273283],
                        [8.982e-08, 1.98501418026, 15113.9892382152],
                        [8.324e-08, 1.93694866513, 1648.4467571974],
                        [7.833e-08, 2.04997447879, 1758.6530784168],
                        [7.957e-08, 3.92331072722, 2921.1277828246],
                        [1.0224e-07, 2.66497189021, 2487.4160449478],
                        [8.277e-08, 0.94860765546, 2906.900688823],
                        [7.371e-08, 0.84378341481, 692.1576012268],
                        [7.545e-08, 5.68031160782, 13916.0191096416],
                        [7.912e-08, 2.81294761885, 15643.6802033098],
                        [6.958e-08, 3.32193127272, 3230.4061054804],
                        [7.426e-08, 6.09656283295, 3583.3410306738],
                        [6.402e-08, 4.19806996774, 5202.3582793352],
                        [6.529e-08, 6.1192925271, 135.0650800354],
                        [6.13e-08, 0.00117252232, 6836.6452528338],
                        [6.226e-08, 6.10683955669, 17256.6315363414],
                        [8.193e-08, 5.24811458833, 10575.4066829418],
                        [6.168e-08, 3.60069207439, 10021.8545337516],
                        [6.169e-08, 1.56992114335, 10021.8200264472],
                        [5.671e-08, 0.1365030666, 13524.9163429314],
                        [6.257e-08, 4.50450768937, 8425.6508378148],
                        [5.249e-08, 2.70122358603, 4459.3682188026],
                        [6.479e-08, 2.74267498287, 7740.6067835888],
                        [5.53e-08, 6.06408145092, 10419.9862835076],
                        [5.536e-08, 5.74996063243, 12168.0026965746],
                        [6.826e-08, 4.69327545839, 17654.7805397496],
                        [5.005e-08, 4.68382632238, 522.5774180938],
                        [6.328e-08, 3.31896726895, 3767.2106175758],
                        [4.734e-08, 0.00755678425, 3325.3599555148],
                        [5.032e-08, 2.33696685608, 1052.2683831884],
                        [4.661e-08, 5.15051711401, 1066.49547719],
                        [4.724e-08, 5.77956037309, 9808.5381846614],
                        [5.136e-08, 1.57259709878, 6525.8044539654],
                        [4.522e-08, 1.44218620352, 3369.0616141676],
                        [6.189e-08, 4.58996159356, 6531.661656265],
                        [6.205e-08, 4.48164856516, 22747.2907148744],
                        [5.329e-08, 4.55145599182, 1744.4259844152],
                        [4.511e-08, 5.94511266539, 6894.5239488376],
                        [4.33e-08, 3.10901365758, 4569.574540022],
                        [5.366e-08, 5.08043436437, 2707.8286873866],
                        [5.134e-08, 1.28568358496, 8439.8779318164],
                        [4.127e-08, 5.48538052912, 2699.7348193176],
                        [5.394e-08, 5.21695066244, 5305.4510535538],
                        [4.449e-08, 5.56764082611, 16865.5287696312],
                        [3.898e-08, 1.4878243479, 9168.6408983474],
                        [3.863e-08, 1.2305080393, 16858.4825329332],
                        [3.766e-08, 0.27090392616, 17395.2197347258],
                        [4.683e-08, 3.05668892586, 5518.7501489918],
                        [4.258e-08, 2.7909014579, 3503.079062832],
                        [3.864e-08, 0.37957291785, 10177.2576795336],
                        [3.992e-08, 1.8442476803, 3134.4268782626],
                        [3.643e-08, 2.95318600206, 6144.4203413042],
                        [3.654e-08, 1.58063207414, 6680.2445323314],
                        [3.931e-08, 1.98436570971, 8969.568896911],
                        [3.35e-08, 2.72637081667, 7875.6718636242],
                        [3.623e-08, 2.91544991631, 6682.2051744678],
                        [4.392e-08, 0.81931997702, 3302.479391062],
                        [4.062e-08, 5.46935175827, 3120.199784261],
                        [3.319e-08, 1.77193665786, 3116.2676309979],
                        [3.51e-08, 1.18027333874, 10184.3039162316],
                        [4.008e-08, 1.33675167812, 6247.5131155228],
                        [3.603e-08, 0.15469852619, 2178.137722292],
                        [3.313e-08, 3.12853663982, 17277.4069318338],
                        [4.138e-08, 4.39568891039, 3074.005384978],
                        [3.201e-08, 3.36492925275, 2384.3232707292],
                        [3.991e-08, 3.8286783691, 3355.8648978848],
                        [4.205e-08, 1.9053227917, 263.0839233728],
                        [3.743e-08, 4.25458024187, 6261.7402095244],
                        [3.111e-08, 1.65445053349, 20199.094959633],
                        [3.634e-08, 5.55063049451, 632.7837393132],
                        [2.892e-08, 1.915149207, 12935.8515159232],
                        [3.373e-08, 5.50812408522, 23384.2869868986],
                        [3.312e-08, 5.83174680245, 5331.3574437408],
                        [3.124e-08, 5.44069658195, 6048.4411140864],
                        [3.813e-08, 0.8027448743, 13517.8701062334],
                        [3.612e-08, 3.68140265686, 5724.935697429],
                        [2.813e-08, 1.68598843422, 2391.43681773],
                        [2.902e-08, 5.30666239739, 8955.3418029094],
                        [3.225e-08, 2.29832592489, 3312.163239232],
                        [3.863e-08, 3.48188264725, 20618.0193585336],
                        [2.738e-08, 5.49768261369, 149.5631971346],
                        [2.809e-08, 4.76933217397, 1964.838626854],
                        [2.711e-08, 2.69244730345, 3178.1457905676],
                        [2.711e-08, 2.38275660721, 2648.454825473],
                        [2.743e-08, 1.09492569851, 536.8045120954],
                        [2.821e-08, 5.91845472246, 12964.300703391],
                        [2.716e-08, 6.10377796874, 3973.396166013],
                        [2.487e-08, 3.87703916286, 1861.7458526354],
                        [2.617e-08, 2.65526535627, 8329.671610597],
                        [2.938e-08, 5.68402398615, 6158.6474353058],
                        [2.336e-08, 3.24847913311, 4672.6673142406],
                        [2.318e-08, 1.69214259672, 3914.9572250346],
                        [2.371e-08, 4.75067664712, 103.0927742186],
                        [2.963e-08, 0.23381699914, 20597.2439630412],
                        [2.19e-08, 6.18344448099, 3346.1353510072],
                        [2.444e-08, 1.92547995169, 7799.9806455024],
                        [2.121e-08, 4.87491216115, 9830.3890139878],
                        [2.532e-08, 5.3955008727, 3863.1898447936],
                        [2.101e-08, 2.84309138388, 3415.3940252671],
                        [2.176e-08, 0.58632570025, 162.4666361322],
                        [2.106e-08, 3.06229353931, 19800.9459562248],
                        [2.347e-08, 3.90795942709, 3335.0895023924],
                        [2.031e-08, 5.52057907797, 10021.9045904022],
                        [1.997e-08, 2.77243710569, 13936.794505134],
                        [2.139e-08, 5.40620646615, 266.6070417218],
                        [2.147e-08, 0.089669876, 13358.9265884502],
                        [1.996e-08, 2.62541669265, 20.7753954924],
                        [1.961e-08, 4.88521794174, 3237.5196524812],
                        [2.216e-08, 1.06829128652, 3320.257107301],
                        [2.131e-08, 3.02112533027, 5625.3660415594],
                        [2.124e-08, 3.68620121537, 5618.3198048614],
                        [1.938e-08, 1.29006691721, 17924.9106998204],
                        [2.555e-08, 4.91826220321, 6604.958782124],
                        [2.561e-08, 2.10055088914, 7910.1869667218],
                        [1.82e-08, 5.57528712663, 3351.2490920496],
                        [1.786e-08, 5.77310414452, 3607.2194684216],
                        [1.78e-08, 4.48010071981, 10818.1352869158],
                        [2.106e-08, 5.75526661975, 13365.9728251482],
                        [1.987e-08, 2.61151965233, 3546.797975137],
                        [1.799e-08, 2.73192475257, 3360.96774609859],
                        [1.715e-08, 1.50805385053, 1692.1656695024],
                        [1.752e-08, 2.21455466761, 13119.7211028252],
                        [1.913e-08, 3.32230688971, 6702.000248892],
                        [1.724e-08, 1.43449979531, 4885.9664096786],
                        [2.05e-08, 1.19293239093, 6660.4494579072],
                        [1.774e-08, 2.18404386388, 6784.3176276182],
                        [1.722e-08, 4.86031154305, 10014.7237330986],
                        [1.773e-08, 2.09448668554, 3603.6963500726],
                        [1.606e-08, 3.48105136801, 23141.5583829246],
                        [1.621e-08, 5.73820120882, 4555.3474460204],
                        [1.579e-08, 1.88769198841, 6298.3283211764],
                        [1.53e-08, 5.1638156423, 76.2660712756],
                        [1.615e-08, 3.24110713658, 3657.0042963564],
                        [1.576e-08, 3.52622401575, 6688.3384004004],
                        [2.034e-08, 2.63620520451, 16460.333529525],
                        [2.025e-08, 5.92907541624, 10021.7699697966],
                        [1.689e-08, 4.41053057494, 5729.506447149],
                        [1.878e-08, 4.53291044847, 3329.97576135],
                        [1.53e-08, 4.76331644411, 7895.9598727202],
                        [1.529e-08, 1.35289110986, 1581.959348283],
                        [1.807e-08, 1.86212004697, 2693.601593385],
                        [1.855e-08, 2.38561742394, 6843.6914895318],
                        [1.518e-08, 3.9847615775, 6546.1597733642],
                        [1.389e-08, 1.82099537095, 9779.1086761254],
                        [1.447e-08, 2.35649936427, 6034.2140200848],
                        [1.386e-08, 5.55304113895, 4775.7600884592],
                        [1.372e-08, 1.07224580315, 12722.5524204852],
                        [1.423e-08, 4.46530428193, 574.3447983348],
                        [1.424e-08, 2.57162391016, 3399.9862886134],
                        [1.38e-08, 5.76156315252, 16335.8378045366],
                        [1.338e-08, 2.97604558638, 6127.6554505572],
                        [1.479e-08, 4.74310691166, 12566.1516999828],
                        [1.706e-08, 0.30579918494, 10551.528245194],
                        [1.281e-08, 2.00285974432, 6677.6344247478],
                        [1.35e-08, 0.78892333409, 853.196381752],
                        [1.534e-08, 4.33326399444, 640.8776073822],
                        [1.247e-08, 1.02503908468, 3024.2205570432],
                        [1.289e-08, 1.92786975543, 3347.6586633978],
                        [1.243e-08, 2.44217806237, 6684.8152820514],
                        [1.453e-08, 1.74218016403, 3333.5661900018],
                        [1.675e-08, 1.7969345633, 1118.7557921028],
                        [1.491e-08, 2.59386711806, 2494.5295919486],
                        [1.293e-08, 3.31710472549, 3407.0998356142],
                        [1.188e-08, 4.92989260576, 22743.4093795164],
                        [1.329e-08, 1.99426530402, 1228.9621133222],
                        [1.373e-08, 2.5335498734, 5459.3762870782],
                        [1.183e-08, 4.25338096667, 3344.4937620578],
                        [1.231e-08, 2.50206227837, 4356.275444584],
                        [1.243e-08, 2.6517626786, 74.7815985673],
                        [1.285e-08, 4.34087881585, 3326.3853326982],
                        [1.119e-08, 1.91321862491, 3281.2385647862],
                        [1.094e-08, 5.50748655535, 3017.1070100424],
                        [1.259e-08, 3.7765466283, 11236.57229942],
                        [1.285e-08, 1.38335267684, 3077.528503327],
                        [1.1e-08, 1.17130732373, 6606.4432548323],
                        [1.115e-08, 5.81275569652, 2675.8563815698],
                        [1.38e-08, 5.70641426169, 2807.3983432562],
                        [1.256e-08, 3.35479933251, 4039.8835749274],
                        [1.187e-08, 2.41348693872, 10596.1820784342],
                        [1.052e-08, 3.33521939538, 3304.5845600224],
                        [1.188e-08, 5.84735836632, 3336.7310913418],
                        [1.072e-08, 2.78383184435, 8270.2977486834],
                        [1.105e-08, 3.03463252672, 3929.677253708],
                        [1.013e-08, 3.52026711847, 8013.2797409404],
                        [1.079e-08, 0.51857999039, 2814.4445799542],
                        [9.99e-09, 4.7273400876, 533.2140834436],
                        [1.131e-08, 0.52584038526, 6816.289933435],
                        [1.191e-08, 0.6087429252, 2301.58581590939],
                        [1.313e-08, 2.07273299121, 23539.7073863328],
                        [9.96e-09, 4.03971126547, 16062.1845261168],
                        [9.54e-09, 5.90340414098, 20206.141196331],
                        [9.93e-09, 0.07132588892, 24150.080051345],
                        [1.051e-08, 2.2209653487, 3980.5097130138],
                        [1.089e-08, 1.25512213569, 5938.234792867],
                        [9.12e-09, 2.54221161167, 433.7117378768],
                        [1.249e-08, 0.60003625956, 16173.3711684044],
                        [1.027e-08, 4.95999945094, 19676.4502312364],
                        [1.108e-08, 4.3420944816, 3339.1279539915],
                        [1.188e-08, 6.21563747433, 2679.3794999188],
                        [8.49e-09, 0.82548606454, 2597.6223661672],
                        [1.145e-08, 4.48151980872, 19402.7969528166],
                        [9.48e-09, 1.30280088857, 8273.8208670324],
                        [1.016e-08, 5.1446481583, 1596.1864422846],
                        [8.32e-09, 5.6062365203, 3340.19235060619],
                        [1.035e-08, 4.71893106874, 419.4846438752],
                        [9.03e-09, 0.45419000582, 12995.2253778368],
                        [1.089e-08, 0.51294377637, 11250.7993934216],
                        [8.4e-09, 5.30858028008, 26084.0218062162],
                        [9.9e-09, 2.06776368865, 7255.5696517344],
                        [8.08e-09, 6.25630819993, 15508.6151232744],
                        [8.06e-09, 3.09007612135, 5415.6573747732],
                        [7.82e-09, 4.62274599734, 2547.8375382324],
                        [9.63e-09, 2.10680539916, 6456.8800576977],
                        [7.78e-09, 3.56602161857, 12721.572099417],
                        [8.73e-09, 5.09097164784, 2540.7913015344],
                        [7.72e-09, 3.08101797047, 11081.2192102886],
                        [9.65e-09, 2.33106703115, 18454.601664915],
                        [8.59e-09, 4.14788214122, 6438.4962494256],
                        [1.012e-08, 4.4501166454, 3316.733988952],
                        [9.06e-09, 4.29336078401, 3344.5445799629],
                        [7.41e-09, 2.6144640358, 2284.7536148596],
                        [7.9e-09, 6.03436225041, 12509.2533250472],
                        [7.38e-09, 0.52092422137, 18052.9295431578],
                        [7.37e-09, 4.11165247543, 3760.097070575],
                        [7.27e-09, 3.28066632751, 3510.1926098328],
                        [1.006e-08, 0.45037465289, 27490.6924780448],
                        [9.23e-09, 2.78717931388, 1332.0548875408],
                        [7.56e-09, 0.86881841787, 1545.3539829788],
                        [7.74e-09, 3.715355419, 6571.0185321802],
                        [9e-09, 2.74944190055, 316.3918696566],
                        [7.04e-09, 1.89617185328, 13362.432453147],
                        [7.01e-09, 2.21328293796, 20995.3929664494],
                        [7.01e-09, 3.926894387, 13362.4669604514],
                        [6.95e-09, 5.52658147215, 3364.4908644476],
                        [7.64e-09, 1.88253040972, 5732.0492444298],
                        [6.93e-09, 0.34849213821, 5835.1420186484],
                        [6.98e-09, 1.79132650081, 206.1855484372],
                        [6.87e-09, 0.11649928911, 13760.5987102074],
                        [8.27e-09, 0.49766945172, 3376.6402933772],
                        [6.86e-09, 0.23965591265, 2409.249339848],
                        [6.72e-09, 0.51352450554, 25685.872802808],
                        [6.99e-09, 5.9016759508, 19004.6479494084],
                        [6.47e-09, 3.01091875955, 5223.6939198022],
                        [6.43e-09, 4.88507402785, 11766.2632645146],
                        [7.23e-09, 3.28296530537, 4142.976349146],
                        [6.6e-09, 4.2733439383, 1214.7350193206],
                        [6.75e-09, 0.48874492682, 5408.5438277724],
                        [8.09e-09, 3.13310075522, 18984.2926300096],
                        [6.46e-09, 3.63004914186, 7107.8230442756],
                        [8.31e-09, 4.49449658957, 3341.0325027934],
                        [6.8e-09, 0.16949964513, 110.2063212194],
                        [5.92e-09, 6.03272224596, 20809.4676246452],
                        [6.27e-09, 4.93438097728, 9872.2740829648],
                        [6.98e-09, 1.45709305452, 3377.217792004],
                        [5.83e-09, 4.01887095237, 664.75604513],
                        [5.91e-09, 4.01381288194, 19406.6782881746],
                        [5.71e-09, 1.20823284619, 5621.8601768626],
                        [6.8e-09, 4.72905586557, 8116.372515159],
                        [7.39e-09, 3.19765996917, 9380.9596727172],
                        [5.71e-09, 5.46064659057, 5621.8256695582],
                        [7.02e-09, 0.14107083764, 6923.9534573736],
                        [5.98e-09, 3.05986754375, 3341.0423098265],
                        [6.01e-09, 2.17944973698, 7270.2896804078],
                        [5.72e-09, 0.42001145821, 15110.4661198662],
                        [6.55e-09, 1.08706089359, 3169.9395560806],
                        [5.82e-09, 1.68224967199, 26087.9031415742],
                        [5.43e-09, 2.42716241058, 170.6728706192],
                        [5.43e-09, 1.68460678113, 11780.4903585162],
                        [5.33e-09, 2.63982684952, 2277.7073781616],
                        [5.5e-09, 2.54220679987, 7380.4960016272],
                        [5.76e-09, 1.69042028754, 3384.3313390048],
                        [5.35e-09, 5.0127922346, 1375.7737998458],
                        [5.79e-09, 5.99182453047, 2149.6885348242],
                        [5.98e-09, 0.75754342787, 3340.1825435731],
                        [5.75e-09, 1.33793171924, 3296.8935143948],
                        [6.89e-09, 0.02993986536, 22345.2603761082],
                        [5.26e-09, 6.14212516186, 13149.1506113612],
                        [5.4e-09, 5.54137118955, 8646.0634802536],
                        [5.28e-09, 2.74183495775, 3826.5844794894],
                        [6.89e-09, 6.28205551764, 12295.9542296092],
                        [4.99e-09, 0.25665224668, 2142.6422981262],
                        [4.98e-09, 5.91370528026, 6460.8122109608],
                        [5.88e-09, 3.39977690249, 3329.5667264359],
                        [5.07e-09, 0.63367870048, 20735.8321614256],
                        [5.9e-09, 3.87951788923, 9065.5481241288],
                        [5.09e-09, 2.59333214746, 3877.4169387952],
                        [4.86e-09, 4.01113864377, 23937.856389741],
                        [5.41e-09, 1.55072392536, 2221.856634597],
                        [4.82e-09, 0.00200643783, 10235.1363755374],
                        [4.74e-09, 4.14503805378, 3113.1362939108],
                        [5.23e-09, 2.89171162726, 6040.3472460174],
                        [4.58e-09, 4.08131432844, 1162.4747044078],
                        [4.93e-09, 2.98933582802, 1039.0266107904],
                        [4.89e-09, 4.88201647585, 5511.636601991],
                        [5.37e-09, 1.24870344441, 48835.1938564486],
                        [5.85e-09, 5.5338491934, 4981.9456368964],
                        [4.62e-09, 5.38999453893, 15664.0355227086],
                        [5.31e-09, 1.22287288928, 10721.108428327],
                        [4.4e-09, 4.69966067585, 799.8211251654],
                        [5.88e-09, 5.15076051189, 3873.8265101434],
                        [4.65e-09, 5.49236978535, 3342.0968994081],
                        [5.45e-09, 5.91813092143, 1478.8665740644],
                        [4.4e-09, 2.28287871244, 12310.1813236108],
                        [4.36e-09, 0.12478564862, 956.2891559706],
                        [5.73e-09, 3.86388572602, 26482.1708096244],
                        [4.29e-09, 1.20474317285, 28.4491874678],
                        [4.35e-09, 3.75437730899, 5195.2447323344],
                        [4.57e-09, 1.45606713663, 5636.070017212],
                        [5.53e-09, 5.30628175145, 2766.267628365],
                        [4.94e-09, 0.63303483918, 3274.1250177854],
                        [5.3e-09, 3.18458612574, 8535.8571590342],
                        [5.35e-09, 1.89165024367, 9866.4168806652],
                        [4.33e-09, 0.33270291162, 6665.9723822146],
                        [4.04e-09, 4.6793996459, 4825.544916394],
                        [4.02e-09, 3.25727658426, 5820.9149246468],
                        [4.15e-09, 1.41915166067, 21947.1113727],
                        [4.14e-09, 3.32843373219, 8859.3625756916],
                        [4.03e-09, 1.68400791606, 9588.1255422226],
                        [3.99e-09, 0.93465630912, 2295.4575905122],
                        [4.02e-09, 0.85364636108, 29026.4852295078],
                        [4.94e-09, 4.57792960199, 8542.970706035],
                        [4.13e-09, 2.60545132222, 38.1330356378],
                        [4.13e-09, 5.44081623497, 4407.1079038898],
                        [4.04e-09, 5.33168348188, 3189.5647568569],
                        [3.85e-09, 1.90313951519, 10020.8569590312],
                        [4.54e-09, 1.18358809702, 10610.9021071076],
                        [3.81e-09, 4.90212003667, 19146.7592661418],
                        [4.15e-09, 3.07892141478, 11216.284290324],
                        [3.78e-09, 0.19461412344, 2067.9314010726],
                        [4.18e-09, 1.14626975196, 6643.0918177618],
                        [4.26e-09, 4.33863084563, 220.4126424388],
                        [4.12e-09, 0.02314567339, 3192.5337022735],
                        [3.91e-09, 4.75902617217, 6414.6178116778],
                        [3.99e-09, 1.3770857398, 9654.612951137],
                        [3.81e-09, 2.74120772781, 1854.6323056346],
                        [3.78e-09, 4.16366866018, 13553.8979729108],
                        [4.09e-09, 3.12117409635, 3723.4917052708],
                        [3.79e-09, 5.87578711682, 6357.7194367422],
                        [3.75e-09, 3.29175394061, 31022.7531708562],
                        [3.58e-09, 3.99134138048, 8958.9322315612],
                        [3.9e-09, 2.01175211992, 1903.4368125012],
                        [3.73e-09, 1.27018251531, 2111.6503133776],
                        [4.93e-09, 4.66294641806, 1435.1476617594],
                        [3.79e-09, 4.08720452061, 10706.8813343254],
                        [4.61e-09, 1.9012230147, 25287.7237993998],
                        [3.64e-09, 3.2523113684, 5095.6750764648],
                        [3.82e-09, 2.18684874688, 16276.463942623],
                        [3.59e-09, 2.29096599931, 28628.3362260996],
                        [3.62e-09, 4.15084528423, 6696.4773245846],
                        [3.74e-09, 5.78780163439, 3490.1756238344],
                        [3.86e-09, 4.73230339383, 3981.490034082],
                        [3.44e-09, 5.7915671479, 26880.3198130326],
                        [3.68e-09, 3.44405073824, 15.252471185],
                        [4.1e-09, 1.76294940448, 6709.6740408674],
                        [3.39e-09, 1.71242500987, 224.3447957019],
                        [3.73e-09, 2.71286157688, 3472.1543883862],
                        [3.34e-09, 1.10569460106, 59.3738619136],
                        [3.94e-09, 4.02046774116, 2075.0449480734],
                        [4.02e-09, 3.27520695853, 931.3630868518],
                        [3.18e-09, 3.2889252478, 9485.032768004],
                        [3.19e-09, 4.05344391333, 3450.8187479192],
                        [3.41e-09, 6.08567978892, 17085.9586657222],
                        [3.78e-09, 0.71609301686, 3209.0704650134],
                        [3.26e-09, 4.58257191106, 8982.810669309],
                        [3.69e-09, 6.17228742886, 8671.9698704406],
                        [3.08e-09, 1.01924467785, 18606.4989460002],
                        [3.7e-09, 2.84011243059, 4392.8808098882],
                        [3.03e-09, 5.00239879717, 2810.9387152574],
                        [3.03e-09, 2.97162741204, 2810.904207953],
                        [4.19e-09, 2.798305624, 5106.3790521174],
                        [3.58e-09, 1.15955325186, 4076.4889402316],
                        [3.6e-09, 5.8322612331, 26724.8994135984],
                        [2.98e-09, 5.57160706753, 3041.4860324306],
                        [2.98e-09, 3.06970285022, 11670.2840372968],
                        [3.88e-09, 5.01197738185, 12323.4230960088],
                        [3.36e-09, 4.60208332758, 9602.3526362242],
                        [3.71e-09, 2.23508025241, 4996.172730898],
                        [3e-09, 6.04069385215, 9499.2598620056],
                        [3.45e-09, 1.74260482164, 5617.9107699473],
                        [3.02e-09, 3.0112734994, 7483.5887758458],
                        [2.89e-09, 0.39479288685, 2412.772458197],
                        [2.89e-09, 2.21430640344, 11140.5930722022],
                        [3.3e-09, 5.81605457596, 4246.0691233646],
                        [3.94e-09, 2.1222910724, 6475.0393049624],
                        [3.01e-09, 5.26147877814, 9945.5712088238],
                        [3.38e-09, 4.94717046909, 5625.7750764735],
                        [3.72e-09, 5.469686628, 3561.0250691386],
                        [2.79e-09, 0.54063870001, 3226.2133197864],
                        [2.91e-09, 5.21021494024, 13171.0014406876],
                        [3.84e-09, 3.23921380878, 10022.8176011676],
                        [3.09e-09, 3.17514941939, 14047.4937610252],
                        [2.73e-09, 1.68203034215, 4253.1826703654],
                        [2.72e-09, 0.11218647217, 7314.0085927128],
                        [2.81e-09, 5.15132055967, 2825.1485556068],
                        [2.92e-09, 3.33720586058, 9468.267877257],
                        [3.16e-09, 1.41719074976, 589.0648270082],
                        [2.64e-09, 0.4884559473, 16699.53901515],
                        [2.66e-09, 1.69694779915, 647.0108333148],
                        [3.18e-09, 2.47072726153, 8436.2875031646],
                        [2.6e-09, 2.54459932529, 20.3553193988],
                        [2.75e-09, 2.78608579994, 2970.9126107594],
                        [2.95e-09, 5.96367554548, 4025.6564809258],
                        [2.68e-09, 3.01034973031, 6518.7582172674],
                        [2.59e-09, 5.20888482695, 7366.2689076256],
                        [2.98e-09, 2.71010678192, 6652.7756659318],
                        [2.76e-09, 0.785451083, 3735.238311759],
                        [3.05e-09, 6.19137255377, 6677.3435180416],
                        [2.65e-09, 3.25145629239, 24889.5747959916],
                        [2.6e-09, 3.99612605351, 2171.0241752912],
                        [2.52e-09, 4.14773813625, 5642.1982426092],
                        [2.54e-09, 1.38470256851, 846.0828347512],
                        [2.58e-09, 2.03261985834, 2089.782230399],
                        [2.98e-09, 3.81212222628, 28230.1872226914],
                        [2.41e-09, 2.96550398155, 27682.1407441564],
                        [2.59e-09, 4.79545870271, 6657.3464156518],
                        [2.38e-09, 1.18977479528, 3171.0322435668],
                        [2.56e-09, 1.01427800277, 568.8218740274],
                        [2.36e-09, 5.56425829084, 14.2270940016],
                        [3.04e-09, 3.81556245925, 1190.9238918756],
                        [2.37e-09, 1.37222961867, 2277.2983432475],
                        [2.39e-09, 2.47752611026, 5430.3946570988],
                        [2.34e-09, 4.34929504798, 6675.7019290922],
                        [2.39e-09, 0.14012746335, 3742.284548457],
                        [2.86e-09, 5.04045301355, 5607.6158292088],
                        [3.05e-09, 4.5973907966, 6685.1061887576],
                        [2.54e-09, 5.03693878366, 1905.4647649404],
                        [3.23e-09, 1.67390215145, 4922.5717749828],
                        [2.32e-09, 4.82565548677, 9070.1188738488],
                        [2.36e-09, 2.40662610715, 3620.3989310522],
                        [2.6e-09, 5.72282468723, 17468.8551979454],
                        [2.59e-09, 6.15179402778, 16706.585251848],
                        [2.63e-09, 0.63922292958, 2008.557539159],
                        [3e-09, 3.78527265088, 34363.365597556],
                        [2.26e-09, 1.86970344963, 6418.1409300268],
                        [2.39e-09, 0.046169974, 13362.3823964964],
                        [2.41e-09, 4.85896907298, 14158.7477136156],
                        [2.25e-09, 1.70179250908, 18451.078546566],
                        [2.88e-09, 2.26316945288, 6621.850991486],
                        [2.31e-09, 2.19861265305, 3936.7908007088],
                        [2.51e-09, 5.51232121883, 3416.8784979754],
                        [2.45e-09, 3.30613942274, 1197.9701285736],
                        [2.53e-09, 4.54308131689, 2285.1626497737],
                        [2.25e-09, 5.50822507089, 4936.7988689844],
                        [2.49e-09, 1.06089727346, 3313.210870603],
                        [3.09e-09, 6.21936675838, 16304.9131300908],
                        [2.44e-09, 1.94855224181, 3.5904286518],
                        [2.87e-09, 5.70461951656, 792.7748884674],
                        [2.54e-09, 5.34446995416, 5401.4302807716],
                        [2.63e-09, 1.49663212332, 6364.832983743],
                        [2.23e-09, 2.66825139116, 31968.9486527994],
                        [2.22e-09, 2.48370132727, 5355.2358814886],
                        [2.2e-09, 5.20799024654, 23017.0626579362],
                        [2.15e-09, 2.72743996418, 6740.5987153132],
                        [2.18e-09, 1.30797197521, 29822.7832363242],
                        [2.7e-09, 0.90714939427, 6155.057006654],
                        [2.16e-09, 4.73975263349, 6679.7403806913],
                        [2.11e-09, 3.72756562629, 10042.6126755918],
                        [2.11e-09, 2.61999755641, 10124.930054318],
                        [2.93e-09, 6.07059383381, 14061.7208550268],
                        [2.19e-09, 2.98472846458, 131.5419616864],
                        [2.1e-09, 5.27496906319, 13355.3361597984],
                        [2.59e-09, 1.2526730583, 2641.3412784722],
                        [2.08e-09, 3.30241021109, 6850.8050365326],
                        [2.26e-09, 5.48438086246, 7203.8022714934],
                        [2.43e-09, 2.44748800604, 3311.18291816379],
                        [2.08e-09, 1.13500579457, 5888.4499649322],
                        [2.51e-09, 4.67012983729, 6666.997759398],
                        [2.27e-09, 1.59926413307, 10001.061884607],
                        [2.64e-09, 3.72622435628, 6747.712262314],
                        [2.16e-09, 0.34122804918, 6686.747777707],
                        [2.6e-09, 3.67749190896, 6645.1969867222],
                        [2.09e-09, 4.31928920378, 3337.8609160888],
                        [2.18e-09, 4.08068730999, 3378.7454623376],
                        [2.75e-09, 1.64274205426, 2011.1003364398],
                        [2.04e-09, 0.73237459784, 3.9321532631],
                        [2.19e-09, 0.88584017263, 19513.9835951042],
                        [2.05e-09, 2.60851826933, 2771.7905526724],
                        [2.15e-09, 2.99299817517, 10824.2012025456],
                        [2.49e-09, 0.99914444136, 5753.3848848968],
                        [2.25e-09, 0.23309143434, 4782.87363546],
                        [2.75e-09, 0.86215660461, 8749.1562544722],
                        [2.01e-09, 2.87118854159, 21548.9623692918],
                        [2.46e-09, 3.34468800742, 3333.9287628257],
                        [2.03e-09, 4.11410443276, 31570.7996493912],
                        [2.02e-09, 4.96805650734, 8166.1573430938],
                        [2.32e-09, 2.69372584349, 5989.0672521728],
                        [2.14e-09, 4.83852070026, 6681.6449294932],
                        [2.58e-09, 2.66551831451, 1062.9050485382],
                        [1.97e-09, 0.55202541352, 735.8765135318],
                        [2.56e-09, 2.76274941586, 2480.302497947],
                        [2.16e-09, 4.02506717011, 3133.9116894032],
                        [1.93e-09, 1.52645682146, 949.1756089698],
                        [2.09e-09, 0.67348618655, 13892.1406718938],
                        [2.2e-09, 1.52502617699, 6660.8695340008],
                        [2.23e-09, 1.09348882524, 6148.010769956],
                        [1.92e-09, 2.90571322264, 8799.988713778],
                        [2.43e-09, 3.36420301442, 8965.9784682592],
                        [2.06e-09, 5.11175800472, 4140.4335518652],
                        [1.89e-09, 1.06641624209, 9374.8264467846],
                        [2.4e-09, 5.92078519032, 13362.517017102],
                        [2.48e-09, 5.79997873732, 15806.146839442],
                        [1.93e-09, 3.19008521814, 6756.0064519669],
                        [2.37e-09, 4.11979030463, 22487.3716928416],
                        [2.18e-09, 0.84212090761, 6717.252720077],
                        [2e-09, 2.4310084663, 10018.2468514476],
                        [1.99e-09, 5.81238461796, 4289.7880356696],
                        [2.14e-09, 5.95026024979, 6680.804777306],
                        [1.92e-09, 3.06285109033, 32765.2466596158],
                        [2.29e-09, 1.68884404323, 11614.4332937322],
                        [1.85e-09, 3.13072183492, 3253.30422216],
                        [2.46e-09, 2.58151525126, 1795.258443721],
                        [1.87e-09, 4.06797969837, 14577.1847261198],
                        [1.85e-09, 0.96747889626, 2604.735913168],
                        [1.84e-09, 1.46731725339, 1437.1756141986],
                        [1.86e-09, 2.55094700069, 3188.7151456146],
                        [2.11e-09, 4.23522784526, 16703.0793871512],
                        [1.96e-09, 2.80582160764, 2796.6943676036],
                        [1.98e-09, 5.9237206756, 4133.3873151672],
                        [2.38e-09, 2.30957041178, 1879.5583747534],
                        [2.24e-09, 3.13550652378, 3613.2853840514],
                        [2.23e-09, 1.81801741599, 3184.2117061974],
                        [1.99e-09, 3.64983703995, 4271.9755135516],
                        [1.81e-09, 2.71721121316, 4186.695261451],
                        [1.84e-09, 2.03051030984, 6674.1786167016],
                        [1.82e-09, 1.5443144281, 9947.0556815321],
                        [1.79e-09, 4.38762678121, 9886.772200064],
                        [1.81e-09, 1.80044971979, 6717.8302187038],
                        [1.9e-09, 4.97714900529, 6670.5881880498],
                        [2.47e-09, 5.77972128678, 29424.634232916],
                        [1.94e-09, 5.90745451439, 6705.1032911474],
                        [2.24e-09, 5.61893896091, 227.476132789],
                        [1.82e-09, 2.77233344458, 6887.4104018368],
                        [2.24e-09, 1.94094757956, 8226.5788363784],
                        [1.81e-09, 4.6138108133, 3361.9480671668],
                        [2.03e-09, 5.24659800837, 7586.6815500644],
                        [1.83e-09, 5.23826533455, 6578.132079181],
                        [2.07e-09, 0.88292186428, 10156.9023601348],
                        [2.32e-09, 0.75375986797, 3232.9489027612],
                        [1.79e-09, 5.89794151802, 4452.2546718018],
                        [1.77e-09, 6.16223629155, 3547.3131639964],
                        [1.77e-09, 0.1929289803, 401.6721217572],
                        [1.73e-09, 3.898140641, 6019.9919266186],
                        [1.72e-09, 2.42933586666, 6944.3087767724],
                        [2.01e-09, 6.18392570315, 6947.8318951214],
                        [1.83e-09, 5.82189570737, 8962.438096258],
                        [1.89e-09, 2.71231990816, 742.9900605326],
                        [1.72e-09, 3.86810071059, 10028.9508271002],
                        [1.88e-09, 5.22462530948, 2125.8774073792],
                        [1.96e-09, 1.883885699, 5032.7780962022],
                        [2.09e-09, 5.78130707501, 3343.3639373108],
                        [1.67e-09, 6.26758992296, 15849.865751747],
                        [1.89e-09, 2.38894304278, 3212.5935833624],
                        [2.08e-09, 5.62485439431, 31172.650645983],
                        [1.7e-09, 1.0734640106, 20426.571092422],
                        [1.83e-09, 5.21160560654, 27832.0382192832],
                        [1.81e-09, 2.19756653553, 16703.0448798468],
                        [2.14e-09, 1.66101921272, 21265.5231265202],
                        [1.65e-09, 2.10517924574, 6688.2710900976],
                        [1.72e-09, 0.85495655009, 14591.4118201214],
                        [1.64e-09, 1.68898542913, 3468.6312700372],
                        [1.83e-09, 1.56948199057, 8962.4726035624],
                        [1.91e-09, 5.54553650068, 2806.9893083421],
                        [1.62e-09, 4.06699160265, 5209.471826336],
                        [1.65e-09, 3.44003333876, 14421.8316369884],
                        [1.63e-09, 2.42152585351, 6314.0005244372],
                        [1.89e-09, 0.57681608522, 2973.3880977374],
                        [1.69e-09, 2.86190807726, 5490.300961524],
                        [1.74e-09, 1.69333072403, 1744.493294718],
                        [2.24e-09, 2.35886332922, 9638.9407478762],
                        [2.07e-09, 3.13737248079, 3336.6802734367],
                        [2.21e-09, 3.14807587279, 11610.9101753832],
                        [1.58e-09, 5.87599422932, 4606.1799053262],
                        [1.66e-09, 4.61834424167, 9175.7544453482],
                        [1.62e-09, 5.40045489036, 23.8784377478],
                        [1.58e-09, 5.57047764661, 4503.0871311076],
                        [1.56e-09, 3.08339691033, 3448.2759506384],
                        [2.02e-09, 2.56469307457, 7321.1221397136],
                        [1.64e-09, 1.10347159072, 3710.3122426402],
                        [1.58e-09, 3.65995745934, 6997.6167230562],
                        [1.69e-09, 1.85985317117, 1329.51209026],
                        [2.11e-09, 1.66624816725, 3304.0070613956],
                        [2.06e-09, 1.81572746145, 1596.1191319818],
                        [1.69e-09, 0.46310427277, 17101.2111369072],
                        [1.59e-09, 5.73384451559, 1265.5674786264],
                        [1.59e-09, 0.92643196778, 4001.8453534808],
                        [1.89e-09, 2.7416385092, 2910.4911174748],
                        [1.81e-09, 5.48699984659, 3319.2767862328],
                        [1.56e-09, 5.9546211847, 8584.6616659008],
                        [1.58e-09, 3.38732507447, 8742.0427074714],
                        [1.71e-09, 3.11406750626, 5621.9102335132],
                        [1.99e-09, 2.86370198218, 10025.4277087512],
                        [1.73e-09, 4.73384838991, 9389.0535407862],
                        [1.6e-09, 3.06861532268, 1612.9513330316],
                        [2.03e-09, 1.71629299113, 699.2711482276],
                        [1.98e-09, 0.56267868345, 15265.8865193004],
                        [1.86e-09, 2.44573687199, 2814.8536148683],
                        [1.67e-09, 0.4441794226, 37895.4262903674],
                        [1.52e-09, 5.0861661053, 3322.7999045818],
                        [1.62e-09, 2.58982908935, 1883.0814931024],
                        [1.78e-09, 4.58774508034, 6685.1570066627],
                        [1.91e-09, 4.12771141768, 9911.63095888],
                        [1.85e-09, 4.32284898739, 323.5054166574],
                        [1.99e-09, 1.83524172935, 3436.5916539176],
                        [1.99e-09, 6.00292619279, 4427.3959129858],
                        [1.53e-09, 3.4644766959, 22324.9050567094],
                        [1.71e-09, 3.52256446633, 5621.7756129076],
                        [1.65e-09, 3.32970937124, 1272.6810256272],
                        [1.49e-09, 0.13370088791, 36.0278666774],
                        [1.49e-09, 1.23280447264, 4193.8088084518],
                        [1.56e-09, 0.13018524921, 11925.2740926006],
                        [1.46e-09, 1.24102730441, 3372.5847325166],
                        [1.54e-09, 5.63537863362, 3185.2593375684],
                        [1.97e-09, 3.2336418844, 3774.3241645766],
                        [1.8e-09, 3.47485722477, 8564.306346502],
                        [1.85e-09, 2.18248214016, 802.3639224462],
                        [1.45e-09, 2.62035460481, 3368.0139827966],
                        [1.8e-09, 6.01236697222, 6691.8615187494],
                        [1.48e-09, 2.5171017883, 3262.8618827159],
                        [1.51e-09, 4.17118896078, 16894.5103996106],
                        [1.85e-09, 3.0393966835, 3354.8395207014],
                        [1.43e-09, 3.37267915445, 3468.5639597344],
                        [1.6e-09, 2.1670595973, 0.9803210682],
                        [1.9e-09, 1.63240538938, 2324.9494088156],
                        [1.4e-09, 1.27592043896, 6549.6828917132],
                        [1.86e-09, 1.44849264278, 1015.6630178842],
                        [1.41e-09, 4.19208049402, 5813.291189322],
                        [1.53e-09, 5.97405255778, 3568.0885594888],
                        [1.36e-09, 0.45455359025, 3193.8007401762],
                        [1.88e-09, 0.98977442882, 2538.2485042536],
                        [1.57e-09, 3.32117477144, 3181.6689089166],
                        [1.64e-09, 1.67705754742, 2751.5475996916],
                        [1.34e-09, 5.26327877742, 13212.8865096646],
                        [1.84e-09, 0.73082474043, 369.6998159404],
                        [1.45e-09, 5.54086212771, 3152.68727893721],
                        [1.39e-09, 3.30464120245, 6151.5166346528],
                        [1.32e-09, 0.96753793729, 3487.4241132234],
                        [1.48e-09, 1.55321724063, 7696.8878712838],
                        [1.4e-09, 5.390007578, 2945.9865416406],
                        [1.55e-09, 4.35207037526, 4005.3684718298],
                        [1.42e-09, 5.13441372991, 1641.3332101966],
                        [1.31e-09, 2.48606821423, 1353.3905280078],
                        [1.31e-09, 2.18754536881, 1765.7666254176],
                        [1.33e-09, 3.0130058204, 3283.7140517642],
                        [1.77e-09, 2.37558492362, 11346.7786206394],
                        [1.45e-09, 0.79525636457, 2281.2477501628],
                        [1.33e-09, 5.96263652624, 34513.2630726828],
                        [1.65e-09, 1.32559153826, 6510.5519827804],
                        [1.32e-09, 4.31118469609, 1971.9521738548],
                        [1.76e-09, 3.17539133688, 6701.5801727984],
                        [1.4e-09, 1.18723558164, 1461.0540519464],
                        [1.28e-09, 6.07261046225, 3362.4632560262],
                        [1.39e-09, 5.33541181199, 6151.5511419572],
                        [1.43e-09, 1.04060603784, 3351.6581269637],
                        [1.38e-09, 1.96009952022, 2014.6234547888],
                        [1.27e-09, 2.12310260285, 2917.5373541728],
                        [1.42e-09, 0.29094317859, 3212.6608936652],
                        [1.28e-09, 0.4997445644, 10264.5658840734],
                        [1.25e-09, 1.62548810323, 10191.4174632324],
                        [1.28e-09, 3.55358985291, 3223.2925584796],
                        [1.4e-09, 5.87379732521, 6382.0984591304],
                        [1.29e-09, 2.90428606882, 6812.766815086],
                        [1.27e-09, 4.03101399507, 10448.4354709754],
                        [1.28e-09, 3.23265469, 4576.6880870228],
                        [1.24e-09, 2.02283056331, 6724.9437657046],
                        [1.34e-09, 0.19295362623, 3130.8364496108],
                        [1.45e-09, 5.04767049759, 2281.2132428584],
                        [1.43e-09, 4.45744983982, 7100.7094972748],
                        [1.33e-09, 5.00404182123, 11883.5831327348],
                        [1.24e-09, 0.73925895836, 1485.9801210652],
                        [1.23e-09, 0.47283015475, 3347.2960905739],
                        [1.37e-09, 5.73370922615, 5244.049239201],
                        [1.52e-09, 5.0146445546, 3358.4249488178],
                        [1.22e-09, 1.37003015612, 3370.0419352358],
                        [1.43e-09, 1.95740753086, 2921.6880277992],
                        [1.23e-09, 3.94139290312, 4957.0868780804],
                        [1.3e-09, 0.90844304292, 3427.9206312396],
                        [1.35e-09, 3.56996218538, 3229.4257844122],
                        [1.43e-09, 5.3022576787, 14128.2427712456],
                        [1.34e-09, 2.47836558803, 7167.1969061892],
                        [1.5e-09, 5.89116199733, 966.9708774356],
                        [1.23e-09, 3.58787674774, 3318.7615973734],
                        [1.53e-09, 0.37199746202, 6533.1461289733],
                        [1.45e-09, 1.73326841661, 6637.5059410946],
                        [1.33e-09, 3.27553306809, 11876.469585734],
                        [1.19e-09, 5.15087396729, 15636.566656309],
                        [1.17e-09, 3.70999224131, 3343.1552239806],
                        [1.15e-09, 5.99541570797, 11986.6759069534],
                        [1.52e-09, 5.6666233996, 6530.1771835567],
                        [1.23e-09, 0.05231448642, 9801.4246376606],
                        [1.3e-09, 1.4237792604, 16063.164847185],
                        [1.2e-09, 4.19579234337, 604.8497407048],
                        [1.26e-09, 1.38788085609, 169.580183133],
                        [1.22e-09, 0.18785107006, 18849.2275499742],
                        [1.13e-09, 4.67731144918, 24491.4257925834],
                        [1.22e-09, 1.21803689218, 3067.9394693482],
                        [1.18e-09, 3.92389195187, 2963.238818784],
                        [1.37e-09, 0.80076862963, 3123.7902129128],
                        [1.24e-09, 0.77274469912, 12465.5344127422],
                        [1.32e-09, 4.73888023892, 2267.003402509],
                        [1.22e-09, 3.66231014052, 8756.269801473],
                        [1.13e-09, 3.74955221887, 21393.5419698576],
                        [1.53e-09, 5.00596002145, 15906.7641266826],
                        [1.09e-09, 1.4639407844, 2854.6403739102],
                        [1.25e-09, 6.00744459186, 1442.2612087602],
                        [1.4e-09, 0.64532646558, 13532.0298899322],
                        [1.08e-09, 2.11691804278, 43.718912305],
                        [1.3e-09, 1.4318591196, 3370.1042450032],
                        [1.33e-09, 2.31239626151, 9072.6616711296],
                        [1.07e-09, 5.68864833782, 4878.8528626778],
                        [1.16e-09, 3.91262234002, 11904.9187732018],
                        [1.06e-09, 1.99989592271, 3497.0131472022],
                        [1.06e-09, 5.79020088316, 1.4844727083],
                        [1.05e-09, 1.79751699456, 3517.3061568336],
                        [1.3e-09, 0.80396347034, 3397.5108016354],
                        [1.07e-09, 5.29449090921, 10.6366653498],
                        [1.37e-09, 0.47037516401, 13575.7488022372],
                        [1.04e-09, 5.03145022037, 1751.5222777638],
                        [1.46e-09, 2.57659804831, 3308.640120883],
                        [1.03e-09, 3.29589452622, 4379.6390374902],
                        [1.04e-09, 0.77903634693, 1751.5567850682],
                        [1.18e-09, 4.11892224522, 10927.2939767642],
                        [1.06e-09, 2.25714927822, 13207.029307365],
                        [1.26e-09, 1.10289326962, 6680.7949702729],
                        [1.05e-09, 1.41449747957, 10081.211142013],
                        [1.1e-09, 6.16072219971, 3338.069629419],
                        [1.13e-09, 0.61947991056, 13421.8235687128],
                        [1.39e-09, 2.21345603147, 1954.7171503636],
                        [1.02e-09, 3.81767069895, 6670.1791531357],
                        [1.01e-09, 3.44583422545, 1505.28780909299],
                        [1.05e-09, 2.46134952447, 5525.8636959926],
                        [1.19e-09, 5.64454862995, 8425.7181481176],
                        [1.01e-09, 1.87446179141, 9161.5273513466],
                        [1.11e-09, 5.46183253107, 7214.4389368432],
                        [1.23e-09, 0.14056284625, 16489.763038061],
                        [1.28e-09, 0.00452525697, 2185.2512692928],
                        [1.06e-09, 6.2022517933, 3717.9860346156],
                        [9.9e-10, 1.70554147455, 1655.5603041982],
                        [1e-09, 1.76373681853, 3002.3697277168],
                        [1.01e-09, 0.55693458655, 3337.1566186536],
                        [1.01e-09, 0.56441794685, 30774.5016425748],
                        [9.8e-10, 1.93983799659, 5562.4690612968],
                        [1.3e-09, 5.65255471249, 2735.762685995],
                        [1.25e-09, 6.18575288406, 9698.331863442],
                        [1e-09, 2.35767934317, 3337.0720546986],
                        [1e-09, 3.76317527562, 3344.152798701],
                        [1.05e-09, 5.33897491215, 5096.0841113789],
                        [1.03e-09, 1.24189801298, 1385.8952763362],
                        [1.01e-09, 1.42727612221, 37455.7264959744],
                        [9.6e-10, 2.55328478399, 4466.4817658034],
                        [9.7e-10, 5.8677912741, 5220.1708014532],
                        [1.01e-09, 2.61513508379, 16858.4152226304],
                        [1.07e-09, 4.23943588615, 8823.8671515258],
                        [1e-09, 4.38845221965, 3337.106562003],
                        [1e-09, 1.73240240188, 3344.11829139661],
                        [1.01e-09, 3.51764169063, 4694.0029547076],
                        [9.6e-10, 3.16895015703, 12825.6451947038],
                        [1.01e-09, 6.24060604565, 2942.5307335944],
                        [1.03e-09, 1.09500325425, 12089.768681172],
                        [1.06e-09, 5.57931664756, 39048.3225096072],
                        [1.26e-09, 3.4052173855, 6681.6547365263],
                        [1.05e-09, 2.52404371984, 1755.062649765],
                        [1.15e-09, 6.10031030713, 3145.6410422392],
                        [9.2e-10, 5.06385191401, 5085.1057214178],
                        [9.7e-10, 1.11670836674, 3341.7930693519],
                        [9.2e-10, 5.83209800268, 6682.7093261079],
                        [1.21e-09, 2.39411154886, 18208.349942592],
                        [1.1e-09, 2.51677822824, 1045.1548361876],
                        [9.1e-10, 1.07173725022, 927.8399685028],
                        [9.6e-10, 3.60155667418, 13363.4300278674],
                        [9.7e-10, 5.34224904711, 7636.4663779992],
                        [9.4e-10, 1.20811080231, 9495.6694333538],
                        [9e-10, 4.17568982529, 0.0673103028],
                        [9.7e-10, 3.20862890174, 5298.337506553],
                        [9.2e-10, 3.20029831258, 4403.517475238],
                        [9e-10, 3.79900428724, 685.044054226],
                        [1.01e-09, 2.1277832928, 10050.2864675672],
                        [9.8e-10, 3.89390262307, 2373.6415492642],
                        [9e-10, 4.49046504054, 6453.7487206106],
                        [9.6e-10, 5.13129666936, 7792.8670985016],
                        [8.9e-10, 4.51228904794, 10037.0897512844],
                        [9.8e-10, 0.65689906709, 2810.988771908],
                        [1.14e-09, 4.15908543927, 9090.4741932476],
                        [9.4e-10, 4.78960145866, 35707.7100829074],
                        [8.7e-10, 6.26525215858, 34554.8138636676],
                        [8.7e-10, 1.50181194995, 9983.7042444616],
                        [8.7e-10, 1.43790822626, 9488.6231966558],
                        [9e-10, 2.79573736864, 47477.5637760738],
                        [9.4e-10, 5.68919291448, 6106.8800550648],
                        [8.7e-10, 0.74049208991, 41990.7859328988],
                        [1.01e-09, 0.99308133443, 6614.7374444852],
                        [1.15e-09, 3.49732055752, 4.5034394172],
                        [8.6e-10, 0.18628425275, 216.822213787],
                        [9.9e-10, 1.06539589813, 2810.8541513024],
                        [8.7e-10, 3.02856210899, 7218.029365495],
                        [8.5e-10, 4.58476007089, 1699.2792165032],
                        [8.8e-10, 4.47996444588, 21957.680727747],
                        [1.06e-09, 6.1201188073, 4819.4790007642],
                        [8.9e-10, 3.88600719587, 12199.9750023914],
                        [9.7e-10, 2.70091698598, 3339.4317840477],
                        [1.18e-09, 1.027395272, 34115.1140692746],
                        [1.01e-09, 0.36591831115, 2942.3961129888],
                        [8.4e-10, 5.66081869654, 1169.5882514086],
                        [8.6e-10, 1.91214909013, 55516.4187098482],
                        [8.4e-10, 4.30909434949, 4150.0898961468],
                        [9.4e-10, 1.36645151323, 9093.9973115966],
                        [9.7e-10, 2.26544245706, 13361.469385731],
                        [9.9e-10, 1.16054562056, 128.0188433374],
                        [9.4e-10, 1.10573952457, 4591.4426230006],
                        [9.2e-10, 0.74386387542, 4845.9002357928],
                        [1.01e-09, 1.5157029904, 7807.0941925032],
                        [9.6e-10, 1.02187746571, 2899.7871418222],
                        [8.6e-10, 0.66787658068, 2957.7331481288],
                        [8.7e-10, 3.4967618964, 4061.751657906],
                        [9.5e-10, 3.35452781355, 661.232926781],
                        [8.7e-10, 0.04840436087, 23546.7536230308],
                        [1.14e-09, 2.83270741566, 394.6258850592],
                        [8.1e-10, 3.44420073782, 148.0787244263],
                        [8.1e-10, 1.27062968985, 4893.0799566794],
                        [8.3e-10, 5.48462687348, 4349.1618975832],
                        [1.05e-09, 3.4784203613, 3413.9095525588],
                        [8.4e-10, 4.33209852801, 51449.3242632782],
                        [9.3e-10, 1.59775582035, 5088.2198048527],
                        [8.8e-10, 3.29950478012, 2655.501062171],
                        [8.1e-10, 1.65543714666, 78263.7094247226],
                        [8.6e-10, 1.19342535692, 4029.2469095776],
                        [7.9e-10, 4.41964678009, 151.0476698429],
                        [8.4e-10, 1.96289182788, 14867.7375158922],
                        [9.1e-10, 5.76229906142, 2544.3316735356],
                        [8.6e-10, 3.78659802914, 1481.4093713452],
                        [8.2e-10, 2.85633413428, 14164.8136292454],
                        [7.8e-10, 4.29426812598, 187.9251477626],
                        [7.8e-10, 5.38566529072, 2655.5683724738],
                        [8.4e-10, 2.15121245434, 3311.1206083964],
                        [7.8e-10, 2.01651247942, 9124.9219860424],
                        [8.3e-10, 4.28280129037, 74923.0969980228],
                        [7.7e-10, 1.45903147715, 2544.3817301862],
                        [8.1e-10, 3.62204400197, 12306.590894959],
                        [1e-09, 1.33498371324, 9278.8472195668],
                        [8.9e-10, 2.62080312892, 24341.5283174566],
                        [9.8e-10, 3.78877505378, 3198.4337996636],
                        [8.1e-10, 4.34306418828, 10177.1903692308],
                        [8e-10, 5.80054348103, 2751.01515718],
                        [9.2e-10, 2.80228448795, 3707.8367556622],
                        [8.2e-10, 2.4581289624, 9815.6517316622],
                        [7.6e-10, 3.03616461584, 9993.3880926316],
                        [7.6e-10, 3.92674885488, 2910.0820825607],
                        [7.6e-10, 3.2000404072, 7733.493236588],
                        [9.8e-10, 3.28574616663, 3289.33208883739],
                        [7.7e-10, 2.0594893001, 12928.7379689224],
                        [7.5e-10, 0.85784191736, 28638.9055811466],
                        [7.8e-10, 0.29690749181, 10654.6210194126],
                        [1.01e-09, 0.72388999452, 48827.4311857326],
                        [8.5e-10, 5.1943801013, 2146.148162823],
                        [8.3e-10, 4.42475849926, 2060.8178540718],
                        [7.5e-10, 5.19097428778, 1055.4497769261],
                        [9.6e-10, 6.24132708357, 11.0457002639],
                        [7.4e-10, 3.37882325472, 8006.1661939396],
                        [1.01e-09, 0.95332927487, 8186.5126624926],
                        [9.2e-10, 0.961730051, 151.8972810852],
                        [7.4e-10, 2.2271663021, 272.6729573516],
                        [9.2e-10, 5.56705883046, 27873.589010268],
                        [9.1e-10, 3.73152787182, 2544.2971662312],
                        [8.4e-10, 0.41493230617, 4296.9015826704],
                        [7.4e-10, 5.09669613096, 9755.2302383776],
                        [7.8e-10, 1.79565224435, 3564.9572224017],
                        [7.5e-10, 4.58345774133, 9153.9036160218],
                        [7.4e-10, 3.88658218247, 25298.2931544468],
                        [8.5e-10, 5.31472029744, 4716.3862265456],
                        [7.4e-10, 1.46907693289, 11527.1250891924],
                        [1.01e-09, 2.94847804254, 12032.9376165392],
                        [7.2e-10, 0.24413748615, 1324.94134054],
                        [7.8e-10, 0.17721609024, 3391.89276456221],
                        [7.3e-10, 1.65072742864, 5452.2627400774],
                        [7.3e-10, 4.9173008347, 10787.6303445458],
                        [7.3e-10, 3.28285909319, 8830.9133882238],
                        [8.1e-10, 5.4634074205, 3856.0762977928],
                        [7.3e-10, 4.61913155968, 3288.352111787],
                        [9.6e-10, 5.71767221046, 206.7007372966],
                        [8e-10, 4.47918417138, 12299.544658261],
                        [7.1e-10, 4.9813032833, 12942.965062924],
                        [7.3e-10, 2.86057567032, 4960.6099964294],
                        [7.2e-10, 5.14120362338, 4665.5537672398],
                        [7.6e-10, 0.00928867041, 6534.413166876],
                        [9e-10, 5.38224594245, 2125.8100970764],
                        [8.5e-10, 0.94196641948, 2146.1826701274],
                        [9.6e-10, 0.68069708134, 10006.5848089144],
                        [7.3e-10, 1.06048379839, 3866.7802734454],
                        [7.2e-10, 0.84342376295, 3334.54651107],
                        [9.1e-10, 5.12701600437, 3392.8727416126],
                        [7.6e-10, 5.96038992872, 3482.791053736],
                        [9e-10, 1.46230169383, 5092.169211768],
                        [7.1e-10, 1.16745785331, 1574.8458012822],
                        [7.2e-10, 3.86137692169, 16762.4359954126],
                        [7e-10, 0.07310763691, 12839.8722887054],
                        [7.3e-10, 0.11725123446, 10507.809332889],
                        [8.1e-10, 5.86817748181, 3495.9655158312],
                        [7.1e-10, 2.07963275673, 1063.3140834523],
                        [6.8e-10, 3.30993028662, 4106.4054911462],
                        [6.9e-10, 0.33467954461, 5.5229243074],
                        [6.8e-10, 1.56404561711, 2398.5503647308],
                        [9e-10, 2.61953849393, 3346.6783423296],
                        [6.8e-10, 1.06108185791, 191.3809558088],
                        [7.7e-10, 0.87794040199, 2917.9463890869],
                        [6.7e-10, 0.29712068423, 12012.5822971404],
                        [6.7e-10, 2.55451787747, 11567.1912630782],
                        [8.3e-10, 1.82578570364, 3511.285297319],
                        [6.8e-10, 2.68247854175, 20213.2547433318],
                        [8.6e-10, 2.79273636804, 367.2243289624],
                        [8.6e-10, 0.81171860574, 209.775977089],
                        [6.7e-10, 5.28035928877, 8966.3875031733],
                        [6.7e-10, 0.20258020424, 27433.889215875],
                        [7.1e-10, 2.76410148218, 15650.7937503106],
                        [9e-10, 0.71593793107, 3451.7990689874],
                        [6.7e-10, 6.18148420146, 3966.2826190122],
                        [7.4e-10, 3.61959120765, 7064.1041319706],
                        [6.8e-10, 2.69550405031, 12725.453434775],
                        [7.4e-10, 1.24854309783, 8027.5691447094],
                        [8.4e-10, 2.47006028699, 3738.7441764558],
                        [7.7e-10, 5.89874180572, 4307.5833041354],
                        [6.7e-10, 0.33285041428, 19645.5255567906],
                        [8.3e-10, 3.79134493696, 2472.6787626222],
                        [6.4e-10, 0.43216125634, 1994.26813539],
                        [7.1e-10, 0.65707804543, 860.3099287528],
                        [6.4e-10, 0.98960038205, 3376.1751611684],
                        [7e-10, 0.96227192685, 8428.8322315525],
                        [6.6e-10, 0.65425879867, 8219.4652893776],
                        [7e-10, 4.36060455306, 8436.6965380787],
                        [8.4e-10, 4.50083253887, 3738.7786837602],
                        [7.3e-10, 5.69670871544, 14687.3910473392],
                        [7.1e-10, 0.36334330253, 2619.4731954936],
                        [8e-10, 5.85771861744, 7747.7203305896],
                        [6.8e-10, 3.06409889136, 8446.9914788172],
                        [6.6e-10, 1.07137364271, 1987.221898692],
                        [6.1e-10, 3.71171429905, 1055.8588118402],
                        [7.9e-10, 0.06487001849, 6286.5989683404],
                        [7.5e-10, 1.54177744365, 1059.3991838414],
                        [6.1e-10, 1.47350010728, 1685.0521225016],
                        [6.1e-10, 0.46897959303, 1727.6610936682],
                        [6.4e-10, 2.11869877898, 3305.0496922312],
                        [6e-10, 1.17940250396, 97670.3877128972],
                        [6e-10, 5.13953821352, 1898.3339642874],
                        [6.4e-10, 4.04058406722, 3945.4621674046],
                        [6.3e-10, 5.20562384814, 24606.13555322],
                        [6.1e-10, 0.55428968913, 7082.8969751568],
                        [7.5e-10, 4.81208819076, 27299.2442119332],
                        [5.9e-10, 1.75511446129, 12082.6551341712],
                        [6.1e-10, 5.8833385561, 6901.6374958384],
                        [7.4e-10, 3.46408580786, 14556.8967170238],
                        [7.4e-10, 4.40649822049, 9360.6043533184],
                        [5.8e-10, 4.22827613192, 4531.5363185754],
                        [8e-10, 2.14103357856, 7917.3005137226],
                        [7.5e-10, 1.8561801142, 52566.1926158406],
                        [7.5e-10, 5.1583065968, 45884.967762441],
                        [6.8e-10, 2.06915254754, 8958.5231966471],
                        [5.6e-10, 3.77847713307, 299.1263942692],
                        [6.2e-10, 2.25564130818, 9758.7533567266],
                        [5.9e-10, 2.68657637673, 6283.0585963392],
                        [5.6e-10, 5.54148283448, 13286.1836355236],
                        [5.6e-10, 3.892008116, 8962.3880396074],
                        [6.3e-10, 2.07254352069, 7593.7950970652],
                        [6.1e-10, 4.31994402891, 4709.2726795448],
                        [7.5e-10, 5.79419108898, 1059.364676537],
                        [5.6e-10, 0.18569912415, 7768.0083396856],
                        [5.9e-10, 5.49627068572, 7322.1024607818],
                        [6.4e-10, 3.9599211222, 3050.1269472302],
                        [5.5e-10, 2.19506741266, 7.046236698],
                        [5.7e-10, 4.052526953, 3930.2096962196],
                        [7.5e-10, 3.99788100837, 5483.254724826],
                        [6e-10, 4.61703903739, 6990.5031760554],
                        [7.3e-10, 4.20362525534, 21150.8133658836],
                        [6.6e-10, 2.82009591985, 8771.0070837986],
                        [5.4e-10, 0.38782719267, 360.1107819616],
                        [5.9e-10, 4.71734799803, 6283.0931036436],
                        [6.8e-10, 5.74655335863, 987.746272928],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.0110743334, 2.0325052495, 3340.6124266998],
                        [0.00103175886, 2.37071845682, 6681.2248533996],
                        [0.000128772, 0, 0],
                        [0.0001081588, 2.70888093803, 10021.8372800994],
                        [1.19455e-05, 3.04702182503, 13362.4497067992],
                        [4.38579e-06, 2.88835072628, 2281.2304965106],
                        [3.95698e-06, 3.42324611291, 3344.1355450488],
                        [1.82572e-06, 1.58428644001, 2544.3144198834],
                        [1.3585e-06, 3.38507017993, 16703.062133499],
                        [1.28204e-06, 0.6299122057, 1059.3819301892],
                        [1.27068e-06, 1.9538977574, 796.2980068164],
                        [1.18443e-06, 2.99761345074, 2146.1654164752],
                        [1.28362e-06, 6.04343360441, 3337.0893083508],
                        [8.7537e-07, 3.42052758979, 398.1490034082],
                        [8.3026e-07, 3.85574986653, 3738.761430108],
                        [7.5598e-07, 4.45101839349, 6151.533888305],
                        [7.1999e-07, 2.7644218068, 529.6909650946],
                        [6.6542e-07, 2.54892602695, 1751.539531416],
                        [5.4314e-07, 0.67750943459, 8962.4553499102],
                        [5.1035e-07, 3.72585409207, 6684.7479717486],
                        [6.643e-07, 4.40597549957, 1748.016413067],
                        [4.7863e-07, 2.28527896843, 2914.0142358238],
                        [4.9428e-07, 5.72959428364, 3340.5951730476],
                        [4.9424e-07, 1.47717922226, 3340.629680352],
                        [5.7518e-07, 0.54354327916, 1194.4470102246],
                        [4.8318e-07, 2.58061691301, 3149.1641605882],
                        [3.6384e-07, 6.02728752344, 3185.1920272656],
                        [3.7176e-07, 5.81439911546, 1349.8674096588],
                        [3.6036e-07, 5.89508336048, 3333.498879699],
                        [3.1115e-07, 0.9783250696, 191.4482661116],
                        [3.8953e-07, 2.31900090554, 4136.9104335162],
                        [2.7244e-07, 5.41367977087, 1592.5960136328],
                        [2.43e-07, 3.75843924498, 155.4203994342],
                        [2.2804e-07, 1.74830773908, 5088.6288397668],
                        [2.2324e-07, 0.9393204073, 951.7184062506],
                        [2.1708e-07, 3.83571581352, 6283.0758499914],
                        [2.1304e-07, 0.78049229782, 1589.0728952838],
                        [2.1631e-07, 4.56895741061, 3532.0606928114],
                        [1.7956e-07, 4.21930481803, 3870.3033917944],
                        [1.8237e-07, 0.41328624131, 5486.777843175],
                        [1.6251e-07, 3.80760134974, 3340.545116397],
                        [1.6803e-07, 5.54857987615, 3097.88382272579],
                        [1.685e-07, 4.53690440252, 4292.3308329504],
                        [1.5755e-07, 4.75736730681, 9492.1463150048],
                        [1.5746e-07, 3.72356090283, 20043.6745601988],
                        [2.0428e-07, 3.13540712557, 4690.4798363586],
                        [1.4699e-07, 5.95325006816, 3894.1818295422],
                        [1.6251e-07, 3.39910907599, 3340.6797370026],
                        [1.4259e-07, 3.99897353022, 1990.745017041],
                        [1.6528e-07, 0.96752074938, 4399.994356889],
                        [1.301e-07, 5.14230107067, 6677.7017350506],
                        [1.2492e-07, 1.03211063742, 3341.592747768],
                        [1.6463e-07, 3.53882915214, 2700.7151403858],
                        [1.6171e-07, 2.34870953554, 553.5694028424],
                        [1.3169e-07, 0.41461716663, 5614.7293762096],
                        [1.1272e-07, 1.02375627844, 12303.06777661],
                        [1.2408e-07, 6.23142869816, 5628.9564702112],
                        [1.2747e-07, 0.69046314049, 3723.508958923],
                        [1.1827e-07, 6.25283898676, 2274.1169495098],
                        [1.0384e-07, 1.23257236014, 426.598190876],
                        [1.1208e-07, 1.31750963435, 3496.032826134],
                        [1.0345e-07, 0.9006246469, 4535.0594369244],
                        [1.2215e-07, 4.22316056098, 7079.3738568078],
                        [9.765e-08, 3.45310940204, 382.8965322232],
                        [8.586e-08, 1.16471901139, 2787.0430238574],
                        [7.879e-08, 5.7380886179, 2288.3440435114],
                        [9.195e-08, 1.81689739851, 6681.2421070518],
                        [7.751e-08, 4.15046998466, 6041.3275670856],
                        [9.195e-08, 6.06945250657, 6681.2075997474],
                        [9.026e-08, 2.58210941053, 2388.8940204492],
                        [6.771e-08, 0.23987737854, 11773.3768115154],
                        [7.087e-08, 3.51414944377, 8031.0922630584],
                        [9.159e-08, 3.9015859055, 3553.9115221378],
                        [6.702e-08, 4.25572879119, 242.728603974],
                        [7.232e-08, 3.70287400141, 2818.035008606],
                        [6.546e-08, 0.04353472459, 2957.7158944766],
                        [8.781e-08, 2.19735028572, 1221.8485663214],
                        [6.54e-08, 2.11834687923, 8429.2412664666],
                        [6.836e-08, 4.04512263654, 10025.3603984484],
                        [7.28e-08, 4.26943100715, 2803.8079146044],
                        [7.676e-08, 1.00782250264, 8432.7643848156],
                        [5.732e-08, 3.13956241764, 213.299095438],
                        [5.344e-08, 3.78220670098, 5092.1519581158],
                        [5.991e-08, 2.96408254428, 6489.776587288],
                        [5.132e-08, 3.98288453952, 7.1135470008],
                        [6.261e-08, 1.90346469972, 5621.8429232104],
                        [5.241e-08, 2.6709379505, 7477.522860216],
                        [6.261e-08, 1.60056695152, 3347.7259737006],
                        [6.526e-08, 2.76281601349, 3339.6321056316],
                        [4.591e-08, 1.81986278078, 2810.9214616052],
                        [5.46e-08, 4.60874445963, 3583.3410306738],
                        [4.733e-08, 0.9056002634, 5099.2655051166],
                        [5.486e-08, 4.91408093456, 7632.9432596502],
                        [4.004e-08, 4.14067157211, 9623.6882766912],
                        [3.837e-08, 0.03343295627, 7234.794256242],
                        [3.621e-08, 5.76532393672, 4933.2084403326],
                        [3.747e-08, 0.08778985966, 6525.8044539654],
                        [3.016e-08, 3.73838855125, 6681.2921637024],
                        [3.975e-08, 4.91288592965, 2942.4634232916],
                        [3.911e-08, 0.67451768877, 3127.3133312618],
                        [3.923e-08, 3.07703531632, 3.523118349],
                        [3.944e-08, 0.53974754515, 5884.9268465832],
                        [2.901e-08, 4.66281989264, 7210.9158184942],
                        [2.803e-08, 1.00530177454, 7064.1213856228],
                        [3.153e-08, 4.54673175664, 2487.4160449478],
                        [2.784e-08, 0.05495331967, 639.897286314],
                        [2.759e-08, 5.17099857257, 5828.0284716476],
                        [3.017e-08, 4.14668877243, 6681.1575430968],
                        [2.999e-08, 0.82918667275, 5085.038411115],
                        [2.677e-08, 0.69427974692, 2699.7348193176],
                        [3.023e-08, 2.59489020298, 2906.900688823],
                        [2.596e-08, 1.08693013783, 4929.6853219836],
                        [3.126e-08, 1.00027692782, 2118.7638603784],
                        [2.598e-08, 5.01195749912, 10018.3141617504],
                        [2.606e-08, 5.34420770679, 10973.55568635],
                        [2.779e-08, 3.98358744953, 6467.9257579616],
                        [2.46e-08, 1.52653571249, 6836.6452528338],
                        [2.382e-08, 3.93610586965, 11371.7046897582],
                        [2.59e-08, 5.08892664109, 12832.7587417046],
                        [2.201e-08, 0.18880589605, 9595.2390892234],
                        [2.128e-08, 5.69450469171, 3191.0492295652],
                        [2.065e-08, 3.541331746, 1066.49547719],
                        [1.868e-08, 5.0159253181, 3475.6775067352],
                        [2.081e-08, 1.3027445922, 7740.6067835888],
                        [1.83e-08, 5.68365327697, 3319.8370312074],
                        [2.022e-08, 6.1609232806, 1744.4259844152],
                        [1.708e-08, 2.21675931288, 2921.1277828246],
                        [1.836e-08, 6.16477009621, 8425.6508378148],
                        [2.06e-08, 6.24041853265, 6674.1113063988],
                        [1.735e-08, 4.58243571826, 10419.9862835076],
                        [1.852e-08, 1.36883022935, 15643.6802033098],
                        [1.689e-08, 1.92829590736, 3767.2106175758],
                        [1.954e-08, 0.46215988899, 10575.4066829418],
                        [1.8e-08, 2.3091334366, 3355.8648978848],
                        [1.444e-08, 2.15042616899, 10021.8545337516],
                        [1.76e-08, 5.87267582299, 3320.257107301],
                        [1.845e-08, 4.06123235448, 23384.2869868986],
                        [1.423e-08, 4.65085713203, 4562.4609930212],
                        [1.41e-08, 1.50438410845, 3325.3599555148],
                        [1.444e-08, 0.11969993808, 10021.8200264472],
                        [1.443e-08, 0.55828572929, 15113.9892382152],
                        [1.334e-08, 1.25483731308, 7875.6718636242],
                        [1.442e-08, 1.38958943728, 6682.2051744678],
                        [1.606e-08, 4.34241260905, 5331.3574437408],
                        [1.377e-08, 0.1479168382, 1758.6530784168],
                        [1.282e-08, 5.78533014319, 14584.2982731206],
                        [1.281e-08, 1.35125896423, 10404.7338123226],
                        [1.471e-08, 0.34649469321, 8969.568896911],
                        [1.245e-08, 6.02681709446, 3264.3463554242],
                        [1.234e-08, 1.88341938354, 10177.2576795336],
                        [1.552e-08, 5.92727420332, 8439.8779318164],
                        [1.182e-08, 4.18100226016, 3360.96774609859],
                        [1.333e-08, 1.86551437099, 692.1576012268],
                        [1.189e-08, 0.89892514263, 13916.0191096416],
                        [1.192e-08, 4.30473818946, 6894.5239488376],
                        [1.145e-08, 0.15197504252, 3134.4268782626],
                        [1.299e-08, 1.44631688592, 6254.6266625236],
                        [1.494e-08, 1.54417907271, 3361.3878221922],
                        [1.054e-08, 0.67591855339, 3344.2028553516],
                        [1.21e-08, 0.85117132607, 3120.199784261],
                        [1.061e-08, 0.13258232364, 522.5774180938],
                        [1.003e-08, 1.28021784912, 4569.574540022],
                        [1.012e-08, 5.77497169905, 14314.1681130498],
                        [1.169e-08, 2.99767730172, 6247.5131155228],
                        [1.062e-08, 0.25467691252, 3337.021998048],
                        [1.032e-08, 5.6983368362, 536.8045120954],
                        [1.082e-08, 2.58016159997, 6261.7402095244],
                        [8.67e-09, 1.50283829131, 6127.6554505572],
                        [9.53e-09, 2.92377030638, 5729.506447149],
                        [8.87e-09, 5.28743574972, 10213.285546211],
                        [1.108e-08, 2.8433917189, 640.8776073822],
                        [8.61e-09, 3.21491381593, 3914.9572250346],
                        [1.069e-08, 0.49400181869, 11243.6858464208],
                        [8e-09, 4.64154002129, 6144.4203413042],
                        [7.99e-09, 3.33215212691, 9830.3890139878],
                        [1.046e-08, 4.059078777, 6158.6474353058],
                        [7.43e-09, 4.9333799729, 3230.4061054804],
                        [7.4e-09, 3.01511102229, 10818.1352869158],
                        [7.16e-09, 2.52567242762, 5202.3582793352],
                        [7.05e-09, 4.39344403231, 9808.5381846614],
                        [7.86e-09, 1.72357089999, 3178.1457905676],
                        [7.19e-09, 0.38924465445, 6298.3283211764],
                        [7.17e-09, 6.23927283856, 3369.0616141676],
                        [7.04e-09, 1.96763488855, 6688.3384004004],
                        [8.82e-09, 2.10339285493, 2301.58581590939],
                        [9.13e-09, 2.30662326829, 13517.8701062334],
                        [9.14e-09, 4.36610748804, 13365.9728251482],
                        [6.59e-09, 3.40905557071, 1648.4467571974],
                        [8.28e-09, 2.13305589137, 7903.073419721],
                        [6.52e-09, 5.97050449428, 574.3447983348],
                        [6.88e-09, 4.02232587894, 1052.2683831884],
                        [7.09e-09, 2.24658423912, 9225.539273283],
                        [5.9e-09, 0.67418318613, 8955.3418029094],
                        [6.04e-09, 2.73550395152, 16858.4825329332],
                        [7.85e-09, 3.58704322751, 2693.601593385],
                        [5.7e-09, 4.11146135269, 6034.2140200848],
                        [6.24e-09, 4.45415856101, 12964.300703391],
                        [5.63e-09, 3.72383942144, 13119.7211028252],
                        [5.47e-09, 3.04142188931, 2707.8286873866],
                        [5.36e-09, 4.65546776421, 135.0650800354],
                        [6.8e-09, 3.62640859214, 6048.4411140864],
                        [5.35e-09, 3.32503801413, 9779.1086761254],
                        [6.15e-09, 0.31792697641, 7910.1869667218],
                        [5.06e-09, 1.24339056369, 4555.3474460204],
                        [6.33e-09, 1.32124830132, 2648.454825473],
                        [6.71e-09, 2.88173567087, 3316.733988952],
                        [5.7e-09, 4.94522781693, 6923.9534573736],
                        [4.89e-09, 0.48479532469, 12935.8515159232],
                        [4.9e-09, 1.57712746955, 162.4666361322],
                        [4.92e-09, 4.08592823251, 10021.9045904022],
                        [4.68e-09, 4.50628939729, 2384.3232707292],
                        [4.62e-09, 1.30653882308, 17256.6315363414],
                        [4.44e-09, 5.20556841675, 13358.9265884502],
                        [5.11e-09, 5.29436707935, 853.196381752],
                        [4.58e-09, 5.52316111365, 6438.4962494256],
                        [4.43e-09, 4.37626774329, 12168.0026965746],
                        [4.29e-09, 4.06329082027, 149.5631971346],
                        [5.02e-09, 6.12188881856, 8273.8208670324],
                        [4.2e-09, 3.51990468754, 9168.6408983474],
                        [4.52e-09, 0.15931716927, 7895.9598727202],
                        [4.01e-09, 0.93276882765, 433.7117378768],
                        [4.91e-09, 4.49372643902, 10021.7699697966],
                        [3.9e-09, 1.26790524143, 5459.3762870782],
                        [4.6e-09, 3.56765356005, 1596.1864422846],
                        [5.14e-09, 4.14617297678, 16460.333529525],
                        [5.1e-09, 2.12338136542, 3335.0895023924],
                        [3.65e-09, 0.84035244694, 3364.4908644476],
                        [4.44e-09, 0.42154996651, 9866.4168806652],
                        [3.8e-09, 2.74315160117, 3344.4937620578],
                        [3.55e-09, 2.20831807719, 5518.7501489918],
                        [3.74e-09, 0.93920520997, 3863.1898447936],
                        [3.8e-09, 0.60825828556, 3980.5097130138],
                        [3.66e-09, 1.45297694305, 1039.0266107904],
                        [4.58e-09, 5.01867719021, 10551.528245194],
                        [3.52e-09, 5.59661824792, 16062.1845261168],
                        [3.61e-09, 5.43698827477, 11236.57229942],
                        [3.23e-09, 3.25474887566, 3116.2676309979],
                        [3.96e-09, 5.43635200834, 16173.3711684044],
                        [3.16e-09, 5.10862851689, 17395.2197347258],
                        [3.25e-09, 4.59103320065, 19800.9459562248],
                        [3.2e-09, 0.1002213259, 1692.1656695024],
                        [3.13e-09, 4.76509182263, 3304.5845600224],
                        [3.29e-09, 3.51515201342, 1903.4368125012],
                        [3.61e-09, 1.4017957282, 8270.2977486834],
                        [3.8e-09, 1.11278812152, 3503.079062832],
                        [3.09e-09, 1.63585786252, 11081.2192102886],
                        [3.04e-09, 6.27804875103, 2391.43681773],
                        [3.36e-09, 2.95777936427, 6680.2445323314],
                        [2.99e-09, 0.48751113813, 3347.6586633978],
                        [3.27e-09, 3.19951479738, 3981.490034082],
                        [2.98e-09, 4.26967988388, 13936.794505134],
                        [3.09e-09, 5.0577507818, 12721.572099417],
                        [3.1e-09, 6.10243075443, 17924.9106998204],
                        [2.9e-09, 4.52880846817, 5724.935697429],
                        [2.79e-09, 4.30091602167, 3607.2194684216],
                        [2.93e-09, 1.90646493379, 6702.000248892],
                        [3.75e-09, 5.37146136739, 3376.6402933772],
                        [2.68e-09, 4.93796347898, 13760.5987102074],
                        [2.69e-09, 5.63342755549, 4032.7700279266],
                        [3.61e-09, 4.70448724123, 9380.9596727172],
                        [2.85e-09, 4.37639190605, 6040.3472460174],
                        [3.05e-09, 3.60878132297, 7255.5696517344],
                        [2.65e-09, 5.82002998533, 1214.7350193206],
                        [2.46e-09, 3.48844723382, 3237.5196524812],
                        [3.39e-09, 6.05128485092, 6660.4494579072],
                        [3.25e-09, 5.12798981834, 11250.7993934216],
                        [2.43e-09, 0.48346700024, 13362.432453147],
                        [2.46e-09, 4.41923388458, 3546.797975137],
                        [2.39e-09, 3.73073204843, 76.2660712756],
                        [2.39e-09, 6.27709788173, 1964.838626854],
                        [2.42e-09, 2.51411096474, 13362.4669604514],
                        [2.38e-09, 4.61745673345, 17277.4069318338],
                        [2.32e-09, 3.13987850882, 20199.094959633],
                        [2.45e-09, 3.88310965561, 4407.1079038898],
                        [2.42e-09, 3.07232693388, 12566.1516999828],
                        [2.77e-09, 3.88618268628, 10596.1820784342],
                        [2.77e-09, 6.1445946998, 19402.7969528166],
                        [2.22e-09, 2.20253799065, 7107.8230442756],
                        [2.18e-09, 1.37621606096, 3415.3940252671],
                        [2.97e-09, 3.78408680173, 2766.267628365],
                        [2.64e-09, 5.35345322905, 6816.289933435],
                        [2.13e-09, 1.10915354432, 19004.6479494084],
                        [2.13e-09, 4.60032427636, 3973.396166013],
                        [2.3e-09, 4.39356021431, 26724.8994135984],
                        [2.02e-09, 0.60981942427, 6677.6344247478],
                        [2.68e-09, 5.05058237041, 9381.9399937854],
                        [1.99e-09, 1.34402137469, 8329.671610597],
                        [1.98e-09, 5.08527311506, 5820.9149246468],
                        [2.01e-09, 0.05002970566, 11780.4903585162],
                        [1.99e-09, 2.66187512344, 6696.4773245846],
                        [2.27e-09, 1.69939961119, 18984.2926300096],
                        [2.17e-09, 4.71565260831, 8671.9698704406],
                        [1.99e-09, 0.66532566162, 15664.0355227086],
                        [2.01e-09, 3.90133282111, 266.6070417218],
                        [2.42e-09, 0.76562027191, 3281.2385647862],
                        [2.54e-09, 6.0771214653, 14054.607308026],
                        [1.93e-09, 6.08798590746, 8982.810669309],
                        [2.02e-09, 1.12506176909, 6684.8152820514],
                        [2.12e-09, 0.41763591084, 5732.0492444298],
                        [1.91e-09, 0.63315794517, 3017.1070100424],
                        [1.84e-09, 5.68898048651, 5642.1982426092],
                        [1.8e-09, 4.60366258431, 10235.1363755374],
                        [1.98e-09, 1.01742381306, 3336.7310913418],
                        [2.07e-09, 0.80702499658, 3877.4169387952],
                        [2.02e-09, 1.61753574776, 11216.284290324],
                        [1.77e-09, 0.20305783491, 22743.4093795164],
                        [1.81e-09, 6.17864681592, 4885.9664096786],
                        [2.28e-09, 0.90779655425, 18454.601664915],
                        [1.65e-09, 3.97299091423, 20.3553193988],
                        [2.06e-09, 3.58770221682, 3205.5473466644],
                        [1.85e-09, 2.7708843606, 220.4126424388],
                        [1.63e-09, 0.00569068383, 1437.1756141986],
                        [1.85e-09, 6.2312887516, 6660.8695340008],
                        [1.64e-09, 4.64548469502, 3253.30422216],
                        [2.1e-09, 4.85590304986, 5618.3198048614],
                        [2.26e-09, 1.76563729092, 5625.3660415594],
                        [1.63e-09, 0.67931390118, 12310.1813236108],
                        [2.11e-09, 1.51278040364, 4039.8835749274],
                        [1.77e-09, 2.14779710666, 3346.1353510072],
                        [1.54e-09, 3.33525296567, 9070.1188738488],
                        [1.78e-09, 1.65162116131, 10713.9948813262],
                        [1.56e-09, 6.12783235584, 103.0927742186],
                        [1.55e-09, 3.51854579269, 7373.3824546264],
                        [1.57e-09, 4.91614155659, 15508.6151232744],
                        [1.91e-09, 1.74459210202, 10022.8176011676],
                        [1.78e-09, 3.53665589741, 533.2140834436],
                        [1.54e-09, 2.64640687885, 3333.5661900018],
                        [1.62e-09, 1.2723539268, 5415.6573747732],
                        [1.44e-09, 1.30886254982, 6460.8122109608],
                        [1.73e-09, 3.76291627342, 3561.0250691386],
                        [1.44e-09, 0.86629692094, 7380.4960016272],
                        [1.5e-09, 0.23529641094, 1228.9621133222],
                        [1.44e-09, 0.12285484149, 647.0108333148],
                        [1.6e-09, 0.24157324936, 11614.4332937322],
                        [1.46e-09, 4.76067886088, 16706.585251848],
                        [1.88e-09, 2.96688973732, 2178.137722292],
                        [1.75e-09, 1.66915420767, 22345.2603761082],
                        [1.41e-09, 1.75571255457, 3657.0042963564],
                        [1.45e-09, 0.71777671857, 6784.3176276182],
                        [1.38e-09, 2.74151377335, 6546.1597733642],
                        [1.39e-09, 4.12056692213, 3351.2490920496],
                        [1.52e-09, 4.88528890547, 110.2063212194],
                        [1.34e-09, 0.86682710306, 3603.6963500726],
                        [1.7e-09, 5.54401695608, 3265.8308281325],
                        [1.65e-09, 2.74557093704, 4672.6673142406],
                        [1.29e-09, 0.94520493983, 419.4846438752],
                        [1.67e-09, 3.43007767272, 1581.959348283],
                        [1.36e-09, 3.68877945956, 13171.0014406876],
                        [1.6e-09, 0.68321924763, 6475.0393049624],
                        [1.29e-09, 4.46548223743, 9499.2598620056],
                        [1.44e-09, 1.88085102951, 9468.267877257],
                        [1.49e-09, 3.49118810274, 14158.7477136156],
                        [1.38e-09, 1.92770959208, 15.252471185],
                        [1.72e-09, 0.23189971635, 12323.4230960088],
                        [1.21e-09, 1.75813513715, 4379.6390374902],
                        [1.2e-09, 6.04299490267, 6606.4432548323],
                        [1.34e-09, 1.98845453946, 8965.9784682592],
                        [1.18e-09, 0.22641710036, 11766.2632645146],
                        [1.22e-09, 2.92219895926, 21947.1113727],
                        [1.47e-09, 5.86576524955, 3169.9395560806],
                        [1.21e-09, 5.75886629308, 19513.9835951042],
                        [1.19e-09, 3.93419985914, 4936.7988689844],
                        [1.23e-09, 4.65853055862, 13149.1506113612],
                        [1.51e-09, 4.38870879458, 13362.517017102],
                        [1.34e-09, 4.49208622602, 2480.302497947],
                        [1.15e-09, 5.78268772131, 12722.5524204852],
                        [1.26e-09, 4.43971496486, 3568.0885594888],
                        [1.14e-09, 0.36704570747, 3384.3313390048],
                        [1.17e-09, 0.67607782416, 13207.029307365],
                        [1.24e-09, 5.80386208894, 10721.108428327],
                        [1.15e-09, 0.23672592056, 224.3447957019],
                        [1.1e-09, 0.26402316132, 3077.528503327],
                        [1.12e-09, 3.50979462224, 1375.7737998458],
                        [1.08e-09, 5.30086016687, 10264.5658840734],
                        [1.46e-09, 2.36972522432, 4989.0591838972],
                        [1.43e-09, 0.92798026058, 5401.4302807716],
                        [1.11e-09, 2.47771615302, 18606.4989460002],
                        [1.24e-09, 1.13870545502, 2807.3983432562],
                        [1.05e-09, 5.87122793977, 4193.8088084518],
                        [1.15e-09, 3.01754571849, 1118.7557921028],
                        [1.07e-09, 2.03274473347, 25685.872802808],
                        [1.07e-09, 4.82345245872, 13362.3823964964],
                        [1.05e-09, 1.21018340855, 8584.6616659008],
                        [1.04e-09, 5.07527834174, 23141.5583829246],
                        [1e-09, 4.08698733114, 3511.285297319],
                        [1.05e-09, 1.1383323428, 1162.4747044078],
                        [1.02e-09, 2.55243872323, 664.75604513],
                        [1.38e-09, 3.04361079523, 3329.97576135],
                        [1.3e-09, 3.04769575195, 3341.0325027934],
                        [1.17e-09, 2.97177407391, 9602.3526362242],
                        [9.8e-10, 4.54292546461, 3362.4632560262],
                        [9.7e-10, 2.21618504638, 10042.6126755918],
                        [1e-09, 5.4554164858, 3024.2205570432],
                        [9.7e-10, 1.55448890675, 8799.988713778],
                        [1.07e-09, 5.1500176439, 956.2891559706],
                        [1e-09, 1.80839732601, 6665.9723822146],
                        [1.04e-09, 0.04641040148, 10001.061884607],
                        [9.7e-10, 0.30502193916, 10014.7237330986],
                        [1.25e-09, 3.71144870102, 3873.8265101434],
                        [1.02e-09, 5.38933965862, 13892.1406718938],
                        [1.08e-09, 4.3343889579, 3490.1756238344],
                        [9.5e-10, 2.32591017464, 10028.9508271002],
                        [1.13e-09, 1.7432394516, 11610.9101753832],
                        [1.19e-09, 4.94578003013, 3443.7052009184],
                        [9.6e-10, 1.63239207663, 11925.2740926006],
                        [1.24e-09, 0.82697196609, 9638.9407478762],
                        [1.01e-09, 1.51065535085, 1062.9050485382],
                        [1.07e-09, 4.3665371608, 6531.661656265],
                        [9e-10, 2.0153477417, 22324.9050567094],
                        [9.4e-10, 4.85202869277, 14047.4937610252],
                        [8.9e-10, 1.23714034226, 20809.4676246452],
                        [9.5e-10, 5.69916785631, 6717.252720077],
                        [9.5e-10, 2.15038299943, 8013.2797409404],
                        [1.11e-09, 3.91313035726, 3311.18291816379],
                        [8.9e-10, 1.37925538521, 74.7815985673],
                        [9.4e-10, 3.24872875047, 6657.3464156518],
                        [8.9e-10, 0.70324117212, 23.8784377478],
                        [8.7e-10, 0.40376031248, 2221.856634597],
                        [9.2e-10, 3.3316578619, 2540.7913015344],
                        [1.2e-09, 3.09344469205, 6685.1061887576],
                        [8.7e-10, 4.9269430907, 1505.28780909299],
                        [9.1e-10, 1.66121998822, 24150.080051345],
                        [9e-10, 5.47687082598, 16699.53901515],
                        [1.19e-09, 2.53709230647, 3312.163239232],
                        [1.18e-09, 5.56523997231, 2814.4445799542],
                        [9.3e-10, 1.61394240489, 3341.0423098265],
                        [8.4e-10, 1.19439840758, 3450.8187479192],
                        [8.5e-10, 4.95060410388, 7314.0085927128],
                        [8.4e-10, 3.92244493446, 170.6728706192],
                        [9.6e-10, 5.49205832489, 3427.9206312396],
                        [1.06e-09, 1.61703818023, 3774.3241645766],
                        [1.01e-09, 6.18535119914, 5511.636601991],
                        [8.1e-10, 3.16562241132, 52175.8062831484],
                        [9.3e-10, 5.15512549422, 3451.7990689874],
                        [1.08e-09, 0.33314004399, 6709.6740408674],
                        [7.8e-10, 2.38080208142, 13553.8979729108],
                        [8.5e-10, 1.1858843064, 6705.1032911474],
                        [9.8e-10, 3.24856024758, 25287.7237993998],
                        [8e-10, 2.54327778068, 6675.7019290922],
                        [7.8e-10, 4.70533248161, 24889.5747959916],
                        [9.5e-10, 1.59916172961, 4271.9755135516],
                        [7.6e-10, 0.90799171644, 2675.8563815698],
                        [9.1e-10, 3.80728044706, 2125.8774073792],
                        [9.3e-10, 5.59480359619, 3340.1825435731],
                        [9.5e-10, 2.06299921822, 6518.7582172674],
                        [1e-09, 6.02550501045, 3313.210870603],
                        [7.5e-10, 6.1609589009, 3370.0419352358],
                        [7.7e-10, 4.92444879515, 3229.4257844122],
                        [9e-10, 4.55063359845, 6701.5801727984],
                        [7.8e-10, 2.01202524407, 14421.8316369884],
                        [7.9e-10, 5.92142974185, 6155.057006654],
                        [1.01e-09, 2.07923317336, 15265.8865193004],
                        [8.2e-10, 6.04078010866, 3760.097070575],
                        [7.3e-10, 3.01106366205, 206.1855484372],
                        [7.8e-10, 1.71095661489, 3399.9862886134],
                        [7.3e-10, 3.32824316241, 9588.1255422226],
                        [7.6e-10, 1.74030672711, 6756.0064519669],
                        [7.3e-10, 1.44980946324, 5408.5438277724],
                        [7.7e-10, 5.64501410813, 3209.0704650134],
                        [8e-10, 5.70272305344, 10156.9023601348],
                        [7.5e-10, 3.83222347813, 39048.3225096072],
                        [7.2e-10, 0.82629826575, 7366.2689076256],
                        [8.3e-10, 4.71804515025, 14061.7208550268],
                        [7.2e-10, 4.35767091893, 21548.9623692918],
                        [8.6e-10, 1.50107043029, 5989.0672521728],
                        [7.3e-10, 3.77377582806, 28628.3362260996],
                        [8.2e-10, 0.7874018109, 16276.463942623],
                        [7e-10, 2.69225539304, 3296.8935143948],
                        [6.9e-10, 1.01941228196, 12295.9542296092],
                        [8.1e-10, 4.64227979982, 6947.8318951214],
                        [9.4e-10, 0.74502278458, 5244.049239201],
                        [6.7e-10, 4.4732887165, 20206.141196331],
                        [9.1e-10, 2.95968633697, 3326.3853326982],
                        [7.6e-10, 2.86128350856, 8542.970706035],
                        [6.5e-10, 1.31079130285, 23546.7536230308],
                        [6.5e-10, 3.31422850411, 6414.6178116778],
                        [6.4e-10, 3.98415414793, 3368.0139827966],
                        [6.5e-10, 4.15810281695, 3340.19235060619],
                        [7.1e-10, 3.82044323862, 6578.132079181],
                        [8e-10, 1.02128994578, 7321.1221397136],
                        [6.4e-10, 1.07965886113, 6944.3087767724],
                        [6.4e-10, 1.20215520018, 38.1330356378],
                        [7e-10, 5.11166911478, 9485.032768004],
                        [6.7e-10, 2.22216014849, 4845.9002357928],
                        [8.3e-10, 1.86067842148, 931.3630868518],
                        [6.3e-10, 0.45029141698, 6418.1409300268],
                        [6.2e-10, 5.68207205878, 4459.3682188026],
                        [6.2e-10, 0.62454636835, 6688.2710900976],
                        [7.6e-10, 0.41820625869, 5032.7780962022],
                        [6.2e-10, 5.72811519809, 2008.557539159],
                        [6e-10, 1.98790201827, 12199.9750023914],
                        [7.8e-10, 2.18035217615, 3232.9489027612],
                        [6e-10, 1.08971396071, 10124.930054318],
                        [7.2e-10, 4.08555524166, 3416.8784979754],
                        [6.1e-10, 2.49066420507, 4005.3684718298],
                        [5.9e-10, 2.9375514437, 9886.772200064],
                        [6.9e-10, 1.02371083242, 6621.850991486],
                        [6.1e-10, 4.57446273568, 2277.7073781616],
                        [5.9e-10, 4.7474548172, 16865.5287696312],
                        [6.9e-10, 3.6257698172, 15906.7641266826],
                        [5.8e-10, 4.15993379336, 1854.6323056346],
                        [6e-10, 4.92798256747, 3391.89276456221],
                        [7e-10, 4.51699340219, 16304.9131300908],
                        [5.6e-10, 3.5935463928, 7322.1024607818],
                        [6.8e-10, 0.8121709197, 16703.0448798468],
                        [5.6e-10, 3.19997567622, 4140.4335518652],
                        [5.8e-10, 1.73479637157, 2409.249339848],
                        [5.4e-10, 5.5431093749, 2604.735913168],
                        [5.9e-10, 2.0292225638, 45486.8187590328],
                        [6.3e-10, 5.29505507594, 17101.2111369072],
                        [5.4e-10, 4.8823066075, 48300.16010269],
                        [7.1e-10, 4.843810412, 3289.33208883739],
                        [5.4e-10, 1.76917054114, 3510.1926098328],
                        [6.3e-10, 2.80175814276, 16894.5103996106],
                        [5.8e-10, 0.91631357427, 10018.2468514476],
                        [5.4e-10, 1.06826755543, 8948.2282559086],
                        [7.2e-10, 1.36121375974, 10025.4277087512],
                        [6.1e-10, 0.92427393171, 17468.8551979454],
                        [6.8e-10, 2.84271358352, 16703.0793871512],
                        [5.3e-10, 3.42679182927, 14867.7375158922],
                        [5.4e-10, 0.41070672545, 18451.078546566],
                        [6e-10, 5.86922287544, 7447.017917846],
                        [5.1e-10, 1.64684042106, 3472.1543883862],
                        [5.7e-10, 6.13250399703, 17085.9586657222],
                        [5.3e-10, 4.16969434701, 6106.8800550648],
                        [5e-10, 3.17196717347, 2111.6503133776],
                        [5.5e-10, 5.7260754556, 10706.8813343254],
                        [6.2e-10, 0.57333106196, 3171.0322435668],
                        [5.3e-10, 1.29007833025, 6652.7756659318],
                        [5e-10, 2.96441858632, 10037.0897512844],
                        [6.5e-10, 5.11165617529, 3113.1362939108],
                        [5.3e-10, 4.87447079015, 1485.9801210652],
                        [5e-10, 2.52848298042, 10448.4354709754],
                        [5.9e-10, 1.69623653028, 4025.6564809258],
                        [4.7e-10, 5.15559748285, 12012.5822971404],
                        [4.9e-10, 1.19473362353, 3448.2759506384],
                        [6.3e-10, 1.01191427607, 11769.8536931664],
                        [6.4e-10, 3.86219786087, 18208.349942592],
                        [5.9e-10, 2.96261275062, 14071.4395090758],
                        [4.9e-10, 1.41657179779, 2938.9403049426],
                        [4.8e-10, 2.95878690387, 11527.1250891924],
                        [5.2e-10, 0.01971915447, 8226.5788363784],
                        [4.5e-10, 5.07966377852, 3318.7615973734],
                        [4.3e-10, 1.23879381294, 7218.029365495],
                        [5.8e-10, 5.58121433163, 6643.0918177618],
                        [4.8e-10, 5.02446939402, 6645.1969867222],
                        [4.3e-10, 0.69492704598, 20995.3929664494],
                        [4.4e-10, 4.02272101657, 9389.0535407862],
                        [5.5e-10, 4.38138154697, 1478.8665740644],
                        [5.1e-10, 4.24292455428, 792.7748884674],
                        [4.2e-10, 2.74826708762, 14577.1847261198],
                        [4.4e-10, 4.18397905503, 8535.8571590342],
                        [4.7e-10, 1.33588473182, 632.7837393132],
                        [4.2e-10, 5.05676915852, 3397.5108016354],
                        [4.2e-10, 0.28204510006, 10001.4819607006],
                        [4.2e-10, 0.75310918544, 6357.7194367422],
                        [4.2e-10, 4.94532732982, 18052.9295431578],
                        [5.2e-10, 4.09912687749, 5835.1420186484],
                        [5.4e-10, 2.46533302314, 8186.5126624926],
                        [4.3e-10, 4.77713978044, 32124.3690522336],
                        [5.3e-10, 6.08293348275, 3377.217792004],
                        [4.1e-10, 2.51168269556, 4186.695261451],
                        [4.1e-10, 1.24482327948, 3212.5935833624],
                        [4.1e-10, 5.42003026893, 685.044054226],
                        [4.1e-10, 5.04768364997, 6571.0185321802],
                        [4.2e-10, 2.08904552145, 13363.4300278674],
                        [4.8e-10, 4.82888746454, 1835.3246176068],
                        [4.3e-10, 4.17203713456, 43340.6533425576],
                        [4.6e-10, 0.81640935106, 45884.967762441],
                        [4.2e-10, 2.26773068307, 12729.665967486],
                        [3.9e-10, 5.85791936573, 846.0828347512],
                        [4.3e-10, 2.90976420757, 6872.6731195112],
                        [4.5e-10, 1.98725045807, 1861.7458526354],
                        [4.5e-10, 0.50053853542, 14128.2427712456],
                        [4.6e-10, 2.86512929328, 38650.173506199],
                        [3.8e-10, 3.65846461938, 29698.2875113358],
                        [3.9e-10, 4.57679716458, 6901.6374958384],
                        [3.9e-10, 3.85504465583, 9945.5712088238],
                        [4e-10, 0.06127203284, 9947.0556815321],
                        [4.3e-10, 5.28854105201, 3274.1250177854],
                        [4.7e-10, 6.25707790441, 24606.13555322],
                        [3.7e-10, 5.02115296017, 11128.9760857842],
                        [3.9e-10, 1.7142191987, 7696.8878712838],
                        [3.7e-10, 4.3465298512, 3283.7140517642],
                        [3.7e-10, 0.05572748092, 21150.8133658836],
                        [4.2e-10, 4.9787204146, 13575.7488022372],
                        [5e-10, 4.24170332288, 7747.7203305896],
                        [3.7e-10, 4.07496312186, 8646.0634802536],
                        [3.8e-10, 0.44080908793, 24491.4257925834],
                        [3.6e-10, 1.73681874925, 3468.6312700372],
                        [4.1e-10, 5.69294900686, 26087.9031415742],
                        [3.6e-10, 1.80256389689, 8756.269801473],
                        [3.6e-10, 3.37374689465, 48429.2821823244],
                        [3.5e-10, 0.10555289345, 8742.0427074714],
                        [4.1e-10, 4.26832466355, 21000.9158907568],
                        [3.8e-10, 0.73199792046, 26084.0218062162],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [0.00044242247, 0.47930603943, 3340.6124266998],
                        [8.138042e-05, 0.86998398093, 6681.2248533996],
                        [1.274915e-05, 1.22594050809, 10021.8372800994],
                        [1.87387e-06, 1.57298991982, 13362.4497067992],
                        [4.0744e-07, 1.9708017506, 3344.1355450488],
                        [5.2396e-07, 3.14159265359, 0],
                        [2.6616e-07, 1.91665615762, 16703.062133499],
                        [1.7825e-07, 4.43499505333, 2281.2304965106],
                        [1.1713e-07, 4.5251045373, 3185.1920272656],
                        [1.0209e-07, 5.39143469548, 1059.3819301892],
                        [9.95e-08, 0.41870577185, 796.2980068164],
                        [9.237e-08, 4.53579272961, 2146.1654164752],
                        [7.299e-08, 3.14218509183, 2544.3144198834],
                        [7.217e-08, 2.29300859074, 6684.7479717486],
                        [6.808e-08, 5.26702580055, 155.4203994342],
                        [6.528e-08, 2.30781369329, 3738.761430108],
                        [7.785e-08, 5.93369079547, 1748.016413067],
                        [5.84e-08, 1.05191350362, 1349.8674096588],
                        [6.749e-08, 5.30194395749, 1194.4470102246],
                        [4.695e-08, 0.76880586144, 3097.88382272579],
                        [5.391e-08, 1.00223256041, 3149.1641605882],
                        [4.406e-08, 2.45556303355, 951.7184062506],
                        [4.286e-08, 3.89643520638, 1592.5960136328],
                        [3.514e-08, 1.85168391963, 398.1490034082],
                        [3.699e-08, 2.26043707772, 20043.6745601988],
                        [3.377e-08, 3.81683532672, 1751.539531416],
                        [4.585e-08, 0.8078744174, 4136.9104335162],
                        [3.201e-08, 2.11657635165, 5614.7293762096],
                        [3.622e-08, 1.32395191387, 3333.498879699],
                        [2.916e-08, 1.19337460559, 529.6909650946],
                        [2.979e-08, 2.86481008776, 6151.533888305],
                        [3.057e-08, 4.55276793064, 5628.9564702112],
                        [2.906e-08, 1.20295377623, 3894.1818295422],
                        [3.85e-08, 3.86055626689, 553.5694028424],
                        [2.82e-08, 2.48683324916, 1990.745017041],
                        [2.657e-08, 6.07411629964, 4292.3308329504],
                        [2.7e-08, 2.9213977335, 3496.032826134],
                        [2.395e-08, 5.94175921617, 2787.0430238574],
                        [2.264e-08, 2.56219866409, 191.4482661116],
                        [2.167e-08, 5.36812435483, 8962.4553499102],
                        [2.149e-08, 2.74950075397, 242.728603974],
                        [2.217e-08, 1.85265984462, 3337.0893083508],
                        [1.996e-08, 5.76429928131, 3341.592747768],
                        [1.999e-08, 3.82349238481, 2914.0142358238],
                        [1.835e-08, 5.68592723044, 1589.0728952838],
                        [1.812e-08, 3.32042068028, 5088.6288397668],
                        [2.413e-08, 4.68291336853, 4690.4798363586],
                        [1.97e-08, 4.17480610904, 3340.5951730476],
                        [1.97e-08, 6.20643855008, 3340.629680352],
                        [1.627e-08, 5.67733051452, 4535.0594369244],
                        [2.16e-08, 1.07452599834, 2388.8940204492],
                        [1.964e-08, 3.10805316088, 3583.3410306738],
                        [1.985e-08, 5.7585035184, 4399.994356889],
                        [1.507e-08, 4.95936409838, 382.8965322232],
                        [1.278e-08, 4.82232889938, 2957.7158944766],
                        [1.475e-08, 2.22707926559, 3723.508958923],
                        [1.196e-08, 3.2672445892, 9492.1463150048],
                        [1.349e-08, 4.87573224485, 6525.8044539654],
                        [1.433e-08, 2.69734916443, 7079.3738568078],
                        [1.224e-08, 2.62012336714, 10025.3603984484],
                        [1.404e-08, 5.19056026479, 2700.7151403858],
                        [1.202e-08, 0.93472783088, 2810.9214616052],
                        [8.69e-09, 5.81340811635, 12303.06777661],
                        [8.67e-09, 2.20046640409, 2699.7348193176],
                        [8.3e-09, 2.01484544773, 5092.1519581158],
                        [8.55e-09, 5.96220147975, 426.598190876],
                        [8.48e-09, 2.26407047301, 6283.0758499914],
                        [9.17e-09, 1.40295785881, 6489.776587288],
                        [8.33e-09, 1.17384197174, 7477.522860216],
                        [1.041e-08, 6.27171470048, 3347.7259737006],
                        [9.65e-09, 3.39855816541, 5621.8429232104],
                        [7.22e-09, 4.26304776331, 4933.2084403326],
                        [7.06e-09, 2.34131594714, 7.1135470008],
                        [7.68e-09, 2.06208352904, 5486.777843175],
                        [9.53e-09, 2.11123497948, 3870.3033917944],
                        [8.44e-09, 2.2393196324, 3553.9115221378],
                        [6.46e-09, 2.24669034469, 3340.545116397],
                        [6.53e-09, 3.99043329363, 6677.7017350506],
                        [7.14e-09, 0.29739480601, 6681.2421070518],
                        [8.28e-09, 0.2286361767, 3532.0606928114],
                        [6.12e-09, 1.55388376751, 7234.794256242],
                        [7.14e-09, 4.54969883976, 6681.2075997474],
                        [5.86e-09, 3.30118433303, 1221.8485663214],
                        [6.46e-09, 1.83853693231, 3340.6797370026],
                        [5.6e-09, 5.05848353328, 8031.0922630584],
                        [6.51e-09, 0.1589747216, 7632.9432596502],
                        [4.88e-09, 3.08086378649, 6836.6452528338],
                        [5.34e-09, 4.25727954634, 3339.6321056316],
                        [5.04e-09, 2.59990772815, 23384.2869868986],
                        [3.72e-09, 6.27186983164, 2487.4160449478],
                        [3.43e-09, 4.71059403854, 639.897286314],
                        [4.49e-09, 1.34123846614, 640.8776073822],
                        [3.42e-09, 5.96338023755, 4929.6853219836],
                        [3.29e-09, 2.6595525877, 9623.6882766912],
                        [3.52e-09, 6.09567212646, 7740.6067835888],
                        [3.26e-09, 6.05498346093, 2118.7638603784],
                        [4.03e-09, 4.96465831103, 8969.568896911],
                        [4.02e-09, 2.84624835384, 5331.3574437408],
                        [3.19e-09, 1.44545457475, 5729.506447149],
                        [3.03e-09, 0.01918776551, 6127.6554505572],
                        [2.97e-09, 5.74070606294, 6041.3275670856],
                        [2.97e-09, 3.06763224975, 10419.9862835076],
                        [2.82e-09, 6.04069352017, 7875.6718636242],
                        [2.78e-09, 5.11654962157, 11773.3768115154],
                        [2.59e-09, 2.89786343627, 7210.9158184942],
                        [2.73e-09, 3.83181794308, 8429.2412664666],
                        [2.56e-09, 1.08862226474, 2288.3440435114],
                        [2.88e-09, 6.1357268768, 6682.2051744678],
                        [3.02e-09, 3.61490647715, 12832.7587417046],
                        [2.35e-09, 2.21413387615, 6681.2921637024],
                        [3.17e-09, 3.60634897209, 2301.58581590939],
                        [2.89e-09, 5.08223311018, 2274.1169495098],
                        [2.54e-09, 0.36603904729, 3767.2106175758],
                        [2.35e-09, 2.6243448155, 6681.1575430968],
                        [2.26e-09, 3.45305949713, 6923.9534573736],
                        [2.05e-09, 3.88943452829, 10018.3141617504],
                        [2.06e-09, 3.44453113177, 10177.2576795336],
                        [2.1e-09, 0.57926734389, 10973.55568635],
                        [1.94e-09, 1.57870686859, 10818.1352869158],
                        [1.9e-09, 2.42312911773, 8955.3418029094],
                        [1.94e-09, 2.45887376159, 7064.1213856228],
                        [1.93e-09, 0.58793888724, 5828.0284716476],
                        [1.83e-09, 1.68247271963, 213.299095438],
                        [2.36e-09, 1.98863774162, 10575.4066829418],
                        [2.45e-09, 2.17761779228, 4562.4609930212],
                        [1.77e-09, 0.66379705293, 10021.8545337516],
                        [1.76e-09, 4.91607557961, 10021.8200264472],
                        [2.17e-09, 2.93968443649, 13365.9728251482],
                        [1.67e-09, 4.74764434327, 3914.9572250346],
                        [2.13e-09, 0.15734917857, 2942.4634232916],
                        [1.55e-09, 1.78776991092, 9830.3890139878],
                        [1.8e-09, 5.21088564787, 9866.4168806652],
                        [1.61e-09, 5.1768386138, 6298.3283211764],
                        [1.59e-09, 2.6898068485, 6894.5239488376],
                        [1.49e-09, 6.26524493469, 1039.0266107904],
                        [1.47e-09, 0.36939961702, 6688.3384004004],
                        [1.51e-09, 1.2227289229, 574.3447983348],
                        [1.37e-09, 2.09492296067, 1066.49547719],
                        [1.65e-09, 6.15952050903, 15643.6802033098],
                        [1.63e-09, 4.66507592292, 8273.8208670324],
                        [1.24e-09, 0.67855210339, 6438.4962494256],
                        [1.28e-09, 1.69206367749, 3981.490034082],
                        [1.16e-09, 2.78191248964, 3360.96774609859],
                        [1.28e-09, 0.84461423001, 3355.8648978848],
                        [1.24e-09, 1.63253732557, 6674.1113063988],
                        [1.2e-09, 0.31762150109, 3127.3133312618],
                        [1.29e-09, 2.26678583645, 6467.9257579616],
                        [1.04e-09, 0.07355376701, 3325.3599555148],
                        [1.3e-09, 4.4177719083, 3320.257107301],
                        [9.5e-10, 1.31957248342, 7903.073419721],
                        [1.14e-09, 0.65681602343, 3178.1457905676],
                        [9.2e-10, 4.98392367746, 9779.1086761254],
                        [1.01e-09, 4.10670787374, 536.8045120954],
                        [1.06e-09, 5.41622566807, 15113.9892382152],
                        [9.6e-10, 3.52561014696, 3475.6775067352],
                        [1.01e-09, 2.91169549546, 692.1576012268],
                        [9.3e-10, 3.21464368291, 8671.9698704406],
                        [8.7e-10, 5.24375873119, 13119.7211028252],
                        [1.06e-09, 3.76804681559, 13517.8701062334],
                        [8.9e-10, 5.73652101746, 11371.7046897582],
                        [1.04e-09, 5.90078964406, 8432.7643848156],
                        [9.9e-10, 3.61425346453, 853.196381752],
                        [7.8e-10, 0.95802015551, 3191.0492295652],
                        [8.9e-10, 2.50872076312, 1052.2683831884],
                        [7.8e-10, 2.98115354616, 26724.8994135984],
                        [7.9e-10, 5.9151499393, 6040.3472460174],
                        [9e-10, 3.00950470302, 12964.300703391],
                        [7.5e-10, 1.31512531841, 17924.9106998204],
                        [7.3e-10, 5.01153593776, 1903.4368125012],
                        [7.5e-10, 2.57969241717, 10021.9045904022],
                        [7.3e-10, 4.09954161905, 3319.8370312074],
                        [7e-10, 5.37678396256, 12310.1813236108],
                        [7.1e-10, 0.9842299824, 13362.4669604514],
                        [6.8e-10, 4.69140248943, 522.5774180938],
                        [6.8e-10, 3.24217441291, 16706.585251848],
                        [6.9e-10, 2.53964193741, 5884.9268465832],
                        [7e-10, 2.38237948321, 13916.0191096416],
                        [6.6e-10, 3.48443797546, 13760.5987102074],
                        [6.8e-10, 5.27435069681, 3980.5097130138],
                        [7.6e-10, 0.12288413214, 11216.284290324],
                        [7.3e-10, 3.94785759909, 16173.3711684044],
                        [6.2e-10, 0.15518975647, 11081.2192102886],
                        [7.4e-10, 2.99926779692, 10021.7699697966],
                        [8e-10, 6.18812323827, 9380.9596727172],
                        [6.4e-10, 3.99294283669, 13358.9265884502],
                        [6.1e-10, 2.56817782412, 149.5631971346],
                        [5.9e-10, 3.80850908229, 10264.5658840734],
                        [6e-10, 4.79879360562, 1437.1756141986],
                        [6.8e-10, 2.07515658228, 1596.1864422846],
                        [6e-10, 2.26503107747, 28628.3362260996],
                        [5.8e-10, 6.10782258899, 5459.3762870782],
                        [6.3e-10, 0.24407077742, 18984.2926300096],
                        [5.8e-10, 5.22738430747, 13362.432453147],
                        [5.6e-10, 1.88708253797, 9070.1188738488],
                        [5.5e-10, 5.72587156499, 433.7117378768],
                        [5.6e-10, 1.18238857561, 6696.4773245846],
                        [6.2e-10, 3.98214740104, 3427.9206312396],
                        [5.6e-10, 5.37129176649, 5099.2655051166],
                        [5.7e-10, 0.86204712032, 5642.1982426092],
                        [5.5e-10, 1.31787605222, 8982.810669309],
                        [5.6e-10, 5.49808236951, 24093.2767891752],
                        [5.4e-10, 3.77562154746, 10213.285546211],
                        [5.4e-10, 2.36294643031, 33716.9650658664],
                        [6.3e-10, 3.53402427573, 3205.5473466644],
                        [6.6e-10, 6.25810929981, 8270.2977486834],
                        [6.7e-10, 0.5859281308, 3335.0895023924],
                        [5.5e-10, 4.74995645767, 6660.8695340008],
                        [5.3e-10, 0.31930032532, 12721.572099417],
                        [6.9e-10, 2.42905593362, 6158.6474353058],
                        [5.5e-10, 5.03192783121, 7255.5696517344],
                        [5.1e-10, 5.45351947711, 13207.029307365],
                        [5e-10, 0.23368526162, 4379.6390374902],
                        [5.3e-10, 2.1282634402, 13171.0014406876],
                        [4.9e-10, 2.35512151368, 4032.7700279266],
                        [4.9e-10, 2.8177305089, 9808.5381846614],
                        [6.7e-10, 2.26295786556, 2766.267628365],
                        [4.9e-10, 0.72597680486, 10028.9508271002],
                        [5e-10, 6.1011945035, 3253.30422216],
                        [5.9e-10, 0.27861398526, 9225.539273283],
                        [5.3e-10, 1.27330874549, 3344.4937620578],
                        [4.9e-10, 2.91499389416, 10404.7338123226],
                        [4.7e-10, 0.48598973231, 17395.2197347258],
                        [4.9e-10, 3.40240207389, 3304.5845600224],
                        [6e-10, 3.40554368741, 10551.528245194],
                        [5e-10, 1.83471955355, 30376.3526391666],
                        [4.6e-10, 3.04980996832, 6144.4203413042],
                        [4.9e-10, 0.33200904496, 6702.000248892],
                        [5.3e-10, 0.35820094732, 9468.267877257],
                        [5e-10, 0.15378507249, 2648.454825473],
                        [4.4e-10, 0.79762157297, 7107.8230442756],
                        [5e-10, 2.41332661328, 4407.1079038898],
                        [5.4e-10, 0.21682940856, 10022.8176011676],
                        [4.4e-10, 5.78502737591, 3364.4908644476],
                        [4.4e-10, 0.75508636274, 16062.1845261168],
                        [4.3e-10, 3.10581037685, 10235.1363755374],
                        [4.4e-10, 5.21252098878, 7373.3824546264],
                        [5.8e-10, 4.51680312444, 6660.4494579072],
                        [4.3e-10, 0.15523355839, 1505.28780909299],
                        [5.5e-10, 5.93371026829, 8439.8779318164],
                        [4.2e-10, 5.40417232308, 3344.2028553516],
                        [5.6e-10, 3.87534582911, 6816.289933435],
                        [4.9e-10, 5.57153056447, 17468.8551979454],
                        [4.6e-10, 3.07783299049, 12722.5524204852],
                        [4.5e-10, 1.49303542795, 6247.5131155228],
                        [5.5e-10, 6.26098836404, 3361.3878221922],
                        [4.2e-10, 4.74455545491, 3369.0616141676],
                        [4e-10, 1.58676666294, 2818.035008606],
                        [4.3e-10, 4.97295184315, 3337.021998048],
                        [5.5e-10, 3.8021563852, 3376.6402933772],
                        [4.7e-10, 1.97367775421, 1581.959348283],
                        [4.5e-10, 2.03598705348, 5244.049239201],
                        [4.9e-10, 4.43182954044, 9595.2390892234],
                        [4.3e-10, 0.38914582094, 6665.9723822146],
                        [4e-10, 1.06953099245, 23695.127785767],
                        [3.8e-10, 0.59996214864, 10713.9948813262],
                        [3.9e-10, 3.79055778605, 33318.8160624582],
                        [4.1e-10, 5.54542347834, 3863.1898447936],
                        [3.7e-10, 5.27208151144, 20752.6643624754],
                        [3.9e-10, 3.15412760412, 14469.588512484],
                        [4.1e-10, 0.55705920174, 3346.1353510072],
                        [4.8e-10, 1.42210748234, 3316.733988952],
                        [4.9e-10, 5.44942247991, 9638.9407478762],
                        [3.8e-10, 2.11846271943, 15664.0355227086],
                        [3.5e-10, 5.30782933148, 6677.6344247478],
                        [3.6e-10, 2.68151450016, 8584.6616659008],
                        [4.6e-10, 3.09450395763, 6701.5801727984],
                        [3.8e-10, 1.81885395671, 14158.7477136156],
                        [3.7e-10, 5.80483071722, 6684.8152820514],
                        [4.7e-10, 2.60317702777, 162.4666361322],
                        [3.8e-10, 2.22559377525, 3503.079062832],
                        [3.5e-10, 0.84358942718, 6518.7582172674],
                        [3.3e-10, 4.92302322062, 23141.5583829246],
                        [4.3e-10, 0.95148893985, 34115.1140692746],
                        [4.6e-10, 4.99457196207, 9381.9399937854],
                        [4.3e-10, 1.73832102244, 12323.4230960088],
                        [3.2e-10, 2.92741580696, 9499.2598620056],
                        [4.3e-10, 1.50296327105, 27035.7402124668],
                        [3.3e-10, 5.41731109688, 20597.2439630412],
                        [3.2e-10, 4.13881058425, 31570.7996493912],
                        [4e-10, 5.8446306918, 16460.333529525],
                        [3.5e-10, 5.50083743557, 8425.6508378148],
                        [3.8e-10, 5.91991985929, 3336.7310913418],
                        [3e-10, 5.09155042811, 5085.038411115],
                        [3.1e-10, 4.27211180916, 36659.428489158],
                        [3e-10, 4.87389489592, 1692.1656695024],
                        [3e-10, 3.75494646937, 4845.9002357928],
                        [3.4e-10, 3.71030605417, 8827.3902698748],
                        [3e-10, 0.0159945685, 11243.6858464208],
                        [2.9e-10, 2.66198696023, 12295.9542296092],
                        [2.8e-10, 3.12114207206, 11925.2740926006],
                        [3.6e-10, 1.16568750904, 18052.9295431578],
                        [3.2e-10, 1.72704226918, 12566.1516999828],
                        [2.8e-10, 2.80254457895, 3607.2194684216],
                        [3.2e-10, 4.04390839531, 6680.2445323314],
                        [2.7e-10, 2.53565904393, 19004.6479494084],
                        [3.6e-10, 3.33518515689, 29978.2036357584],
                        [2.8e-10, 0.58104982217, 20354.5153590672],
                        [2.9e-10, 5.85207825749, 31172.650645983],
                        [2.6e-10, 2.22598820379, 3.523118349],
                        [3.3e-10, 5.15903548241, 10596.1820784342],
                        [2.8e-10, 1.89792803028, 3333.5661900018],
                        [2.7e-10, 2.25129832716, 76.2660712756],
                        [2.6e-10, 4.32703172263, 17085.9586657222],
                        [2.6e-10, 5.12847780702, 11766.2632645146],
                        [2.8e-10, 0.80926596905, 20735.8321614256],
                        [2.6e-10, 5.06814803493, 17412.0519357756],
                        [2.4e-10, 4.473991556, 3134.4268782626],
                        [2.4e-10, 4.35557152695, 14584.2982731206],
                        [2.7e-10, 4.98717355201, 3877.4169387952],
                        [2.5e-10, 5.63712701265, 14054.607308026],
                        [2.4e-10, 4.12573657295, 4193.8088084518],
                        [2.5e-10, 1.40880282063, 8186.5126624926],
                        [2.4e-10, 4.96463811748, 26087.9031415742],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [1.113107e-05, 5.14987350142, 3340.6124266998],
                        [4.24446e-06, 5.61343766478, 6681.2248533996],
                        [1.00044e-06, 5.99726827028, 10021.8372800994],
                        [1.9606e-07, 0.07633062094, 13362.4497067992],
                        [3.477e-08, 0.42951907576, 16703.062133499],
                        [4.693e-08, 3.14159265359, 0],
                        [2.869e-08, 0.44711842697, 3344.1355450488],
                        [2.428e-08, 3.02115527957, 3185.1920272656],
                        [6.88e-09, 0.80693359444, 6684.7479717486],
                        [5.4e-09, 3.86836515672, 1059.3819301892],
                        [5.77e-09, 0.7785327512, 20043.6745601988],
                        [4.68e-09, 4.52450786544, 3496.032826134],
                        [4.87e-09, 1.60862391345, 3583.3410306738],
                        [3.62e-09, 4.42397903418, 2787.0430238574],
                        [3.97e-09, 5.71967986581, 3149.1641605882],
                        [2.99e-09, 0.75640033535, 3738.761430108],
                        [3.5e-09, 5.55691984889, 4136.9104335162],
                        [3.14e-09, 3.37632898783, 6525.8044539654],
                        [2.33e-09, 2.13965262306, 3097.88382272579],
                        [2.12e-09, 4.20487494011, 3341.592747768],
                        [2.14e-09, 0.56779556947, 155.4203994342],
                        [2.01e-09, 2.35284464564, 1592.5960136328],
                        [2.04e-09, 0.96723315302, 1990.745017041],
                        [2.3e-09, 5.82959057146, 2388.8940204492],
                        [1.6e-09, 4.14974194757, 4535.0594369244],
                        [1.56e-09, 5.13345210285, 796.2980068164],
                        [1.46e-09, 3.29541339704, 2957.7158944766],
                        [1.56e-09, 1.13805508457, 10025.3603984484],
                        [1.59e-09, 3.76174286126, 1194.4470102246],
                        [1.36e-09, 5.58293924642, 3894.1818295422],
                        [1.45e-09, 3.02112488974, 3337.0893083508],
                        [1.46e-09, 4.25359617225, 4399.994356889],
                        [1e-09, 4.26740096115, 1589.0728952838],
                        [9.1e-10, 6.12108227231, 6489.776587288],
                        [1.01e-09, 1.17242141914, 7079.3738568078],
                        [9.8e-10, 1.12613498307, 23384.2869868986],
                        [7.5e-10, 6.02182689533, 529.6909650946],
                        [7.8e-10, 5.93418069229, 7477.522860216],
                        [6.8e-10, 1.70775041911, 9492.1463150048],
                        [7e-10, 3.67253155189, 8962.4553499102],
                        [6.2e-10, 4.14954627063, 4292.3308329504],
                        [6.7e-10, 0.1509224655, 3870.3033917944],
                        [6.6e-10, 1.12578506413, 6151.533888305],
                        [6.2e-10, 1.93984222091, 6923.9534573736],
                        [6e-10, 4.30641513096, 12303.06777661],
                        [7.4e-10, 4.72156358149, 3347.7259737006],
                        [5.5e-10, 2.75742802464, 4933.2084403326],
                        [5.3e-10, 4.77894621871, 6127.6554505572],
                        [5e-10, 2.57807944338, 3340.5951730476],
                        [4.8e-10, 3.72532068729, 9866.4168806652],
                        [4.2e-10, 6.15391373101, 7234.794256242],
                        [4.3e-10, 3.43955584179, 5486.777843175],
                        [5e-10, 4.60885064189, 3340.629680352],
                        [4.4e-10, 4.47943289816, 426.598190876],
                        [4.5e-10, 6.244852075, 2274.1169495098],
                        [4e-10, 0.73805316471, 7.1135470008],
                        [3.8e-10, 1.06497784748, 9623.6882766912],
                        [4.1e-10, 4.60954640493, 6682.2051744678],
                        [3.8e-10, 4.60963924082, 7740.6067835888],
                        [3.6e-10, 3.15129246169, 639.897286314],
                        [3.7e-10, 6.14629970622, 5729.506447149],
                        [4e-10, 1.4739554485, 13365.9728251482],
                        [3.5e-10, 2.60772245492, 4690.4798363586],
                        [3.5e-10, 2.450779319, 2288.3440435114],
                        [3.4e-10, 4.50544497582, 7875.6718636242],
                        [4.2e-10, 2.11383330882, 12832.7587417046],
                        [3.3e-10, 3.97655860802, 191.4482661116],
                        [3.2e-10, 4.06047154083, 3532.0606928114],
                        [3.4e-10, 5.06671994554, 6681.2421070518],
                        [4.2e-10, 4.67024017441, 15643.6802033098],
                        [3.6e-10, 0.29140871479, 3723.508958923],
                        [3.3e-10, 4.52588149629, 4929.6853219836],
                        [3.4e-10, 2.7449907289, 6677.7017350506],
                        [3e-10, 1.57743012295, 10419.9862835076],
                        [4e-10, 1.31713176335, 5331.3574437408],
                        [3.4e-10, 3.03490000148, 6681.2075997474],
                        [3.1e-10, 1.25306164576, 242.728603974],
                        [2.9e-10, 5.44118048011, 10021.8545337516],
                        [2.9e-10, 3.41037097794, 10021.8200264472],
                        [2.8e-10, 4.81855060968, 6836.6452528338],
                        [2.8e-10, 0.72745302325, 6283.0758499914],
                        [3e-10, 3.06267495632, 2281.2304965106],
                        [2.7e-10, 0.62535799761, 6681.2921637024],
                        [3e-10, 3.56389476096, 8969.568896911],
                        [3.2e-10, 5.31078691958, 553.5694028424],
                        [3.3e-10, 2.00753799963, 5884.9268465832],
                        [2.7e-10, 1.18001479303, 8955.3418029094],
                        [2.5e-10, 2.94122791628, 2544.3144198834],
                        [2.5e-10, 0.17808889827, 9830.3890139878],
                        [3.1e-10, 5.73384204593, 3339.6321056316],
                        [2.8e-10, 3.70436008855, 6298.3283211764],
                        [2.4e-10, 0.07739730466, 10818.1352869158],
                        [2.7e-10, 1.03401737006, 6681.1575430968],
                        [2.4e-10, 0.09987383242, 382.8965322232],
                        [2.7e-10, 0.60053652251, 3553.9115221378],
                        [2.7e-10, 4.97107900859, 3767.2106175758],
                        [2.4e-10, 3.36621347824, 8031.0922630584],
                        [2.6e-10, 4.80509833364, 7632.9432596502],
                        [2.2e-10, 1.43966107077, 26724.8994135984],
                        [2e-10, 0.36901153144, 398.1490034082],
                        [1.9e-10, 1.00325306041, 7064.1213856228],
                        [2e-10, 0.19821371186, 6674.1113063988],
                        [1.8e-10, 1.07169297658, 7210.9158184942],
                        [2.1e-10, 2.6951214034, 10018.3141617504],
                        [2.3e-10, 3.25670295081, 5621.8429232104],
                        [1.8e-10, 0.24542781929, 3981.490034082],
                        [1.8e-10, 5.14428605713, 6688.3384004004],
                        [2e-10, 0.97539014916, 6894.5239488376],
                        [2.4e-10, 4.42156401638, 1748.016413067],
                        [1.6e-10, 0.6538950344, 3340.545116397],
                        [1.6e-10, 5.28427106012, 3333.498879699],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [1.9552e-07, 3.58211650473, 3340.6124266998],
                        [1.6323e-07, 4.05116076923, 6681.2248533996],
                        [5.848e-08, 4.46383962094, 10021.8372800994],
                        [1.532e-08, 4.84374321619, 13362.4497067992],
                        [3.75e-09, 1.50962233608, 3185.1920272656],
                        [3.39e-09, 5.20684967613, 16703.062133499],
                        [1.51e-09, 5.16472931648, 3344.1355450488],
                        [1.25e-09, 2.19233532803, 3496.032826134],
                        [1.48e-09, 0, 0],
                        [8.7e-10, 0.10275067375, 3583.3410306738],
                        [7e-10, 5.55303619365, 20043.6745601988],
                        [4.8e-10, 2.91797786512, 2787.0430238574],
                        [4.9e-10, 5.5703851483, 6684.7479717486],
                        [5.7e-10, 1.86867280743, 6525.8044539654],
                        [3.4e-10, 3.63370917313, 3097.88382272579],
                        [2.1e-10, 2.30677637991, 1059.3819301892],
                        [2.1e-10, 4.03682122005, 4136.9104335162],
                        [1.8e-10, 4.1743875589, 3149.1641605882],
                        [1.3e-10, 1.97805475719, 155.4203994342],
                        [1.7e-10, 5.9485641469, 10025.3603984484],
                        [1.2e-10, 0.51097435253, 6923.9534573736],
                        [1.2e-10, 3.27945299261, 6127.6554505572],
                        [1.3e-10, 2.22938285522, 9866.4168806652],
                        [1.6e-10, 2.64206771227, 4399.994356889],
                        [1.3e-10, 2.75813969974, 6836.6452528338],
                        [1.3e-10, 4.51988349676, 6489.776587288],
                        [1.4e-10, 0.76591550754, 3894.1818295422],
                        [1.1e-10, 5.47381242145, 3738.761430108],
                      ],
          },
          {
            series => "R5",
            terms  => [
                        [4.76e-09, 2.47617204701, 6681.2248533996],
                        [2.68e-09, 2.91510547706, 10021.8372800994],
                        [1.15e-09, 1.76888962311, 3340.6124266998],
                        [9.6e-10, 3.31378377179, 13362.4497067992],
                        [4.8e-10, 6.27457828287, 3185.1920272656],
                        [2.7e-10, 3.69380877066, 16703.062133499],
                        [1.3e-10, 3.72005807206, 3496.032826134],
                        [1.2e-10, 4.88179002689, 3583.3410306738],
                        [1.2e-10, 3.14159265359, 0],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 4,
      sidereal_period => 59355058.747,
      tropical_period => 59350726.982,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Mars - VSOP87D model of the position of Mars

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Mars;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Mars->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Mars using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Superior|Astro::Coord::ECI::VSOP87D::_Superior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<https://rt.cpan.org/Public/Dist/Display.html?Name=Astro-Coord-ECI-VSOP87D>,
L<https://github.com/trwyant/perl-Astro-Coord-ECI-VSOP87D/issues>, or in
electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2022, 2024 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
