/************************************************************************
 *			Definition of the postscript fonts used		*
 ************************************************************************/
#include <assert.h>
#include "a2ps.h"
#include "afm.h"

/*
 *      This is the WX field of the afm file of the font Times-Roman
 *		(extracted by getISOwx)
 */
unsigned long Times_WX [256] = {
/* .notdef (/0) */      0,
/* .notdef (/1) */      0,
/* .notdef (/2) */      0,
/* .notdef (/3) */      0,
/* .notdef (/4) */      0,
/* .notdef (/5) */      0,
/* .notdef (/6) */      0,
/* .notdef (/7) */      0,
/* .notdef (/8) */      0,
/* .notdef (/9) */      0,
/* .notdef (/10) */     0,
/* .notdef (/11) */     0,
/* .notdef (/12) */     0,
/* .notdef (/13) */     0,
/* .notdef (/14) */     0,
/* .notdef (/15) */     0,
/* .notdef (/16) */     0,
/* .notdef (/17) */     0,
/* .notdef (/18) */     0,
/* .notdef (/19) */     0,
/* .notdef (/20) */     0,
/* .notdef (/21) */     0,
/* .notdef (/22) */     0,
/* .notdef (/23) */     0,
/* .notdef (/24) */     0,
/* .notdef (/25) */     0,
/* .notdef (/26) */     0,
/* .notdef (/27) */     0,
/* .notdef (/28) */     0,
/* .notdef (/29) */     0,
/* .notdef (/30) */     0,
/* .notdef (/31) */     0,
/* space (/32) */       250,
/* exclam (/33) */      333,
/* quotedbl (/34) */    408,
/* numbersign (/35) */  500,
/* dollar (/36) */      500,
/* percent (/37) */     833,
/* ampersand (/38) */   778,
/* quoteright (/39) */  333,
/* parenleft (/40) */   333,
/* parenright (/41) */  333,
/* asterisk (/42) */    500,
/* plus (/43) */        564,
/* comma (/44) */       250,
/* minus (/45) */       564,
/* period (/46) */      250,
/* slash (/47) */       278,
/* zero (/48) */        500,
/* one (/49) */ 500,
/* two (/50) */ 500,
/* three (/51) */       500,
/* four (/52) */        500,
/* five (/53) */        500,
/* six (/54) */ 500,
/* seven (/55) */       500,
/* eight (/56) */       500,
/* nine (/57) */        500,
/* colon (/58) */       278,
/* semicolon (/59) */   278,
/* less (/60) */        564,
/* equal (/61) */       564,
/* greater (/62) */     564,
/* question (/63) */    444,
/* at (/64) */  921,
/* A (/65) */   722,
/* B (/66) */   667,
/* C (/67) */   667,
/* D (/68) */   722,
/* E (/69) */   611,
/* F (/70) */   556,
/* G (/71) */   722,
/* H (/72) */   722,
/* I (/73) */   333,
/* J (/74) */   389,
/* K (/75) */   722,
/* L (/76) */   611,
/* M (/77) */   889,
/* N (/78) */   722,
/* O (/79) */   722,
/* P (/80) */   556,
/* Q (/81) */   722,
/* R (/82) */   667,
/* S (/83) */   556,
/* T (/84) */   611,
/* U (/85) */   722,
/* V (/86) */   722,
/* W (/87) */   944,
/* X (/88) */   722,
/* Y (/89) */   722,
/* Z (/90) */   611,
/* bracketleft (/91) */ 333,
/* backslash (/92) */   278,
/* bracketright (/93) */        333,
/* asciicircum (/94) */ 469,
/* underscore (/95) */  500,
/* quoteleft (/96) */   333,
/* a (/97) */   444,
/* b (/98) */   500,
/* c (/99) */   444,
/* d (/100) */  500,
/* e (/101) */  444,
/* f (/102) */  333,
/* g (/103) */  500,
/* h (/104) */  500,
/* i (/105) */  278,
/* j (/106) */  278,
/* k (/107) */  500,
/* l (/108) */  278,
/* m (/109) */  778,
/* n (/110) */  500,
/* o (/111) */  500,
/* p (/112) */  500,
/* q (/113) */  500,
/* r (/114) */  333,
/* s (/115) */  389,
/* t (/116) */  278,
/* u (/117) */  500,
/* v (/118) */  500,
/* w (/119) */  722,
/* x (/120) */  500,
/* y (/121) */  500,
/* z (/122) */  444,
/* braceleft (/123) */  480,
/* bar (/124) */        200,
/* braceright (/125) */ 480,
/* asciitilde (/126) */ 541,
/* .notdef (/127) */    0,
/* .notdef (/128) */    0,
/* .notdef (/129) */    0,
/* .notdef (/130) */    0,
/* .notdef (/131) */    0,
/* .notdef (/132) */    0,
/* .notdef (/133) */    0,
/* .notdef (/134) */    0,
/* .notdef (/135) */    0,
/* .notdef (/136) */    0,
/* .notdef (/137) */    0,
/* .notdef (/138) */    0,
/* .notdef (/139) */    0,
/* .notdef (/140) */    0,
/* .notdef (/141) */    0,
/* .notdef (/142) */    0,
/* .notdef (/143) */    0,
/* dotlessi (/144) */   278,
/* grave (/145) */      333,
/* acute (/146) */      333,
/* circumflex (/147) */ 333,
/* tilde (/148) */      333,
/* macron (/149) */     333,
/* breve (/150) */      333,
/* dotaccent (/151) */  333,
/* dieresis (/152) */   333,
/* .notdef (/153) */    0,
/* ring (/154) */       333,
/* cedilla (/155) */    333,
/* .notdef (/156) */    0,
/* hungarumlaut (/157) */       333,
/* ogonek (/158) */     333,
/* caron (/159) */      333,
/* space (/160) */      250,
/* exclamdown (/161) */ 333,
/* cent (/162) */       500,
/* sterling (/163) */   500,
/* currency (/164) */   500,
/* yen (/165) */        500,
/* brokenbar (/166) */  200,
/* section (/167) */    500,
/* dieresis (/168) */   333,
/* copyright (/169) */  760,
/* ordfeminine (/170) */        276,
/* guillemotleft (/171) */      500,
/* logicalnot (/172) */ 564,
/* hyphen (/173) */     333,
/* registered (/174) */ 760,
/* macron (/175) */     333,
/* degree (/176) */     400,
/* plusminus (/177) */  564,
/* twosuperior (/178) */        300,
/* threesuperior (/179) */      300,
/* acute (/180) */      333,
/* mu (/181) */ 500,
/* paragraph (/182) */  453,
/* periodcentered (/183) */     250,
/* cedilla (/184) */    333,
/* onesuperior (/185) */        300,
/* ordmasculine (/186) */       310,
/* guillemotright (/187) */     500,
/* onequarter (/188) */ 750,
/* onehalf (/189) */    750,
/* threequarters (/190) */      750,
/* questiondown (/191) */       444,
/* Agrave (/192) */     722,
/* Aacute (/193) */     722,
/* Acircumflex (/194) */        722,
/* Atilde (/195) */     722,
/* Adieresis (/196) */  722,
/* Aring (/197) */      722,
/* AE (/198) */ 889,
/* Ccedilla (/199) */   667,
/* Egrave (/200) */     611,
/* Eacute (/201) */     611,
/* Ecircumflex (/202) */        611,
/* Edieresis (/203) */  611,
/* Igrave (/204) */     333,
/* Iacute (/205) */     333,
/* Icircumflex (/206) */        333,
/* Idieresis (/207) */  333,
/* Eth (/208) */        722,
/* Ntilde (/209) */     722,
/* Ograve (/210) */     722,
/* Oacute (/211) */     722,
/* Ocircumflex (/212) */        722,
/* Otilde (/213) */     722,
/* Odieresis (/214) */  722,
/* multiply (/215) */   564,
/* Oslash (/216) */     722,
/* Ugrave (/217) */     722,
/* Uacute (/218) */     722,
/* Ucircumflex (/219) */        722,
/* Udieresis (/220) */  722,
/* Yacute (/221) */     722,
/* Thorn (/222) */      556,
/* germandbls (/223) */ 500,
/* agrave (/224) */     444,
/* aacute (/225) */     444,
/* acircumflex (/226) */        444,
/* atilde (/227) */     444,
/* adieresis (/228) */  444,
/* aring (/229) */      444,
/* ae (/230) */ 667,
/* ccedilla (/231) */   444,
/* egrave (/232) */     444,
/* eacute (/233) */     444,
/* ecircumflex (/234) */        444,
/* edieresis (/235) */  444,
/* igrave (/236) */     278,
/* iacute (/237) */     278,
/* icircumflex (/238) */        278,
/* idieresis (/239) */  278,
/* eth (/240) */        500,
/* ntilde (/241) */     500,
/* ograve (/242) */     500,
/* oacute (/243) */     500,
/* ocircumflex (/244) */        500,
/* otilde (/245) */     500,
/* odieresis (/246) */  500,
/* divide (/247) */     564,
/* oslash (/248) */     500,
/* ugrave (/249) */     500,
/* uacute (/250) */     500,
/* ucircumflex (/251) */        500,
/* udieresis (/252) */  500,
/* yacute (/253) */     500,
/* thorn (/254) */      500,
/* ydieresis (/255) */  500
};

/*
 *      This is the WX field of the afm file of the font Symbol
 *		(extracted by ./getwx)
 */
unsigned long Symbol_WX [256] = {
/* .notdef (/0) */      0,
/* .notdef (/1) */      0,
/* .notdef (/2) */      0,
/* .notdef (/3) */      0,
/* .notdef (/4) */      0,
/* .notdef (/5) */      0,
/* .notdef (/6) */      0,
/* .notdef (/7) */      0,
/* .notdef (/8) */      0,
/* .notdef (/9) */      0,
/* .notdef (/10) */     0,
/* .notdef (/11) */     0,
/* .notdef (/12) */     0,
/* .notdef (/13) */     0,
/* .notdef (/14) */     0,
/* .notdef (/15) */     0,
/* .notdef (/16) */     0,
/* .notdef (/17) */     0,
/* .notdef (/18) */     0,
/* .notdef (/19) */     0,
/* .notdef (/20) */     0,
/* .notdef (/21) */     0,
/* .notdef (/22) */     0,
/* .notdef (/23) */     0,
/* .notdef (/24) */     0,
/* .notdef (/25) */     0,
/* .notdef (/26) */     0,
/* .notdef (/27) */     0,
/* .notdef (/28) */     0,
/* .notdef (/29) */     0,
/* .notdef (/30) */     0,
/* .notdef (/31) */     0,
/* space (/32) */       250,
/* exclam (/33) */      333,
/* universal (/34) */   713,
/* numbersign (/35) */  500,
/* existential (/36) */ 549,
/* percent (/37) */     833,
/* ampersand (/38) */   778,
/* suchthat (/39) */    439,
/* parenleft (/40) */   333,
/* parenright (/41) */  333,
/* asteriskmath (/42) */        500,
/* plus (/43) */        549,
/* comma (/44) */       250,
/* minus (/45) */       549,
/* period (/46) */      250,
/* slash (/47) */       278,
/* zero (/48) */        500,
/* one (/49) */ 500,
/* two (/50) */ 500,
/* three (/51) */       500,
/* four (/52) */        500,
/* five (/53) */        500,
/* six (/54) */ 500,
/* seven (/55) */       500,
/* eight (/56) */       500,
/* nine (/57) */        500,
/* colon (/58) */       278,
/* semicolon (/59) */   278,
/* less (/60) */        549,
/* equal (/61) */       549,
/* greater (/62) */     549,
/* question (/63) */    444,
/* congruent (/64) */   549,
/* Alpha (/65) */       722,
/* Beta (/66) */        667,
/* Chi (/67) */ 722,
/* Delta (/68) */       612,
/* Epsilon (/69) */     611,
/* Phi (/70) */ 763,
/* Gamma (/71) */       603,
/* Eta (/72) */ 722,
/* Iota (/73) */        333,
/* theta1 (/74) */      631,
/* Kappa (/75) */       722,
/* Lambda (/76) */      686,
/* Mu (/77) */  889,
/* Nu (/78) */  722,
/* Omicron (/79) */     722,
/* Pi (/80) */  768,
/* Theta (/81) */       741,
/* Rho (/82) */ 556,
/* Sigma (/83) */       592,
/* Tau (/84) */ 611,
/* Upsilon (/85) */     690,
/* sigma1 (/86) */      439,
/* Omega (/87) */       768,
/* Xi (/88) */  645,
/* Psi (/89) */ 795,
/* Zeta (/90) */        611,
/* bracketleft (/91) */ 333,
/* therefore (/92) */   863,
/* bracketright (/93) */        333,
/* perpendicular (/94) */       658,
/* underscore (/95) */  500,
/* radicalex (/96) */   500,
/* alpha (/97) */       631,
/* beta (/98) */        549,
/* chi (/99) */ 549,
/* delta (/100) */      494,
/* epsilon (/101) */    439,
/* phi (/102) */        521,
/* gamma (/103) */      411,
/* eta (/104) */        603,
/* iota (/105) */       329,
/* phi1 (/106) */       603,
/* kappa (/107) */      549,
/* lambda (/108) */     549,
/* mu (/109) */ 576,
/* nu (/110) */ 521,
/* omicron (/111) */    549,
/* pi (/112) */ 549,
/* theta (/113) */      521,
/* rho (/114) */        549,
/* sigma (/115) */      603,
/* tau (/116) */        439,
/* upsilon (/117) */    576,
/* omega1 (/118) */     713,
/* omega (/119) */      686,
/* xi (/120) */ 493,
/* psi (/121) */        686,
/* zeta (/122) */       494,
/* braceleft (/123) */  480,
/* bar (/124) */        200,
/* braceright (/125) */ 480,
/* similar (/126) */    549,
/* .notdef (/127) */    0,
/* .notdef (/128) */    0,
/* .notdef (/129) */    0,
/* .notdef (/130) */    0,
/* .notdef (/131) */    0,
/* .notdef (/132) */    0,
/* .notdef (/133) */    0,
/* .notdef (/134) */    0,
/* .notdef (/135) */    0,
/* .notdef (/136) */    0,
/* .notdef (/137) */    0,
/* .notdef (/138) */    0,
/* .notdef (/139) */    0,
/* .notdef (/140) */    0,
/* .notdef (/141) */    0,
/* .notdef (/142) */    0,
/* .notdef (/143) */    0,
/* .notdef (/144) */    0,
/* .notdef (/145) */    0,
/* .notdef (/146) */    0,
/* .notdef (/147) */    0,
/* .notdef (/148) */    0,
/* .notdef (/149) */    0,
/* .notdef (/150) */    0,
/* .notdef (/151) */    0,
/* .notdef (/152) */    0,
/* .notdef (/153) */    0,
/* .notdef (/154) */    0,
/* .notdef (/155) */    0,
/* .notdef (/156) */    0,
/* .notdef (/157) */    0,
/* .notdef (/158) */    0,
/* .notdef (/159) */    0,
/* .notdef (/160) */    0,
/* Upsilon1 (/161) */   620,
/* minute (/162) */     247,
/* lessequal (/163) */  549,
/* fraction (/164) */   167,
/* infinity (/165) */   713,
/* florin (/166) */     500,
/* club (/167) */       753,
/* diamond (/168) */    753,
/* heart (/169) */      753,
/* spade (/170) */      753,
/* arrowboth (/171) */  1042,
/* arrowleft (/172) */  987,
/* arrowup (/173) */    603,
/* arrowright (/174) */ 987,
/* arrowdown (/175) */  603,
/* degree (/176) */     400,
/* plusminus (/177) */  549,
/* second (/178) */     411,
/* greaterequal (/179) */       549,
/* multiply (/180) */   549,
/* proportional (/181) */       713,
/* partialdiff (/182) */        494,
/* bullet (/183) */     460,
/* divide (/184) */     549,
/* notequal (/185) */   549,
/* equivalence (/186) */        549,
/* approxequal (/187) */        549,
/* ellipsis (/188) */   1000,
/* arrowvertex (/189) */        603,
/* arrowhorizex (/190) */       1000,
/* carriagereturn (/191) */     658,
/* aleph (/192) */      823,
/* Ifraktur (/193) */   686,
/* Rfraktur (/194) */   795,
/* weierstrass (/195) */        987,
/* circlemultiply (/196) */     768,
/* circleplus (/197) */ 768,
/* emptyset (/198) */   823,
/* intersection (/199) */       768,
/* union (/200) */      768,
/* propersuperset (/201) */     713,
/* reflexsuperset (/202) */     713,
/* notsubset (/203) */  713,
/* propersubset (/204) */       713,
/* reflexsubset (/205) */       713,
/* element (/206) */    713,
/* notelement (/207) */ 713,
/* angle (/208) */      768,
/* gradient (/209) */   713,
/* registerserif (/210) */      790,
/* copyrightserif (/211) */     790,
/* trademarkserif (/212) */     890,
/* product (/213) */    823,
/* radical (/214) */    549,
/* dotmath (/215) */    250,
/* logicalnot (/216) */ 713,
/* logicaland (/217) */ 603,
/* logicalor (/218) */  603,
/* arrowdblboth (/219) */       1042,
/* arrowdblleft (/220) */       987,
/* arrowdblup (/221) */ 603,
/* arrowdblright (/222) */      987,
/* arrowdbldown (/223) */       603,
/* lozenge (/224) */    494,
/* angleleft (/225) */  329,
/* registersans (/226) */       790,
/* copyrightsans (/227) */      790,
/* trademarksans (/228) */      786,
/* summation (/229) */  713,
/* parenlefttp (/230) */        384,
/* parenleftex (/231) */        384,
/* parenleftbt (/232) */        384,
/* bracketlefttp (/233) */      384,
/* bracketleftex (/234) */      384,
/* bracketleftbt (/235) */      384,
/* bracelefttp (/236) */        494,
/* braceleftmid (/237) */       494,
/* braceleftbt (/238) */        494,
/* braceex (/239) */    494,
/* .notdef (/240) */    790,		/* actually this is apple */
/* angleright (/241) */ 329,
/* integral (/242) */   274,
/* integraltp (/243) */ 686,
/* integralex (/244) */ 686,
/* integralbt (/245) */ 686,
/* parenrighttp (/246) */       384,
/* parenrightex (/247) */       384,
/* parenrightbt (/248) */       384,
/* bracketrighttp (/249) */     384,
/* bracketrightex (/250) */     384,
/* bracketrightbt (/251) */     384,
/* bracerighttp (/252) */       494,
/* bracerightmid (/253) */      494,
/* bracerightbt (/254) */       494,
};

/*
 *	Returns the WX of a char (including M- and ^)
 */
unsigned long char_WX(unsigned char c, FONT font)
{
  if (only_printable)
    return CHAR_WX(c, font);

  if (ISOlatin1)
    return((c < ' ' || (c < 144 && 0177 <= c) ? CHAR_WX('^', font) : 0) 
	   + CHAR_WX(c, font));
  
  return(0177 < c ? (CHAR_WX('M', font) + CHAR_WX('-', font)): 0 
	 + ((c&0177) < ' ' || (c&0177) == 0177 ? CHAR_WX('^', font) : 0) 
	 + CHAR_WX(c, font));
}

/*
 *	Returns the WX of a string (including M- and ^)
 */
unsigned long string_WX(unsigned char *string, FONT font)
{
  unsigned long result=0;

  assert(string);

  for (/* skip */; *string ; string ++)
    result += char_WX(*string, font);

  return result;
}
