package Games::LMSolve::Registry;
$Games::LMSolve::Registry::VERSION = '0.14.0';
use strict;
use warnings;


use Games::LMSolve;

use vars qw(@ISA);

@ISA = qw(Games::LMSolve);

use Games::LMSolve::Alice;
use Games::LMSolve::Minotaur;
use Games::LMSolve::Numbers;
use Games::LMSolve::Plank::Base;
use Games::LMSolve::Tilt::Single;
use Games::LMSolve::Tilt::Multi;
use Games::LMSolve::Tilt::RedBlue;
use Games::LMSolve::Plank::Hex;


sub register_all_solvers
{
    my $self = shift;
    $self->register_solvers(
        {
            'alice'       => "Games::LMSolve::Alice",
            'minotaur'    => "Games::LMSolve::Minotaur",
            'numbers'     => "Games::LMSolve::Numbers",
            'plank'       => "Games::LMSolve::Plank::Base",
            'hex_plank'   => "Games::LMSolve::Plank::Hex",
            'tilt_single' => "Games::LMSolve::Tilt::Single",
            'tilt_multi'  => "Games::LMSolve::Tilt::Multi",
            'tilt_rb'     => "Games::LMSolve::Tilt::RedBlue",
            'tilt_puzzle' => "Games::LMSolve::Tilt::RedBlue",
        }
    );

    $self->set_default_variant("minotaur");

    return 0;
}

1;

__END__

=pod

=head1 NAME

Games::LMSolve::Registry - the registry of all LM-Solve drivers.

=head1 VERSION

version 0.14.0

=head1 DESCRIPTION

This is a registry of all LM-Solve drivers.

=head1 METHODS

=head2 $self->register_all_solvers()

Register all the solvers.

=head1 SEE ALSO

L<Games::LMSolve>

=head1 AUTHORS

Shlomi Fish, L<http://www.shlomifish.org/>

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2007 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/lm-solve-source/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Perldoc

You can find documentation for this module with the perldoc command.

  perldoc Games::LMSolve::Registry

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/Games-LMSolve>

=item *

Search CPAN

The default CPAN search engine, useful to view POD in HTML format.

L<http://search.cpan.org/dist/Games-LMSolve>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Games-LMSolve>

=item *

AnnoCPAN

The AnnoCPAN is a website that allows community annotations of Perl module documentation.

L<http://annocpan.org/dist/Games-LMSolve>

=item *

CPAN Ratings

The CPAN Ratings is a website that allows community ratings and reviews of Perl modules.

L<http://cpanratings.perl.org/d/Games-LMSolve>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Games-LMSolve>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/G/Games-LMSolve>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Games-LMSolve>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Games::LMSolve>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-games-lmsolve at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Games-LMSolve>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/lm-solve-source>

  git clone git://github.com/shlomif/lm-solve-source.git

=cut
