# Generated by default/object.tt
package Paws::SageMaker::DeviceSummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has DeviceArn => (is => 'ro', isa => 'Str', required => 1);
  has DeviceFleetName => (is => 'ro', isa => 'Str');
  has DeviceName => (is => 'ro', isa => 'Str', required => 1);
  has IotThingName => (is => 'ro', isa => 'Str');
  has LatestHeartbeat => (is => 'ro', isa => 'Str');
  has Models => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::EdgeModelSummary]');
  has RegistrationTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DeviceSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::DeviceSummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., RegistrationTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::DeviceSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Summary of the device.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the device.


=head2 B<REQUIRED> DeviceArn => Str

Amazon Resource Name (ARN) of the device.


=head2 DeviceFleetName => Str

The name of the fleet the device belongs to.


=head2 B<REQUIRED> DeviceName => Str

The unique identifier of the device.


=head2 IotThingName => Str

The Amazon Web Services Internet of Things (IoT) object thing name
associated with the device..


=head2 LatestHeartbeat => Str

The last heartbeat received from the device.


=head2 Models => ArrayRef[L<Paws::SageMaker::EdgeModelSummary>]

Models on the device.


=head2 RegistrationTime => Str

The timestamp of the last registration or de-reregistration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

