# Generated by default/object.tt
package Paws::Route53Resolver::ResolverQueryLogConfigAssociation;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has Error => (is => 'ro', isa => 'Str');
  has ErrorMessage => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has ResolverQueryLogConfigId => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::ResolverQueryLogConfigAssociation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::ResolverQueryLogConfigAssociation object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::ResolverQueryLogConfigAssociation object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

In the response to an AssociateResolverQueryLogConfig
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html),
DisassociateResolverQueryLogConfig
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html),
GetResolverQueryLogConfigAssociation
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html),
or ListResolverQueryLogConfigAssociations
(https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html),
request, a complex type that contains settings for a specified
association between an Amazon VPC and a query logging configuration.

=head1 ATTRIBUTES


=head2 CreationTime => Str

The date and time that the VPC was associated with the query logging
configuration, in Unix time format and Coordinated Universal Time
(UTC).


=head2 Error => Str

If the value of C<Status> is C<FAILED>, the value of C<Error> indicates
the cause:

=over

=item *

C<DESTINATION_NOT_FOUND>: The specified destination (for example, an
Amazon S3 bucket) was deleted.

=item *

C<ACCESS_DENIED>: Permissions don't allow sending logs to the
destination.

=back

If the value of C<Status> is a value other than C<FAILED>, C<Error> is
null.


=head2 ErrorMessage => Str

Contains additional information about the error. If the value or
C<Error> is null, the value of C<ErrorMessage> also is null.


=head2 Id => Str

The ID of the query logging association.


=head2 ResolverQueryLogConfigId => Str

The ID of the query logging configuration that a VPC is associated
with.


=head2 ResourceId => Str

The ID of the Amazon VPC that is associated with the query logging
configuration.


=head2 Status => Str

The status of the specified query logging association. Valid values
include the following:

=over

=item *

C<CREATING>: Resolver is creating an association between an Amazon VPC
and a query logging configuration.

=item *

C<CREATED>: The association between an Amazon VPC and a query logging
configuration was successfully created. Resolver is logging queries
that originate in the specified VPC.

=item *

C<DELETING>: Resolver is deleting this query logging association.

=item *

C<FAILED>: Resolver either couldn't create or couldn't delete the query
logging association.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

