use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

for my $file (<t/bpp-16/*.*>) {
  my $pimage = PDL::IO::Image->new_from_file($file);
  is($pimage->get_image_type , "BITMAP", "get_image_type: $file");
  is($pimage->get_color_type , "RGB", "get_color_type: $file");
  is($pimage->get_colors_used, 0 , "get_colors_used: $file");
  is($pimage->get_bpp        , 16, "get_bpp: $file");
}

my $expected_565 = [
 [
  [255,255,247,107, 74, 74,222,107],
  [255,247,107,165,255,222,107, 74],
  [247,165,107,255,255,247,140, 74],
  [247,107,165,255,255,247,165,107],
  [247, 74,198,255,255,247,140,140],
  [247,107,198,255,255,247, 74,165],
  [247,140,107,255,247,107, 74,222],
  [255,247,107, 74, 74,165, 74,255],
  [255,255,255,255,247,165,107,255],
  [198, 74,255,255,247, 74,198,255],
  [247,140, 74, 74, 74,165,255,255],
 ],
 [
  [255,255,223, 77, 77,109,223, 77],
  [255,223, 77,223,255,166,109,109],
  [251,109,166,255,255,251, 77,138],
  [223, 77,223,255,255,251,109,166],
  [195, 77,251,255,255,251, 77,195],
  [223, 77,251,255,255,195, 77,223],
  [251, 77,166,255,223, 77,109,251],
  [255,223, 77, 77, 77,166,138,255],
  [255,255,255,255,251,109,166,255],
  [138,138,255,255,195, 77,251,255],
  [251, 77, 77, 77, 77,223,255,255],
 ],
 [
  [255,255,165, 74, 74,165,165,140],
  [255,165,107,247,255,107,107,165],
  [222, 74,222,255,255,198, 74,198],
  [165,107,247,255,255,222, 74,222],
  [140,140,247,255,255,198, 74,247],
  [165,140,247,255,255,140,107,247],
  [198, 74,222,255,165, 74,165,247],
  [255,165, 74, 74,140,107,198,255],
  [255,255,255,255,222, 74,222,255],
  [ 74,198,255,255,140,140,247,255],
  [198, 74, 74, 74,107,247,255,255],
 ],
];

my $expected_555 = [
 [
  [  0,  0,247,107, 74, 74,222,107],
  [  0,247,107,165,  0,222,107, 74],
  [247,165,107,  0,  0,247,140, 74],
  [247,107,165,  0,  0,247,165,107],
  [247, 74,198,  0,  0,247,140,140],
  [247,107,198,  0,  0,247, 74,165],
  [247,140,107,  0,247,107, 74,222],
  [  0,247,107, 74, 74,165, 74,  0],
  [  0,  0,  0,  0,247,165,107,  0],
  [198, 74,  0,  0,247, 74,198,  0],
  [247,140, 74, 74, 74,165,  0,  0],
 ],
 [
  [  0,  0,222, 74, 74,107,222, 74],
  [  0,222, 74,222,  0,165,107,107],
  [247,107,165,  0,  0,247, 74,140],
  [222, 74,222,  0,  0,247,107,165],
  [198, 74,247,  0,  0,247, 74,198],
  [222, 74,247,  0,  0,198, 74,222],
  [247, 74,165,  0,222, 74,107,247],
  [  0,222, 74, 74, 74,165,140,  0],
  [  0,  0,  0,  0,247,107,165,  0],
  [140,140,  0,  0,198, 74,247,  0],
  [247, 74, 74, 74, 74,222,  0,  0],
 ],
 [
  [  0,  0,165, 74, 74,165,165,140],
  [  0,165,107,247,  0,107,107,165],
  [222, 74,222,  0,  0,198, 74,198],
  [165,107,247,  0,  0,222, 74,222],
  [140,140,247,  0,  0,198, 74,247],
  [165,140,247,  0,  0,140,107,247],
  [198, 74,222,  0,165, 74,165,247],
  [  0,165, 74, 74,140,107,198,  0],
  [  0,  0,  0,  0,222, 74,222,  0],
  [ 74,198,  0,  0,140,140,247,  0],
  [198, 74, 74, 74,107,247,  0,  0],
 ],
];

{
  my $pimage = PDL::IO::Image->new_from_file('t/bpp-16/8x11_16rgb-565.bmp');
  delta_ok($pimage->pixels_to_pdl->unpdl, $expected_565, "expected_565");
}

{
  my $pimage = PDL::IO::Image->new_from_file('t/bpp-16/8x11_16rgba-5551.bmp');
  delta_ok($pimage->pixels_to_pdl->unpdl, $expected_555, "expected_555");
}

done_testing();