/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.RawToBinaryFormatStream;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.ReaderToUTF8Stream;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedResultSet
extends ConnectionChild
implements java.sql.ResultSet,
Comparable {
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    protected ExecRow currentRow;
    private DataValueDescriptor[] rowData;
    protected boolean wasNull;
    protected boolean isClosed;
    private Object currentStream;
    protected ResultSet theResults;
    private boolean forMetaData;
    private ResultSetMetaData rMetaData;
    private SQLWarning topWarning;
    Activation finalizeActivation;
    final int order;
    private final ResultDescription resultDescription;
    private int maxRows;
    private final int maxFieldSize;
    private int NumberofFetchedRows;
    protected final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    protected final boolean isAtomic;
    protected final int concurrencyOfThisResultSet;
    private DataValueDescriptor[] copyOfDatabaseRow;
    private boolean[] columnGotUpdated;
    private boolean currentRowHasBeenUpdated;
    private int fetchDirection;
    private int fetchSize;

    public EmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        super(embedConnection);
        this.theResults = resultSet;
        this.forMetaData = bl;
        this.stmt = this.owningStmt = embedStatement;
        this.isAtomic = bl2;
        if (embedStatement == null) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (embedStatement.getResultSetConcurrency() == 1007) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (!this.isForUpdate()) {
            this.concurrencyOfThisResultSet = 1007;
            SQLWarning sQLWarning = StandardException.newWarning("01J06");
            if (this.topWarning == null) {
                this.topWarning = sQLWarning;
            } else {
                this.topWarning.setNextWarning(sQLWarning);
            }
        } else {
            this.concurrencyOfThisResultSet = 1008;
        }
        this.resultDescription = this.theResults.getResultDescription();
        this.columnGotUpdated = new boolean[this.getMetaData().getColumnCount()];
        this.copyOfDatabaseRow = new DataValueDescriptor[this.columnGotUpdated.length];
        if (embedStatement != null) {
            if (embedStatement.resultSetType == 1003) {
                this.maxRows = embedStatement.maxRows;
            }
            this.maxFieldSize = embedStatement.MaxFieldSize;
        } else {
            this.maxFieldSize = 0;
        }
        this.order = embedConnection.getResultSetOrderId();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.finalizeActivation != null) {
            this.finalizeActivation.markUnused();
        }
    }

    protected final DataValueDescriptor[] checkOnRow() throws SQLException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowData;
        if (dataValueDescriptorArray == null) {
            throw this.newSQLException("24000");
        }
        return dataValueDescriptorArray;
    }

    final int getColumnType(int n) throws SQLException {
        this.checkOnRow();
        if (n < 1 || n > this.resultDescription.getColumnCount()) {
            throw this.newSQLException("S0022", new Integer(n));
        }
        return this.resultDescription.getColumnDescriptor(n).getType().getJDBCTypeId();
    }

    public boolean next() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        for (int i = 0; i < this.columnGotUpdated.length; ++i) {
            this.columnGotUpdated[i] = false;
        }
        this.currentRowHasBeenUpdated = false;
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int n, String string) throws SQLException {
        return this.movePosition(n, 0, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean movePosition(int n, int n2, String string) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.setupContextStack();
            try {
                boolean bl2;
                Object object2;
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                try {
                    object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSQLText(), this.getParameterValueSet(), false);
                    switch (n) {
                        case 5: {
                            this.currentRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            this.currentRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            this.currentRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            this.currentRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            this.currentRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            this.currentRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            this.currentRow = this.theResults.getAbsoluteRow(n2);
                            break;
                        }
                        case 8: {
                            this.currentRow = this.theResults.getRelativeRow(n2);
                            break;
                        }
                    }
                    languageConnectionContext.popStatementContext((StatementContext)object2, null);
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
                object2 = this.theResults.getWarnings();
                if (object2 != null) {
                    if (this.topWarning == null) {
                        this.topWarning = object2;
                    } else {
                        this.topWarning.setNextWarning((SQLWarning)object2);
                    }
                }
                boolean bl3 = bl2 = this.currentRow != null;
                if (!(bl2 || n != 2 || this.forMetaData && languageConnectionContext.getActivationCount() > 1 || this.owningStmt == null)) {
                    this.owningStmt.resultSetClosing(this);
                }
                this.rowData = bl2 ? this.currentRow.getRowArray() : null;
                bl = bl2;
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
            }
            catch (SQLException sQLException) {
                return;
            }
            try {
                try {
                    this.theResults.finish();
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                if (this.forMetaData) {
                    LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                    if (languageConnectionContext.getActivationCount() > 1) {
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                } else if (this.owningStmt != null) {
                    this.owningStmt.resultSetClosing(this);
                }
            }
            finally {
                this.isClosed = true;
                this.restoreContextStack();
            }
            this.currentRow = null;
            this.rowData = null;
            this.rMetaData = null;
            for (int i = 0; i < this.columnGotUpdated.length; ++i) {
                this.columnGotUpdated[i] = false;
            }
            this.currentRowHasBeenUpdated = false;
        }
    }

    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    public final String getString(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            String string = dataValueDescriptor.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.getColumnType(n)) && string.length() > this.maxFieldSize) {
                string = string.substring(0, this.maxFieldSize);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final boolean getBoolean(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return false;
            }
            return dataValueDescriptor.getBoolean();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte getByte(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getByte();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final short getShort(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getShort();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final int getInt(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getInt();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final long getLong(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dataValueDescriptor.getLong();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final float getFloat(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dataValueDescriptor.getFloat();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final double getDouble(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dataValueDescriptor.getDouble();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte[] getBytes(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] byArray = dataValueDescriptor.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.getColumnType(n)) && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = new byte[this.maxFieldSize];
                System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Date getDate(int n) throws SQLException {
        return this.getDate(n, (Calendar)null);
    }

    public final Time getTime(int n) throws SQLException {
        return this.getTime(n, (Calendar)null);
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getDate(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumnName(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTime(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTimestamp(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Reader getCharacterStream(int n) throws SQLException {
        Object object;
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2005: {
                n2 = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16BE");
                    this.currentStream = inputStreamReader;
                    return inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", n);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    Reader reader = null;
                    return reader;
                }
                bl = true;
                this.setupContextStack();
                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                InputStream inputStream = streamStorable.returnStream();
                if (inputStream == null) {
                    String string = dataValueDescriptor.getString();
                    if (n2 > 0 && string.length() > n2) {
                        string = string.substring(0, n2);
                    }
                    StringReader stringReader = new StringReader(string);
                    this.currentStream = stringReader;
                    StringReader stringReader2 = stringReader;
                    return stringReader2;
                }
                UTF8Reader uTF8Reader = new UTF8Reader(inputStream, n2, this, object);
                this.currentStream = uTF8Reader;
                UTF8Reader uTF8Reader2 = uTF8Reader;
                return uTF8Reader2;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(n);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", n);
            }
        }
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream getBinaryStream(int n) throws SQLException {
        Object object;
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2004: {
                n2 = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", n);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                InputStream inputStream;
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream2 = null;
                    return inputStream2;
                }
                bl = true;
                this.setupContextStack();
                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                InputStream inputStream3 = streamStorable.returnStream();
                inputStream3 = inputStream3 == null ? new NewByteArrayInputStream(dataValueDescriptor.getBytes()) : new BinaryToRawStream(inputStream3, dataValueDescriptor);
                if (n2 > 0) {
                    inputStream = new LimitInputStream(inputStream3);
                    ((LimitInputStream)inputStream).setLimit(n2);
                    inputStream3 = inputStream;
                }
                this.currentStream = inputStream3;
                inputStream = inputStream3;
                return inputStream;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final String getString(String string) throws SQLException {
        return this.getString(this.findColumnName(string));
    }

    public final boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumnName(string));
    }

    public final byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumnName(string));
    }

    public final short getShort(String string) throws SQLException {
        return this.getShort(this.findColumnName(string));
    }

    public final int getInt(String string) throws SQLException {
        return this.getInt(this.findColumnName(string));
    }

    public final long getLong(String string) throws SQLException {
        return this.getLong(this.findColumnName(string));
    }

    public final float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumnName(string));
    }

    public final double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumnName(string));
    }

    public final byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumnName(string));
    }

    public final Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumnName(string));
    }

    public final Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumnName(string));
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumnName(string));
    }

    public final Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumnName(string));
    }

    public final InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumnName(string));
    }

    public final InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumnName(string));
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public URL getURL(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rMetaData == null) {
                this.rMetaData = this.newEmbedResultSetMetaData(this.resultDescription);
            }
            return this.rMetaData;
        }
    }

    public final Object getObject(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getObject();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumnName(string));
    }

    public final int findColumn(String string) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(string);
    }

    public final Statement getStatement() {
        return this.stmt;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    public boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    public boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    public boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    public void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    public void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    public boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    public boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    public int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    public boolean absolute(int n) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, n, "absolute");
    }

    public boolean relative(int n) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, n, "relative");
    }

    public boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        if (this.fetchDirection == 0) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.stmt.getMaxRows() != 0 && n > this.stmt.getMaxRows()) {
            throw Util.generateCsSQLException("XJ062.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return this.concurrencyOfThisResultSet;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        throw Util.notImplemented();
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    protected void checksBeforeUpdateXXX(String string, int n) throws SQLException {
        this.checksBeforeUpdateOrDelete(string, n);
        ResultDescription resultDescription = this.theResults.getResultDescription();
        if (n < 1 || n > resultDescription.getColumnCount()) {
            throw Util.generateCsSQLException("XCL14.S", (Object)new Integer(n), String.valueOf(resultDescription.getColumnCount()));
        }
        if (resultDescription.getColumnDescriptor(n).getSourceTableName() == null) {
            throw Util.generateCsSQLException("XJ084.U", string);
        }
        if (!this.getMetaData().isWritable(n)) {
            throw Util.generateCsSQLException("42X31", (Object)this.theResults.getResultDescription().getColumnDescriptor(n).getName(), this.getCursorName());
        }
    }

    protected void checksBeforeUpdateOrDelete(String string, int n) throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw Util.generateCsSQLException("XJ083.U", string);
        }
        this.checkIfClosed(string);
        this.checkOnRow();
        if (this.theResults.isClosed()) {
            throw Util.generateCsSQLException("XCL16.S", string);
        }
    }

    protected DataValueDescriptor getDVDforColumnToBeUpdated(int n, String string) throws StandardException, SQLException {
        this.checksBeforeUpdateXXX(string, n);
        if (!this.columnGotUpdated[n - 1]) {
            this.copyOfDatabaseRow[n - 1] = this.currentRow.getColumn(n).getClone();
        }
        this.columnGotUpdated[n - 1] = true;
        this.currentRowHasBeenUpdated = true;
        return this.currentRow.getColumn(n);
    }

    public void updateNull(int n) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateNull").setToNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateBoolean").setValue(bl);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateByte").setValue(by);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateShort").setValue(s);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateInt").setValue(n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateLong").setValue(l);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateFloat").setValue(f);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateDouble").setValue(d);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateString").setValue(string);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateBytes").setValue(byArray);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateDate").setValue(date);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateTime").setValue(time);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateTimestamp").setValue(timestamp);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateAsciiStream", n);
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.InputStream");
            }
        }
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.updateCharacterStream(n, (Reader)inputStreamReader, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateBinaryStream", n);
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.InputStream");
            }
        }
        if (n2 < 0) {
            throw this.newSQLException("XJ025.S");
        }
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        this.updateBinaryStreamInternal(n, inputStream, n2, "updateBinaryStream");
    }

    protected void updateBinaryStreamInternal(int n, InputStream inputStream, int n2, String string) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, string).setValue(new RawToBinaryFormatStream(inputStream, n2), n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateCharacterStream", n);
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.Reader");
            }
        }
        if (n2 < 0) {
            throw this.newSQLException("XJ025.S");
        }
        if (reader == null) {
            this.updateNull(n);
            return;
        }
        this.updateCharacterStreamInternal(n, reader, n2, "updateCharacterStream");
    }

    protected void updateCharacterStreamInternal(int n, Reader reader, int n2, String string) throws SQLException {
        try {
            LimitReader limitReader = new LimitReader(reader);
            if (n2 != -1) {
                limitReader.setLimit(n2);
            }
            ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream(limitReader);
            this.getDVDforColumnToBeUpdated(n, string).setValue(readerToUTF8Stream, n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
        int n3 = this.getColumnType(n);
        if (n3 == 3 || n3 == 2) {
            if (n2 < 0) {
                throw this.newSQLException("XJ044.S", new Integer(n2));
            }
            try {
                DataValueDescriptor dataValueDescriptor = this.currentRow.getColumn(n);
                int n4 = dataValueDescriptor.getLength();
                ((VariableSizeDataValue)((Object)dataValueDescriptor)).setWidth(-1, n2, false);
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checksBeforeUpdateXXX("updateObject", n);
        int n2 = this.getColumnType(n);
        if (n2 == 2000) {
            try {
                this.getDVDforColumnToBeUpdated(n, "updateObject").setValue(object);
                return;
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
        if (object == null) {
            this.updateNull(n);
            return;
        }
        if (object instanceof String) {
            this.updateString(n, (String)object);
            return;
        }
        if (object instanceof Boolean) {
            this.updateBoolean(n, (boolean)((Boolean)object));
            return;
        }
        if (object instanceof Short) {
            this.updateShort(n, (short)((Short)object));
            return;
        }
        if (object instanceof Integer) {
            this.updateInt(n, (int)((Integer)object));
            return;
        }
        if (object instanceof Long) {
            this.updateLong(n, (long)((Long)object));
            return;
        }
        if (object instanceof Float) {
            this.updateFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.updateDouble(n, (double)((Double)object));
            return;
        }
        if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.updateDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.updateTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Blob) {
            this.updateBlob(n, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.updateClob(n, (Clob)object);
            return;
        }
        throw this.dataTypeConversion(n, object.getClass().getName());
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumnName(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumnName(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumnName(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumnName(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumnName(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumnName(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumnName(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumnName(string), d);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumnName(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumnName(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumnName(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumnName(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumnName(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumnName(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumnName(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumnName(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumnName(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumnName(string), object);
    }

    public void insertRow() throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext languageConnectionContext;
            block14: {
                block13: {
                    this.checksBeforeUpdateOrDelete("updateRow", -1);
                    this.setupContextStack();
                    languageConnectionContext = null;
                    statementContext = null;
                    try {
                        try {
                            if (!this.currentRowHasBeenUpdated) {
                                Object var14_4 = null;
                                if (statementContext != null) {
                                    languageConnectionContext.popStatementContext(statementContext, null);
                                }
                                break block13;
                            }
                            boolean bl = false;
                            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                            CursorActivation cursorActivation = this.getEmbedConnection().getLanguageConnection().lookupCursorActivation(this.getCursorName());
                            ExecCursorTableReference execCursorTableReference = cursorActivation.getPreparedStatement().getTargetTable();
                            stringBuffer.append(this.getFullBaseTableName(execCursorTableReference));
                            stringBuffer.append(" SET ");
                            ResultDescription resultDescription = this.theResults.getResultDescription();
                            for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                                if (!this.columnGotUpdated[i - 1]) continue;
                                if (bl) {
                                    stringBuffer.append(",");
                                }
                                stringBuffer.append("\"" + resultDescription.getColumnDescriptor(i).getName() + "\"=?");
                                bl = true;
                            }
                            stringBuffer.append(" WHERE CURRENT OF \"" + this.getCursorName() + "\"");
                            languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                            statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, stringBuffer.toString(), null, false);
                            PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                            Activation activation = preparedStatement.getActivation(languageConnectionContext, false);
                            int n = 0;
                            for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                                if (!this.columnGotUpdated[i - 1]) continue;
                                activation.getParameterValueSet().getParameterForSet(n++).setValue(this.currentRow.getColumn(i));
                            }
                            ResultSet resultSet = preparedStatement.execute(activation, false, true, true);
                            resultSet.close();
                            resultSet.finish();
                            this.rowData = null;
                            this.currentRow = null;
                            languageConnectionContext.popStatementContext(statementContext, null);
                            break block14;
                        }
                        catch (StandardException standardException) {
                            throw this.closeOnTransactionError(standardException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_6 = null;
                        if (statementContext != null) {
                            languageConnectionContext.popStatementContext(statementContext, null);
                        }
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return;
            }
            Object var14_5 = null;
            if (statementContext != null) {
                languageConnectionContext.popStatementContext(statementContext, null);
            }
            this.restoreContextStack();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeUpdateOrDelete("deleteRow", -1);
            this.setupContextStack();
            try {
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                CursorActivation cursorActivation = this.getEmbedConnection().getLanguageConnection().lookupCursorActivation(this.getCursorName());
                stringBuffer.append(this.getFullBaseTableName(cursorActivation.getPreparedStatement().getTargetTable()));
                stringBuffer.append(" WHERE CURRENT OF \"" + this.getCursorName() + "\"");
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                StatementContext statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, stringBuffer.toString(), null, false);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                ResultSet resultSet = preparedStatement.execute(languageConnectionContext, true);
                resultSet.close();
                resultSet.finish();
                this.rowData = null;
                this.currentRow = null;
                languageConnectionContext.popStatementContext(statementContext, null);
            }
            catch (StandardException standardException) {
                throw this.closeOnTransactionError(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    private String getFullBaseTableName(ExecCursorTableReference execCursorTableReference) {
        if (execCursorTableReference.getSchemaName() != null) {
            return "\"" + execCursorTableReference.getSchemaName() + "\".\"" + execCursorTableReference.getBaseName() + "\"";
        }
        return "\"" + execCursorTableReference.getBaseName() + "\"";
    }

    public void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checksBeforeUpdateOrDelete("cancelRowUpdates", -1);
        if (!this.currentRowHasBeenUpdated) {
            return;
        }
        for (int i = 0; i < this.columnGotUpdated.length; ++i) {
            if (this.columnGotUpdated[i]) {
                this.currentRow.setColumn(i + 1, this.copyOfDatabaseRow[i]);
            }
            this.columnGotUpdated[i] = false;
        }
        this.currentRowHasBeenUpdated = false;
        this.rowData = this.currentRow.getRowArray();
    }

    public void moveToInsertRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void moveToCurrentRow() throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Blob getBlob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n2 = this.getColumnType(n);
            if (n2 != 2004) {
                throw this.dataTypeConversion("java.sql.Blob", n);
            }
            boolean bl = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.currentRow.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    Blob blob = null;
                    return blob;
                }
                if (dataValueDescriptor.getStream() != null) {
                    bl = true;
                }
                if (bl) {
                    this.setupContextStack();
                }
                EmbedBlob embedBlob = new EmbedBlob(dataValueDescriptor, this.getEmbedConnection());
                return embedBlob;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Clob getClob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n2 = this.getColumnType(n);
            if (n2 != 2005) {
                throw this.dataTypeConversion("java.sql.Clob", n);
            }
            boolean bl = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.currentRow.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    Clob clob = null;
                    return clob;
                }
                if (dataValueDescriptor.getStream() != null) {
                    bl = true;
                }
                if (bl) {
                    this.setupContextStack();
                }
                EmbedClob embedClob = new EmbedClob(dataValueDescriptor, this.getEmbedConnection());
                return embedClob;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumnName(string));
    }

    public final Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumnName(string));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
        if (blob == null) {
            this.updateNull(n);
        } else {
            this.updateBinaryStreamInternal(n, blob.getBinaryStream(), -1, "updateBlob");
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumnName(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
        if (clob == null) {
            this.updateNull(n);
        } else {
            this.updateCharacterStreamInternal(n, clob.getCharacterStream(), -1, "updateClob");
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumnName(string), clob);
    }

    protected int findColumnName(String string) throws SQLException {
        if (string == null) {
            throw this.newSQLException("XJ018.S");
        }
        ResultDescription resultDescription = this.resultDescription;
        int n = resultDescription.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string2 = resultDescription.getColumnDescriptor(i).getName();
            if (!StringUtil.SQLEqualsIgnoreCase(string, string2)) continue;
            return i;
        }
        throw this.newSQLException("S0022", string);
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDescription) {
        return new EmbedResultSetMetaData(resultDescription.getColumnInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    protected final void checkIfClosed(String string) throws SQLException {
        if (this.isClosed) {
            throw this.newSQLException("XCL16.S", string);
        }
    }

    protected final void checkExecIfClosed(String string) throws SQLException {
        this.checkIfClosed(string);
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection == null || connection.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int n) {
        return n == -2 || n == -3 || n == -4 || n == 1 || n == 12 || n == -1;
    }

    protected final SQLException closeOnTransactionError(Throwable throwable) throws SQLException {
        StandardException standardException;
        int n;
        SQLException sQLException = this.handleException(throwable);
        if (throwable instanceof StandardException && (n = (standardException = (StandardException)throwable).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable throwable2) {
                SQLException sQLException2 = this.handleException(throwable2);
                sQLException2.setNextException(sQLException);
                sQLException = sQLException2;
            }
        }
        return sQLException;
    }

    protected final DataValueDescriptor getColumn(int n) throws SQLException, StandardException {
        this.closeCurrentStream();
        this.checkIfClosed("getXXX");
        DataValueDescriptor[] dataValueDescriptorArray = this.checkOnRow();
        try {
            return dataValueDescriptorArray[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.newSQLException("S0022", new Integer(n));
        }
    }

    public static final SQLException noStateChangeException(Throwable throwable) {
        return TransactionResourceImpl.wrapInSQLException(null, throwable);
    }

    void setDynamicResultSet(EmbedStatement embedStatement) {
        this.owningStmt = embedStatement;
        this.localConn = embedStatement.getEmbedConnection();
    }

    public final int compareTo(Object object) {
        EmbedResultSet embedResultSet = (EmbedResultSet)object;
        return this.order - embedResultSet.order;
    }

    private void checkScrollCursor(String string) throws SQLException {
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.newEmbedSQLException("XJ061.S", new Object[]{string}, StandardException.getSeverityFromIdentifier("XJ061.S"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int n, String string) throws SQLException {
        this.checkScrollCursor(string);
        this.checkIfClosed(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                StatementContext statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSQLText(), this.getParameterValueSet(), false);
                boolean bl = this.theResults.checkRowPosition(n);
                languageConnectionContext.popStatementContext(statementContext, null);
                boolean bl2 = bl;
                return bl2;
            }
            catch (Throwable throwable) {
                throw this.closeOnTransactionError(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    protected final SQLException dataTypeConversion(String string, int n) {
        return this.newSQLException("22005", string, this.resultDescription.getColumnDescriptor(n).getType().getTypeId().getSQLTypeName());
    }

    protected final SQLException dataTypeConversion(int n, String string) {
        return this.newSQLException("22005", this.resultDescription.getColumnDescriptor(n).getType().getTypeId().getSQLTypeName(), string);
    }
}

