# Generated by default/object.tt
package Paws::SESv2::ReviewDetails;
  use Moose;
  has CaseId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ReviewDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ReviewDetails object:

  $service_obj->Method(Att1 => { CaseId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ReviewDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CaseId

=head1 DESCRIPTION

An object that contains information about your account details review.

=head1 ATTRIBUTES


=head2 CaseId => Str

The associated support center case ID (if any).


=head2 Status => Str

The status of the latest review of your account. The status can be one
of the following:

=over

=item *

C<PENDING> E<ndash> We have received your appeal and are in the process
of reviewing it.

=item *

C<GRANTED> E<ndash> Your appeal has been reviewed and your production
access has been granted.

=item *

C<DENIED> E<ndash> Your appeal has been reviewed and your production
access has been denied.

=item *

C<FAILED> E<ndash> An internal error occurred and we didn't receive
your appeal. You can submit your appeal again.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

