package Daje::Workflow::GeneratePerl::Generate::Interface;
use Mojo::Base 'Daje::Workflow::GeneratePerl::Base::Common' ,-base, -signatures;

use String::CamelCase qw(camelize);


our $VERSION = '0.01';
has 'name_space';
has 'table' ;
has 'name_interface';
has 'interface_space_dir';

sub generate($self) {
    $self->table(camelize($self->table));

    my $tpl = $self->templates->get_data_section('interface');
    my $name_space = $self->context->{context}->{perl}->{$self->name_space()};
    my $interface = $self->context->{context}->{perl}->{$self->name_interface()};
    my $date = localtime();
    my $table = $self->table();

    $tpl =~ s/<<date>>/$date/ig;
    $tpl =~ s/<<interface>>/$interface/ig;
    $tpl =~ s/<<classname>>/$table/ig;
    $tpl =~ s/<<name_space>>/$name_space/ig;

    my $data->{file} = $self->context->{context}->{perl}->{$self->interface_space_dir} . "$table.pm";
    $data->{data} = $tpl;
    $data->{only_new} = 1;
    $data->{path} = 1;
    push(@{$self->context->{context}->{perlfiles}}, $data);
}

1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::GeneratePerl::Generate::Interface


=head1 DESCRIPTION

pod generated by Pod::Autopod - keep this line to make pod updates possible ####################


=head1 REQUIRES

L<String::CamelCase> 

L<Mojo::Base> 


=head1 METHODS

=head2 generate($self)

 generate($self)();


=cut

