#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

VŠEOBECNÁ DEKLARACE LIDSKÝCH PRÁV
Úvod
U vědomí toho,

že uznání přirozené důstojnosti a rovných a nezcizitelných práv členů lidské rodiny je základem svobody, spravedlnosti a míru ve světě,

že zneuznání lidských práv a pohrdání jimi vedlo k barbarským činům, urážejícím svědomí lidstva, a že vybudování světa, ve kterém lidé, zbavení strachu a nouze, se budou těšiti svobodě projevu a přesvĕdčení, bylo prohlášeno za nejvyšší cíl lidu,

že je nutné, aby lidská práva byla chránena zákonem, nemá-li být človĕk donucen uchylovat se, když vše ostatní selhalo, k odboji proti tyranii a útlaku,

že je nutné podporovat rozvoj přátelských vztahu mezi národy,

že lid Spojených národů zdůraznil v Chartě znovu svou víru v základní lidská práva, v důstojnost a hodnotu lidské osobnosti, v rovná práva mužů i žen a že se rozhodl podporovat sociální pokrok a vytvořit lepší životní podmínky ve větší svobodě,

že členské státy převzaly závazek zajistit ve spolupráci s Organizací spojených národů všeobecné uznávání a zachovávání lidských práv a základních svobod a

že stejné chápání těchto práv a svobod má nesmírný význam pro dokonalé splnění tohoto závazku,

Valné shromáždění

vyhlašuje tuto

Všeobecnou deklaraci lidských práv

jakožto společný cíl pro všechny národy a všechny státy za tím účelem, aby se každý jednotlivec a každý orgán společnosti, maje tuto deklaraci stále na mysli, snažil vyučováním a výchovou rozšířit úctu k těmto právům a svobodám azajistit postupnými opatřeními vnitrostátními i mezinárodními jejich všeobecné a účinné uznávání a zachovávání jak mezi lidem členských států samých, tak i mezi lidem území, jež jsou pod jejich pravomocí.

Článek 1
Všichni lidé rodí se svobodní a sobě rovní co do důstojnosti a práv. Jsou nadáni rozumem a svědomím a mají spolu jednat v duchu bratrství.

Článek 2
Každý má všechna práva a všechny svobody, stanovené touto deklarací, bez jakéhokoli rozlišování, zejména podle rasy, barvy, pohlaví, jazyka, nábozenství, politického nebo jiného smýšlení, národnostního nebo sociálního původu, majetku, rodu nebo jiného postavení.

Žádný rozdíl nebude dále činěn z důvodu politického, právního nebo mezinárodního postavení země nebo území, k nimž určitá osoba přísluší, ať jde o zemi nebo území nezávislé nebo pod poručenstvím, nesamosprávné nebo podrobené jakémukoli jinému omezení suverenity.

Článek 3
Každý má právo na život, svobodu a osobní bezpečnost.

Článek 4
Nikdo nesmí být držen v otroctví nebo nevolnictví; všechny formy otroctví a obchodu s otroky jsou zakázány.

Článek 5
Nikdo nesmí být mučen nebo podrobován krutému, nelidskému nebo ponižujícímu zacházení nebo trestu.

Článek 6
Každý má právo na to, aby byla všude uznávána jeho právní osobnost.

Článek 7
Všichni jsou si před zákonem rovni a mají právo na stejnou ochranu zákona bez jakéhokoli rozlišování. Všichni mají právo na stejnou ochranu proti jakékoli diskriminaci, která porušuje tuto deklaraci, a proti každému podněcování k takové diskriminaci.

Článek 8
Každý má právo, aby mu příslušné vnitrostátní soudy poskytly účinnou ochranu proti činům porušujícím základní práva, která jsou mu přiznána ústavou nebo zákonem.

Článek 9
Nikdo nesmí být svévolně zatčen, držen ve vazbě nebo vyhoštěn do vyhnanství.

Článek 10
Každý má úplně stejné právo, aby byl spravedlivě a veřejně vyslechnut nezávislým a nestranným soudem, který rozhoduje buď o jeho právech a povinnostech, nebo o jakémkoli trestním obvinění vzneseném proti němu.

Článek 11
Každý, kdo je obviněn z trestného činu, považuje se za nevinného, dokud není zákonným postupem prokázána jeho vina ve veřejném řízení, v němž mu byly zajištěny veškeré možnosti obhajoby.
Nikdo nesmí být odsouzen pro čin nebo opomenutí, které v dobe, kdy byly spáchány, nebyly trestné podle státního nebo mezinárodního práva. Rovnez nesmí být ulozen trest tezší, nez jakého bylo lze pouzít v dobe, kdy byl trestný čin spáchán.
Článek 12
Nikdo nesmí být vystaven svévolnému zasahování do soukromého života, do rodiny, domova nebo korespondence, ani útokům na svou čest a pověst. Každý má právo na zákonnou ochranu proti takovým zásahům nebo útokům.

Článek 13
Každý má právo volně se pohybovat a svobodně si volit bydliště uvnitř určitého státu.
Každý má právo opustit kteroukoli zemi, i svou vlastní, a vrátit se do své země.
Článek 14
Každý má právo vyhledat si před pronásledováním útocištĕ v jiných zemích a požívat tam azylu.
Toto právo nelze uplatnit v prípadě stíhání skutečně odůvodneného nepolitickými zločiny nebo činy, které jsou v rozporu s cíli a zásadami Spojených národů.
Článek 15
Každý má právo na státní příslušnost.
Nikdo nesmí být svévolně zbaven své státní příslušnosti ani práva svou státní příslušnost změnit.
Článek 16
Muži a ženy, jakmile dosáhnou plnoletosti, mají právo, bez jakéhokoli omezení z důvodů příslušnoti rasové, národnostní nebo náboženské, uzavřít sňatek a založit rodinu. Pokud jde o manzelství, mají za jeho trvání i při jeho rozvázání stejná práva.
Sňatky mohou být uzavřeny jen se svobodným a plným souhlasem nastávajících manželů.
Rodina je přirozenou a základní jednotkou společnosti a má nárok na ochranu že strany společnosti a státu.
Článek 17
Každý má právo vlastnit majetek jak sám, tak spolu sjinými.
Nikdo nesmí být svévolně zbaven svého majetku.
Článek 18
Každý má právo na svobodu myšlení, svědomí a náboženství; toto právo zahrnuje v sobě i volnost změnit své náboženství nebo víru, jakož i svobodu projevovat své náboženství nebo víru, sám nebo společně s jinými, ať veřejně nebo soukromě, vyučováním, prováděním náboženských úkonů, bohoslužbou a zachováváním obřadů.

Článek 19
Každý má právo na svobodu přesvědčení a projevu; toto právo nepřipouští, aby někdo trpěl újmu pro své přesvědčení, a zahrnuje právo vyhledávat, príjímat a rozšiřovat informace a myšlenky jakýmikoli prostředky a bez ohledu na hranice.

Článek 20
Každému je zaručena svoboda pokojného shromažďování a sdružování.
Nikdo nesmí být nucen, aby byl členem nějakého sdružení.
Článek 21
Každý má právo, aby se účastnil vlády své země přímo nebo prostřednictvím svobodně volených zástupců.
Každý má právo vstoupit za rovných podmínek do veřejných služeb své země.
Základem vládní moci budiž vůle lidu; ta musí být vyjádřena správne prováděnými volbami, které se mají konat v pravidelných obdobích na základě všeobecného arovného hlasovacího práva tajným hlasováním nebo jiným rovnocenným postupem, zabezpečujícím svobodu hlasování.
Článek 22
Každý človĕk má jako člen společnosti právo na sociální zabezpeční a nárok na to, aby mu byla národním úsilím i mezinárodní součinností a v souladu s organizací a s prostředky príslušného státu zajištěna hospodářská, sociální a kulturní práva, nezbytná k jeho důstojnosti a k svobodnému rozvoji jeho osobnosti.

Článek 23
Každý má právo na práci, na svobodnou volbu zaměstnání, na spravedlivé a uspokojivé pracovní podmínky a na ochranu proti nezaměstnanosti.
Každý, bez jakéhokoli rozlišování, má nárok na stejný plat za stejnou práci.
Každý pracující má právo na spravedlivou a uspokojivou odměnu, která by zajišťovala jemu samému a jeho rodině živobytí odpovídající lidské důstojnosti a která by byla doplněna, kdyby toho bylo třeba, jinými prostředky sociální ochrany.
Na ochranu svých zájmů má každý právo zakládat s jinými odborové organizace a přistupovat k nim.
Článek 24
Každý má právo na odpočinek a na zotavení, zejména také na rozumné vymezení pracovních hodin a na pravidelnou placenou dovolenou.

Článek 25
Každý má právo na takovou životní úroveň, která by byla s to zajistit jeho zdraví a blahobyt i zdraví a blahobyt jeho rodiny, počítajíc v to zejména výživu, šatstvo, byt a lékařskou péči, jakož i nezbytná sociální opatření; má právo na zabezpečení v nezaměstnanosti, v nemoci, při nezpůsobilosti k práci, při ovdovění, ve stáří nebo v ostatních případech ztráty výdělečných možností, nastalé v důsledku okolností nezávislých na jeho vůli.
Mateřství a dětství mají nárok na zvláštní péči a pomoc. Všechny děti, ať manželské nebo nemanželské, pozívají stejné sociální ochrany.
Článek 26
Každý má právo na vzdělání. Vzdělání nechť je bezplatné, alespoň v počátečních a základních stupních. Základní vzdělání je povinné. Technické a odborné vzdělání budiž všeobecně přístupné a rovněž vyšší vzdělání má být stejně přístupné všem podle schopností.
Vzdělání má směřovat k plnému rozvoji lidské osobnosti a k posílení úcty k lidským právům a základním svobodám. Má napomáhat k vzájemnému porozumění, snášenlivosti a přátelství mezi všemi národy a všemi skupinami rasovými i náboženskými, jakož i k rozvoji činnosti Spojených národů pro zachování míru.
Rodiče mají přednostní právo volit druh vzdělání pro své děti.
Článek 27
Každý má právo svobodně se účastnit kulturního života společnosti, úžívat plodů umění a podílet se na vědeckém pokroku a jeho výtěžcích.
Každý má právo na ochranu morálních a materiálních zájmů, které vyplývají z jeho vědecké, literární nebo umělecké tvorby.
Článek 28
Každý má právo na to, aby vládl takový sociální a mezinárodní řád, ve kterém by práva a svobody stanovené v této deklaraci byly plně uplatněny.

Článek 29
Každý má povinnosti vůči společnosti, v níz jediné může volně a plně rozvinout svou osobnost.
Každý je při výkonu svých práv a svobod podroben jen takovým omezením, která stanoví zákon výhradně za tím účelem, aby bylo zajištěno uznávání a zachovávání práv asvobod ostatních a vyhověno spravedlivým pozadavkům morálky, veřejného pořádku a obecného blaha v demokratické společnosti.
Výkon těchto práv a svobod nesmí být v žádném případě v rozporu s cíli a zásadami Spojených národů.
Článek 30
Nic v této deklaraci nemůže být vykládáno jako by dávalo kterémukoli státu, kterékoli skupině nebo osobě jakékoli právo vyvíjet činnost nebo dopouštět se činů, které by směřovaly k potlačení některého z práv nebo některé ze svobod v této deklaraci uvedených.

TEXT

is(Text::Guess::Language->guess($text),'cs','is cs');

done_testing;
