#!/usr/bin/perl

package eBay::API::XML::Call::GetWantItNowPost;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetWantItNowPost.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetWantItNowPost

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetWantItNowPost inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostRequestType;
use eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetWantItNowPost';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetWantItNowPost::GetWantItNowPostResponseType';
}

#
# input properties
#

=head2 setPostID()

Specifies the post ID that uniquely identifies the Want It Now post for
which to retrieve the data. PostID is a required input. PostID is unique
across all eBay sites.

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setPostID {
   my $self   = shift;
   my $pPostID = shift;
   $self->getRequestDataType()->setPostID($pPostID);
}



#
# output properties
#

=head2 getWantItNowPost()

Contains the data defining a single Want It Now post.

  Returned: Always
#    Returns: 'ns:WantItNowPostType'

=cut
       
sub getWantItNowPost {
   my $self = shift;
   return $self->getResponseDataType()->getWantItNowPost();
}





1;   
