package Google::Ads::AdWords::v201302::FeedItemValidationDetail;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %feedMappingId_of :ATTR(:get<feedMappingId>);
my %validationStatus_of :ATTR(:get<validationStatus>);
my %validationErrors_of :ATTR(:get<validationErrors>);
my %approvalStatus_of :ATTR(:get<approvalStatus>);

__PACKAGE__->_factory(
    [ qw(        feedMappingId
        validationStatus
        validationErrors
        approvalStatus

    ) ],
    {
        'feedMappingId' => \%feedMappingId_of,
        'validationStatus' => \%validationStatus_of,
        'validationErrors' => \%validationErrors_of,
        'approvalStatus' => \%approvalStatus_of,
    },
    {
        'feedMappingId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'validationStatus' => 'Google::Ads::AdWords::v201302::FeedItemValidationDetail::ValidationStatus',
        'validationErrors' => 'Google::Ads::AdWords::v201302::FeedItemAttributeError',
        'approvalStatus' => 'Google::Ads::AdWords::v201302::FeedItemValidationDetail::ApprovalStatus',
    },
    {

        'feedMappingId' => 'feedMappingId',
        'validationStatus' => 'validationStatus',
        'validationErrors' => 'validationErrors',
        'approvalStatus' => 'approvalStatus',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::FeedItemValidationDetail

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FeedItemValidationDetail from the namespace https://adwords.google.com/api/adwords/cm/v201302.

Contains offline-validation and approval results for a given FeedItem and FeedMapping. Each validation detail indicates any issues found on the feed item when used in the context of the feed mapping. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * feedMappingId


=item * validationStatus


=item * validationErrors


=item * approvalStatus




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

