package Google::Ads::AdWords::v201809::AssetLink;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %asset_of :ATTR(:get<asset>);
my %pinnedField_of :ATTR(:get<pinnedField>);
my %assetPolicySummaryInfo_of :ATTR(:get<assetPolicySummaryInfo>);
my %assetPerformanceLabel_of :ATTR(:get<assetPerformanceLabel>);

__PACKAGE__->_factory(
    [ qw(        asset
        pinnedField
        assetPolicySummaryInfo
        assetPerformanceLabel

    ) ],
    {
        'asset' => \%asset_of,
        'pinnedField' => \%pinnedField_of,
        'assetPolicySummaryInfo' => \%assetPolicySummaryInfo_of,
        'assetPerformanceLabel' => \%assetPerformanceLabel_of,
    },
    {
        'asset' => 'Google::Ads::AdWords::v201809::Asset',
        'pinnedField' => 'Google::Ads::AdWords::v201809::ServedAssetFieldType',
        'assetPolicySummaryInfo' => 'Google::Ads::AdWords::v201809::AssetPolicySummaryInfo',
        'assetPerformanceLabel' => 'Google::Ads::AdWords::v201809::AssetPerformanceLabel',
    },
    {

        'asset' => 'asset',
        'pinnedField' => 'pinnedField',
        'assetPolicySummaryInfo' => 'assetPolicySummaryInfo',
        'assetPerformanceLabel' => 'assetPerformanceLabel',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::AssetLink

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AssetLink from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Represents an asset link. This class contains an asset and information that is specific to an asset-entity link (e.g. policy information). 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * asset


=item * pinnedField


=item * assetPolicySummaryInfo


=item * assetPerformanceLabel




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

