# Generated by default/object.tt
package Paws::CustomerProfiles::MatchItem;
  use Moose;
  has MatchId => (is => 'ro', isa => 'Str');
  has ProfileIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CustomerProfiles::MatchItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CustomerProfiles::MatchItem object:

  $service_obj->Method(Att1 => { MatchId => $value, ..., ProfileIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CustomerProfiles::MatchItem object:

  $result = $service_obj->Method(...);
  $result->Att1->MatchId

=head1 DESCRIPTION

The Match group object.

=head1 ATTRIBUTES


=head2 MatchId => Str

The unique identifiers for this group of profiles that match.


=head2 ProfileIds => ArrayRef[Str|Undef]

A list of identifiers for profiles that match.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CustomerProfiles>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

