# Generated by default/object.tt
package Paws::SecurityHub::AwsCloudFrontDistributionCacheBehavior;
  use Moose;
  has ViewerProtocolPolicy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCloudFrontDistributionCacheBehavior

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCloudFrontDistributionCacheBehavior object:

  $service_obj->Method(Att1 => { ViewerProtocolPolicy => $value, ..., ViewerProtocolPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCloudFrontDistributionCacheBehavior object:

  $result = $service_obj->Method(...);
  $result->Att1->ViewerProtocolPolicy

=head1 DESCRIPTION

Information about a cache behavior for the distribution.

=head1 ATTRIBUTES


=head2 ViewerProtocolPolicy => Str

The protocol that viewers can use to access the files in an origin. You
can specify the following options:

=over

=item *

C<allow-all> - Viewers can use HTTP or HTTPS.

=item *

C<redirect-to-https> - CloudFront responds to HTTP requests with an
HTTP status code of 301 (Moved Permanently) and the HTTPS URL. The
viewer then uses the new URL to resubmit.

=item *

C<https-only> - CloudFront responds to HTTP request with an HTTP status
code of 403 (Forbidden).

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

