#!perl -w -I../lib -I../blib/arch 
use feature ':5.12';
use strict;
use warnings all=>'FATAL';

use Test::More;
use DBM::Deep::Blue;

#-----------------------------------------------------------------------
# aaa package
#-----------------------------------------------------------------------

 {package aaa;
  sub aaa($)
   {my $r = $_[0];                  # Reference
    $r->{a}
   }
 }

#-----------------------------------------------------------------------
# ccc package
#-----------------------------------------------------------------------

 {package ccc;
  sub ccc($)
   {my $r = $_[0];                  # Reference
    $r->{c}
   }
 }

#-----------------------------------------------------------------------
# Load a blessed structure
#-----------------------------------------------------------------------

my $m = DBM::Deep::Blue::new();
my $h = $m->allocHash();

$h->{data} = &data();

ok $h->{data}{a}        == 1;
ok $h->{data}->aaa()    == 1;
ok $h->{data}{c}{c}     == 3;
ok $h->{data}{c}->ccc() == 3;

$m->dump("zz");
 
done_testing;

#-----------------------------------------------------------------------
# Data structure
#-----------------------------------------------------------------------

sub data()
 {return bless {a=>1, b=>[1..10], c=>bless({c=>3}, 'ccc')}, 'aaa';
 }

