package Test2::Manual;
use strict;
use warnings;

our $VERSION = '0.000152';

1;

__END__

=head1 NAME

Test2::Manual - Documentation hub for Test2 and Test2-Suite.

=head1 DESCRIPTION

This is the hub for L<Test2> and L<Test2::Suite> documentation.

=head1 WRITING TESTS

The L<Test2::Manual::Testing> POD is the hub for documentation related to
writing tests.

=head1 WRITING TOOLS

The L<Test2::Manual::Tooling> POD is the hub for documentation related to
writing new tools.

=head1 GUTS AND INNER WORKINGS

The L<Test2::Manual::Anatomy> POD is the hub for documentation of the inner
workings of Test2 components.

=head1 A NOTE ON CONCURRENCY (SUPPORT FOR FORKING AND THREADING)

The L<Test2::Manual::Concurrency> POD documents the concurrency support policy
for L<Test2>.

=head1 CONTRIBUTING

The L<Test2::Manual::Contributing> POD is for people who want to contribute to
L<Test2> or L<Test2::Suite> directly.

=head1 SEE ALSO

L<Test2> - Test2 itself.

L<Test2::Suite> - Initial tools built using L<Test2>.

=head1 SOURCE

The source code repository for Test2-Manual can be found at
F<https://github.com/Test-More/Test2-Suite/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright 2018 Chad Granum E<lt>exodist@cpan.orgE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
