/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceElement;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMentionArgument;
import java.util.ArrayList;
import java.util.List;

public class AceRelation
extends AceElement {
    private String mType;
    private String mSubtype;
    private String mModality;
    private String mTense;
    private List<AceRelationMention> mMentions;
    public static final String NIL_LABEL = "nil";

    public AceRelation(String id, String type, String subtype, String modality, String tense) {
        super(id);
        this.mType = type;
        this.mSubtype = subtype;
        this.mModality = modality;
        this.mTense = tense;
        this.mMentions = new ArrayList<AceRelationMention>();
    }

    public void addMention(AceRelationMention m) {
        this.mMentions.add(m);
        m.setParent(this);
    }

    public AceRelationMention getMention(int which) {
        return this.mMentions.get(which);
    }

    public int getMentionCount() {
        return this.mMentions.size();
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String s) {
        this.mType = s;
    }

    public String getSubtype() {
        return this.mSubtype;
    }

    public void setSubtype(String s) {
        this.mSubtype = s;
    }

    public String toXml(int offset) {
        StringBuffer buffer = new StringBuffer();
        AceRelation.appendOffset(buffer, offset);
        buffer.append("<relation ID=\"" + this.getId() + "\" TYPE =\"" + this.mType + "\" SUBTYPE=\"" + this.mSubtype + "\" MODALITY=\"" + this.mModality + "\" TENSE=\"" + this.mTense + "\">\n");
        AceRelationMentionArgument arg1 = this.mMentions.get(0).getArgs()[0];
        AceRelationMentionArgument arg2 = this.mMentions.get(0).getArgs()[1];
        if (arg1.getRole().equals("Arg-1")) {
            buffer.append(arg1.toXmlShort(offset + 2) + "\n");
            buffer.append(arg2.toXmlShort(offset + 2) + "\n");
        } else {
            buffer.append(arg2.toXmlShort(offset + 2) + "\n");
            buffer.append(arg1.toXmlShort(offset + 2) + "\n");
        }
        for (AceRelationMention m : this.mMentions) {
            buffer.append(m.toXml(offset + 2));
            buffer.append("\n");
        }
        AceRelation.appendOffset(buffer, offset);
        buffer.append("</relation>");
        return buffer.toString();
    }
}

