# vim:set filetype=perl:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 04_izhcrifel.t'

#########################

use Test::More tests => 37;
use Carp;

BEGIN { use_ok 'Lingua::Zompist::Barakhinei', 'izhcrifel' }

sub form_ok ($$$) {
    # croak 'usage: form_ok($verb, $is, $should)' unless @_ >= 3;
    my($verb, $is, $should) = @_;

    is($is->[0], $should->[0], "I.sg. of $verb");
    is($is->[1], $should->[1], "II.sg. of $verb");
    is($is->[2], $should->[2], "III.sg. of $verb");
    is($is->[3], $should->[3], "I.pl. of $verb");
    is($is->[4], $should->[4], "II.pl. of $verb");
    is($is->[5], $should->[5], "III.pl. of $verb");
}

form_ok('elir',  izhcrifel('elir',  1), [ qw( elirri  elirr  elirr  elirr  elirr  elirrn  ) ]);
form_ok('rikha',  izhcrifel('rikha',  2), [ qw( rikhri  rikhri  rikhr  rikhru  rikhr  rikhrn  ) ]);
form_ok('lel',   izhcrifel('lel',   3), [ qw( lelri   lelri   lelr   lelru   lelr   lelrn   ) ]);
form_ok('bshti', izhcrifel('bshti', 4), [ qw( bshtri bshtr bshtr bshtr bshtr bshtrn ) ]);
form_ok('hab',   izhcrifel('hab',   5), [ qw( habri   habr   habr   habr   habr   habrn   ) ]);

#form_ok('groch', izhcrifel('groch', 1), [ qw( grochi groch grok   grog  grog  grochn ) ]);
#form_ok('foka',   izhcrifel('foka',   2), [ qw( fochi  fochi  fok   foku   fok   fochn  ) ]);
#form_ok('noch',  izhcrifel('noch',  3), [ qw( nochi  nochi  nog   nogu   nog   nochn  ) ]);
#form_ok('faichi', izhcrifel('faichi', 4), [ qw( faichi faich faok  faich faich faichn ) ]);
#form_ok('klach', izhcrifel('klach', 5), [ qw( klachi klach klach  klach klach klachn ) ]);

form_ok('eza', izhcrifel('eza'), [ qw( firi firi fur furu fur firin ) ]);

#form_ok('epeza', izhcrifel('epeza'), [ qw( zi   zi   ep zu   z   zn   ) ]);
#form_ok('kedh', izhcrifel('kedh'), [ qw( kedhi kedhi ki kedhu kedh kedhn ) ]);

#form_ok('foli',    izhcrifel('foli'   ), [ qw( ful     ful   fut   folu    folu    foln    ) ]);
#form_ok('lhib',   izhcrifel('lhib'  ), [ qw( lhua    lh   lhu   lhubu   lhubu   ln      ) ]);
#form_ok('nh',     izhcrifel('nh'    ), [ qw( nhe     ni    ni    nheza   nhezu   nh      ) ]);
#form_ok('shkriv', izhcrifel('shkriv'), [ qw( shkriva shkri shkri shkrivu shkrivu shkrivn ) ]);
#form_ok('shtan',  izhcrifel('shtan' ), [ qw( sht    sht  sht  shtana  shtanu  shtn    ) ]);
#form_ok('fli',    izhcrifel('fli'   ), [ qw( fl     fl   fl   flu    flu    fln    ) ]);
#form_ok('hizi',    izhcrifel('hizi'   ), [ qw( huz     hu    hut   hizu    hizu    hizn    ) ]);
#form_ok('oi',      izhcrifel('oi'     ), [ qw( oh      fi    fit   ou      ou      on      ) ]);
