/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.persistence.util.COSObjectKey;

public class PDFParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFParser.class);
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private List<ConflictObj> conflictList = new ArrayList<ConflictObj>();
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    private File tempDirectory = null;
    private RandomAccess raf = null;

    public PDFParser(InputStream input) throws IOException {
        this(input, null, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi) throws IOException {
        this(input, rafi, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi, boolean force) throws IOException {
        super(input, force);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    protected boolean isContinueOnError(Exception e) {
        return this.forceParsing;
    }

    public void parse() throws IOException {
        try {
            this.document = this.raf == null ? (this.tempDirectory != null ? new COSDocument(this.tempDirectory) : new COSDocument()) : new COSDocument(this.raf);
            this.setDocument(this.document);
            this.parseHeader();
            this.skipToNextObj();
            boolean wasLastParsedObjectEOF = false;
            while (!this.pdfSource.isEOF()) {
                try {
                    wasLastParsedObjectEOF = this.parseObject();
                }
                catch (IOException e) {
                    if (wasLastParsedObjectEOF) break;
                    if (this.isContinueOnError(e)) {
                        LOG.warn("Parsing Error, Skipping Object", e);
                        this.skipToNextObj();
                    }
                    throw e;
                }
                this.skipSpaces();
            }
            this.xrefTrailerResolver.setStartxref(this.document.getStartXref());
            this.document.setTrailer(this.xrefTrailerResolver.getTrailer());
            this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
            if (!this.document.isEncrypted()) {
                this.document.dereferenceObjectStreams();
            }
            ConflictObj.resolveConflicts(this.document, this.conflictList);
        }
        catch (Throwable t) {
            if (this.document != null) {
                this.document.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new WrappedIOException(t);
        }
        finally {
            this.pdfSource.close();
        }
    }

    private void skipToNextObj() throws IOException {
        int l;
        byte[] b = new byte[16];
        Pattern p = Pattern.compile("\\d+\\s+\\d+\\s+obj.*", 32);
        while (!this.pdfSource.isEOF() && (l = this.pdfSource.read(b)) >= 1) {
            String s = new String(b, "US-ASCII");
            if (s.startsWith("trailer") || s.startsWith("xref") || s.startsWith("startxref") || s.startsWith("stream") || p.matcher(s).matches()) {
                this.pdfSource.unread(b);
                break;
            }
            this.pdfSource.unread(b, 1, l - 1);
        }
    }

    private void parseHeader() throws IOException {
        String headerGarbage;
        String header = this.readLine();
        if (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
            header = this.readLine();
            while (!(header.indexOf(PDF_HEADER) != -1 || header.indexOf(FDF_HEADER) != -1 || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
            throw new IOException("Error: Header doesn't contain versioninfo");
        }
        int headerStart = header.indexOf(PDF_HEADER);
        if (headerStart == -1) {
            headerStart = header.indexOf(FDF_HEADER);
        }
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(PDF_HEADER)) {
            if (!header.matches("%PDF-\\d.\\d")) {
                headerGarbage = header.substring(PDF_HEADER.length() + 3, header.length()) + "\n";
                header = header.substring(0, PDF_HEADER.length() + 3);
                this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
            }
        } else if (!header.matches("%FDF-\\d.\\d")) {
            headerGarbage = header.substring(FDF_HEADER.length() + 3, header.length()) + "\n";
            header = header.substring(0, FDF_HEADER.length() + 3);
            this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
        }
        this.document.setHeaderString(header);
        try {
            if (header.startsWith(PDF_HEADER)) {
                float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            } else {
                float pdfVersion = Float.parseFloat(header.substring(FDF_HEADER.length(), Math.min(header.length(), FDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Error getting pdf version:" + e);
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument());
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private boolean parseObject() throws IOException {
        long currentObjByteOffset = this.pdfSource.getOffset();
        boolean isEndOfFile = false;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            currentObjByteOffset = this.pdfSource.getOffset();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                this.parseXrefTable(currentObjByteOffset);
            } else if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    this.parseTrailer();
                    peekedChar = (char)this.pdfSource.peek();
                }
                if (peekedChar == 's') {
                    this.parseStartXref();
                    while (this.isWhitespace(this.pdfSource.peek()) && !this.pdfSource.isEOF()) {
                        this.pdfSource.read();
                    }
                    String eof = "";
                    if (!this.pdfSource.isEOF()) {
                        eof = this.readLine();
                    }
                    if (!"%%EOF".equals(eof)) {
                        if (eof.startsWith("%%EOF")) {
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(eof.substring(5).getBytes("ISO-8859-1"));
                        } else {
                            LOG.warn("expected='%%EOF' actual='" + eof + "'");
                            if (!this.pdfSource.isEOF()) {
                                this.pdfSource.unread(32);
                                this.pdfSource.unread(eof.getBytes("ISO-8859-1"));
                            }
                        }
                    }
                    isEndOfFile = true;
                }
            } else {
                COSObjectKey key;
                COSObject pdfObject;
                int number = -1;
                int genNum = -1;
                String objectKey = null;
                boolean missingObjectNumber = false;
                try {
                    char peeked = (char)this.pdfSource.peek();
                    if (peeked == '<') {
                        missingObjectNumber = true;
                    } else {
                        number = this.readInt();
                    }
                }
                catch (IOException e) {
                    number = this.readInt();
                }
                if (!missingObjectNumber) {
                    this.skipSpaces();
                    genNum = this.readInt();
                    objectKey = this.readString(3);
                    if (!(objectKey.equals("obj") || this.isContinueOnError(null) && objectKey.equals("o"))) {
                        throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                    }
                } else {
                    number = -1;
                    genNum = -1;
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof COSDictionary) {
                        COSStream strmObj = (COSStream)(pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile()));
                        COSName objectType = (COSName)strmObj.getItem(COSName.TYPE);
                        if (objectType != null && objectType.equals(COSName.XREF)) {
                            this.parseXrefStream(strmObj, currentObjByteOffset);
                        }
                    } else {
                        throw new IOException("stream not preceded by dictionary");
                    }
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                }
                if ((pdfObject = this.document.getObjectFromPool(key = new COSObjectKey(number, genNum))).getObject() == null) {
                    pdfObject.setObject(pb);
                } else {
                    this.addObjectToConflicts(currentObjByteOffset, key, pb);
                }
                if (!endObjectKey.equals("endobj")) {
                    if (endObjectKey.startsWith("endobj")) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.substring(6).getBytes("ISO-8859-1"));
                    } else if (endObjectKey.trim().endsWith("endobj")) {
                        LOG.warn("expected='endobj' actual='" + endObjectKey + "' ");
                    } else if (!this.pdfSource.isEOF()) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    private void addObjectToConflicts(long offset, COSObjectKey key, COSBase pb) throws IOException {
        COSObject obj = new COSObject(null);
        obj.setObjectNumber(COSInteger.get(key.getNumber()));
        obj.setGenerationNumber(COSInteger.get(key.getGeneration()));
        obj.setObject(pb);
        ConflictObj conflictObj = new ConflictObj(offset, key, obj);
        this.conflictList.add(conflictObj);
    }

    protected boolean parseStartXref() throws IOException {
        if (this.pdfSource.peek() != 115) {
            return false;
        }
        String startXRef = this.readString();
        if (!startXRef.trim().equals("startxref")) {
            return false;
        }
        this.skipSpaces();
        this.getDocument().setStartXref(this.readInt());
        return true;
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        char c;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        this.xrefTrailerResolver.nextXrefObj(startByteOffset);
        do {
            int currObjID = this.readInt();
            int count = this.readInt();
            this.skipSpaces();
            for (int i = 0; i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek()) && this.pdfSource.peek() != 116; ++i) {
                String currentLine = this.readLine();
                String[] splitString = currentLine.split(" ");
                if (splitString.length < 3) {
                    LOG.warn("invalid xref line: " + currentLine);
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e.getMessage());
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while ((c = (char)this.pdfSource.peek()) >= '0' && c <= '9');
        return true;
    }

    protected boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                byte[] b = nextLine.getBytes("ISO-8859-1");
                int len = "trailer".length();
                this.pdfSource.unread(10);
                this.pdfSource.unread(b, len, b.length - len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.readVersionInTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    private void readVersionInTrailer(COSDictionary parsedTrailer) {
        float trailerVersion;
        COSName version;
        COSObject root = (COSObject)parsedTrailer.getItem(COSName.ROOT);
        if (root != null && (version = (COSName)root.getItem(COSName.VERSION)) != null && (trailerVersion = Float.valueOf(version.getName()).floatValue()) > this.document.getVersion()) {
            this.document.setVersion(trailerVersion);
        }
    }

    public void parseXrefStream(COSStream stream, long objByteOffset) throws IOException {
        this.xrefTrailerResolver.nextXrefObj(objByteOffset);
        this.xrefTrailerResolver.setTrailer(stream);
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.forceParsing, this.xrefTrailerResolver);
        parser.parse();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConflictObj {
        private long offset;
        private COSObjectKey objectKey;
        private COSObject object;

        public ConflictObj(long offsetValue, COSObjectKey key, COSObject pdfObject) {
            this.offset = offsetValue;
            this.objectKey = key;
            this.object = pdfObject;
        }

        public String toString() {
            return "Object(" + this.offset + ", " + this.objectKey + ")";
        }

        private static void resolveConflicts(COSDocument document, List<ConflictObj> conflictList) throws IOException {
            for (ConflictObj o : conflictList) {
                Long offset = new Long(o.offset);
                if (!document.getXrefTable().containsValue(offset)) continue;
                COSObject pdfObject = document.getObjectFromPool(o.objectKey);
                pdfObject.setObject(o.object.getObject());
            }
        }
    }
}

