/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;

public class InterpolationTable
extends Interpolation {
    protected int precisionBits;
    private int round;
    private int numSubsamplesH;
    private int numSubsamplesV;
    protected double[] dataHd;
    protected double[] dataVd;
    protected float[] dataHf;
    protected float[] dataVf;
    protected int[] dataHi;
    protected int[] dataVi;

    public InterpolationTable(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        this.leftPadding = n;
        this.topPadding = n2;
        this.width = n3;
        this.rightPadding = n3 - n - 1;
        this.precisionBits = n7;
        if (n7 > 0) {
            this.round = 1 << n7 - 1;
        }
        this.subsampleBitsH = n5;
        this.numSubsamplesH = 1 << n5;
        int n8 = n3 * this.numSubsamplesH;
        if (nArray.length != n8) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        double d = 1 << n7;
        this.dataHi = (int[])nArray.clone();
        this.dataHf = new float[n8];
        this.dataHd = new double[n8];
        int n9 = 0;
        while (n9 < n8) {
            double d2 = (double)this.dataHi[n9] / d;
            this.dataHf[n9] = (float)d2;
            this.dataHd[n9] = d2;
            ++n9;
        }
        if (nArray2 != null) {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = 1 << n6;
            int n10 = n4 * this.numSubsamplesV;
            if (nArray2.length != n10) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVi = (int[])nArray2.clone();
            this.dataVf = new float[n10];
            this.dataVd = new double[n10];
            n9 = 0;
            while (n9 < n10) {
                double d3 = (double)this.dataVi[n9] / d;
                this.dataVf[n9] = (float)d3;
                this.dataVd[n9] = d3;
                ++n9;
            }
        } else {
            this.height = n3;
            this.subsampleBitsV = n5;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
            this.dataVd = this.dataHd;
        }
        this.bottomPadding = this.height - n2 - 1;
    }

    public InterpolationTable(int n, int n2, int n3, int n4, int[] nArray) {
        this(n, n, n2, n2, n3, n3, n4, nArray, (int[])null);
    }

    public InterpolationTable(int n, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray, float[] fArray2) {
        this.leftPadding = n;
        this.topPadding = n2;
        this.width = n3;
        this.rightPadding = n3 - n - 1;
        this.precisionBits = n7;
        if (n7 > 0) {
            this.round = 1 << n7 - 1;
        }
        this.subsampleBitsH = n5;
        this.numSubsamplesH = 1 << n5;
        int n8 = n3 * this.numSubsamplesH;
        if (fArray.length != n8) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        float f = 1 << n7;
        this.dataHf = (float[])fArray.clone();
        this.dataHi = new int[n8];
        this.dataHd = new double[n8];
        int n9 = 0;
        while (n9 < n8) {
            float f2 = this.dataHf[n9];
            this.dataHi[n9] = Math.round(f2 * f);
            this.dataHd[n9] = f2;
            ++n9;
        }
        if (fArray2 != null) {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = 1 << n6;
            int n10 = n4 * this.numSubsamplesV;
            if (fArray2.length != n10) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVf = (float[])fArray2.clone();
            this.dataVi = new int[n10];
            this.dataVd = new double[n10];
            n9 = 0;
            while (n9 < n10) {
                float f3 = this.dataVf[n9];
                this.dataVi[n9] = Math.round(f3 * f);
                this.dataVd[n9] = f3;
                ++n9;
            }
        } else {
            this.height = n3;
            this.subsampleBitsV = n5;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
            this.dataVd = this.dataHd;
        }
        this.bottomPadding = this.height - n2 - 1;
    }

    public InterpolationTable(int n, int n2, int n3, int n4, float[] fArray) {
        this(n, n, n2, n2, n3, n3, n4, fArray, (float[])null);
    }

    public InterpolationTable(int n, int n2, int n3, int n4, int n5, int n6, int n7, double[] dArray, double[] dArray2) {
        this.leftPadding = n;
        this.topPadding = n2;
        this.width = n3;
        this.rightPadding = n3 - n - 1;
        this.precisionBits = n7;
        if (n7 > 0) {
            this.round = 1 << n7 - 1;
        }
        this.subsampleBitsH = n5;
        this.numSubsamplesH = 1 << n5;
        int n8 = n3 * this.numSubsamplesH;
        if (dArray.length != n8) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        double d = 1 << n7;
        this.dataHd = (double[])dArray.clone();
        this.dataHi = new int[n8];
        this.dataHf = new float[n8];
        int n9 = 0;
        while (n9 < n8) {
            double d2 = this.dataHd[n9];
            this.dataHi[n9] = (int)Math.round(d2 * d);
            this.dataHf[n9] = (float)d2;
            ++n9;
        }
        if (dArray2 != null) {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = 1 << n6;
            int n10 = n4 * this.numSubsamplesV;
            if (dArray2.length != n10) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVd = (double[])dArray2.clone();
            this.dataVi = new int[n10];
            this.dataVf = new float[n10];
            n9 = 0;
            while (n9 < n10) {
                double d3 = this.dataVd[n9];
                this.dataVi[n9] = (int)Math.round(d3 * d);
                this.dataVf[n9] = (float)d3;
                ++n9;
            }
        } else {
            this.height = n3;
            this.subsampleBitsV = n5;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVd = this.dataHd;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
        }
        this.bottomPadding = this.height - n2 - 1;
    }

    public InterpolationTable(int n, int n2, int n3, int n4, double[] dArray) {
        this(n, n, n2, n2, n3, n3, n4, dArray, null);
    }

    public int getPrecisionBits() {
        return this.precisionBits;
    }

    public int[] getHorizontalTableData() {
        return this.dataHi;
    }

    public int[] getVerticalTableData() {
        return this.dataVi;
    }

    public float[] getHorizontalTableDataFloat() {
        return this.dataHf;
    }

    public float[] getVerticalTableDataFloat() {
        return this.dataVf;
    }

    public double[] getHorizontalTableDataDouble() {
        return this.dataHd;
    }

    public double[] getVerticalTableDataDouble() {
        return this.dataVd;
    }

    public int interpolateH(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.width * n;
        int n4 = 0;
        while (n4 < this.width) {
            n2 += this.dataHi[n3 + n4] * nArray[n4];
            ++n4;
        }
        return n2 + this.round >> this.precisionBits;
    }

    public int interpolateV(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.width * n;
        int n4 = 0;
        while (n4 < this.width) {
            n2 += this.dataVi[n3 + n4] * nArray[n4];
            ++n4;
        }
        return n2 + this.round >> this.precisionBits;
    }

    public int interpolateH(int n, int n2, int n3) {
        int n4 = 2 * n3;
        int n5 = this.dataHi[n4] * n;
        return (n5 += this.dataHi[n4 + 1] * n2) + this.round >> this.precisionBits;
    }

    public int interpolateH(int n, int n2, int n3, int n4, int n5) {
        int n6 = 4 * n5;
        int n7 = this.dataHi[n6] * n;
        n7 += this.dataHi[n6 + 1] * n2;
        n7 += this.dataHi[n6 + 2] * n3;
        return (n7 += this.dataHi[n6 + 3] * n4) + this.round >> this.precisionBits;
    }

    public int interpolateV(int n, int n2, int n3) {
        int n4 = 2 * n3;
        int n5 = this.dataVi[n4] * n;
        return (n5 += this.dataVi[n4 + 1] * n2) + this.round >> this.precisionBits;
    }

    public int interpolateV(int n, int n2, int n3, int n4, int n5) {
        int n6 = 4 * n5;
        int n7 = this.dataVi[n6] * n;
        n7 += this.dataVi[n6 + 1] * n2;
        n7 += this.dataVi[n6 + 2] * n3;
        return (n7 += this.dataVi[n6 + 3] * n4) + this.round >> this.precisionBits;
    }

    public int interpolate(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 2 * n5;
        int n8 = this.dataHi[n7] * n + this.dataHi[n7 + 1] * n2;
        int n9 = this.dataHi[n7] * n3 + this.dataHi[n7 + 1] * n4;
        n8 = n8 + this.round >> this.precisionBits;
        n9 = n9 + this.round >> this.precisionBits;
        int n10 = 2 * n6;
        int n11 = this.dataVi[n10] * n8 + this.dataVi[n10 + 1] * n9;
        return n11 + this.round >> this.precisionBits;
    }

    public int interpolate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        int n19 = 4 * n17;
        int n20 = n19 + 1;
        int n21 = n19 + 2;
        int n22 = n19 + 3;
        long l = (long)this.dataHi[n19] * (long)n;
        l += (long)this.dataHi[n20] * (long)n2;
        l += (long)this.dataHi[n21] * (long)n3;
        l += (long)this.dataHi[n22] * (long)n4;
        long l2 = (long)this.dataHi[n19] * (long)n5;
        l2 += (long)this.dataHi[n20] * (long)n6;
        l2 += (long)this.dataHi[n21] * (long)n7;
        l2 += (long)this.dataHi[n22] * (long)n8;
        long l3 = (long)this.dataHi[n19] * (long)n9;
        l3 += (long)this.dataHi[n20] * (long)n10;
        l3 += (long)this.dataHi[n21] * (long)n11;
        l3 += (long)this.dataHi[n22] * (long)n12;
        long l4 = (long)this.dataHi[n19] * (long)n13;
        l4 += (long)this.dataHi[n20] * (long)n14;
        l4 += (long)this.dataHi[n21] * (long)n15;
        l4 += (long)this.dataHi[n22] * (long)n16;
        l = l + (long)this.round >> this.precisionBits;
        l2 = l2 + (long)this.round >> this.precisionBits;
        l3 = l3 + (long)this.round >> this.precisionBits;
        l4 = l4 + (long)this.round >> this.precisionBits;
        int n23 = 4 * n18;
        long l5 = (long)this.dataVi[n23] * l;
        l5 += (long)this.dataVi[n23 + 1] * l2;
        l5 += (long)this.dataVi[n23 + 2] * l3;
        return (int)((l5 += (long)this.dataVi[n23 + 3] * l4) + (long)this.round >> this.precisionBits);
    }

    public int interpolateF(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        int n19 = 4 * n17;
        float f = this.dataHf[n19] * (float)n;
        f += this.dataHf[n19 + 1] * (float)n2;
        f += this.dataHf[n19 + 2] * (float)n3;
        f += this.dataHf[n19 + 3] * (float)n4;
        float f2 = this.dataHf[n19] * (float)n5;
        f2 += this.dataHf[n19 + 1] * (float)n6;
        f2 += this.dataHf[n19 + 2] * (float)n7;
        f2 += this.dataHf[n19 + 3] * (float)n8;
        float f3 = this.dataHf[n19] * (float)n9;
        f3 += this.dataHf[n19 + 1] * (float)n10;
        f3 += this.dataHf[n19 + 2] * (float)n11;
        f3 += this.dataHf[n19 + 3] * (float)n12;
        float f4 = this.dataHf[n19] * (float)n13;
        f4 += this.dataHf[n19 + 1] * (float)n14;
        f4 += this.dataHf[n19 + 2] * (float)n15;
        int n20 = 4 * n18;
        float f5 = this.dataVf[n20] * f;
        f5 += this.dataVf[n20 + 1] * f2;
        f5 += this.dataVf[n20 + 2] * f3;
        int n21 = (int)(f5 += this.dataVf[n20 + 3] * (f4 += this.dataHf[n19 + 3] * (float)n16));
        return n21;
    }

    public float interpolateH(float[] fArray, float f) {
        float f2 = 0.0f;
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = this.width * n;
        int n3 = 0;
        while (n3 < this.width) {
            f2 += this.dataHf[n2 + n3] * fArray[n3];
            ++n3;
        }
        return f2;
    }

    public float interpolateV(float[] fArray, float f) {
        float f2 = 0.0f;
        int n = (int)(f * (float)this.numSubsamplesV);
        int n2 = this.width * n;
        int n3 = 0;
        while (n3 < this.width) {
            f2 += this.dataVf[n2 + n3] * fArray[n3];
            ++n3;
        }
        return f2;
    }

    public float interpolateH(float f, float f2, float f3) {
        float f4 = 0.0f;
        int n = (int)(f3 * (float)this.numSubsamplesH);
        int n2 = 2 * n;
        f4 = this.dataHf[n2] * f + this.dataHf[n2 + 1] * f2;
        return f4;
    }

    public float interpolateH(float f, float f2, float f3, float f4, float f5) {
        int n = (int)(f5 * (float)this.numSubsamplesH);
        int n2 = 4 * n;
        float f6 = this.dataHf[n2] * f;
        f6 += this.dataHf[n2 + 1] * f2;
        f6 += this.dataHf[n2 + 2] * f3;
        return f6 += this.dataHf[n2 + 3] * f4;
    }

    public float interpolateV(float f, float f2, float f3) {
        int n = (int)(f3 * (float)this.numSubsamplesV);
        int n2 = 2 * n;
        float f4 = this.dataVf[n2] * f;
        return f4 += this.dataVf[n2 + 1] * f2;
    }

    public float interpolateV(float f, float f2, float f3, float f4, float f5) {
        int n = (int)(f5 * (float)this.numSubsamplesV);
        int n2 = 4 * n;
        float f6 = this.dataVf[n2] * f;
        f6 += this.dataVf[n2 + 1] * f2;
        f6 += this.dataVf[n2 + 2] * f3;
        return f6 += this.dataVf[n2 + 3] * f4;
    }

    public float interpolate(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = (int)(f5 * (float)this.numSubsamplesH);
        int n2 = 2 * n;
        float f7 = this.dataHf[n2] * f + this.dataHf[n2 + 1] * f2;
        float f8 = this.dataHf[n2] * f3 + this.dataHf[n2 + 1] * f4;
        n = (int)(f6 * (float)this.numSubsamplesV);
        int n3 = 2 * n;
        float f9 = this.dataVf[n3] * f7 + this.dataVf[n3 + 1] * f8;
        return f9;
    }

    public float interpolate(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        int n = (int)(f17 * (float)this.numSubsamplesH);
        int n2 = 4 * n;
        int n3 = n2 + 1;
        int n4 = n2 + 2;
        int n5 = n2 + 3;
        float f19 = this.dataHf[n2] * f;
        f19 += this.dataHf[n3] * f2;
        f19 += this.dataHf[n4] * f3;
        f19 += this.dataHf[n5] * f4;
        float f20 = this.dataHf[n2] * f5;
        f20 += this.dataHf[n3] * f6;
        f20 += this.dataHf[n4] * f7;
        f20 += this.dataHf[n5] * f8;
        float f21 = this.dataHf[n2] * f9;
        f21 += this.dataHf[n3] * f10;
        f21 += this.dataHf[n4] * f11;
        f21 += this.dataHf[n5] * f12;
        float f22 = this.dataHf[n2] * f13;
        f22 += this.dataHf[n3] * f14;
        f22 += this.dataHf[n4] * f15;
        f22 += this.dataHf[n5] * f16;
        n = (int)(f18 * (float)this.numSubsamplesV);
        int n6 = 4 * n;
        float f23 = this.dataVf[n6] * f19;
        f23 += this.dataVf[n6 + 1] * f20;
        f23 += this.dataVf[n6 + 2] * f21;
        return f23 += this.dataVf[n6 + 3] * f22;
    }

    public double interpolateH(double[] dArray, float f) {
        double d = 0.0;
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = this.width * n;
        int n3 = 0;
        while (n3 < this.width) {
            d += this.dataHd[n2 + n3] * dArray[n3];
            ++n3;
        }
        return d;
    }

    public double interpolateV(double[] dArray, float f) {
        double d = 0.0;
        int n = (int)(f * (float)this.numSubsamplesV);
        int n2 = this.width * n;
        int n3 = 0;
        while (n3 < this.width) {
            d += this.dataVd[n2 + n3] * dArray[n3];
            ++n3;
        }
        return d;
    }

    public double interpolateH(double d, double d2, float f) {
        double d3 = 0.0;
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = 2 * n;
        d3 = this.dataHd[n2] * d + this.dataHd[n2 + 1] * d2;
        return d3;
    }

    public double interpolateH(double d, double d2, double d3, double d4, float f) {
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = 4 * n;
        double d5 = this.dataHd[n2] * d;
        d5 += this.dataHd[n2 + 1] * d2;
        d5 += this.dataHd[n2 + 2] * d3;
        return d5 += this.dataHd[n2 + 3] * d4;
    }

    public double interpolateV(double d, double d2, float f) {
        int n = (int)(f * (float)this.numSubsamplesV);
        int n2 = 2 * n;
        double d3 = this.dataVd[n2] * d;
        return d3 += this.dataVd[n2 + 1] * d2;
    }

    public double interpolateV(double d, double d2, double d3, double d4, float f) {
        int n = (int)(f * (float)this.numSubsamplesV);
        int n2 = 4 * n;
        double d5 = this.dataVd[n2] * d;
        d5 += this.dataVd[n2 + 1] * d2;
        d5 += this.dataVd[n2 + 2] * d3;
        return d5 += this.dataVd[n2 + 3] * d4;
    }

    public double interpolate(double d, double d2, double d3, double d4, float f, float f2) {
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = 2 * n;
        double d5 = this.dataHd[n2] * d + this.dataHd[n2 + 1] * d2;
        double d6 = this.dataHd[n2] * d3 + this.dataHd[n2 + 1] * d4;
        n = (int)(f2 * (float)this.numSubsamplesV);
        int n3 = 2 * n;
        double d7 = this.dataVd[n3] * d5 + this.dataVd[n3 + 1] * d6;
        return d7;
    }

    public double interpolate(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, float f, float f2) {
        int n = (int)(f * (float)this.numSubsamplesH);
        int n2 = 4 * n;
        int n3 = n2 + 1;
        int n4 = n2 + 2;
        int n5 = n2 + 3;
        double d17 = this.dataHd[n2] * d;
        d17 += this.dataHd[n3] * d2;
        d17 += this.dataHd[n4] * d3;
        d17 += this.dataHd[n5] * d4;
        double d18 = this.dataHd[n2] * d5;
        d18 += this.dataHd[n3] * d6;
        d18 += this.dataHd[n4] * d7;
        d18 += this.dataHd[n5] * d8;
        double d19 = this.dataHd[n2] * d9;
        d19 += this.dataHd[n3] * d10;
        d19 += this.dataHd[n4] * d11;
        d19 += this.dataHd[n5] * d12;
        double d20 = this.dataHd[n2] * d13;
        d20 += this.dataHd[n3] * d14;
        d20 += this.dataHd[n4] * d15;
        d20 += this.dataHd[n5] * d16;
        n = (int)(f2 * (float)this.numSubsamplesV);
        int n6 = 4 * n;
        double d21 = this.dataVd[n6] * d17;
        d21 += this.dataVd[n6 + 1] * d18;
        d21 += this.dataVd[n6 + 2] * d19;
        return d21 += this.dataVd[n6 + 3] * d20;
    }
}

