use strict;
use warnings;

use Test::Exception;
use Test::More tests => 16;
use Test::NoWarnings;
use Test::Warn;
use VolSurface::Calibration::Equities;

my $sabr = VolSurface::Calibration::Equities->new(
    surface => {
        "7" => {
            smile => {
                "80"  => 0.4687,
                "82"  => 0.44029013,
                "84"  => 0.4099894,
                "86"  => 0.38051407,
                "88"  => 0.35301949,
                "90"  => 0.3271,
                "92"  => 0.30213587,
                "94"  => 0.2769224,
                "96"  => 0.25022646,
                "98"  => 0.22352399,
                "100" => 0.201,
                "102" => 0.18636158,
                "104" => 0.18093297,
                "106" => 0.18533875,
                "108" => 0.19781314,
                "110" => 0.2142,
                "112" => 0.23087109,
                "114" => 0.24672556,
                "116" => 0.26131282,
                "118" => 0.27460561,
                "120" => 0.287,
            }
        },
        "31" => {
            smile => {
                "80"  => 0.3532173,
                "82"  => 0.34191893,
                "84"  => 0.32961755,
                "86"  => 0.31652443,
                "88"  => 0.30292388,
                "90"  => 0.28920136,
                "92"  => 0.27566307,
                "94"  => 0.26224788,
                "96"  => 0.24882963,
                "98"  => 0.23561642,
                "100" => 0.22310108,
                "102" => 0.21173074,
                "104" => 0.20191991,
                "106" => 0.19413481,
                "108" => 0.18891448,
                "110" => 0.1867635,
                "112" => 0.18779591,
                "114" => 0.1910271,
                "116" => 0.19525829,
                "118" => 0.19977536,
                "120" => 0.20433817,
            }
        },
        "61" => {
            smile => {
                "80"  => 0.33086996,
                "82"  => 0.32116083,
                "84"  => 0.31090051,
                "86"  => 0.30025201,
                "88"  => 0.28940513,
                "90"  => 0.27857583,
                "92"  => 0.26793303,
                "94"  => 0.25745513,
                "96"  => 0.24707812,
                "98"  => 0.23685619,
                "100" => 0.22696139,
                "102" => 0.21758734,
                "104" => 0.20899472,
                "106" => 0.20146068,
                "108" => 0.19527836,
                "110" => 0.19075842,
                "112" => 0.18813543,
                "114" => 0.18731498,
                "116" => 0.18810011,
                "118" => 0.19011032,
                "120" => 0.19279516
            }
        },
        "94" => {
            "vol_spread" => {"100" => 0.00417714285714286},
            "smile"      => {
                "80"  => 0.31260906,
                "82"  => 0.30381871,
                "84"  => 0.29481852,
                "86"  => 0.28578654,
                "88"  => 0.27683083,
                "90"  => 0.26798943,
                "92"  => 0.25928689,
                "94"  => 0.25070691,
                "96"  => 0.24222615,
                "98"  => 0.23389071,
                "100" => 0.22581588,
                "102" => 0.21812605,
                "104" => 0.21097115,
                "106" => 0.2045065,
                "108" => 0.19886855,
                "110" => 0.19417499,
                "112" => 0.19053876,
                "114" => 0.18805605,
                "116" => 0.18681108,
                "118" => 0.18669122,
                "120" => 0.18738486
            }
        },
        "185" => {
            "vol_spread" => {"100" => 0.0039725},
            "smile"      => {
                "80"  => 0.28918824,
                "82"  => 0.28220786,
                "84"  => 0.27531613,
                "86"  => 0.26853325,
                "88"  => 0.26184371,
                "90"  => 0.25519635,
                "92"  => 0.24855951,
                "94"  => 0.24198592,
                "96"  => 0.23554797,
                "98"  => 0.22928547,
                "100" => 0.2232056,
                "102" => 0.21732841,
                "104" => 0.21173124,
                "106" => 0.20650483,
                "108" => 0.2017182,
                "110" => 0.19741872,
                "112" => 0.19364177,
                "114" => 0.19037877,
                "116" => 0.18761205,
                "118" => 0.18536944,
                "120" => 0.18372432
            }
        },
        "276" => {
            "vol_spread" => {"100" => 0.003836},
            "smile"      => {
                "80"  => 0.27732867,
                "82"  => 0.27160145,
                "84"  => 0.26594347,
                "86"  => 0.26030289,
                "88"  => 0.2546407,
                "90"  => 0.24893094,
                "92"  => 0.24317128,
                "94"  => 0.23745098,
                "96"  => 0.23187957,
                "98"  => 0.2265065,
                "100" => 0.2213212,
                "102" => 0.21632633,
                "104" => 0.21158777,
                "106" => 0.20718609,
                "108" => 0.2031784,
                "110" => 0.19959838,
                "112" => 0.19646334,
                "114" => 0.19372931,
                "116" => 0.1913374,
                "118" => 0.18923823,
                "120" => 0.18739187
            }
        },
        "367" => {
            "vol_spread" => {"100" => 0.0036995},
            "smile"      => {
                "80"  => 0.26722224,
                "82"  => 0.26240646,
                "84"  => 0.25759664,
                "86"  => 0.25271314,
                "88"  => 0.24773263,
                "90"  => 0.24268812,
                "92"  => 0.2376209,
                "94"  => 0.23259579,
                "96"  => 0.22768244,
                "98"  => 0.22292741,
                "100" => 0.21835412,
                "102" => 0.2139861,
                "104" => 0.20985136,
                "106" => 0.2059795,
                "108" => 0.20241164,
                "110" => 0.19920042,
                "112" => 0.19638184,
                "114" => 0.19392337,
                "116" => 0.19177564,
                "118" => 0.18989565,
                "120" => 0.18824681
            }}
    },
    term_by_day  => [7,  31, 61, 94, 185, 276, 367],
    smile_points => [80, 82, 84, 86, 88,  90,  92, 94, 96, 98, 100, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120],
    parameterization => {
        values => {
            skewwingR      => 1.87015651133553,
            atmvol1year    => 0.219766155389221,
            kurtosisshort  => 0.150608673970564,
            atmvolshort    => 0.187582985633831,
            kurtosislong   => 0.0518437039369349,
            skewlong       => -0.23402654328242,
            skewwingL      => 19.988794932651,
            skewshort      => -0.112269566944989,
            atmvolLong     => 0.216810749972404,
            atmWingL       => 1.57535727572548,
            atmWingR       => 19.9998925272659,
            skew1year      => -0.225821021160232,
            kurtosisgrowth => 4.98144241252259
        }});

#p14n is for parameterization
my $p14n = $sabr->compute_parameterization;

is(sprintf("%.10f", $p14n->{calibration_error}), 5.3044315395);

is(sprintf("%.10f", $p14n->{values}->{skewwingR}),      1.8810714347);
is(sprintf("%.10f", $p14n->{values}->{atmvol1year}),    0.2197519127);
is(sprintf("%.9f",  $p14n->{values}->{kurtosisshort}),  0.149061064);
is(sprintf("%.10f", $p14n->{values}->{atmvolshort}),    0.1876633194);
is(sprintf("%.10f", $p14n->{values}->{kurtosislong}),   0.0519890234);
is(sprintf("%.10f", $p14n->{values}->{skewlong}),       -0.2337190005);
is(sprintf("%.10f", $p14n->{values}->{skewwingL}),      19.9889221541);
is(sprintf("%.10f", $p14n->{values}->{skewshort}),      -0.1116237356);
is(sprintf("%.10f", $p14n->{values}->{atmvolLong}),     0.2167814562);
is(sprintf("%.10f", $p14n->{values}->{atmWingL}),       1.5738120938);
is(sprintf("%.10f", $p14n->{values}->{atmWingR}),       19.9995540634);
is(sprintf("%.10f", $p14n->{values}->{skew1year}),      -0.2256747732);
is(sprintf("%.10f", $p14n->{values}->{kurtosisgrowth}), 4.9817644932);

dies_ok { VolSurface::Calibration::Equities->new(); } "Checking for required parameters";
