use strict;
use warnings;
use Test::More;


use Crypt::NaCl::Sodium qw(:utils);


# scalarmult.c
my $alicesk = join('', map { chr($_) }
        0x77, 0x07, 0x6d, 0x0a, 0x73, 0x18, 0xa5, 0x7d, 0x3c, 0x16, 0xc1,
        0x72, 0x51, 0xb2, 0x66, 0x45, 0xdf, 0x4c, 0x2f, 0x87, 0xeb, 0xc0,
        0x99, 0x2a, 0xb1, 0x77, 0xfb, 0xa5, 0x1d, 0xb9, 0x2c, 0x2a
);

# scalarmult.exp
my $alicepk = join('', map { chr($_) }
     0x85,0x20,0xf0,0x09,0x89,0x30,0xa7,0x54
    ,0x74,0x8b,0x7d,0xdc,0xb4,0x3e,0xf7,0x5a
    ,0x0d,0xbf,0x3a,0x0d,0x26,0x38,0x1a,0xf4
    ,0xeb,0xa4,0xa9,0x8e,0xaa,0x9b,0x4e,0x6a
);

# scalarmult2.c
my $bobsk = join('', map { chr($_) }
        0x5d, 0xab, 0x08, 0x7e, 0x62, 0x4a, 0x8a, 0x4b, 0x79, 0xe1, 0x7f,
        0x8b, 0x83, 0x80, 0x0e, 0xe6, 0x6f, 0x3b, 0xb1, 0x29, 0x26, 0x18,
        0xb6, 0xfd, 0x1c, 0x2f, 0x8b, 0x27, 0xff, 0x88, 0xe0, 0xeb
);

# scalarmult5.c
my $bobpk = join('', map { chr($_) }
        0xde, 0x9e, 0xdb, 0x7d, 0x7b, 0x7d, 0xc1, 0xb4, 0xd3, 0x5b, 0x61,
        0xc2, 0xec, 0xe4, 0x35, 0x37, 0x3f, 0x83, 0x43, 0xc8, 0x5b, 0x78,
        0x67, 0x4d, 0xad, 0xfc, 0x7e, 0x14, 0x6f, 0x88, 0x2b, 0x4f
);

# scalarmult5.exp
my $sharedsecret = join('', map { chr($_) }
     0x4a,0x5d,0x9d,0x5b,0xa4,0xce,0x2d,0xe1
    ,0x72,0x8e,0x3b,0xf4,0x80,0x35,0x0f,0x25
    ,0xe0,0x7e,0x21,0xc9,0x47,0xd1,0x9e,0x33
    ,0x76,0xf0,0x9b,0x3c,0x1e,0x16,0x17,0x42
);

my $crypto_scalarmult = Crypt::NaCl::Sodium->scalarmult();

my $alicepk_got = $crypto_scalarmult->base( $alicesk );
is(bin2hex($alicepk_got), bin2hex($alicepk), "alice: got correct PK from SK");

my $bobpk_got = $crypto_scalarmult->base( $bobsk );
is(bin2hex($bobpk_got), bin2hex($bobpk), "bob: got correct PK from SK");

my $sharedsecret_got = $crypto_scalarmult->shared_secret( $alicesk, $bobpk );
is(bin2hex($sharedsecret_got), bin2hex($sharedsecret), "got correct shared secret");

done_testing();
