/* -*- mode: C; buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADSV_STORE	 = 10,
	OP_PADAV	 = 11,
	OP_PADHV	 = 12,
	OP_PADANY	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_MULTICONCAT	 = 68,
	OP_STRINGIFY	 = 69,
	OP_LEFT_SHIFT	 = 70,
	OP_RIGHT_SHIFT	 = 71,
	OP_LT		 = 72,
	OP_I_LT		 = 73,
	OP_GT		 = 74,
	OP_I_GT		 = 75,
	OP_LE		 = 76,
	OP_I_LE		 = 77,
	OP_GE		 = 78,
	OP_I_GE		 = 79,
	OP_EQ		 = 80,
	OP_I_EQ		 = 81,
	OP_NE		 = 82,
	OP_I_NE		 = 83,
	OP_NCMP		 = 84,
	OP_I_NCMP	 = 85,
	OP_SLT		 = 86,
	OP_SGT		 = 87,
	OP_SLE		 = 88,
	OP_SGE		 = 89,
	OP_SEQ		 = 90,
	OP_SNE		 = 91,
	OP_SCMP		 = 92,
	OP_BIT_AND	 = 93,
	OP_BIT_XOR	 = 94,
	OP_BIT_OR	 = 95,
	OP_NBIT_AND	 = 96,
	OP_NBIT_XOR	 = 97,
	OP_NBIT_OR	 = 98,
	OP_SBIT_AND	 = 99,
	OP_SBIT_XOR	 = 100,
	OP_SBIT_OR	 = 101,
	OP_NEGATE	 = 102,
	OP_I_NEGATE	 = 103,
	OP_NOT		 = 104,
	OP_COMPLEMENT	 = 105,
	OP_NCOMPLEMENT	 = 106,
	OP_SCOMPLEMENT	 = 107,
	OP_ATAN2	 = 108,
	OP_SIN		 = 109,
	OP_COS		 = 110,
	OP_RAND		 = 111,
	OP_SRAND	 = 112,
	OP_EXP		 = 113,
	OP_LOG		 = 114,
	OP_SQRT		 = 115,
	OP_INT		 = 116,
	OP_HEX		 = 117,
	OP_OCT		 = 118,
	OP_ABS		 = 119,
	OP_LENGTH	 = 120,
	OP_SUBSTR	 = 121,
	OP_VEC		 = 122,
	OP_INDEX	 = 123,
	OP_RINDEX	 = 124,
	OP_SPRINTF	 = 125,
	OP_FORMLINE	 = 126,
	OP_ORD		 = 127,
	OP_CHR		 = 128,
	OP_CRYPT	 = 129,
	OP_UCFIRST	 = 130,
	OP_LCFIRST	 = 131,
	OP_UC		 = 132,
	OP_LC		 = 133,
	OP_QUOTEMETA	 = 134,
	OP_RV2AV	 = 135,
	OP_AELEMFAST	 = 136,
	OP_AELEMFAST_LEX = 137,
	OP_AELEMFASTLEX_STORE = 138,
	OP_AELEM	 = 139,
	OP_ASLICE	 = 140,
	OP_KVASLICE	 = 141,
	OP_AEACH	 = 142,
	OP_AVALUES	 = 143,
	OP_AKEYS	 = 144,
	OP_EACH		 = 145,
	OP_VALUES	 = 146,
	OP_KEYS		 = 147,
	OP_DELETE	 = 148,
	OP_EXISTS	 = 149,
	OP_RV2HV	 = 150,
	OP_HELEM	 = 151,
	OP_HSLICE	 = 152,
	OP_KVHSLICE	 = 153,
	OP_MULTIDEREF	 = 154,
	OP_UNPACK	 = 155,
	OP_PACK		 = 156,
	OP_SPLIT	 = 157,
	OP_JOIN		 = 158,
	OP_LIST		 = 159,
	OP_LSLICE	 = 160,
	OP_ANONLIST	 = 161,
	OP_ANONHASH	 = 162,
	OP_EMPTYAVHV	 = 163,
	OP_SPLICE	 = 164,
	OP_PUSH		 = 165,
	OP_POP		 = 166,
	OP_SHIFT	 = 167,
	OP_UNSHIFT	 = 168,
	OP_SORT		 = 169,
	OP_REVERSE	 = 170,
	OP_GREPSTART	 = 171,
	OP_GREPWHILE	 = 172,
	OP_ANYSTART	 = 173,
	OP_ALLSTART	 = 174,
	OP_ANYWHILE	 = 175,
	OP_MAPSTART	 = 176,
	OP_MAPWHILE	 = 177,
	OP_RANGE	 = 178,
	OP_FLIP		 = 179,
	OP_FLOP		 = 180,
	OP_AND		 = 181,
	OP_OR		 = 182,
	OP_XOR		 = 183,
	OP_DOR		 = 184,
	OP_COND_EXPR	 = 185,
	OP_ANDASSIGN	 = 186,
	OP_ORASSIGN	 = 187,
	OP_DORASSIGN	 = 188,
	OP_ENTERSUB	 = 189,
	OP_LEAVESUB	 = 190,
	OP_LEAVESUBLV	 = 191,
	OP_ARGCHECK	 = 192,
	OP_ARGELEM	 = 193,
	OP_ARGDEFELEM	 = 194,
	OP_CALLER	 = 195,
	OP_WARN		 = 196,
	OP_DIE		 = 197,
	OP_RESET	 = 198,
	OP_LINESEQ	 = 199,
	OP_NEXTSTATE	 = 200,
	OP_DBSTATE	 = 201,
	OP_UNSTACK	 = 202,
	OP_ENTER	 = 203,
	OP_LEAVE	 = 204,
	OP_SCOPE	 = 205,
	OP_ENTERITER	 = 206,
	OP_ITER		 = 207,
	OP_ENTERLOOP	 = 208,
	OP_LEAVELOOP	 = 209,
	OP_RETURN	 = 210,
	OP_LAST		 = 211,
	OP_NEXT		 = 212,
	OP_REDO		 = 213,
	OP_DUMP		 = 214,
	OP_GOTO		 = 215,
	OP_EXIT		 = 216,
	OP_METHOD	 = 217,
	OP_METHOD_NAMED	 = 218,
	OP_METHOD_SUPER	 = 219,
	OP_METHOD_REDIR	 = 220,
	OP_METHOD_REDIR_SUPER = 221,
	OP_OPEN		 = 222,
	OP_CLOSE	 = 223,
	OP_PIPE_OP	 = 224,
	OP_FILENO	 = 225,
	OP_UMASK	 = 226,
	OP_BINMODE	 = 227,
	OP_TIE		 = 228,
	OP_UNTIE	 = 229,
	OP_TIED		 = 230,
	OP_DBMOPEN	 = 231,
	OP_DBMCLOSE	 = 232,
	OP_SSELECT	 = 233,
	OP_SELECT	 = 234,
	OP_GETC		 = 235,
	OP_READ		 = 236,
	OP_ENTERWRITE	 = 237,
	OP_LEAVEWRITE	 = 238,
	OP_PRTF		 = 239,
	OP_PRINT	 = 240,
	OP_SAY		 = 241,
	OP_SYSOPEN	 = 242,
	OP_SYSSEEK	 = 243,
	OP_SYSREAD	 = 244,
	OP_SYSWRITE	 = 245,
	OP_EOF		 = 246,
	OP_TELL		 = 247,
	OP_SEEK		 = 248,
	OP_TRUNCATE	 = 249,
	OP_FCNTL	 = 250,
	OP_IOCTL	 = 251,
	OP_FLOCK	 = 252,
	OP_SEND		 = 253,
	OP_RECV		 = 254,
	OP_SOCKET	 = 255,
	OP_SOCKPAIR	 = 256,
	OP_BIND		 = 257,
	OP_CONNECT	 = 258,
	OP_LISTEN	 = 259,
	OP_ACCEPT	 = 260,
	OP_SHUTDOWN	 = 261,
	OP_GSOCKOPT	 = 262,
	OP_SSOCKOPT	 = 263,
	OP_GETSOCKNAME	 = 264,
	OP_GETPEERNAME	 = 265,
	OP_LSTAT	 = 266,
	OP_STAT		 = 267,
	OP_FTRREAD	 = 268,
	OP_FTRWRITE	 = 269,
	OP_FTREXEC	 = 270,
	OP_FTEREAD	 = 271,
	OP_FTEWRITE	 = 272,
	OP_FTEEXEC	 = 273,
	OP_FTIS		 = 274,
	OP_FTSIZE	 = 275,
	OP_FTMTIME	 = 276,
	OP_FTATIME	 = 277,
	OP_FTCTIME	 = 278,
	OP_FTROWNED	 = 279,
	OP_FTEOWNED	 = 280,
	OP_FTZERO	 = 281,
	OP_FTSOCK	 = 282,
	OP_FTCHR	 = 283,
	OP_FTBLK	 = 284,
	OP_FTFILE	 = 285,
	OP_FTDIR	 = 286,
	OP_FTPIPE	 = 287,
	OP_FTSUID	 = 288,
	OP_FTSGID	 = 289,
	OP_FTSVTX	 = 290,
	OP_FTLINK	 = 291,
	OP_FTTTY	 = 292,
	OP_FTTEXT	 = 293,
	OP_FTBINARY	 = 294,
	OP_CHDIR	 = 295,
	OP_CHOWN	 = 296,
	OP_CHROOT	 = 297,
	OP_UNLINK	 = 298,
	OP_CHMOD	 = 299,
	OP_UTIME	 = 300,
	OP_RENAME	 = 301,
	OP_LINK		 = 302,
	OP_SYMLINK	 = 303,
	OP_READLINK	 = 304,
	OP_MKDIR	 = 305,
	OP_RMDIR	 = 306,
	OP_OPEN_DIR	 = 307,
	OP_READDIR	 = 308,
	OP_TELLDIR	 = 309,
	OP_SEEKDIR	 = 310,
	OP_REWINDDIR	 = 311,
	OP_CLOSEDIR	 = 312,
	OP_FORK		 = 313,
	OP_WAIT		 = 314,
	OP_WAITPID	 = 315,
	OP_SYSTEM	 = 316,
	OP_EXEC		 = 317,
	OP_KILL		 = 318,
	OP_GETPPID	 = 319,
	OP_GETPGRP	 = 320,
	OP_SETPGRP	 = 321,
	OP_GETPRIORITY	 = 322,
	OP_SETPRIORITY	 = 323,
	OP_TIME		 = 324,
	OP_TMS		 = 325,
	OP_LOCALTIME	 = 326,
	OP_GMTIME	 = 327,
	OP_ALARM	 = 328,
	OP_SLEEP	 = 329,
	OP_SHMGET	 = 330,
	OP_SHMCTL	 = 331,
	OP_SHMREAD	 = 332,
	OP_SHMWRITE	 = 333,
	OP_MSGGET	 = 334,
	OP_MSGCTL	 = 335,
	OP_MSGSND	 = 336,
	OP_MSGRCV	 = 337,
	OP_SEMOP	 = 338,
	OP_SEMGET	 = 339,
	OP_SEMCTL	 = 340,
	OP_REQUIRE	 = 341,
	OP_DOFILE	 = 342,
	OP_HINTSEVAL	 = 343,
	OP_ENTEREVAL	 = 344,
	OP_LEAVEEVAL	 = 345,
	OP_ENTERTRY	 = 346,
	OP_LEAVETRY	 = 347,
	OP_GHBYNAME	 = 348,
	OP_GHBYADDR	 = 349,
	OP_GHOSTENT	 = 350,
	OP_GNBYNAME	 = 351,
	OP_GNBYADDR	 = 352,
	OP_GNETENT	 = 353,
	OP_GPBYNAME	 = 354,
	OP_GPBYNUMBER	 = 355,
	OP_GPROTOENT	 = 356,
	OP_GSBYNAME	 = 357,
	OP_GSBYPORT	 = 358,
	OP_GSERVENT	 = 359,
	OP_SHOSTENT	 = 360,
	OP_SNETENT	 = 361,
	OP_SPROTOENT	 = 362,
	OP_SSERVENT	 = 363,
	OP_EHOSTENT	 = 364,
	OP_ENETENT	 = 365,
	OP_EPROTOENT	 = 366,
	OP_ESERVENT	 = 367,
	OP_GPWNAM	 = 368,
	OP_GPWUID	 = 369,
	OP_GPWENT	 = 370,
	OP_SPWENT	 = 371,
	OP_EPWENT	 = 372,
	OP_GGRNAM	 = 373,
	OP_GGRGID	 = 374,
	OP_GGRENT	 = 375,
	OP_SGRENT	 = 376,
	OP_EGRENT	 = 377,
	OP_GETLOGIN	 = 378,
	OP_SYSCALL	 = 379,
	OP_LOCK		 = 380,
	OP_ONCE		 = 381,
	OP_CUSTOM	 = 382,
	OP_COREARGS	 = 383,
	OP_AVHVSWITCH	 = 384,
	OP_RUNCV	 = 385,
	OP_FC		 = 386,
	OP_PADCV	 = 387,
	OP_INTROCV	 = 388,
	OP_CLONECV	 = 389,
	OP_PADRANGE	 = 390,
	OP_REFASSIGN	 = 391,
	OP_LVREF	 = 392,
	OP_LVREFSLICE	 = 393,
	OP_LVAVREF	 = 394,
	OP_ANONCONST	 = 395,
	OP_ISA		 = 396,
	OP_CMPCHAIN_AND	 = 397,
	OP_CMPCHAIN_DUP	 = 398,
	OP_ENTERTRYCATCH = 399,
	OP_LEAVETRYCATCH = 400,
	OP_POPTRY	 = 401,
	OP_CATCH	 = 402,
	OP_PUSHDEFER	 = 403,
	OP_IS_BOOL	 = 404,
	OP_IS_WEAK	 = 405,
	OP_WEAKEN	 = 406,
	OP_UNWEAKEN	 = 407,
	OP_BLESSED	 = 408,
	OP_REFADDR	 = 409,
	OP_REFTYPE	 = 410,
	OP_CEIL		 = 411,
	OP_FLOOR	 = 412,
	OP_IS_TAINTED	 = 413,
	OP_HELEMEXISTSOR = 414,
	OP_METHSTART	 = 415,
	OP_INITFIELD	 = 416,
	OP_CLASSNAME	 = 417,
	OP_max		
} opcode;

/*
=for apidoc Ay||opcode
An enum of all the legal Perl opcodes, defined in F<opnames.h>

=cut
*/

#define MAXO 418
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)   \
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)   \
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)   \
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)   \
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro ft=c: */
