/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* real.c
**
**/

#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "range.h"

static void *Int2Real (int *value, real * copy);
static void *String2Real (char *value, real * copy);
static void *Bool2Real (bool * value, real * copy);

static int Size (void *value);
static int Comp (void *pvalue1, void *pvalue2, int type);

static Converter Converters[] = {
  {IntegerType, RealType, (ConverterType) Int2Real},
  {StringType, RealType, (ConverterType) String2Real},
  {BooleanType, RealType, (ConverterType) Bool2Real},
  {0, 0, 0}
};


vtype realRec = {
  "r",
  Converters,

  Size,
  VXAcce,
  Comp
};


static void *
String2Real (char *value, real * copy)
{
  char *scanto = NULL;
  char *temp_value = NULL;

  if ((value == NULL) || (copy == NULL))
    return NULL;

  if (!strcmp (value, "INDEF") || !strcmp (value, "INDEFD"))
    {
      *copy = INDEFD;
      return copy;
    }

  if ((temp_value = (char *) malloc ((strlen (value) + 1) * sizeof (char))) !=
      NULL)
    {
      char *doublep;

      strcpy (temp_value, value);

      /* change reference of 'd' or 'D' to 'E' */
      if ((doublep = strpbrk (temp_value, "dD")) != NULL)
	*doublep = 'E';

      *copy = strtod (temp_value, &scanto);
    }
  else
    {
      *copy = strtod (value, &scanto);
    }

  if (*scanto)
    {
      parerr = PARCANTCONVERT;
      return NULL;
    }


  if (temp_value)
    free (temp_value);
  temp_value = NULL;

  return copy;
}



static void *
Int2Real (int *value, real * copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value;
  return copy;
}


static void *
Bool2Real (bool * value, real * copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = *value == 1;
  return copy;
}


static int
Size (void *value)
{
  return sizeof (real);
}

static int
Comp (void *pvalue1, void *pvalue2, int type)
{
  real *value1 = (real *) pvalue1;
  real *value2 = (real *) pvalue2;

  if (*value1 == INDEFD || *value2 == INDEFD)
    return 1;

  switch (type)
    {
    case PRange_EQ:
      return *value1 == *value2;
    case PRange_NE:
      return *value1 != *value2;
    case PRange_GT:
      return *value1 > *value2;
    case PRange_GE:
      return *value1 >= *value2;
    case PRange_LT:
      return *value1 < *value2;
    case PRange_LE:
      return *value1 <= *value2;
    default:
      return 0;
    }
}
