#include "uulib/util.h"

IV uu_time(const struct uu *in, struct timeval *out) {
  return 4;
}

/* a.k.a. version */
UV uu_type(const struct uu *in) {
  UV  type;

  type = in->time_high_and_version >> 12;

  if (type <= 8)
    return type;
  return 0;
}

UV uu_variant(const struct uu *in) {
  U16 variant;

  variant = in->clock_seq_and_variant;

  if ((variant & 0x8000) == 0) return 0;
  if ((variant & 0x4000) == 0) return 1;
  if ((variant & 0x2000) == 0) return 2;
  return 3;
}

/* ex:set ts=2 sw=2 itab=spaces: */
