use strict;
use warnings;
use Test::More tests => 19;
use Digest::Fugue qw(fugue_256 fugue_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Fugue->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            fugue_256_hex($data), $digest,
            "fugue_256_hex: $len bits of $msg"
        );
        ok(
            fugue_256($data) eq pack('H*', $digest),
            "fugue_256: $len bits of $msg"
        );
    }
    else {
        TODO:
        eval {
            local $TODO = 'add_bits is not yet implemented';
            my $md = Digest::Fugue->new(256)->add_bits($data, $len)
                ->hexdigest;
            is($md, $digest, "new/add_bits/hexdigest: $msg");
        };
    }
}
continue { $len++ }

__DATA__
00|D6EC528980C130AAD1D1ACD28B9DD8DBDEAE0D79EDED1FCA72C2AF9F37C2246F
00|62C7C83D5EE85C4B016E7B74DB181883F5AE440F1154CA86BE1D5EFC8DA1F605
C0|ACF97C3E41D35295469BFB95B44BBD960F26AE312DC85D46458E5A90B47DE408
C0|DC82018D6A7582D1B5FA30C433EF900B13EE37532DC7944EDBC0C9369BA3FBBA
80|077BE43564C8DA92D58BACE34DCEFF6212D4CC7CD0418C802C5E9332FE1A1934
48|52BC1C3CAB50F36FF7187261160DBCB11DD7B40CFCCFA84C4769517E70A9F8CA
50|5AD64F3683B2E7A1C0A79C38B95FDF7CDEF7CBAF29EEA5B1E4863171D19DF56D
98|4F7F0AB484F3356DEB289A64BF593BB5F97CBCF08200D002AD6B0B9039F9590E
CC|B894EB2DF58162F6C48D495F156E73BD086DD13DB407EE38781177BB23D129BB
9800|517DDF37B496AA39F6687F78354285A6DE30A70809CC07D59D6F9BCAB300F302
9D40|84C618A8D0C284612A9A2F3D49BD5E0F14A01F78238D989F4508D608EB740805
AA80|D14C1FAF0F87310D0A7F7156C7715B7C5D62219ED0AA4A001DAFB6706DD78E93
9830|E7F246718D12407DE1B06766C9F71ABC31EE4F132AB8C448F4B97A929652AE97
5030|550C7BDF3E30A0D44D471CD6833C845C9821F9FCC6C8AD3E15690F5A9DF050C4
4D24|5480ACAFDD07E8CB98455D346A166F1E8AABDCD60834819A8251223F889B96C8
CBDE|8034144C88B92EA1AC4ABC075EFC5C122DF2D6A3B637AC7B927ED230DFC5BC75
41FB|584827DEA879A043438C23A32C42BA0990F0F8CE385852693B7EEB2BC4D7FAB1
4FF400|ED8E1315165050FF691D768745AAB3F4963980AA9E60E4A0F68EA379AA8CEA5D
FD0440|B4979C4BDD12F50C49DB9F4CC76D0698081F6769D39CAFDC491E32D96410AD9B
424D00|448CC9764741522CA5721835CAE5DB705F19D903625B3463AA4E88541E3A01F9
3FDEE0|6EB176075B6EBB1CC90A66225F131C06328E35FE9613E2659BFFFF10847FBEED
335768|F9050F972E2DF897530889CEB692A46A63B62F343E7185078CD2BBD75282A60C
051E7C|404776119C422901292AE0392A7B0912FC81BB695266AFF414D4352740C5A542
717F8C|5674F6CD5EB04C88EA738AB8E7EC86DBA4FAB8E9B99E56A57612D3438ECF4518
1F877C|F9F5CF602B093C43BF9C6D551F6A9E60214CE1BB3A6D842C3D9A5F358DF05547
EB35CF80|CEA20A30B7BE0F1B612BCB94D64F479E496EF88F16331BF4CCB9719131598F1B
B406C480|1DE1B6404F1E1A1F3E8ECD3D1B62E09EC7378A628C3EB2FC2D7538C64F44483E
CEE88040|AB4405395FD1235D6B1F52A2E678ECAB2786E3794AE4AE9BD7C7046203955D0F
C584DB70|43A16D65A3FFA17B67ADF2C5D059F4D3559FF64A45F7D6FD3754694B8E92C6FD
53587BC8|AAA5BBA99BEA6A0D4AEEE4B226D0E6213A56E805EB5751F52F62DAD4D08D628E
69A305B0|8B1E521FD7C7BF680650F6288BB58AA2CE6BE6D39B17298473F06D97116A94C9
C9375ECE|C1A218AFFF38A2EA1064B12945AE94DE95BEDE6FD2835198939BFFE90075FD82
C1ECFDFC|9041D9EDF413CF0A8CFB6AED97C13032315319438BE004685F4BB583F67ACF23
8D73E8A280|8FC10587565AD64B53F95558A69926F3FBC29F56A34BC741AE6DE3E7344B0A89
06F2522080|8FEAC53BB2A8B86B575FA9B8D89A4A47EA13D41E4968AEBD3F04DA4D408D42EF
3EF6C36F20|05FE555DF0C292DB7ABF322B13177F36CFC10664C0BD3CEFD0834A316D9ED7B1
0127A1D340|339D415AE8E68884604836B7B3C2CE8E333E5FA8F656425A5527C4BA3C8B8768
6A6AB6C210|5188E0F88D1E63784EC53B198F965A95AC36BCCC5DF2B45D93E7AF44855E9E7F
AF3175E160|24B97E19F970BD8DE19A41D680846D7C2546404A82D6F6BD956B62D43B836449
B66609ED86|D0AB08964EE1C7492C1A0F8E76251EACF4B0320DEADE1A5737DD1BE490AD76C0
21F134AC57|2FCA43424B89301D8E1BA3C5EB760A8633639B35C5D72331C0A26ED4AEE7E4BA
3DC2AADFFC80|709C7A639C62EFF52AC8E150F5FEB333015EA2DA4E19CBEFDC3ADB7529EF8C3E
9202736D2240|11361FEA3C841B0E355FBED216AAA4755388CC285509C4B62BE443F9B5D30AF8
F219BD629820|2D0F3E5A271940ADD7FDDE762E8241D53056DA5F0921F99E0E3AFFD03A240389
F3511EE2C4B0|2D093146C9F7B25657E4B3BB1318AE20044D62647B9F81EB9E66E240D0277486
3ECAB6BF7720|2FEE4ADC3AB139CC27BAB483D56294404C8FC26EE0D6FF40C1B34D83A7FDED6B
CD62F688F498|4E9CB926F70865E4F94C387DD10BE1E11ED9B25E20AB354A04234B5106F17B16
C2CBAA33A9F8|0A4B3C8C0808F0C4089C061F599589EF2E222E4A430A40ABC90C2A11F33C07F4
C6F50BB74E29|70D683F0B39D3016FC243355A2E40A7F1337AA826FC88785A3F15C0D5E96EB1C
79F1B4CCC62A00|E62AA99DBC8580ADC1A76EC6A6F34B98A68E27E84C0F0613DBB94E1EFC1EC23E
