/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.UnsupportedEncodingException;

public class ByteArrayReader
implements BufferReader {
    @NotNull
    private final byte[] _buffer;
    private boolean _isMotorolaByteOrder = true;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public ByteArrayReader(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this._buffer = buffer;
    }

    public long getLength() {
        return this._buffer.length;
    }

    public void setMotorolaByteOrder(boolean motorolaByteOrder) {
        this._isMotorolaByteOrder = motorolaByteOrder;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public short getUInt8(int index) throws BufferBoundsException {
        this.checkBounds(index, 1);
        return (short)(this._buffer[index] & 0xFF);
    }

    public byte getInt8(int index) throws BufferBoundsException {
        this.checkBounds(index, 1);
        return this._buffer[index];
    }

    public int getUInt16(int index) throws BufferBoundsException {
        this.checkBounds(index, 2);
        if (this._isMotorolaByteOrder) {
            return this._buffer[index] << 8 & 0xFF00 | this._buffer[index + 1] & 0xFF;
        }
        return this._buffer[index + 1] << 8 & 0xFF00 | this._buffer[index] & 0xFF;
    }

    public short getInt16(int index) throws BufferBoundsException {
        this.checkBounds(index, 2);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this._buffer[index] << 8 & 0xFFFFFF00 | (short)this._buffer[index + 1] & 0xFF);
        }
        return (short)((short)this._buffer[index + 1] << 8 & 0xFFFFFF00 | (short)this._buffer[index] & 0xFF);
    }

    public long getUInt32(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        if (this._isMotorolaByteOrder) {
            return (long)this._buffer[index] << 24 & 0xFF000000L | (long)this._buffer[index + 1] << 16 & 0xFF0000L | (long)this._buffer[index + 2] << 8 & 0xFF00L | (long)this._buffer[index + 3] & 0xFFL;
        }
        return (long)this._buffer[index + 3] << 24 & 0xFF000000L | (long)this._buffer[index + 2] << 16 & 0xFF0000L | (long)this._buffer[index + 1] << 8 & 0xFF00L | (long)this._buffer[index] & 0xFFL;
    }

    public int getInt32(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        if (this._isMotorolaByteOrder) {
            return this._buffer[index] << 24 & 0xFF000000 | this._buffer[index + 1] << 16 & 0xFF0000 | this._buffer[index + 2] << 8 & 0xFF00 | this._buffer[index + 3] & 0xFF;
        }
        return this._buffer[index + 3] << 24 & 0xFF000000 | this._buffer[index + 2] << 16 & 0xFF0000 | this._buffer[index + 1] << 8 & 0xFF00 | this._buffer[index] & 0xFF;
    }

    public long getInt64(int index) throws BufferBoundsException {
        this.checkBounds(index, 8);
        if (this._isMotorolaByteOrder) {
            return (long)this._buffer[index] << 56 & 0xFF00000000000000L | (long)this._buffer[index + 1] << 48 & 0xFF000000000000L | (long)this._buffer[index + 2] << 40 & 0xFF0000000000L | (long)this._buffer[index + 3] << 32 & 0xFF00000000L | (long)this._buffer[index + 4] << 24 & 0xFF000000L | (long)this._buffer[index + 5] << 16 & 0xFF0000L | (long)this._buffer[index + 6] << 8 & 0xFF00L | (long)this._buffer[index + 7] & 0xFFL;
        }
        return (long)this._buffer[index + 7] << 56 & 0xFF00000000000000L | (long)this._buffer[index + 6] << 48 & 0xFF000000000000L | (long)this._buffer[index + 5] << 40 & 0xFF0000000000L | (long)this._buffer[index + 4] << 32 & 0xFF00000000L | (long)this._buffer[index + 3] << 24 & 0xFF000000L | (long)this._buffer[index + 2] << 16 & 0xFF0000L | (long)this._buffer[index + 1] << 8 & 0xFF00L | (long)this._buffer[index] & 0xFFL;
    }

    public float getS15Fixed16(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        if (this._isMotorolaByteOrder) {
            float res = (this._buffer[index] & 0xFF) << 8 | this._buffer[index + 1] & 0xFF;
            int d = (this._buffer[index + 2] & 0xFF) << 8 | this._buffer[index + 3] & 0xFF;
            return (float)((double)res + (double)d / 65536.0);
        }
        float res = (this._buffer[index + 3] & 0xFF) << 8 | this._buffer[index + 2] & 0xFF;
        int d = (this._buffer[index + 1] & 0xFF) << 8 | this._buffer[index] & 0xFF;
        return (float)((double)res + (double)d / 65536.0);
    }

    public float getFloat32(int index) throws BufferBoundsException {
        return Float.intBitsToFloat(this.getInt32(index));
    }

    public double getDouble64(int index) throws BufferBoundsException {
        return Double.longBitsToDouble(this.getInt64(index));
    }

    @NotNull
    public byte[] getBytes(int index, int count) throws BufferBoundsException {
        this.checkBounds(index, count);
        byte[] bytes = new byte[count];
        System.arraycopy(this._buffer, index, bytes, 0, count);
        return bytes;
    }

    @NotNull
    public String getString(int index, int bytesRequested) throws BufferBoundsException {
        return new String(this.getBytes(index, bytesRequested));
    }

    @NotNull
    public String getString(int index, int bytesRequested, String charset) throws BufferBoundsException {
        byte[] bytes = this.getBytes(index, bytesRequested);
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    @NotNull
    public String getNullTerminatedString(int index, int maxLengthBytes) throws BufferBoundsException {
        int length;
        this.checkBounds(index, maxLengthBytes);
        for (length = 0; index + length < this._buffer.length && this._buffer[index + length] != 0 && length < maxLengthBytes; ++length) {
        }
        byte[] bytes = this.getBytes(index, length);
        return new String(bytes);
    }

    private void checkBounds(int index, int bytesRequested) throws BufferBoundsException {
        if (bytesRequested < 0 || index < 0 || (long)index + (long)bytesRequested - 1L >= (long)this._buffer.length) {
            throw new BufferBoundsException(this._buffer, index, bytesRequested);
        }
    }
}

