/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class FlatEarth
extends ProjectionImpl {
    private double rotAngle;
    private double lat0;
    private double lon0;
    private double cosRot;
    private double sinRot;
    private LatLonPointImpl origin;
    private boolean spherical = false;
    private double radius = Earth.getRadius() * 0.001;

    @Override
    public ProjectionImpl constructCopy() {
        return new FlatEarth(this.getOriginLat(), this.getOriginLon(), this.getRotationAngle());
    }

    public FlatEarth() {
        this(0.0, 0.0, 0.0);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(rotAngle);
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
        this.addParameter("grid_mapping_name", "flat_earth");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("rotationAngle", rotAngle);
    }

    public FlatEarth(double lat0, double lon0) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(0.0);
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
        this.addParameter("grid_mapping_name", "flat_earth");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("rotationAngle", this.rotAngle);
    }

    private void precalculate() {
        this.sinRot = Math.sin(this.rotAngle);
        this.cosRot = Math.cos(this.rotAngle);
    }

    @Override
    public Object clone() {
        FlatEarth cl = (FlatEarth)super.clone();
        cl.origin = new LatLonPointImpl(this.getOriginLat(), this.getOriginLon());
        return cl;
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof FlatEarth)) {
            return false;
        }
        FlatEarth oo = (FlatEarth)proj;
        return this.getOriginLat() == oo.getOriginLat() && this.getOriginLon() == oo.getOriginLon() && this.rotAngle == oo.rotAngle;
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = Math.toRadians(lon);
        this.precalculate();
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = Math.toRadians(lat);
        this.precalculate();
    }

    @Override
    public String getProjectionTypeLabel() {
        return "FlatEarth";
    }

    @Override
    public String paramsToString() {
        return " origin " + this.origin.toString() + " rotationAngle " + this.rotAngle;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double dy = this.radius * (fromLat - this.lat0);
        double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
        double toX = this.cosRot * dx - this.sinRot * dy;
        double toY = this.sinRot * dx + this.cosRot * dy;
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double x = world.getX();
        double y = world.getY();
        boolean TOLERENCE = true;
        double xp = this.cosRot * x + this.sinRot * y;
        double yp = -this.sinRot * x + this.cosRot * y;
        double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
        double cosl = Math.cos(Math.toRadians(toLat));
        double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double dy = this.radius * (fromLat - this.lat0);
            double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
            double toX = this.cosRot * dx - this.sinRot * dy;
            double toY = this.sinRot * dx + this.cosRot * dy;
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return pt1.getX() * pt2.getX() < 0.0;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double xp = this.cosRot * fromX + this.sinRot * fromY;
            double yp = -this.sinRot * fromX + this.cosRot * fromY;
            double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
            double cosl = Math.cos(Math.toRadians(toLat));
            double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double dy = this.radius * (fromLat - this.lat0);
            double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
            double toX = this.cosRot * dx - this.sinRot * dy;
            double toY = this.sinRot * dx + this.cosRot * dy;
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double xp = this.cosRot * fromX + this.sinRot * fromY;
            double yp = -this.sinRot * fromX + this.cosRot * fromY;
            double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
            double cosl = Math.cos(Math.toRadians(toLat));
            double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    public static void main(String[] args) {
        FlatEarth a = new FlatEarth(90.0, -100.0, 0.0);
        ProjectionPointImpl p = a.latLonToProj(89.0, -101.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

