# Generated by default/object.tt
package Paws::CloudWatchEvents::ConnectionOAuthResponseParameters;
  use Moose;
  has AuthorizationEndpoint => (is => 'ro', isa => 'Str');
  has ClientParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionOAuthClientResponseParameters');
  has HttpMethod => (is => 'ro', isa => 'Str');
  has OAuthHttpParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionHttpParameters');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ConnectionOAuthResponseParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ConnectionOAuthResponseParameters object:

  $service_obj->Method(Att1 => { AuthorizationEndpoint => $value, ..., OAuthHttpParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ConnectionOAuthResponseParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationEndpoint

=head1 DESCRIPTION

Contains the response parameters when OAuth is specified as the
authorization type.

=head1 ATTRIBUTES


=head2 AuthorizationEndpoint => Str

The URL to the HTTP endpoint that authorized the request.


=head2 ClientParameters => L<Paws::CloudWatchEvents::ConnectionOAuthClientResponseParameters>

A C<ConnectionOAuthClientResponseParameters> object that contains
details about the client parameters returned when OAuth is specified as
the authorization type.


=head2 HttpMethod => Str

The method used to connect to the HTTP endpoint.


=head2 OAuthHttpParameters => L<Paws::CloudWatchEvents::ConnectionHttpParameters>

The additional HTTP parameters used for the OAuth authorization
request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

